/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001b;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u001fmI!\u0001\b\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\tz\"a\u0002'pO\u001eLgn\u001a\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005!!/\u00198l+\u00051\u0003CA\b(\u0013\tA\u0003CA\u0002J]RD3a\t\u00161!\tYc&D\u0001-\u0015\tic!\u0001\u0006b]:|G/\u0019;j_:L!a\f\u0017\u0003\u000bMKgnY3\"\u0003E\nQ\u0001\r\u00189]AB\u0001b\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0006e\u0006t7\u000e\t\u0015\u0004e)\u0002\u0004\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\u0002\u0019U\u001cXM\u001d$fCR,(/Z:\u0016\u0003a\u00022!\u000f\u001f?\u001b\u0005Q$BA\u001e\u0007\u0003\r\u0011H\rZ\u0005\u0003{i\u00121A\u0015#E!\u0011yqHJ!\n\u0005\u0001\u0003\"A\u0002+va2,'\u0007E\u0002\u0010\u0005\u0012K!a\u0011\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0019!u.\u001e2mK\"\u001aQG\u000b\u0019\t\u0011%\u0003!\u0011!Q\u0001\na\nQ\"^:fe\u001a+\u0017\r^;sKN\u0004\u0003f\u0001%+a!AA\n\u0001BC\u0002\u0013\u0005q'A\bqe>$Wo\u0019;GK\u0006$XO]3tQ\rY%\u0006\r\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005q\u0005\u0001\u0002O]8ek\u000e$h)Z1ukJ,7\u000f\t\u0015\u0004\u001d*\u0002\u0004\"\u0002*\u0001\t\u0003\u0019\u0016A\u0002\u001fj]&$h\b\u0006\u0003U-bS\u0006CA+\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013R\u0001\u00041\u0003f\u0001,+a!)a'\u0015a\u0001q!\u001a\u0001L\u000b\u0019\t\u000b1\u000b\u0006\u0019\u0001\u001d)\u0007iS\u0003\u0007K\u0002RUABQA\u0018\u0001\u0005\n}\u000b\u0001C^1mS\u0012\fG/\u001a$fCR,(/Z:\u0015\u0007\u0001\u001c\u0007\u000f\u0005\u0002\u0010C&\u0011!\r\u0005\u0002\u0005+:LG\u000fC\u0003e;\u0002\u0007Q-\u0001\u0003oC6,\u0007C\u00014n\u001d\t97\u000e\u0005\u0002i!5\t\u0011N\u0003\u0002k\u0019\u00051AH]8pizJ!\u0001\u001c\t\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003YBAQ!]/A\u0002a\n\u0001BZ3biV\u0014Xm\u001d\u0005\u0006g\u0002!\t\u0001^\u0001\baJ,G-[2u)\r!Uo\u001e\u0005\u0006mJ\u0004\rAJ\u0001\u0005kN,'\u000fC\u0003ye\u0002\u0007a%A\u0004qe>$Wo\u0019;)\u0007IT\u0003\u0007\u0003\u0004|\u0001\u0001&I\u0001`\u0001\u001fG>,h\u000e^!qaJ|\u0007\u0010R5ti&t7\r^+tKJ\u0004&o\u001c3vGR$2!`A\u0002!\u0011yqH @\u0011\u0005=y\u0018bAA\u0001!\t!Aj\u001c8h\u0011\u001d\t)A\u001fa\u0001\u0003\u000f\tQ\"^:feN\u0004&o\u001c3vGR\u001c\b\u0003B\u001d=\u0003\u0013\u0001BaD 'M!11\u000f\u0001C\u0001\u0003\u001b!B!a\u0004\u0002\u0018A!\u0011\bPA\t!\r)\u00161C\u0005\u0004\u0003+\u0011!A\u0002*bi&tw\r\u0003\u0005\u0002\u0006\u0005-\u0001\u0019AA\u0004Q\u0015\tYAKA\u000eC\t\ti\"A\u00031]er\u0003\u0007\u0003\u0004t\u0001\u0011\u0005\u0011\u0011\u0005\u000b\u0005\u0003G\t\u0019\u0004\u0005\u0004\u0002&\u0005=\u0012\u0011C\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005!!.\u0019<b\u0015\r\tiCB\u0001\u0004CBL\u0017\u0002BA\u0019\u0003O\u0011qAS1wCJ#E\t\u0003\u0005\u0002\u0006\u0005}\u0001\u0019AA\u001b!!\t)#a\u000e\u0002<\u0005m\u0012\u0002BA\u001d\u0003O\u00111BS1wCB\u000b\u0017N\u001d*E\tB!\u0011QHA#\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u000b\n\t\u0005\u001d\u0013q\b\u0002\b\u0013:$XmZ3sQ\u0015\tyBKA&C\t\ti%A\u00032]Ir\u0003\u0007C\u0004\u0002R\u0001!\t!a\u0015\u0002#I,7m\\7nK:$\u0007K]8ek\u000e$8\u000f\u0006\u0004\u0002V\u0005]\u0013\u0011\f\t\u0005\u001f\t\u000b\t\u0002\u0003\u0004w\u0003\u001f\u0002\rA\n\u0005\b\u00037\ny\u00051\u0001'\u0003\rqW/\u001c\u0015\u0006\u0003\u001fR\u0013qL\u0011\u0003\u0003C\nQ!\r\u00182]ABq!!\u001a\u0001\t\u0003\t9'\u0001\bsK\u000e|W.\\3oIV\u001bXM]:\u0015\r\u0005U\u0013\u0011NA6\u0011\u0019A\u00181\ra\u0001M!9\u00111LA2\u0001\u00041\u0003&BA2U\u0005}\u0003\"CA9\u0001\t\u0007I\u0011KA:\u000351wN]7biZ+'o]5p]V\tQ\rC\u0004\u0002x\u0001\u0001\u000b\u0011B3\u0002\u001d\u0019|'/\\1u-\u0016\u00148/[8oA!9\u00111\u0010\u0001\u0005B\u0005u\u0014\u0001B:bm\u0016$R\u0001YA@\u0003\u0017C\u0001\"!!\u0002z\u0001\u0007\u00111Q\u0001\u0003g\u000e\u0004B!!\"\u0002\b6\ta!C\u0002\u0002\n\u001a\u0011Ab\u00159be.\u001cuN\u001c;fqRDq!!$\u0002z\u0001\u0007Q-\u0001\u0003qCRD\u0007&BA=U\u0005E\u0015EAAJ\u0003\u0015\tdf\r\u00181\u0011\u001d\t9\n\u0001C\u0001\u00033\u000b\u0011D]3d_6lWM\u001c3Qe>$Wo\u0019;t\r>\u0014Xk]3sgR!\u00111TAP!\u0011ID(!(\u0011\u000b=yd%!\u0016\t\u000f\u0005m\u0013Q\u0013a\u0001M!*\u0011Q\u0013\u0016\u0002$\u0006\u0012\u0011QU\u0001\u0006c9\"d\u0006\r\u0005\b\u0003S\u0003A\u0011AAV\u0003e\u0011XmY8n[\u0016tG-V:feN4uN\u001d)s_\u0012,8\r^:\u0015\t\u0005m\u0015Q\u0016\u0005\b\u00037\n9\u000b1\u0001'Q\u0015\t9KKARQ\r\u0001!\u0006M\u0004\b\u0003k\u0013\u0001\u0012AA\\\u0003ai\u0015\r\u001e:jq\u001a\u000b7\r^8sSj\fG/[8o\u001b>$W\r\u001c\t\u0004+\u0006efAB\u0001\u0003\u0011\u0003\tYl\u0005\u0004\u0002::\tiL\u0007\t\u0005+\u0005}F+C\u0002\u0002BZ\u0011a\u0001T8bI\u0016\u0014\bb\u0002*\u0002:\u0012\u0005\u0011Q\u0019\u000b\u0003\u0003oC\u0001\"!3\u0002:\u0012%\u00111Z\u0001\ne\u0016\u001cw.\\7f]\u0012$\u0002\"!4\u0002R\u0006U\u0017\u0011\u001c\t\u0005\u001f\t\u000by\r\u0005\u0003\u0010\u007f\u0019\"\u0005bBAj\u0003\u000f\u0004\r!Q\u0001\u0014e\u0016\u001cw.\\7f]\u0012$vNR3biV\u0014Xm\u001d\u0005\b\u0003/\f9\r1\u00019\u0003U\u0011XmY8n[\u0016tG-\u00192mK\u001a+\u0017\r^;sKNDq!a\u0017\u0002H\u0002\u0007a\u0005\u0003\u0005\u0002^\u0006eF\u0011BAp\u0003=\u0011XmY8n[\u0016tGMR8s\u00032dGCCAq\u0003K\f9/a;\u0002pB!\u0011\bPAr!\u0015yqHJAg\u0011\u0019!\u00131\u001ca\u0001M!9\u0011\u0011^An\u0001\u0004A\u0014aC:sG\u001a+\u0017\r^;sKNDq!!<\u0002\\\u0002\u0007\u0001(A\u0006egR4U-\u0019;ve\u0016\u001c\bbBA.\u00037\u0004\rA\n\u0005\t\u0003g\fI\f\"\u0003\u0002v\u0006A!\r\\8dW&4\u0017\u0010\u0006\u0004\u0002x\n-!Q\u0002\t\u0005sq\nI\u0010E\u0003\u0002|\n\u0015aH\u0004\u0003\u0002~\n\u0005ab\u00015\u0002\u0000&\t\u0011#C\u0002\u0003\u0004A\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\b\t%!aA*fc*\u0019!1\u0001\t\t\rE\f\t\u00101\u00019\u0011%\u0011y!!=\u0011\u0002\u0003\u0007a%A\u0005cY>\u001c7nU5{K\"A!1CA]\t\u0003\u0012)\"\u0001\u0003m_\u0006$G#\u0002+\u0003\u0018\te\u0001\u0002CAA\u0005#\u0001\r!a!\t\u000f\u00055%\u0011\u0003a\u0001K\"*!\u0011\u0003\u0016\u0002\u0012\u001eI!qDA]\u0011\u0003\u0011!\u0011E\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0005G\u0011)#\u0004\u0002\u0002:\u001aI!qEA]\u0011\u0003\u0011!\u0011\u0006\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004\u0005Kq\u0001b\u0002*\u0003&\u0011\u0005!Q\u0006\u000b\u0003\u0005CA!B!\r\u0003&\t\u0007I\u0011\u0002B\u001a\u0003E!\b.[:G_Jl\u0017\r\u001e,feNLwN\\\u000b\u0003\u0005k\u0001B!!\u0010\u00038%\u0019a.a\u0010\t\u0013\tm\"Q\u0005Q\u0001\n\tU\u0012A\u0005;iSN4uN]7biZ+'o]5p]\u0002B1Ba\u0010\u0003&\t\u0007I\u0011\u0001\u0002\u00034\u0005iA\u000f[5t\u00072\f7o\u001d(b[\u0016D\u0011Ba\u0011\u0003&\u0001\u0006IA!\u000e\u0002\u001dQD\u0017n]\"mCN\u001ch*Y7fA!A\u00111\u0010B\u0013\t\u0003\u00119\u0005F\u0003a\u0005\u0013\u0012i\u0005C\u0004\u0003L\t\u0015\u0003\u0019\u0001+\u0002\u000b5|G-\u001a7\t\u000f\u00055%Q\ta\u0001K\"A!1\u0003B\u0013\t\u0003\u0011\t\u0006F\u0003U\u0005'\u0012)\u0006\u0003\u0005\u0002\u0002\n=\u0003\u0019AAB\u0011\u001d\tiIa\u0014A\u0002\u0015D\u0001B!\u0017\u0003&\u0011%!1L\u0001\tkN,'\u000fU1uQR\u0019QM!\u0018\t\u000f\u00055%q\u000ba\u0001K\"A!\u0011\rB\u0013\t\u0013\u0011\u0019'A\u0006qe>$Wo\u0019;QCRDGcA3\u0003f!9\u0011Q\u0012B0\u0001\u0004)\u0007B\u0003B5\u0003s\u000b\n\u0011\"\u0003\u0003l\u0005\u0011\"\r\\8dW&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iGK\u0002'\u0005_Z#A!\u001d\u0011\t\tM$1P\u0007\u0003\u0005kRAAa\u001e\u0003z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003[AIAA! \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t\u0005\u0015\u0011XA\u0001\n\u0013\u0011\u0019)A\u0006sK\u0006$'+Z:pYZ,GC\u0001BC!\u0011\tiDa\"\n\t\t%\u0015q\b\u0002\u0007\u001f\nTWm\u0019;)\u000b\u0005e&&!%)\u000b\u0005M&&!%")
public class MatrixFactorizationModel
implements Saveable,
scala.Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        block1: {
            Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(name).append(" feature dimension does not match the rank ").append(this.rank()).append(".").toString());
            if (features.partitioner().isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append(name).append(" factor does not have a partitioner. ").append("Prediction on individual records could be slow.").toString());
            }
            StorageLevel storageLevel = features.getStorageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(name).append(" factor is not cached. Prediction could be slow.").toString());
        }
    }

    public double predict(int user, int product) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        double[] userVector = (double[])userFeatureSeq.head();
        double[] productVector = (double[])productFeatureSeq.head();
        return BLAS.getInstance().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2 & Serializable & scala.Serializable)(hllTuple, v) -> {
            ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
            ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
            return hllTuple;
        }, (Function2 & Serializable & scala.Serializable)(h1, h2) -> {
            ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
            ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
            return h1;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD rDD;
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long usersCount = tuple2._1$mcJ$sp();
        long productsCount = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount);
        Tuple2.mcJJ.sp sp3 = sp2;
        long usersCount2 = sp3._1$mcJ$sp();
        long productsCount2 = sp3._2$mcJ$sp();
        if (usersCount2 < productsCount2) {
            RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                int user;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        user = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double[] uFeatures = (double[])tuple2._1();
                int product = tuple2._2$mcI$sp();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                double[] pFeatures;
                Tuple2 tuple2;
                int product;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        product = tuple22._1$mcI$sp();
                        Tuple2 tuple23 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        tuple2 = (Tuple2)tuple23._1();
                        pFeatures = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int user = tuple2._1$mcI$sp();
                double[] uFeatures = (double[])tuple2._2();
                Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                return rating;
            }, ClassTag$.MODULE$.apply(Rating.class));
        } else {
            RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap$mcII$sp(), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2;
                int product;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$3;
                        if (tuple22 == null) break block2;
                        product = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double[] pFeatures = (double[])tuple2._1();
                int user = tuple2._2$mcI$sp();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                return tuple23;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(products, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                double[] uFeatures;
                Tuple2 tuple2;
                int user;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$4;
                        if (tuple22 == null) break block2;
                        user = tuple22._1$mcI$sp();
                        Tuple2 tuple23 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        tuple2 = (Tuple2)tuple23._1();
                        uFeatures = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int product = tuple2._1$mcI$sp();
                double[] pFeatures = (double[])tuple2._2();
                Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                return rating;
            }, ClassTag$.MODULE$.apply(Rating.class));
        }
        return rDD;
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])userFeatureSeq.head(), this.productFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(user, t._1$mcI$sp(), t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])productFeatureSeq.head(), this.userFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(t._1$mcI$sp(), product, t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int user = tuple2._1$mcI$sp();
            Tuple2[] top = (Tuple2[])tuple2._2();
            Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int product = tuple2._1$mcI$sp();
                double rating = tuple2._2$mcD$sp();
                Rating rating2 = new Rating(user, product, rating);
                return rating2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int product = tuple2._1$mcI$sp();
            Tuple2[] top = (Tuple2[])tuple2._2();
            Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int user = tuple2._1$mcI$sp();
                double rating = tuple2._2$mcD$sp();
                Rating rating2 = new Rating(user, product, rating);
                return rating2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

