/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u0001\u0003\u00015\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"\u0001C*bm\u0016\f'\r\\3\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n!BY8v]\u0012\f'/[3t+\u0005)\u0003cA\b'Q%\u0011q\u0005\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001f%J!A\u000b\t\u0003\r\u0011{WO\u00197fQ\r\u0011CF\r\t\u0003[Aj\u0011A\f\u0006\u0003_\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\tdFA\u0003TS:\u001cW-I\u00014\u0003\u0015\tdf\r\u00181\u0011!)\u0004A!A!\u0002\u0013)\u0013a\u00032pk:$\u0017M]5fg\u0002B3\u0001\u000e\u00173\u0011!A\u0004A!b\u0001\n\u0003!\u0013a\u00039sK\u0012L7\r^5p]ND3a\u000e\u00173\u0011!Y\u0004A!A!\u0002\u0013)\u0013\u0001\u00049sK\u0012L7\r^5p]N\u0004\u0003f\u0001\u001e-e!Aa\b\u0001BC\u0002\u0013\u0005q(\u0001\u0005jg>$xN\\5d+\u0005\u0001\u0005CA\bB\u0013\t\u0011\u0005CA\u0004C_>dW-\u00198)\u0007ub#\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003A\u0003%I7o\u001c;p]&\u001c\u0007\u0005K\u0002EYIBQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtD\u0003\u0002&M\u001dB\u0003\"a\u0013\u0001\u000e\u0003\tAQaI$A\u0002\u0015B3\u0001\u0014\u00173\u0011\u0015At\t1\u0001&Q\rqEF\r\u0005\u0006}\u001d\u0003\r\u0001\u0011\u0015\u0004!2\u0012\u0004fA$-e!9A\u000b\u0001b\u0001\n\u0013)\u0016!\u00049sK\u0012L7\r^5p]>\u0013H-F\u0001W!\r9&\fK\u0007\u00021*\u0011\u0011\fE\u0001\u0005[\u0006$\b.\u0003\u0002\\1\nAqJ\u001d3fe&tw\r\u0003\u0004^\u0001\u0001\u0006IAV\u0001\u000faJ,G-[2uS>twJ\u001d3!\u0011\u0015A\u0005\u0001\"\u0001`)\u0011Q\u0005m\u001a5\t\u000b\rr\u0006\u0019A1\u0011\u0007\t,\u0007&D\u0001d\u0015\t!\u0007$\u0001\u0003mC:<\u0017B\u00014d\u0005!IE/\u001a:bE2,\u0007\"\u0002\u001d_\u0001\u0004\t\u0007\"\u0002 _\u0001\u0004I\u0007C\u00012k\u0013\t\u00115\rK\u0002_Y1\f\u0013!\\\u0001\u0006c9\"d\u0006\r\u0005\u0006_\u0002!I\u0001]\u0001\u000eCN\u001cXM\u001d;Pe\u0012,'/\u001a3\u0015\u0007E\f)\u0001\u0006\u0002skB\u0011qb]\u0005\u0003iB\u0011A!\u00168ji\")aO\u001ca\u0002o\u0006\u0019qN\u001d3\u0011\ta\f\t\u0001\u000b\b\u0003szt!A_?\u000e\u0003mT!\u0001 \u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA@\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L1aWA\u0002\u0015\ty\b\u0003\u0003\u0004\u0002\b9\u0004\r!J\u0001\u0003qNDq!a\u0003\u0001\t\u0003\ti!A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005=\u00111\u0004\t\u0006\u0003#\t9\u0002K\u0007\u0003\u0003'Q1!!\u0006\u0007\u0003\r\u0011H\rZ\u0005\u0005\u00033\t\u0019BA\u0002S\t\u0012C\u0001\"!\b\u0002\n\u0001\u0007\u0011qB\u0001\ti\u0016\u001cH\u000fR1uC\"\"\u0011\u0011\u0002\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003G!B!!\n\u00024A!\u0011qEA\u0018\u001b\t\tICC\u0002\u001a\u0003WQ1!!\f\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003c\tICA\u0007KCZ\fGi\\;cY\u0016\u0014F\t\u0012\u0005\t\u0003;\t\t\u00031\u0001\u0002&!\"\u0011\u0011\u0005\u00173\u0011\u001d\tY\u0001\u0001C\u0001\u0003s!2\u0001KA\u001e\u0011\u001d\ti\"a\u000eA\u0002!BC!a\u000e-e!A\u0011\u0011\t\u0001\u0005\u0002\u0011\t\u0019%\u0001\bc_VtG-\u0019:z-\u0016\u001cGo\u001c:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-C!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003\u001f\nIE\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003'\u0002A\u0011\u0001\u0003\u0002D\u0005\u0001\u0002O]3eS\u000e$\u0018n\u001c8WK\u000e$xN\u001d\u0005\b\u0003/\u0002A\u0011IA-\u0003\u0011\u0019\u0018M^3\u0015\u000bI\fY&a\u001a\t\u0011\u0005u\u0013Q\u000ba\u0001\u0003?\n!a]2\u0011\t\u0005\u0005\u00141M\u0007\u0002\r%\u0019\u0011Q\r\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005%\u0014Q\u000ba\u0001\u0003W\nA\u0001]1uQB!\u0011QNA;\u001d\u0011\ty'!\u001d\u0011\u0005i\u0004\u0012bAA:!\u00051\u0001K]3eK\u001aLA!a\u001e\u0002z\t11\u000b\u001e:j]\u001eT1!a\u001d\u0011Q\u0011\t)\u0006\f7\t\u000f\u0005}\u0004\u0001\"\u0015\u0002\u0002\u0006iam\u001c:nCR4VM]:j_:,\"!a\u001b)\u0007\u0001a#gB\u0004\u0002\b\nA\t!!#\u0002/%\u001bx\u000e^8oS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007cA&\u0002\f\u001a1\u0011A\u0001E\u0001\u0003\u001b\u001br!a#\u000f\u0003\u001f\u000b)\n\u0005\u0003\u001e\u0003#S\u0015bAAJ=\t1Aj\\1eKJ\u00042aDAL\u0013\tY\u0002\u0003C\u0004I\u0003\u0017#\t!a'\u0015\u0005\u0005%u\u0001CAP\u0003\u0017CI!!)\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\t\u0005\r\u0016QU\u0007\u0003\u0003\u00173\u0001\"a*\u0002\f\"%\u0011\u0011\u0016\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004\u0003Ks\u0001b\u0002%\u0002&\u0012\u0005\u0011Q\u0016\u000b\u0003\u0003CC\u0001\"!-\u0002&\u0012\u0005\u0011\u0011Q\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>t\u0007\u0002CA[\u0003K#\t!!!\u0002\u001bQD\u0017n]\"mCN\u001ch*Y7f\r\u001d\tI,!*A\u0003w\u0013A\u0001R1uCN9\u0011q\u0017\b\u0002>\u0006U\u0005cA\b\u0002@&\u0019\u0011\u0011\u0019\t\u0003\u000fA\u0013x\u000eZ;di\"Y\u0011QYA\\\u0005+\u0007I\u0011AAd\u0003!\u0011w.\u001e8eCJLX#\u0001\u0015\t\u0015\u0005-\u0017q\u0017B\tB\u0003%\u0001&A\u0005c_VtG-\u0019:zA!Y\u0011qZA\\\u0005+\u0007I\u0011AAd\u0003)\u0001(/\u001a3jGRLwN\u001c\u0005\u000b\u0003'\f9L!E!\u0002\u0013A\u0013a\u00039sK\u0012L7\r^5p]\u0002Bq\u0001SA\\\t\u0003\t9\u000e\u0006\u0004\u0002Z\u0006u\u0017q\u001c\t\u0005\u00037\f9,\u0004\u0002\u0002&\"9\u0011QYAk\u0001\u0004A\u0003bBAh\u0003+\u0004\r\u0001\u000b\u0005\u000b\u0003G\f9,!A\u0005\u0002\u0005\u0015\u0018\u0001B2paf$b!!7\u0002h\u0006%\b\"CAc\u0003C\u0004\n\u00111\u0001)\u0011%\ty-!9\u0011\u0002\u0003\u0007\u0001\u0006\u0003\u0006\u0002n\u0006]\u0016\u0013!C\u0001\u0003_\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r*\u001a\u0001&a=,\u0005\u0005U\b\u0003BA|\u0003\u007fl!!!?\u000b\t\u0005m\u0018Q`\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\f\t\n\t\t\u0005\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B\u0003\u0003o\u000b\n\u0011\"\u0001\u0002p\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B\u0005\u0003o\u000b\t\u0011\"\u0011\u0003\f\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0004\u0011\u0007\t\u0014y!C\u0002\u0002x\rD!Ba\u0005\u00028\u0006\u0005I\u0011\u0001B\u000b\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u00119\u0002E\u0002\u0010\u00053I1Aa\u0007\u0011\u0005\rIe\u000e\u001e\u0005\u000b\u0005?\t9,!A\u0005\u0002\t\u0005\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005G\u0011I\u0003E\u0002\u0010\u0005KI1Aa\n\u0011\u0005\r\te.\u001f\u0005\u000b\u0005W\u0011i\"!AA\u0002\t]\u0011a\u0001=%c!Q!qFA\\\u0003\u0003%\tE!\r\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\r\u0011\r\tU\"1\bB\u0012\u001b\t\u00119DC\u0002\u0003:A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\u000e\u0003\u0011%#XM]1u_JD!B!\u0011\u00028\u0006\u0005I\u0011\u0001B\"\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001!\u0003F!Q!1\u0006B \u0003\u0003\u0005\rAa\t\t\u0015\t%\u0013qWA\u0001\n\u0003\u0012Y%\u0001\u0005iCND7i\u001c3f)\t\u00119\u0002\u0003\u0006\u0003P\u0005]\u0016\u0011!C!\u0005#\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u001bA!B!\u0016\u00028\u0006\u0005I\u0011\tB,\u0003\u0019)\u0017/^1mgR\u0019\u0001I!\u0017\t\u0015\t-\"1KA\u0001\u0002\u0004\u0011\u0019c\u0002\u0006\u0003^\u0005\u0015\u0016\u0011!E\u0001\u0005?\nA\u0001R1uCB!\u00111\u001cB1\r)\tI,!*\u0002\u0002#\u0005!1M\n\u0007\u0005C\u0012)'!&\u0011\u0011\t\u001d$Q\u000e\u0015)\u00033l!A!\u001b\u000b\u0007\t-\u0004#A\u0004sk:$\u0018.\\3\n\t\t=$\u0011\u000e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002%\u0003b\u0011\u0005!1\u000f\u000b\u0003\u0005?B!Ba\u0014\u0003b\u0005\u0005IQ\tB)\u0011)\u0011IH!\u0019\u0002\u0002\u0013\u0005%1P\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u00033\u0014iHa \t\u000f\u0005\u0015'q\u000fa\u0001Q!9\u0011q\u001aB<\u0001\u0004A\u0003B\u0003BB\u0005C\n\t\u0011\"!\u0003\u0006\u00069QO\\1qa2LH\u0003\u0002BD\u0005'\u0003Ra\u0004BE\u0005\u001bK1Aa#\u0011\u0005\u0019y\u0005\u000f^5p]B)qBa$)Q%\u0019!\u0011\u0013\t\u0003\rQ+\b\u000f\\33\u0011)\u0011)J!!\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0004q\u0012\u0002\u0004B\u0003BM\u0005C\n\t\u0011\"\u0003\u0003\u001c\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011i\nE\u0002c\u0005?K1A!)d\u0005\u0019y%M[3di\"A\u0011qKAS\t\u0003\u0011)\u000bF\u0006s\u0005O\u0013IKa+\u0003.\n=\u0006\u0002CA/\u0005G\u0003\r!a\u0018\t\u0011\u0005%$1\u0015a\u0001\u0003WBaa\tBR\u0001\u0004)\u0003B\u0002\u001d\u0003$\u0002\u0007Q\u0005\u0003\u0004?\u0005G\u0003\r\u0001\u0011\u0005\t\u0005g\u000b)\u000b\"\u0001\u00036\u0006!An\\1e)\u0019\u00119L!/\u0003<B)qBa$&K!A\u0011Q\fBY\u0001\u0004\ty\u0006\u0003\u0005\u0002j\tE\u0006\u0019AA6\u0011!\u0011\u0019,a#\u0005B\t}F#\u0002&\u0003B\n\r\u0007\u0002CA/\u0005{\u0003\r!a\u0018\t\u0011\u0005%$Q\u0018a\u0001\u0003WBCA!0-Y\"Q!\u0011TAF\u0003\u0003%IAa')\t\u0005-E\u0006\u001c\u0015\u0005\u0003\u000bcC\u000e")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static /* bridge */ Saveable load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = IntRef.create((int)1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Elements (").append(xs[i$1.elem - 1]).append(", ").append(xs[i$1.elem]).append(") are not ordered.").toString());
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData2) {
        return testData2.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)testData -> this.predict(testData), ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).last()) : (foundIndex < 0 ? IsotonicRegressionModel.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    private static final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

