/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.stat.KernelDensity$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011QbS3s]\u0016dG)\u001a8tSRL(BA\u0002\u0005\u0003\u0011\u0019H/\u0019;\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mK\")\u0001\u0004\u0001C\u00013\u00051A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011A\u0001\u0005\b;\u0001\u0001\r\u0011\"\u0003\u001f\u0003%\u0011\u0017M\u001c3xS\u0012$\b.F\u0001 !\ty\u0001%\u0003\u0002\"!\t1Ai\\;cY\u0016Dqa\t\u0001A\u0002\u0013%A%A\u0007cC:$w/\u001b3uQ~#S-\u001d\u000b\u0003K!\u0002\"a\u0004\u0014\n\u0005\u001d\u0002\"\u0001B+oSRDq!\u000b\u0012\u0002\u0002\u0003\u0007q$A\u0002yIEBaa\u000b\u0001!B\u0013y\u0012A\u00032b]\u0012<\u0018\u000e\u001a;iA!IQ\u0006\u0001a\u0001\u0002\u0004%IAL\u0001\u0007g\u0006l\u0007\u000f\\3\u0016\u0003=\u00022\u0001M\u001a \u001b\u0005\t$B\u0001\u001a\u0007\u0003\r\u0011H\rZ\u0005\u0003iE\u00121A\u0015#E\u0011%1\u0004\u00011AA\u0002\u0013%q'\u0001\u0006tC6\u0004H.Z0%KF$\"!\n\u001d\t\u000f%*\u0014\u0011!a\u0001_!I!\b\u0001a\u0001\u0002\u0003\u0006KaL\u0001\bg\u0006l\u0007\u000f\\3!\u0011\u0015a\u0004\u0001\"\u0001>\u00031\u0019X\r\u001e\"b]\u0012<\u0018\u000e\u001a;i)\tqt(D\u0001\u0001\u0011\u0015i2\b1\u0001 Q\rY\u0014i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u001a\t!\"\u00198o_R\fG/[8o\u0013\t15IA\u0003TS:\u001cW-I\u0001I\u0003\u0015\td\u0006\u000e\u00181\u0011\u0015Q\u0005\u0001\"\u0001L\u0003%\u0019X\r^*b[BdW\r\u0006\u0002?\u0019\")Q&\u0013a\u0001_!\u001a\u0011*Q$\t\u000b)\u0003A\u0011A(\u0015\u0005y\u0002\u0006\"B\u0017O\u0001\u0004\t\u0006c\u0001*X36\t1K\u0003\u0002U+\u0006!!.\u0019<b\u0015\t1f!A\u0002ba&L!\u0001W*\u0003\u000f)\u000bg/\u0019*E\tB\u0011!LX\u0007\u00027*\u0011A,X\u0001\u0005Y\u0006twMC\u0001U\u0013\t\t3\fK\u0002O\u0003\u001eCQ!\u0019\u0001\u0005\u0002\t\f\u0001\"Z:uS6\fG/\u001a\u000b\u0003G\u001a\u00042a\u00043 \u0013\t)\u0007CA\u0003BeJ\f\u0017\u0010C\u0003hA\u0002\u00071-\u0001\u0004q_&tGo\u001d\u0015\u0004A\u0006;\u0005f\u0001\u0001B\u000f\u001e)1N\u0001E\u0005Y\u0006i1*\u001a:oK2$UM\\:jif\u0004\"aG7\u0007\u000b\u0005\u0011\u0001\u0012\u00028\u0014\u00075tA\u0003C\u0003\u0019[\u0012\u0005\u0001\u000fF\u0001m\u0011\u0015\u0011X\u000e\"\u0001t\u0003\u001dqwN]7QI\u001a$Ra\b;wqjDQ!^9A\u0002}\tA!\\3b]\")q/\u001da\u0001?\u0005\t2\u000f^1oI\u0006\u0014H\rR3wS\u0006$\u0018n\u001c8\t\u000be\f\b\u0019A\u0010\u0002E1|wm\u0015;b]\u0012\f'\u000f\u001a#fm&\fG/[8o!2,8\u000fS1mM2{wM\r)j\u0011\u0015Y\u0018\u000f1\u0001 \u0003\u0005A\bbB?n\u0003\u0003%IA`\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u0000!\rQ\u0016\u0011A\u0005\u0004\u0003\u0007Y&AB(cU\u0016\u001cG\u000f")
public class KernelDensity
implements Serializable {
    private double bandwidth = 1.0;
    private RDD<Object> sample;

    public static double normPdf(double d, double d2, double d3, double d4) {
        return KernelDensity$.MODULE$.normPdf(d, d2, d3, d4);
    }

    private double bandwidth() {
        return this.bandwidth;
    }

    private void bandwidth_$eq(double x$1) {
        this.bandwidth = x$1;
    }

    private RDD<Object> sample() {
        return this.sample;
    }

    private void sample_$eq(RDD<Object> x$1) {
        this.sample = x$1;
    }

    public KernelDensity setBandwidth(double bandwidth) {
        Predef$.MODULE$.require(bandwidth > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("Bandwidth must be positive, but got ").append(bandwidth).append(".").toString());
        this.bandwidth_$eq(bandwidth);
        return this;
    }

    public KernelDensity setSample(RDD<Object> sample) {
        this.sample_$eq(sample);
        return this;
    }

    public KernelDensity setSample(JavaRDD<Double> sample) {
        this.sample_$eq((RDD<Object>)sample.rdd());
        return this;
    }

    public double[] estimate(double[] points) {
        RDD<Object> sample = this.sample();
        double bandwidth = this.bandwidth();
        Predef$.MODULE$.require(sample != null, (Function0 & java.io.Serializable & Serializable)() -> "Must set sample before calling estimate.");
        int n = points.length;
        double logStandardDeviationPlusHalfLog2Pi = package$.MODULE$.log(bandwidth) + 0.5 * package$.MODULE$.log(Math.PI * 2);
        Tuple2 tuple2 = (Tuple2)sample.aggregate((Object)new Tuple2((Object)new double[n], (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & java.io.Serializable & Serializable)(x, y) -> KernelDensity.$anonfun$estimate$2(points, bandwidth, n, logStandardDeviationPlusHalfLog2Pi, x, BoxesRunTime.unboxToDouble((Object)y)), (Function2 & java.io.Serializable & Serializable)(x, y) -> {
            BLAS.getInstance().daxpy(n, 1.0, (double[])y._1(), 1, (double[])x._1(), 1);
            return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + y._2$mcJ$sp())));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] densities = (double[])tuple2._1();
        long count = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)densities, (Object)BoxesRunTime.boxToLong((long)count));
        Tuple2 tuple23 = tuple22;
        double[] densities2 = (double[])tuple23._1();
        long count2 = tuple23._2$mcJ$sp();
        BLAS.getInstance().dscal(n, 1.0 / (double)count2, densities2, 1);
        return densities2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$estimate$2(double[] points$1, double bandwidth$2, int n$1, double logStandardDeviationPlusHalfLog2Pi$1, Tuple2 x, double y) {
        for (int i = 0; i < n$1; ++i) {
            int n = i;
            ((double[])x._1())[n] = ((double[])x._1())[n] + KernelDensity$.MODULE$.normPdf(y, bandwidth$2, logStandardDeviationPlusHalfLog2Pi$1, points$1[i]);
        }
        return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + 1L)));
    }
}

