/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00015\u0011A$T;mi&4\u0018M]5bi\u0016|e\u000e\\5oKN+X.\\1sSj,'O\u0003\u0002\u0004\t\u0005!1\u000f^1u\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003=5+H\u000e^5wCJL\u0017\r^3Ti\u0006$\u0018n\u001d;jG\u0006d7+^7nCJL\bCA\b\u001a\u0013\tQ\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011Q\u0003\u0001\u0005\bA\u0001\u0001\r\u0011\"\u0003\"\u0003\u0005qW#\u0001\u0012\u0011\u0005=\u0019\u0013B\u0001\u0013\u0011\u0005\rIe\u000e\u001e\u0005\bM\u0001\u0001\r\u0011\"\u0003(\u0003\u0015qw\fJ3r)\tA3\u0006\u0005\u0002\u0010S%\u0011!\u0006\u0005\u0002\u0005+:LG\u000fC\u0004-K\u0005\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAI\u0001\u0003]\u0002B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011B\u0019\u0002\u0011\r,(O]'fC:,\u0012A\r\t\u0004\u001fM*\u0014B\u0001\u001b\u0011\u0005\u0015\t%O]1z!\tya'\u0003\u00028!\t1Ai\\;cY\u0016D\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002\u0019\r,(O]'fC:|F%Z9\u0015\u0005!Z\u0004b\u0002\u00179\u0003\u0003\u0005\rA\r\u0005\n{\u0001\u0001\r\u0011!Q!\nI\n\u0011bY;se6+\u0017M\u001c\u0011\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0013\t\u0014aB2veJl%G\u001c\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000b1bY;se6\u0013dn\u0018\u0013fcR\u0011\u0001f\u0011\u0005\bY\u0001\u000b\t\u00111\u00013\u0011%)\u0005\u00011A\u0001B\u0003&!'\u0001\u0005dkJ\u0014XJ\r8!\u0011%9\u0005\u00011AA\u0002\u0013%\u0011'\u0001\u0004dkJ\u0014XJ\r\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n)\u000b!bY;se6\u0013t\fJ3r)\tA3\nC\u0004-\u0011\u0006\u0005\t\u0019\u0001\u001a\t\u00135\u0003\u0001\u0019!A!B\u0013\u0011\u0014aB2veJl%\u0007\t\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\nE\naaY;se2\u000b\u0004\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0003S\u0003)\u0019WO\u001d:Mc}#S-\u001d\u000b\u0003QMCq\u0001\f)\u0002\u0002\u0003\u0007!\u0007C\u0005V\u0001\u0001\u0007\t\u0011)Q\u0005e\u000591-\u001e:s\u0019F\u0002\u0003bB,\u0001\u0001\u0004%I\u0001W\u0001\ti>$\u0018\r\\\"oiV\t\u0011\f\u0005\u0002\u00105&\u00111\f\u0005\u0002\u0005\u0019>tw\rC\u0004^\u0001\u0001\u0007I\u0011\u00020\u0002\u0019Q|G/\u00197D]R|F%Z9\u0015\u0005!z\u0006b\u0002\u0017]\u0003\u0003\u0005\r!\u0017\u0005\u0007C\u0002\u0001\u000b\u0015B-\u0002\u0013Q|G/\u00197D]R\u0004\u0003bB2\u0001\u0001\u0004%I\u0001Z\u0001\u000fi>$\u0018\r\\,fS\u001eDGoU;n+\u0005)\u0004b\u00024\u0001\u0001\u0004%IaZ\u0001\u0013i>$\u0018\r\\,fS\u001eDGoU;n?\u0012*\u0017\u000f\u0006\u0002)Q\"9A&ZA\u0001\u0002\u0004)\u0004B\u00026\u0001A\u0003&Q'A\bu_R\fGnV3jO\"$8+^7!\u0011\u001da\u0007\u00011A\u0005\n\u0011\fqb^3jO\"$8+];be\u0016\u001cV/\u001c\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u0003M9X-[4iiN\u000bX/\u0019:f'Vlw\fJ3r)\tA\u0003\u000fC\u0004-[\u0006\u0005\t\u0019A\u001b\t\rI\u0004\u0001\u0015)\u00036\u0003A9X-[4iiN\u000bX/\u0019:f'Vl\u0007\u0005C\u0005u\u0001\u0001\u0007\t\u0019!C\u0005c\u0005Iq/Z5hQR\u001cV/\u001c\u0005\nm\u0002\u0001\r\u00111A\u0005\n]\fQb^3jO\"$8+^7`I\u0015\fHC\u0001\u0015y\u0011\u001daS/!AA\u0002IB\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\u0002\u0015],\u0017n\u001a5u'Vl\u0007\u0005C\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\u0006\u0019aN\u001c>\u0016\u0003y\u00042aD\u001aZ\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%I!a\u0001\u0002\u000f9t'p\u0018\u0013fcR\u0019\u0001&!\u0002\t\u000f1z\u0018\u0011!a\u0001}\"Q\u0011\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\u0002\t9t'\u0010\t\u0005\u000b\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\t\u0014aB2veJl\u0015\r\u001f\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\"A\u0006dkJ\u0014X*\u0019=`I\u0015\fHc\u0001\u0015\u0002\u0016!AA&a\u0004\u0002\u0002\u0003\u0007!\u0007\u0003\u0006\u0002\u001a\u0001\u0001\r\u0011!Q!\nI\n\u0001bY;se6\u000b\u0007\u0010\t\u0005\u000b\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\t\u0014aB2veJl\u0015N\u001c\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019#A\u0006dkJ\u0014X*\u001b8`I\u0015\fHc\u0001\u0015\u0002&!AA&a\b\u0002\u0002\u0003\u0007!\u0007\u0003\u0006\u0002*\u0001\u0001\r\u0011!Q!\nI\n\u0001bY;se6Kg\u000e\t\u0005\b\u0003[\u0001A\u0011AA\u0018\u0003\r\tG\r\u001a\u000b\u0005\u0003c\t\u0019$D\u0001\u0001\u0011!\t)$a\u000bA\u0002\u0005]\u0012AB:b[BdW\r\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005\u0005\u00131\b\u0002\u0007-\u0016\u001cGo\u001c:)\r\u0005-\u0012QIA)!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\u0006'&t7-Z\u0011\u0003\u0003'\nQ!\r\u00182]AB\u0001\"!\f\u0001\t\u00031\u0011q\u000b\u000b\u0007\u0003c\tI&!\u0018\t\u0011\u0005m\u0013Q\u000ba\u0001\u0003o\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\b\u0003?\n)\u00061\u00016\u0003\u00199X-[4ii\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014!B7fe\u001e,G\u0003BA\u0019\u0003OBq!!\u001b\u0002b\u0001\u0007a$A\u0003pi\",'\u000f\u000b\u0004\u0002b\u0005\u0015\u0013\u0011\u000b\u0005\b\u0003_\u0002A\u0011IA9\u0003\u0011iW-\u00198\u0016\u0005\u0005]\u0002FBA7\u0003\u000b\n\t\u0006C\u0004\u0002x\u0001!\t%!\u001d\u0002\u0011Y\f'/[1oG\u0016Dc!!\u001e\u0002F\u0005E\u0003BBA?\u0001\u0011\u0005\u0003,A\u0003d_VtG\u000f\u000b\u0004\u0002|\u0005\u0015\u0013\u0011\u000b\u0005\b\u0003\u0007\u0003A\u0011IA9\u0003-qW/\u001c(p]j,'o\\:)\r\u0005\u0005\u0015QIA)\u0011\u001d\tI\t\u0001C!\u0003c\n1!\\1yQ\u0019\t9)!\u0012\u0002R!9\u0011q\u0012\u0001\u0005B\u0005E\u0014aA7j]\"2\u0011QRA#\u0003#Bq!!&\u0001\t\u0003\n\t(\u0001\u0004o_JlGJ\r\u0015\u0007\u0003'\u000b)%!'\"\u0005\u0005m\u0015!B\u0019/e9\u0002\u0004bBAP\u0001\u0011\u0005\u0013\u0011O\u0001\u0007]>\u0014X\u000eT\u0019)\r\u0005u\u0015QIAMQ\r\u0001\u0011Q\u0015\t\u0005\u0003\u000f\n9+\u0003\u0003\u0002*\u0006%#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007&\u0002\u0001\u0002F\u0005E\u0003")
public class MultivariateOnlineSummarizer
implements MultivariateStatisticalSummary,
scala.Serializable {
    private int n = 0;
    private double[] currMean;
    private double[] currM2n;
    private double[] currM2;
    private double[] currL1;
    private long totalCnt = 0L;
    private double totalWeightSum = 0.0;
    private double weightSquareSum = 0.0;
    private double[] weightSum;
    private long[] nnz;
    private double[] currMax;
    private double[] currMin;

    private int n() {
        return this.n;
    }

    private void n_$eq(int x$1) {
        this.n = x$1;
    }

    private double[] currMean() {
        return this.currMean;
    }

    private void currMean_$eq(double[] x$1) {
        this.currMean = x$1;
    }

    private double[] currM2n() {
        return this.currM2n;
    }

    private void currM2n_$eq(double[] x$1) {
        this.currM2n = x$1;
    }

    private double[] currM2() {
        return this.currM2;
    }

    private void currM2_$eq(double[] x$1) {
        this.currM2 = x$1;
    }

    private double[] currL1() {
        return this.currL1;
    }

    private void currL1_$eq(double[] x$1) {
        this.currL1 = x$1;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double totalWeightSum() {
        return this.totalWeightSum;
    }

    private void totalWeightSum_$eq(double x$1) {
        this.totalWeightSum = x$1;
    }

    private double weightSquareSum() {
        return this.weightSquareSum;
    }

    private void weightSquareSum_$eq(double x$1) {
        this.weightSquareSum = x$1;
    }

    private double[] weightSum() {
        return this.weightSum;
    }

    private void weightSum_$eq(double[] x$1) {
        this.weightSum = x$1;
    }

    private long[] nnz() {
        return this.nnz;
    }

    private void nnz_$eq(long[] x$1) {
        this.nnz = x$1;
    }

    private double[] currMax() {
        return this.currMax;
    }

    private void currMax_$eq(double[] x$1) {
        this.currMax = x$1;
    }

    private double[] currMin() {
        return this.currMin;
    }

    private void currMin_$eq(double[] x$1) {
        this.currMin = x$1;
    }

    public MultivariateOnlineSummarizer add(Vector sample) {
        return this.add(sample, 1.0);
    }

    public MultivariateOnlineSummarizer add(Vector instance, double weight) {
        Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("sample weight, ").append(weight).append(" has to be >= 0.0").toString());
        if (weight == 0.0) {
            return this;
        }
        if (this.n() == 0) {
            Predef$.MODULE$.require(instance.size() > 0, (Function0 & Serializable & scala.Serializable)() -> "Vector should have dimension larger than zero.");
            this.n_$eq(instance.size());
            this.currMean_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2n_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currM2_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.currL1_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.weightSum_$eq((double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double()));
            this.nnz_$eq((long[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Long()));
            this.currMax_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double$.MODULE$.MinValue(), ClassTag$.MODULE$.Double()));
            this.currMin_$eq((double[])Array$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.MAX_VALUE, ClassTag$.MODULE$.Double()));
        }
        Predef$.MODULE$.require(this.n() == instance.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Dimensions mismatch when adding new sample.").append(new StringBuilder(21).append(" Expecting ").append(this.n()).append(" but got ").append(instance.size()).append(".").toString()).toString());
        double[] localCurrMean = this.currMean();
        double[] localCurrM2n = this.currM2n();
        double[] localCurrM2 = this.currM2();
        double[] localCurrL1 = this.currL1();
        double[] localWeightSum = this.weightSum();
        long[] localNumNonzeros = this.nnz();
        double[] localCurrMax = this.currMax();
        double[] localCurrMin = this.currMin();
        instance.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            block2: {
                if (value == 0.0) break block2;
                if (localCurrMax[index] < value) {
                    localCurrMax$1[index] = value;
                }
                if (localCurrMin[index] > value) {
                    localCurrMin$1[index] = value;
                }
                double prevMean = localCurrMean[index];
                double diff = value - prevMean;
                localCurrMean$1[index] = prevMean + weight * diff / (localWeightSum[index] + weight);
                localCurrM2n$1[index] = localCurrM2n[index] + weight * (value - localCurrMean[index]) * diff;
                localCurrM2$1[index] = localCurrM2[index] + weight * value * value;
                localCurrL1$1[index] = localCurrL1[index] + weight * package$.MODULE$.abs(value);
                localWeightSum$1[index] = localWeightSum[index] + weight;
                localNumNonzeros$1[index] = localNumNonzeros[index] + 1L;
            }
        });
        this.totalWeightSum_$eq(this.totalWeightSum() + weight);
        this.weightSquareSum_$eq(this.weightSquareSum() + weight * weight);
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public MultivariateOnlineSummarizer merge(MultivariateOnlineSummarizer other) {
        block3: {
            block2: {
                if (this.totalWeightSum() == 0.0 || other.totalWeightSum() == 0.0) break block2;
                Predef$.MODULE$.require(this.n() == other.n(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Dimensions mismatch when merging with another summarizer. ").append(new StringBuilder(20).append("Expecting ").append(this.n()).append(" but got ").append(other.n()).append(".").toString()).toString());
                this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
                this.totalWeightSum_$eq(this.totalWeightSum() + other.totalWeightSum());
                this.weightSquareSum_$eq(this.weightSquareSum() + other.weightSquareSum());
                for (int i = 0; i < this.n(); ++i) {
                    double thisNnz = this.weightSum()[i];
                    double otherNnz = other.weightSum()[i];
                    double totalNnz = thisNnz + otherNnz;
                    long totalCnnz = this.nnz()[i] + other.nnz()[i];
                    if (totalNnz != 0.0) {
                        double deltaMean = other.currMean()[i] - this.currMean()[i];
                        double[] dArray = this.currMean();
                        int n = i;
                        dArray[n] = dArray[n] + deltaMean * otherNnz / totalNnz;
                        double[] dArray2 = this.currM2n();
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + (other.currM2n()[i] + deltaMean * deltaMean * thisNnz * otherNnz / totalNnz);
                        double[] dArray3 = this.currM2();
                        int n3 = i;
                        dArray3[n3] = dArray3[n3] + other.currM2()[i];
                        double[] dArray4 = this.currL1();
                        int n4 = i;
                        dArray4[n4] = dArray4[n4] + other.currL1()[i];
                        this.currMax()[i] = package$.MODULE$.max(this.currMax()[i], other.currMax()[i]);
                        this.currMin()[i] = package$.MODULE$.min(this.currMin()[i], other.currMin()[i]);
                    }
                    this.weightSum()[i] = totalNnz;
                    this.nnz()[i] = totalCnnz;
                }
                break block3;
            }
            if (this.totalWeightSum() != 0.0 || other.totalWeightSum() == 0.0) break block3;
            this.n_$eq(other.n());
            this.currMean_$eq((double[])other.currMean().clone());
            this.currM2n_$eq((double[])other.currM2n().clone());
            this.currM2_$eq((double[])other.currM2().clone());
            this.currL1_$eq((double[])other.currL1().clone());
            this.totalCnt_$eq(other.totalCnt());
            this.totalWeightSum_$eq(other.totalWeightSum());
            this.weightSquareSum_$eq(other.weightSquareSum());
            this.weightSum_$eq((double[])other.weightSum().clone());
            this.nnz_$eq((long[])other.nnz().clone());
            this.currMax_$eq((double[])other.currMax().clone());
            this.currMin_$eq((double[])other.currMin().clone());
        }
        return this;
    }

    @Override
    public Vector mean() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMean = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.n(); ++i) {
            realMean[i] = this.currMean()[i] * (this.weightSum()[i] / this.totalWeightSum());
        }
        return Vectors$.MODULE$.dense(realMean);
    }

    @Override
    public Vector variance() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realVariance = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        double denominator = this.totalWeightSum() - this.weightSquareSum() / this.totalWeightSum();
        if (denominator > 0.0) {
            double[] deltaMean = this.currMean();
            int len = this.currM2n().length;
            for (int i = 0; i < len; ++i) {
                realVariance[i] = package$.MODULE$.max((this.currM2n()[i] + deltaMean[i] * deltaMean[i] * this.weightSum()[i] * (this.totalWeightSum() - this.weightSum()[i]) / this.totalWeightSum()) / denominator, 0.0);
            }
        }
        return Vectors$.MODULE$.dense(realVariance);
    }

    @Override
    public long count() {
        return this.totalCnt();
    }

    @Override
    public Vector numNonzeros() {
        Predef$.MODULE$.require(this.totalCnt() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.nnz())).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public Vector max() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMax()[i] < 0.0)) continue;
            this.currMax()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMax());
    }

    @Override
    public Vector min() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        for (int i = 0; i < this.n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMin()[i] > 0.0)) continue;
            this.currMin()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMin());
    }

    @Override
    public Vector normL2() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        double[] realMagnitude = (double[])Array$.MODULE$.ofDim(this.n(), ClassTag$.MODULE$.Double());
        int len = this.currM2().length;
        for (int i = 0; i < len; ++i) {
            realMagnitude[i] = package$.MODULE$.sqrt(this.currM2()[i]);
        }
        return Vectors$.MODULE$.dense(realMagnitude);
    }

    @Override
    public Vector normL1() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Nothing has been added to this summarizer.");
        return Vectors$.MODULE$.dense(this.currL1());
    }
}

