/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.correlation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.correlation.Correlation;
import org.apache.spark.mllib.stat.correlation.PearsonCorrelation$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class SpearmanCorrelation$
implements Correlation,
Logging {
    public static SpearmanCorrelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SpearmanCorrelation$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public double computeCorrelationWithMatrixImpl(RDD<Object> x, RDD<Object> y) {
        return Correlation.computeCorrelationWithMatrixImpl$(this, x, y);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public double computeCorrelation(RDD<Object> x, RDD<Object> y) {
        return this.computeCorrelationWithMatrixImpl(x, y);
    }

    @Override
    public Matrix computeCorrelationMatrix(RDD<Vector> X) {
        RDD colBased = X.zipWithUniqueId().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector vec = (Vector)tuple2._1();
            long uid = tuple2._2$mcJ$sp();
            Seq seq = (Seq)((TraversableViewLike)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vec.toArray())).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double v = tuple2._1$mcD$sp();
                int j = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcID.sp(j, v), (Object)BoxesRunTime.boxToLong((long)uid));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
            return seq;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(colBased, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Double$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Long());
        boolean x$3 = qual$1.sortByKey$default$1();
        int x$4 = qual$1.sortByKey$default$2();
        RDD sorted = qual$1.sortByKey(x$3, x$4);
        RDD qual$2 = sorted.zipWithIndex();
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)iter -> {
            IntRef preCol = IntRef.create((int)-1);
            DoubleRef preVal = DoubleRef.create((double)Double.NaN);
            DoubleRef startRank = DoubleRef.create((double)-1.0);
            ArrayBuffer cachedUids = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            Function0 & Serializable & scala.Serializable flush = (Function0 & Serializable & scala.Serializable)() -> {
                double averageRank = startRank$1.elem + (double)(cachedUids.size() - 1) / 2.0;
                ArrayBuffer output = (ArrayBuffer)cachedUids.map((Function1 & Serializable & scala.Serializable)uid -> SpearmanCorrelation$.$anonfun$computeCorrelationMatrix$5(preCol, averageRank, BoxesRunTime.unboxToLong((Object)uid)), ArrayBuffer$.MODULE$.canBuildFrom());
                cachedUids.clear();
                return output;
            };
            return iter.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Iterator iterator;
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                long rank = tuple2._2$mcJ$sp();
                if (tuple22 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                long uid = tuple22._2$mcJ$sp();
                if (tuple23 == null) throw new MatchError((Object)tuple2);
                int j = tuple23._1$mcI$sp();
                double v = tuple23._2$mcD$sp();
                if (j != preCol$1.elem || v != preVal$1.elem || cachedUids.size() >= 10000000) {
                    Iterable output = (Iterable)flush.apply();
                    preCol$1.elem = j;
                    preVal$1.elem = v;
                    startRank$1.elem = rank;
                    cachedUids.$plus$eq((Object)BoxesRunTime.boxToLong((long)uid));
                    iterator = output;
                    return iterator;
                } else {
                    cachedUids.$plus$eq((Object)BoxesRunTime.boxToLong((long)uid));
                    iterator = package$.MODULE$.Iterator().empty();
                }
                return iterator;
            }).$plus$plus((Function0)flush);
        };
        boolean x$6 = qual$2.mapPartitions$default$2();
        RDD globalRanks = qual$2.mapPartitions((Function1)x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD groupedRanks = RDD$.MODULE$.rddToPairRDDFunctions(globalRanks, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable iter = (Iterable)tuple2._2();
            Vector vector = Vectors$.MODULE$.dense((double[])((TraversableOnce)((TraversableLike)iter.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._2$mcD$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
            return vector;
        }, ClassTag$.MODULE$.apply(Vector.class));
        return PearsonCorrelation$.MODULE$.computeCorrelationMatrix((RDD<Vector>)groupedRanks);
    }

    public static final /* synthetic */ Tuple2 $anonfun$computeCorrelationMatrix$5(IntRef preCol$1, double averageRank$1, long uid) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)uid), (Object)new Tuple2.mcID.sp(preCol$1.elem, averageRank$1));
    }

    private SpearmanCorrelation$() {
        MODULE$ = this;
        Correlation.$init$(this);
        Logging.$init$((Logging)this);
    }
}

