/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTestMethod;
import org.apache.spark.mllib.stat.test.StreamingTestMethod$;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.mllib.stat.test.WelchTTest$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.StatCounter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0017N\\4UKN$(BA\u0002\u0005\u0003\u0011!Xm\u001d;\u000b\u0005\u00151\u0011\u0001B:uCRT!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Ya\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007CA\t\u001e\u0013\tq\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u0005!\u001aq$J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!B\u0011AC1o]>$\u0018\r^5p]&\u0011!f\n\u0002\u0006'&t7-Z\u0011\u0002Y\u0005)\u0011G\f\u001c/a!9a\u0006\u0001a\u0001\n\u0013y\u0013a\u00039fC\u000e,\u0007+\u001a:j_\u0012,\u0012\u0001\r\t\u0003#EJ!A\r\n\u0003\u0007%sG\u000fC\u00045\u0001\u0001\u0007I\u0011B\u001b\u0002\u001fA,\u0017mY3QKJLw\u000eZ0%KF$\"AN\u001d\u0011\u0005E9\u0014B\u0001\u001d\u0013\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\rq\u0002\u0001\u0015)\u00031\u00031\u0001X-Y2f!\u0016\u0014\u0018n\u001c3!\u0011\u001dq\u0004\u00011A\u0005\n=\n!b^5oI><8+\u001b>f\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005\u000bab^5oI><8+\u001b>f?\u0012*\u0017\u000f\u0006\u00027\u0005\"9!hPA\u0001\u0002\u0004\u0001\u0004B\u0002#\u0001A\u0003&\u0001'A\u0006xS:$wn^*ju\u0016\u0004\u0003b\u0002$\u0001\u0001\u0004%IaR\u0001\u000bi\u0016\u001cH/T3uQ>$W#\u0001%\u0011\u0005\rJ\u0015B\u0001&\u0003\u0005M\u0019FO]3b[&tw\rV3ti6+G\u000f[8e\u0011\u001da\u0005\u00011A\u0005\n5\u000ba\u0002^3ti6+G\u000f[8e?\u0012*\u0017\u000f\u0006\u00027\u001d\"9!hSA\u0001\u0002\u0004A\u0005B\u0002)\u0001A\u0003&\u0001*A\u0006uKN$X*\u001a;i_\u0012\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016AD:fiB+\u0017mY3QKJLw\u000e\u001a\u000b\u0003)Vk\u0011\u0001\u0001\u0005\u0006]E\u0003\r\u0001\r\u0015\u0004#\u0016Z\u0003\"\u0002-\u0001\t\u0003I\u0016!D:fi^Kg\u000eZ8x'&TX\r\u0006\u0002U5\")ah\u0016a\u0001a!\u001aq+J\u0016\t\u000bu\u0003A\u0011\u00010\u0002\u001bM,G\u000fV3ti6+G\u000f[8e)\t!v\fC\u0003a9\u0002\u0007\u0011-\u0001\u0004nKRDw\u000e\u001a\t\u0003E&t!aY4\u0011\u0005\u0011\u0014R\"A3\u000b\u0005\u0019t\u0011A\u0002\u001fs_>$h(\u0003\u0002i%\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA'\u0003K\u0002]K-BQA\u001c\u0001\u0005\u0002=\faB]3hSN$XM]*ue\u0016\fW\u000e\u0006\u0002qwB\u0019\u0011O\u001e=\u000e\u0003IT!a\u001d;\u0002\u000f\u0011\u001cHO]3b[*\u0011Q\u000fC\u0001\ngR\u0014X-Y7j]\u001eL!a\u001e:\u0003\u000f\u0011\u001bFO]3b[B\u00111%_\u0005\u0003u\n\u00111c\u0015;sK\u0006l\u0017N\\4UKN$(+Z:vYRDQ\u0001`7A\u0002u\fA\u0001Z1uCB\u0019\u0011O\u001e@\u0011\u0005\rz\u0018bAA\u0001\u0005\ta!)\u001b8bef\u001c\u0016-\u001c9mK\"\u001aQ.J\u0016\t\r9\u0004A\u0011AA\u0004)\u0011\tI!!\u0007\u0011\u000b\u0005-\u0011Q\u0003=\u000e\u0005\u00055!\u0002BA\b\u0003#\tAA[1wC*\u0019\u00111\u0003;\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0018\u00055!a\u0003&bm\u0006$5\u000b\u001e:fC6Dq\u0001`A\u0003\u0001\u0004\tY\u0002E\u0003\u0002\f\u0005Ua\u0010\u000b\u0003\u0002\u0006\u0015Z\u0003\u0002CA\u0011\u0001\u0011\u0005A!a\t\u0002\u001f\u0011\u0014x\u000e\u001d)fC\u000e,\u0007+\u001a:j_\u0012$2!`A\u0013\u0011\u0019a\u0018q\u0004a\u0001{\"A\u0011\u0011\u0006\u0001\u0005\u0002\u0011\tY#A\ftk6l\u0017M]5{K\nK8*Z=B]\u0012<\u0016N\u001c3poR!\u0011QFA$!\u0011\th/a\f\u0011\u000fE\t\t$!\u000e\u0002<%\u0019\u00111\u0007\n\u0003\rQ+\b\u000f\\33!\r\t\u0012qG\u0005\u0004\u0003s\u0011\"a\u0002\"p_2,\u0017M\u001c\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\nyDA\u0006Ti\u0006$8i\\;oi\u0016\u0014\bB\u0002?\u0002(\u0001\u0007Q\u0010\u0003\u0005\u0002L\u0001!\t\u0001BA'\u00035\u0001\u0018-\u001b:Tk6l\u0017M]5fgR!\u0011qJA*!\u0011\th/!\u0015\u0011\u000fE\t\t$a\u000f\u0002<!A\u0011QKA%\u0001\u0004\ti#\u0001\btk6l\u0017M]5{K\u0012$\u0015\r^1)\u0007\u0001)3\u0006")
public class StreamingTest
implements Logging,
scala.Serializable {
    private int peacePeriod;
    private int windowSize;
    private StreamingTestMethod testMethod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int peacePeriod() {
        return this.peacePeriod;
    }

    private void peacePeriod_$eq(int x$1) {
        this.peacePeriod = x$1;
    }

    private int windowSize() {
        return this.windowSize;
    }

    private void windowSize_$eq(int x$1) {
        this.windowSize = x$1;
    }

    private StreamingTestMethod testMethod() {
        return this.testMethod;
    }

    private void testMethod_$eq(StreamingTestMethod x$1) {
        this.testMethod = x$1;
    }

    public StreamingTest setPeacePeriod(int peacePeriod) {
        this.peacePeriod_$eq(peacePeriod);
        return this;
    }

    public StreamingTest setWindowSize(int windowSize) {
        this.windowSize_$eq(windowSize);
        return this;
    }

    public StreamingTest setTestMethod(String method) {
        this.testMethod_$eq(StreamingTestMethod$.MODULE$.getTestMethodFromName(method));
        return this;
    }

    public DStream<StreamingTestResult> registerStream(DStream<BinarySample> data) {
        DStream<BinarySample> dataAfterPeacePeriod = this.dropPeacePeriod(data);
        DStream<Tuple2<Object, StatCounter>> summarizedData = this.summarizeByKeyAndWindow(dataAfterPeacePeriod);
        DStream<Tuple2<StatCounter, StatCounter>> pairedSummaries = this.pairSummaries(summarizedData);
        return this.testMethod().doTest(pairedSummaries);
    }

    public JavaDStream<StreamingTestResult> registerStream(JavaDStream<BinarySample> data) {
        return JavaDStream$.MODULE$.fromDStream(this.registerStream((DStream<BinarySample>)data.dstream()), ClassTag$.MODULE$.apply(StreamingTestResult.class));
    }

    public DStream<BinarySample> dropPeacePeriod(DStream<BinarySample> data) {
        return data.transform((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
            RDD rDD;
            if (time.milliseconds() > data.slideDuration().milliseconds() * (long)this.peacePeriod()) {
                rDD = rdd;
            } else {
                SparkContext qual$1 = data.context().sparkContext();
                Seq x$1 = (Seq)Seq$.MODULE$.empty();
                int x$2 = qual$1.parallelize$default$2();
                rDD = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(BinarySample.class));
            }
            return rDD;
        }, ClassTag$.MODULE$.apply(BinarySample.class));
    }

    public DStream<Tuple2<Object, StatCounter>> summarizeByKeyAndWindow(DStream<BinarySample> data) {
        DStream dStream;
        DStream categoryValuePair = data.map((Function1 & Serializable & scala.Serializable)sample -> new Tuple2.mcZD.sp(sample.isExperiment(), sample.value()), ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.windowSize() == 0) {
            dStream = DStream$.MODULE$.toPairDStreamFunctions(categoryValuePair, ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Boolean$.MODULE$).updateStateByKey((Function2 & Serializable & scala.Serializable)(newValues, oldSummary) -> {
                StatCounter newSummary = (StatCounter)oldSummary.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StatCounter());
                newSummary.merge((TraversableOnce)newValues);
                return new Some((Object)newSummary);
            }, ClassTag$.MODULE$.apply(StatCounter.class));
        } else {
            Duration windowDuration = data.slideDuration().$times(this.windowSize());
            dStream = DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(categoryValuePair, ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Boolean$.MODULE$).groupByKeyAndWindow(windowDuration), ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Boolean$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)values -> {
                void var1_1;
                StatCounter summary = new StatCounter();
                values.foreach((Function1 & Serializable & scala.Serializable)value -> summary.merge(BoxesRunTime.unboxToDouble((Object)value)));
                return var1_1;
            }, ClassTag$.MODULE$.apply(StatCounter.class));
        }
        return dStream;
    }

    public DStream<Tuple2<StatCounter, StatCounter>> pairSummaries(DStream<Tuple2<Object, StatCounter>> summarizedData) {
        return DStream$.MODULE$.toPairDStreamFunctions(summarizedData.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), x._2()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(StatCounter.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((IterableLike)x._2()).head(), ((TraversableLike)x._2()).last()), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public StreamingTest() {
        Logging.$init$((Logging)this);
        this.peacePeriod = 0;
        this.windowSize = 0;
        this.testMethod = WelchTTest$.MODULE$;
    }
}

