/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Predict;
import org.apache.spark.mllib.tree.model.Split;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0001\u0003\u0001=\u0011AAT8eK*\u00111\u0001B\u0001\u0006[>$W\r\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001e:fK*\u0011q\u0001C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-e\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001f7\t9Aj\\4hS:<\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u0005%$W#\u0001\u0012\u0011\u0005E\u0019\u0013B\u0001\u0013\u0013\u0005\rIe\u000e\u001e\u0015\u0004?\u0019b\u0003CA\u0014+\u001b\u0005A#BA\u0015\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003W!\u0012QaU5oG\u0016\f\u0013!L\u0001\u0006c9\u0002d\u0006\r\u0005\t_\u0001\u0011\t\u0011)A\u0005E\u0005\u0019\u0011\u000e\u001a\u0011)\u000792C\u0006\u0003\u00053\u0001\t\u0005\r\u0011\"\u00014\u0003\u001d\u0001(/\u001a3jGR,\u0012\u0001\u000e\t\u0003kYj\u0011AA\u0005\u0003o\t\u0011q\u0001\u0015:fI&\u001cG\u000fK\u00022M1B\u0001B\u000f\u0001\u0003\u0002\u0004%\taO\u0001\faJ,G-[2u?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011\u0011#P\u0005\u0003}I\u0011A!\u00168ji\"9\u0001)OA\u0001\u0002\u0004!\u0014a\u0001=%c!\u001a\u0011H\n\u0017\t\u0011\r\u0003!\u0011!Q!\nQ\n\u0001\u0002\u001d:fI&\u001cG\u000f\t\u0015\u0004\u0005\u001ab\u0003\u0002\u0003$\u0001\u0005\u0003\u0007I\u0011A$\u0002\u0011%l\u0007/\u001e:jif,\u0012\u0001\u0013\t\u0003#%K!A\u0013\n\u0003\r\u0011{WO\u00197fQ\r)e\u0005T\u0011\u0002\u001b\u0006)\u0011G\f\u001a/a!Aq\n\u0001BA\u0002\u0013\u0005\u0001+\u0001\u0007j[B,(/\u001b;z?\u0012*\u0017\u000f\u0006\u0002=#\"9\u0001ITA\u0001\u0002\u0004A\u0005f\u0001('\u0019\"AA\u000b\u0001B\u0001B\u0003&\u0001*A\u0005j[B,(/\u001b;zA!\u001a1K\n'\t\u0011]\u0003!\u00111A\u0005\u0002a\u000ba![:MK\u00064W#A-\u0011\u0005EQ\u0016BA.\u0013\u0005\u001d\u0011un\u001c7fC:D3A\u0016\u0014-\u0011!q\u0006A!a\u0001\n\u0003y\u0016AC5t\u0019\u0016\fgm\u0018\u0013fcR\u0011A\b\u0019\u0005\b\u0001v\u000b\t\u00111\u0001ZQ\rif\u0005\f\u0005\tG\u0002\u0011\t\u0011)Q\u00053\u00069\u0011n\u001d'fC\u001a\u0004\u0003f\u00012'Y!Aa\r\u0001BA\u0002\u0013\u0005q-A\u0003ta2LG/F\u0001i!\r\t\u0012n[\u0005\u0003UJ\u0011aa\u00149uS>t\u0007CA\u001bm\u0013\ti'AA\u0003Ta2LG\u000fK\u0002fM1B\u0001\u0002\u001d\u0001\u0003\u0002\u0004%\t!]\u0001\ngBd\u0017\u000e^0%KF$\"\u0001\u0010:\t\u000f\u0001{\u0017\u0011!a\u0001Q\"\u001aqN\n\u0017\t\u0011U\u0004!\u0011!Q!\n!\faa\u001d9mSR\u0004\u0003f\u0001;'Y!A\u0001\u0010\u0001BA\u0002\u0013\u0005\u00110\u0001\u0005mK\u001a$hj\u001c3f+\u0005Q\bcA\tjwB\u0011Q\u0007\u0001\u0015\u0004o\u001ab\u0003\u0002\u0003@\u0001\u0005\u0003\u0007I\u0011A@\u0002\u00191,g\r\u001e(pI\u0016|F%Z9\u0015\u0007q\n\t\u0001C\u0004A{\u0006\u0005\t\u0019\u0001>)\u0007u4C\u0006C\u0005\u0002\b\u0001\u0011\t\u0011)Q\u0005u\u0006IA.\u001a4u\u001d>$W\r\t\u0015\u0005\u0003\u000b1C\u0006C\u0005\u0002\u000e\u0001\u0011\t\u0019!C\u0001s\u0006I!/[4ii:{G-\u001a\u0015\u0005\u0003\u00171C\u0006\u0003\u0006\u0002\u0014\u0001\u0011\t\u0019!C\u0001\u0003+\tQB]5hQRtu\u000eZ3`I\u0015\fHc\u0001\u001f\u0002\u0018!A\u0001)!\u0005\u0002\u0002\u0003\u0007!\u0010\u000b\u0003\u0002\u0012\u0019b\u0003\"CA\u000f\u0001\t\u0005\t\u0015)\u0003{\u0003)\u0011\u0018n\u001a5u\u001d>$W\r\t\u0015\u0005\u000371C\u0006\u0003\u0006\u0002$\u0001\u0011\t\u0019!C\u0001\u0003K\tQa\u001d;biN,\"!a\n\u0011\tEI\u0017\u0011\u0006\t\u0004k\u0005-\u0012bAA\u0017\u0005\t!\u0012J\u001c4pe6\fG/[8o\u000f\u0006Lgn\u0015;biNDC!!\t'Y!Q\u00111\u0007\u0001\u0003\u0002\u0004%\t!!\u000e\u0002\u0013M$\u0018\r^:`I\u0015\fHc\u0001\u001f\u00028!I\u0001)!\r\u0002\u0002\u0003\u0007\u0011q\u0005\u0015\u0005\u0003c1C\u0006\u0003\u0006\u0002>\u0001\u0011\t\u0011)Q\u0005\u0003O\taa\u001d;biN\u0004\u0003\u0006BA\u001eM1Bq!a\u0011\u0001\t\u0003\t)%\u0001\u0004=S:LGO\u0010\u000b\u0012w\u0006\u001d\u00131JA(\u0003'\n9&a\u0017\u0002`\u0005\r\u0004B\u0002\u0011\u0002B\u0001\u0007!\u0005\u000b\u0003\u0002H\u0019b\u0003B\u0002\u001a\u0002B\u0001\u0007A\u0007\u000b\u0003\u0002L\u0019b\u0003B\u0002$\u0002B\u0001\u0007\u0001\n\u000b\u0003\u0002P\u0019b\u0005BB,\u0002B\u0001\u0007\u0011\f\u000b\u0003\u0002T\u0019b\u0003B\u00024\u0002B\u0001\u0007\u0001\u000e\u000b\u0003\u0002X\u0019b\u0003B\u0002=\u0002B\u0001\u0007!\u0010\u000b\u0003\u0002\\\u0019b\u0003bBA\u0007\u0003\u0003\u0002\rA\u001f\u0015\u0005\u0003?2C\u0006\u0003\u0005\u0002$\u0005\u0005\u0003\u0019AA\u0014Q\u0011\t\u0019G\n\u0017)\t\u0005\u0005c\u0005\u0014\u0005\b\u0003W\u0002A\u0011IA7\u0003!!xn\u0015;sS:<GCAA8!\u0011\t\t(a \u000f\t\u0005M\u00141\u0010\t\u0004\u0003k\u0012RBAA<\u0015\r\tIHD\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u$#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{\u0012\u0002B\u0002\u001a\u0001\t\u0003\t9\tF\u0002I\u0003\u0013C\u0001\"a#\u0002\u0006\u0002\u0007\u0011QR\u0001\tM\u0016\fG/\u001e:fgB!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014\u001a\ta\u0001\\5oC2<\u0017\u0002BAL\u0003#\u0013aAV3di>\u0014\b&BACM\u0005m\u0015EAAO\u0003\u0015\td&\r\u00181\u0011!\t\t\u000b\u0001C\u0001\t\u0005\r\u0016\u0001\u00033fKB\u001cu\u000e]=\u0015\u0003mDq!a*\u0001\t\u0003!\u0011%\u0001\bok6$Um]2f]\u0012\fg\u000e^:\t\u000f\u0005-\u0006\u0001\"\u0001\u0005C\u0005a1/\u001e2ue\u0016,G)\u001a9uQ\"A\u0011q\u0016\u0001\u0005\u0002\u0011\t\t,A\btk\n$(/Z3U_N#(/\u001b8h)\u0011\ty'a-\t\u0013\u0005U\u0016Q\u0016I\u0001\u0002\u0004\u0011\u0013\u0001D5oI\u0016tGOR1di>\u0014\b\u0002CA]\u0001\u0011\u0005A!a/\u0002\u001fM,(\r\u001e:fK&#XM]1u_J,\"!!0\u0011\u000b\u0005}\u0016\u0011Z>\u000f\t\u0005\u0005\u0017Q\u0019\b\u0005\u0003k\n\u0019-C\u0001\u0014\u0013\r\t9ME\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY-!4\u0003\u0011%#XM]1u_JT1!a2\u0013\u0011)\t\t\u000eAI\u0001\n\u0003!\u00111[\u0001\u001agV\u0014GO]3f)>\u001cFO]5oO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002V*\u001a!%a6,\u0005\u0005e\u0007\u0003BAn\u0003Gl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u000b\n\n\t\u0005\u0015\u0018Q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007f\u0001\u0001\u0002jB\u0019q%a;\n\u0007\u00055\bF\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000eK\u0002\u0001M1:\u0001\"a=\u0003\u0011\u0003A\u0011Q_\u0001\u0005\u001d>$W\rE\u00026\u0003o4q!\u0001\u0002\t\u0002!\tIp\u0005\u0003\u0002xB1\u0002\u0002CA\"\u0003o$\t!!@\u0015\u0005\u0005U\b\u0002\u0003B\u0001\u0003o$\tAa\u0001\u0002\u0013\u0015l\u0007\u000f^=O_\u0012,GcA>\u0003\u0006!9!qAA\u0000\u0001\u0004\u0011\u0013!\u00038pI\u0016Le\u000eZ3y\u0011!\u0011Y!a>\u0005\u0002\t5\u0011!B1qa2LH#C>\u0003\u0010\tE!1\u0003B\u000b\u0011\u001d\u00119A!\u0003A\u0002\tBaA\rB\u0005\u0001\u0004!\u0004B\u0002$\u0003\n\u0001\u0007\u0001\n\u0003\u0004X\u0005\u0013\u0001\r!\u0017\u0005\t\u00053\t9\u0010\"\u0001\u0003\u001c\u0005qA.\u001a4u\u0007\"LG\u000eZ%oI\u0016DHc\u0001\u0012\u0003\u001e!9!q\u0001B\f\u0001\u0004\u0011\u0003\u0002\u0003B\u0011\u0003o$\tAa\t\u0002\u001fILw\r\u001b;DQ&dG-\u00138eKb$2A\tB\u0013\u0011\u001d\u00119Aa\bA\u0002\tB\u0001B!\u000b\u0002x\u0012\u0005!1F\u0001\fa\u0006\u0014XM\u001c;J]\u0012,\u0007\u0010F\u0002#\u0005[AqAa\u0002\u0003(\u0001\u0007!\u0005\u0003\u0005\u00032\u0005]H\u0011\u0001B\u001a\u00031Ig\u000eZ3y)>dUM^3m)\r\u0011#Q\u0007\u0005\b\u0005\u000f\u0011y\u00031\u0001#\u0011!\u0011I$a>\u0005\u0002\tm\u0012aC5t\u0019\u00164Go\u00115jY\u0012$2!\u0017B\u001f\u0011\u001d\u00119Aa\u000eA\u0002\tB\u0001B!\u0011\u0002x\u0012\u0005!1I\u0001\u0010[\u0006Dhj\u001c3fg&sG*\u001a<fYR\u0019!E!\u0012\t\u000f\t\u001d#q\ba\u0001E\u0005)A.\u001a<fY\"A!1JA|\t\u0003\u0011i%A\tti\u0006\u0014H/\u00138eKbLe\u000eT3wK2$2A\tB(\u0011\u001d\u00119E!\u0013A\u0002\tB\u0001Ba\u0015\u0002x\u0012\u0005!QK\u0001\bO\u0016$hj\u001c3f)\u0015Y(q\u000bB-\u0011\u001d\u00119A!\u0015A\u0002\tBqAa\u0017\u0003R\u0001\u000710\u0001\u0005s_>$hj\u001c3f\u0011)\u0011y&a>\u0002\u0002\u0013%!\u0011M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003dA!!Q\rB8\u001b\t\u00119G\u0003\u0003\u0003j\t-\u0014\u0001\u00027b]\u001eT!A!\u001c\u0002\t)\fg/Y\u0005\u0005\u0005c\u00129G\u0001\u0004PE*,7\r\u001e")
public class Node
implements scala.Serializable,
Logging {
    private final int id;
    private Predict predict;
    private double impurity;
    private boolean isLeaf;
    private Option<Split> split;
    private Option<Node> leftNode;
    private Option<Node> rightNode;
    private Option<InformationGainStats> stats;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Node getNode(int n, Node node) {
        return Node$.MODULE$.getNode(n, node);
    }

    public static int startIndexInLevel(int n) {
        return Node$.MODULE$.startIndexInLevel(n);
    }

    public static int maxNodesInLevel(int n) {
        return Node$.MODULE$.maxNodesInLevel(n);
    }

    public static boolean isLeftChild(int n) {
        return Node$.MODULE$.isLeftChild(n);
    }

    public static int indexToLevel(int n) {
        return Node$.MODULE$.indexToLevel(n);
    }

    public static int parentIndex(int n) {
        return Node$.MODULE$.parentIndex(n);
    }

    public static int rightChildIndex(int n) {
        return Node$.MODULE$.rightChildIndex(n);
    }

    public static int leftChildIndex(int n) {
        return Node$.MODULE$.leftChildIndex(n);
    }

    public static Node apply(int n, Predict predict, double d, boolean bl) {
        return Node$.MODULE$.apply(n, predict, d, bl);
    }

    public static Node emptyNode(int n) {
        return Node$.MODULE$.emptyNode(n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public Predict predict() {
        return this.predict;
    }

    public void predict_$eq(Predict x$1) {
        this.predict = x$1;
    }

    public double impurity() {
        return this.impurity;
    }

    public void impurity_$eq(double x$1) {
        this.impurity = x$1;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void isLeaf_$eq(boolean x$1) {
        this.isLeaf = x$1;
    }

    public Option<Split> split() {
        return this.split;
    }

    public void split_$eq(Option<Split> x$1) {
        this.split = x$1;
    }

    public Option<Node> leftNode() {
        return this.leftNode;
    }

    public void leftNode_$eq(Option<Node> x$1) {
        this.leftNode = x$1;
    }

    public Option<Node> rightNode() {
        return this.rightNode;
    }

    public void rightNode_$eq(Option<Node> x$1) {
        this.rightNode = x$1;
    }

    public Option<InformationGainStats> stats() {
        return this.stats;
    }

    public void stats_$eq(Option<InformationGainStats> x$1) {
        this.stats = x$1;
    }

    public String toString() {
        return new StringBuilder(43).append("id = ").append(this.id()).append(", isLeaf = ").append(this.isLeaf()).append(", predict = ").append(this.predict()).append(", impurity = ").append(this.impurity()).append(", ").append(new StringBuilder(18).append("split = ").append(this.split()).append(", stats = ").append(this.stats()).toString()).toString();
    }

    public double predict(Vector features) {
        double d;
        if (this.isLeaf()) {
            d = this.predict().predict();
        } else {
            Enumeration.Value value = ((Split)this.split().get()).featureType();
            Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
            d = !(value != null ? !value.equals(value2) : value2 != null) ? (features.apply(((Split)this.split().get()).feature()) <= ((Split)this.split().get()).threshold() ? ((Node)this.leftNode().get()).predict(features) : ((Node)this.rightNode().get()).predict(features)) : (((Split)this.split().get()).categories().contains((Object)BoxesRunTime.boxToDouble((double)features.apply(((Split)this.split().get()).feature()))) ? ((Node)this.leftNode().get()).predict(features) : ((Node)this.rightNode().get()).predict(features));
        }
        return d;
    }

    public Node deepCopy() {
        None$ leftNodeCopy = this.leftNode().isEmpty() ? None$.MODULE$ : new Some((Object)((Node)this.leftNode().get()).deepCopy());
        None$ rightNodeCopy = this.rightNode().isEmpty() ? None$.MODULE$ : new Some((Object)((Node)this.rightNode().get()).deepCopy());
        return new Node(this.id(), this.predict(), this.impurity(), this.isLeaf(), this.split(), (Option<Node>)leftNodeCopy, (Option<Node>)rightNodeCopy, this.stats());
    }

    public int numDescendants() {
        return this.isLeaf() ? 0 : 2 + ((Node)this.leftNode().get()).numDescendants() + ((Node)this.rightNode().get()).numDescendants();
    }

    public int subtreeDepth() {
        return this.isLeaf() ? 0 : 1 + package$.MODULE$.max(((Node)this.leftNode().get()).subtreeDepth(), ((Node)this.rightNode().get()).subtreeDepth());
    }

    public String subtreeToString(int indentFactor) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(indentFactor);
        return this.isLeaf() ? new StringBuilder(0).append(prefix).append(new StringBuilder(10).append("Predict: ").append(this.predict().predict()).append("\n").toString()).toString() : new StringBuilder(0).append(prefix).append(new StringBuilder(4).append("If ").append(Node.splitToString$1((Split)this.split().get(), true)).append("\n").toString()).append(((Node)this.leftNode().get()).subtreeToString(indentFactor + 1)).append(prefix).append(new StringBuilder(6).append("Else ").append(Node.splitToString$1((Split)this.split().get(), false)).append("\n").toString()).append(((Node)this.rightNode().get()).subtreeToString(indentFactor + 1)).toString();
    }

    public int subtreeToString$default$1() {
        return 0;
    }

    public Iterator<Node> subtreeIterator() {
        return scala.package$.MODULE$.Iterator().single((Object)this).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterator)this.leftNode().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.subtreeIterator()).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().empty())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterator)this.rightNode().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.subtreeIterator()).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().empty()));
    }

    private static final String splitToString$1(Split split, boolean left) {
        String string;
        Enumeration.Value value = split.featureType();
        Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = left ? new StringBuilder(14).append("(feature ").append(split.feature()).append(" <= ").append(split.threshold()).append(")").toString() : new StringBuilder(13).append("(feature ").append(split.feature()).append(" > ").append(split.threshold()).append(")").toString();
        } else {
            Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = left ? new StringBuilder(14).append("(feature ").append(split.feature()).append(" in ").append(split.categories().mkString("{", ",", "}")).append(")").toString() : new StringBuilder(18).append("(feature ").append(split.feature()).append(" not in ").append(split.categories().mkString("{", ",", "}")).append(")").toString();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    public Node(int id, Predict predict, double impurity, boolean isLeaf, Option<Split> split, Option<Node> leftNode, Option<Node> rightNode, Option<InformationGainStats> stats) {
        this.id = id;
        this.predict = predict;
        this.impurity = impurity;
        this.isLeaf = isLeaf;
        this.split = split;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.stats = stats;
        Logging.$init$((Logging)this);
    }
}

