/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001\u0002\u000f\u001e\u0001!B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005k!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003F\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bQ\u0003A\u0011A+\t\u000by\u0003A\u0011I0\t\u000b-\u0004A\u0011\t'\t\u000b5\u0004A\u0011\t8\t\rI\u0004A\u0011I\u0011t\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\t\u0001\t\u0003\n)\u0003\u0003\u0004\u0002(\u0001!\t\u0005\u000e\u0005\u0007\u0003_\u0001A\u0011\t\u001b\t\u0011\u0005M\u0002\u0001\"\u0011\u001e\u0003kAa!a\u000f\u0001\t\u0003\"\u0004\u0002CA\"\u0001\u0011\u0005\u0011%!\u0012\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011\u0011\u000b\u0001\u0005B\u0005MsaBAC;!\u0005\u0011q\u0011\u0004\u00079uA\t!!#\t\rQ;B\u0011AAI\u0011\u001d\t\u0019j\u0006C\u0001\u0003+Cq!!,\u0018\t\u0003\ty\u000bC\u0005\u00028^\t\t\u0011\"\u0003\u0002:\na1\u000b]1sg\u00164Vm\u0019;pe*\u0011adH\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u0001\n\u0013!B7mY&\u0014'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001\u0014'D\u0001\u001e\u0013\t\u0011TD\u0001\u0004WK\u000e$xN]\u0001\u0005g&TX-F\u00016!\tQc'\u0003\u00028W\t\u0019\u0011J\u001c;)\u0007\u0005It\b\u0005\u0002;{5\t1H\u0003\u0002=C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yZ$!B*j]\u000e,\u0017%\u0001!\u0002\u000bEr\u0003G\f\u0019\u0002\u000bML'0\u001a\u0011)\u0007\tIt(A\u0004j]\u0012L7-Z:\u0016\u0003\u0015\u00032A\u000b$6\u0013\t95FA\u0003BeJ\f\u0017\u0010K\u0002\u0004s}\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0015\u0004\tez\u0014A\u0002<bYV,7/F\u0001N!\rQcI\u0014\t\u0003U=K!\u0001U\u0016\u0003\r\u0011{WO\u00197fQ\r)\u0011hP\u0001\bm\u0006dW/Z:!Q\r1\u0011hP\u0001\u0007y%t\u0017\u000e\u001e \u0015\tY;\u0016l\u0017\t\u0003a\u0001AQaM\u0004A\u0002UB3aV\u001d@\u0011\u0015\u0019u\u00011\u0001FQ\rI\u0016h\u0010\u0005\u0006\u0017\u001e\u0001\r!\u0014\u0015\u00047fz\u0004fA\u0004:\u007f\u0005AAo\\*ue&tw\rF\u0001a!\t\t\u0007N\u0004\u0002cMB\u00111mK\u0007\u0002I*\u0011QmJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\\\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0016\u0002\u000fQ|\u0017I\u001d:bs\"\u001a\u0011\"O \u0002\t\r|\u0007/_\u000b\u0002-\"\u001a!\"\u000f9\"\u0003E\fQ!\r\u00182]A\n\u0001\"Y:Ce\u0016,'0Z\u000b\u0002iB\u0019Q/\u001f(\u000e\u0003YT!AH<\u000b\u0003a\faA\u0019:fKj,\u0017B\u0001\u001aw\u000351wN]3bG\"\f5\r^5wKR\u0011Ap \t\u0003UuL!A`\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003a\u0001\u0019AA\u0002\u0003\u00051\u0007C\u0002\u0016\u0002\u0006UrE0C\u0002\u0002\b-\u0012\u0011BR;oGRLwN\u001c\u001a)\t1I\u00141B\u0011\u0003\u0003\u001b\tQ!\r\u00187]A\na!Z9vC2\u001cH\u0003BA\n\u00033\u00012AKA\u000b\u0013\r\t9b\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\"\u0004a\u0001\u0003;\tQa\u001c;iKJ\u00042AKA\u0010\u0013\r\t\tc\u000b\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003U\n!B\\;n\u0003\u000e$\u0018N^3tQ\u0011y\u0011(a\u000b\"\u0005\u00055\u0012!B\u0019/i9\u0002\u0014a\u00038v[:{gN_3s_NDC\u0001E\u001d\u0002,\u0005\u0001Bo\\*qCJ\u001cXmV5uQNK'0\u001a\u000b\u0004-\u0006]\u0002BBA\u001d#\u0001\u0007Q'A\u0002o]j\fa!\u0019:h[\u0006D\b\u0006\u0002\n:\u0003\u007f\t#!!\u0011\u0002\u000bErSG\f\u0019\u0002\u000bMd\u0017nY3\u0015\u0007Y\u000b9\u0005\u0003\u0004\u0002JM\u0001\r!R\u0001\u0010g\u0016dWm\u0019;fI&sG-[2fg\u00061Ao\u001c&t_:,\u0012\u0001\u0019\u0015\u0005)e\nY!\u0001\u0003bg6cUCAA+!\u0011\t9&a\u0018\u000e\u0005\u0005e#b\u0001\u0010\u0002\\)\u0019\u0011QL\u0011\u0002\u00055d\u0017b\u0001\u000f\u0002Z!\"Q#OA2C\t\t)'A\u00033]Ar\u0003\u0007K\u0004\u0001\u0003S\nI(a\u001f\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005)A/\u001f9fg*\u0019\u00111O\u0011\u0002\u0007M\fH.\u0003\u0003\u0002x\u00055$AE*R\u0019V\u001bXM\u001d#fM&tW\r\u001a+za\u0016\f1!\u001e3uG\t\ti\bE\u00021\u0003\u007fJ1!!!\u001e\u0005%1Vm\u0019;peV#E\u000bK\u0002\u0001s}\nAb\u00159beN,g+Z2u_J\u0004\"\u0001M\f\u0014\t]I\u00131\u0012\t\u0004U\u00055\u0015bAAHW\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011qQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9*a)\u0011\u000b)\nI*!(\n\u0007\u0005m5F\u0001\u0004PaRLwN\u001c\t\u0007U\u0005}U'R'\n\u0007\u0005\u00056F\u0001\u0004UkBdWm\r\u0005\u0007\u0003KK\u0002\u0019\u0001,\u0002\u0005M4\b\u0006B\r:\u0003S\u000b#!a+\u0002\u000bEr3G\f\u0019\u0002\r\u0019\u0014x.\\'M)\r1\u0016\u0011\u0017\u0005\b\u0003gS\u0002\u0019AA+\u0003\u00051\b\u0006\u0002\u000e:\u0003G\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0017\u0001\u00026bm\u0006LA!!3\u0002@\n1qJ\u00196fGRDCaF\u001d\u0002*\"\"a#OAU\u0001")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public double apply(int i) {
        return Vector.apply$(this, i);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                block0: {
                    if (v == 0.0) break block0;
                    ii$2[k$2.elem] = i;
                    vv$2[k$2.elem] = v;
                    ++k$2.elem;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sliceInds2)).toArray(ClassTag$.MODULE$.Int()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sliceVals2)).toArray(ClassTag$.MODULE$.Double()));
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$1 = jValue = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Sparse vectors require that the dimension of the").append(new StringBuilder(70).append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").toString()).append(new StringBuilder(9).append(" ").append(this.values().length).append(" values.").toString()).toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("You provided ").append(this.indices().length).append(" indices and values, ").append(new StringBuilder(41).append("which exceeds the specified vector size ").append(this.size()).append(".").toString()).toString());
    }
}

