/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.visitors;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.spark_project.dmg.pmml.IntSparseArray;
import org.spark_project.dmg.pmml.RealSparseArray;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.jpmml.model.visitors.NumberInterner;

public class IntegerInterner
extends NumberInterner<Integer> {
    private static final ConcurrentMap<Integer, Integer> cache = new ConcurrentHashMap<Integer, Integer>();

    public IntegerInterner() {
        super(Integer.class, cache);
    }

    @Override
    public Integer canonicalize(Integer value) {
        return (int)value;
    }

    @Override
    public VisitorAction visit(IntSparseArray intSparseArray) {
        if (intSparseArray.hasEntries()) {
            this.internAll(intSparseArray.getEntries());
        }
        if (intSparseArray.hasIndices()) {
            this.internAll(intSparseArray.getIndices());
        }
        return super.visit(intSparseArray);
    }

    @Override
    public VisitorAction visit(RealSparseArray realSparseArray) {
        if (realSparseArray.hasIndices()) {
            this.internAll(realSparseArray.getIndices());
        }
        return super.visit(realSparseArray);
    }

    public static void clear() {
        cache.clear();
    }
}

