/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.ClassifierSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u000e\u001c\u0001\u0019BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005\na:Q!X\u000e\t\u0002y3QAG\u000e\t\u0002}CQa\r\u0003\u0005\u0002\u0019Dqa\u001a\u0003C\u0002\u0013\u0005\u0001\u000e\u0003\u0004x\t\u0001\u0006I!\u001b\u0004\u0005q\u0012\u0001\u0011\u0010\u0003\u0006\u0002\u0018!\u0011)\u0019!C!\u00033A\u0011\"a\u0007\t\u0005\u0003\u0005\u000b\u0011B9\t\rMBA\u0011AA%\u0011\u0019\u0019\u0004\u0002\"\u0001\u0002N!9\u00111\u0006\u0005\u0005B\u0005=\u0003bBA*\u0011\u0011\u0005\u0013Q\u000b\u0005\b\u0003kBA\u0011IA<\u0011\u001d\ty\n\u0003C\u0001\u0003C3a!!\u0004\u0005\u0001\u0005=\u0001BCA\f#\t\u0015\r\u0011\"\u0011\u0002\u001a!I\u00111D\t\u0003\u0002\u0003\u0006I!\u001d\u0005\u0007gE!\t!!\b\t\rM\nB\u0011AA\u0011\u0011\u001d\t\u0019#\u0005C\t\u0003KAq!a\u000b\u0012\t\u0003\ni\u0003C\u0004\u0002@E!\t%!\u0011\t\u0013\u0005=F!!A\u0005\n\u0005E&aD\"mCN\u001c\u0018NZ5feN+\u0018\u000e^3\u000b\u0005qi\u0012AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003=}\t!!\u001c7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001O-\u0002\"\u0001K\u0015\u000e\u0003}I!AK\u0010\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'B\u0001\u0019 \u0003\u0015iG\u000e\\5c\u0013\t\u0011TFA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u001c\u0001\u001b\u0005Y\u0012aC4fiR+7\u000f\u001e#bi\u0006$\"!O'\u0011\u0005iReBA\u001eH\u001d\taTI\u0004\u0002>\t:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0016\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\t1u$A\u0002tc2L!\u0001S%\u0002\u000fA\f7m[1hK*\u0011aiH\u0005\u0003\u00172\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005!K\u0005\"\u0002(\u0003\u0001\u0004y\u0015A\u00027bE\u0016d7\u000fE\u0002Q-fs!!\u0015+\u000f\u0005}\u0012\u0016\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+&\"A*\n\u0005]C&aA*fc*\u0011\u0001*\u0016\t\u00035nk\u0011!V\u0005\u00039V\u0013a\u0001R8vE2,\u0017aD\"mCN\u001c\u0018NZ5feN+\u0018\u000e^3\u0011\u0005Y\"1c\u0001\u0003aGB\u0011!,Y\u0005\u0003EV\u0013a!\u00118z%\u00164\u0007C\u0001.e\u0013\t)WK\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001_\u0003A\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7/F\u0001j!\u0011Qg.\u001d;\u000f\u0005-d\u0007CA V\u0013\tiW+\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u00141!T1q\u0015\tiW\u000b\u0005\u0002ke&\u00111\u000f\u001d\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005i+\u0018B\u0001<V\u0005\r\te._\u0001\u0012C2d\u0007+\u0019:b[N+G\u000f^5oON\u0004#AD'pG.\u001cE.Y:tS\u001aLWM]\n\u0003\u0011i\u0004rAN>~\u0003\u000f\tY!\u0003\u0002}7\tQ1\t\\1tg&4\u0017.\u001a:\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!H\u0001\u0007Y&t\u0017\r\\4\n\u0007\u0005\u0015qP\u0001\u0004WK\u000e$xN\u001d\t\u0004\u0003\u0013AQ\"\u0001\u0003\u0011\u0007\u0005%\u0011CA\fN_\u000e\\7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYN\u0019\u0011#!\u0005\u0011\rY\n\u0019\"`A\u0006\u0013\r\t)b\u0007\u0002\u0014\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\\\u0001\u0004k&$W#A9\u0002\tULG\r\t\u000b\u0005\u0003\u0017\ty\u0002\u0003\u0004\u0002\u0018Q\u0001\r!\u001d\u000b\u0003\u0003\u0017\t!\u0002\u001d:fI&\u001cGOU1x)\ri\u0018q\u0005\u0005\u0007\u0003S1\u0002\u0019A?\u0002\u0011\u0019,\u0017\r^;sKN\fAaY8qsR!\u00111BA\u0018\u0011\u001d\t\td\u0006a\u0001\u0003g\tQ!\u001a=ue\u0006\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003si\u0012!\u00029be\u0006l\u0017\u0002BA\u001f\u0003o\u0011\u0001\u0002U1sC6l\u0015\r]\u0001\u000b]Vl7\t\\1tg\u0016\u001cXCAA\"!\rQ\u0016QI\u0005\u0004\u0003\u000f*&aA%oiR!\u0011qAA&\u0011\u0019\t9b\u0003a\u0001cR\u0011\u0011q\u0001\u000b\u0005\u0003\u000f\t\t\u0006C\u0004\u000225\u0001\r!a\r\u0002\u000bQ\u0014\u0018-\u001b8\u0015\t\u0005-\u0011q\u000b\u0005\b\u00033r\u0001\u0019AA.\u0003\u001d!\u0017\r^1tKR\u0004D!!\u0018\u0002jA1\u0011qLA1\u0003Kj\u0011!S\u0005\u0004\u0003GJ%a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003O\nI\u0007\u0004\u0001\u0005\u0019\u0005-\u0014qKA\u0001\u0002\u0003\u0015\t!!\u001c\u0003\u0007}#\u0013'E\u0002\u0002pQ\u00042AWA9\u0013\r\t\u0019(\u0016\u0002\b\u001d>$\b.\u001b8h\u0003Q)\u0007\u0010\u001e:bGRd\u0015MY3mK\u0012\u0004v.\u001b8ugR1\u0011\u0011PAI\u0003;\u0003b!a\u001f\u0002\u0002\u0006\u0015UBAA?\u0015\r\tyhH\u0001\u0004e\u0012$\u0017\u0002BAB\u0003{\u00121A\u0015#E!\u0011\t9)!$\u000e\u0005\u0005%%bAAF;\u00059a-Z1ukJ,\u0017\u0002BAH\u0003\u0013\u0013A\u0002T1cK2,G\rU8j]RDq!!\u0017\u0010\u0001\u0004\t\u0019\n\r\u0003\u0002\u0016\u0006e\u0005CBA0\u0003C\n9\n\u0005\u0003\u0002h\u0005eE\u0001DAN\u0003#\u000b\t\u0011!A\u0003\u0002\u00055$aA0%e!9\u0011qH\bA\u0002\u0005\r\u0013!D4fi:+Xn\u00117bgN,7\u000f\u0006\u0003\u0002D\u0005\r\u0006bBA-!\u0001\u0007\u0011Q\u0015\u0019\u0005\u0003O\u000bY\u000b\u0005\u0004\u0002`\u0005\u0005\u0014\u0011\u0016\t\u0005\u0003O\nY\u000b\u0002\u0007\u0002.\u0006\r\u0016\u0011!A\u0001\u0006\u0003\tiGA\u0002`IM\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0016\u0001\u00026bm\u0006LA!!1\u00028\n1qJ\u00196fGR\u0004")
public class ClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return ClassifierSuite$.MODULE$.allParamSettings();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private Dataset<Row> getTestData(Seq<Object> labels) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ClassifierSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_ClassifierSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.LabeledPoint").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_ClassifierSuite$$typecreator5$1(ClassifierSuite $outer) {
            }
        }
        return this.testImplicits().localSeqToDatasetHolder((Seq)labels.map((Function1 & Serializable & scala.Serializable)label -> ClassifierSuite.$anonfun$getTestData$1(BoxesRunTime.unboxToDouble((Object)label)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ClassifierSuite$$typecreator5$1(null)))).toDF();
    }

    private final void testImplicits$lzycompute$1() {
        ClassifierSuite classifierSuite = this;
        synchronized (classifierSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ LabeledPoint $anonfun$getTestData$1(double label) {
        return new LabeledPoint(label, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
    }

    public ClassifierSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("extractLabeledPoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MockClassifier c = new MockClassifier();
            Dataset<Row> df0 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.0}))));
            c.extractLabeledPoints(df0, 6).count();
            Dataset<Row> df1 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0, 1.0, 5.0}))));
            this.withClue("Classifier should fail if label is negative", (Function0 & Serializable & scala.Serializable)() -> {
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> c.extractLabeledPoints(df1, 6).count(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            });
            Dataset<Row> df2 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.1, 1.0, 5.0}))));
            this.withClue("Classifier should fail if label is not an integer", (Function0 & Serializable & scala.Serializable)() -> {
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> c.extractLabeledPoints(df2, 6).count(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            });
            this.withClue("Classifier should fail if label is >= numClasses", (Function0 & Serializable & scala.Serializable)() -> {
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> c.extractLabeledPoints(df0, 5).count(), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "given dataset with invalid label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            });
            return (Assertion)this.withClue("Classifier.extractLabeledPoints should fail if numClasses <= 0", (Function0 & Serializable & scala.Serializable)() -> {
                IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> c.extractLabeledPoints(df0, 0).count(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "but requires numClasses > 0";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            });
        }, new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("getNumClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MockClassifier c = new MockClassifier();
            Dataset<Row> df0 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.0}))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)c.getNumClasses(df0)));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Dataset<Row> df1 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, 5.1}))));
            this.withClue("getNumClasses should fail if label is max label not an integer", (Function0 & Serializable & scala.Serializable)() -> {
                IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "requires integers in range";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            });
            Dataset<Row> df2 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 1.0, Integer.MAX_VALUE}))));
            this.withClue("getNumClasses should fail if label is max label is >= Int.MaxValue", (Function0 & Serializable & scala.Serializable)() -> {
                IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "requires integers in range";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            });
            Dataset<Row> df3 = this.getTestData((Seq<Object>)((Seq)Seq$.MODULE$.empty()));
            return (Assertion)this.withClue("getNumClasses should fail if dataset is empty", (Function0 & Serializable & scala.Serializable)() -> {
                SparkException e = (SparkException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> c.getNumClasses(df3), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "ML algorithm was given empty dataset.";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            });
        }, new Position("ClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    public static class MockClassificationModel
    extends ClassificationModel<Vector, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public Vector predictRaw(Vector features) {
            throw new NotImplementedError();
        }

        public MockClassificationModel copy(ParamMap extra) {
            throw new NotImplementedError();
        }

        public int numClasses() {
            throw new NotImplementedError();
        }

        public MockClassificationModel(String uid) {
            this.uid = uid;
        }

        public MockClassificationModel() {
            this(Identifiable$.MODULE$.randomUID("mockclassificationmodel"));
        }
    }

    public static class MockClassifier
    extends Classifier<Vector, MockClassifier, MockClassificationModel> {
        private final String uid;

        public String uid() {
            return this.uid;
        }

        public MockClassifier copy(ParamMap extra) {
            throw new NotImplementedError();
        }

        public MockClassificationModel train(Dataset<?> dataset) {
            throw new NotImplementedError();
        }

        public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
            return super.extractLabeledPoints(dataset, numClasses);
        }

        public int getNumClasses(Dataset<?> dataset) {
            return super.getNumClasses(dataset, super.getNumClasses$default$2());
        }

        public MockClassifier(String uid) {
            this.uid = uid;
        }

        public MockClassifier() {
            this(Identifiable$.MODULE$.randomUID("mockclassifier"));
        }
    }
}

