/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.PowerIterationClustering;
import org.apache.spark.ml.clustering.PowerIterationClusteringSuite$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u000b\u0017\u0001\u0005BQa\r\u0001\u0005\u0002QB\u0011b\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001\u001d\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0003!\u0006\"\u0003#\u0001\u0001\u0004\u0005\t\u0015)\u0003:\u0011\u001dq\u0006A1A\u0005\u0006}CaA\u0019\u0001!\u0002\u001b\u0001\u0007bB2\u0001\u0005\u0004%)\u0001\u001a\u0005\u0007O\u0002\u0001\u000bQB3\t\u000f!\u0004!\u0019!C\u0003S\"1A\u000e\u0001Q\u0001\u000e)Dq!\u001c\u0001C\u0002\u0013\u0015a\u000e\u0003\u0004r\u0001\u0001\u0006ia\u001c\u0005\u0006e\u0002!\te]\u0004\u0006iZA\t!\u001e\u0004\u0006+YA\tA\u001e\u0005\u0006g=!\t! \u0005\u0006}>!Ia \u0005\b\u0003CyA\u0011BA\u0012\u0011\u001d\tic\u0004C\u0001\u0003_A\u0011\"!\u001a\u0010\u0003\u0003%I!a\u001a\u0003;A{w/\u001a:Ji\u0016\u0014\u0018\r^5p]\u000ecWo\u001d;fe&twmU;ji\u0016T!a\u0006\r\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u001a5\u0005\u0011Q\u000e\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011\u0003\u0002\u0001#M9\u0002\"a\t\u0013\u000e\u0003iI!!\n\u000e\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9C&D\u0001)\u0015\tI#&\u0001\u0003vi&d'BA\u0016\u001b\u0003\u0015iG\u000e\\5c\u0013\ti\u0003FA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005=\nT\"\u0001\u0019\u000b\u0005%B\u0012B\u0001\u001a1\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\u00061A(\u001b8jiz\"\u0012!\u000e\t\u0003m\u0001i\u0011AF\u0001\u0005I\u0006$\u0018-F\u0001:a\tQ$\tE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0003{i\t1a]9m\u0013\tyDHA\u0004ECR\f7/\u001a;\u0011\u0005\u0005\u0013E\u0002\u0001\u0003\n\u0007\u0012\t\t\u0011!A\u0003\u00021\u00131a\u0018\u00132\u0003\u0015!\u0017\r^1!Q\t!a\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005JA\u0005ue\u0006t7/[3oiF\u0011Q\n\u0015\t\u0003\u000f:K!a\u0014%\u0003\u000f9{G\u000f[5oOB\u0011q)U\u0005\u0003%\"\u00131!\u00118z\u0003!!\u0017\r^1`I\u0015\fHCA+Y!\t9e+\u0003\u0002X\u0011\n!QK\\5u\u0011\u001dI6!!AA\u0002i\u000b1\u0001\u001f\u00132a\tYV\fE\u0002<}q\u0003\"!Q/\u0005\u0013\rC\u0016\u0011!A\u0001\u0006\u0003a\u0015A\u0001:2+\u0005\u0001w\"A1!\u0011}\u0002\u0010\u0001\u0001\u0001\u0001\u0001\u0001\t1A]\u0019!\u0003\tq\u0017'F\u0001f\u001f\u00051W$\u0001\u0006\u0002\u00079\f\u0004%\u0001\u0002seU\t!nD\u0001lA!\u0001\u0005\u0003\u0001\u0001\u0001\u0001\u0001\u0001\u0011a\u0001:3A\u0005\u0011aNM\u000b\u0002_>\t\u0001/H\u0001)\u0003\rq'\u0007I\u0001\nE\u00164wN]3BY2$\u0012!V\u0001\u001e!><XM]%uKJ\fG/[8o\u00072,8\u000f^3sS:<7+^5uKB\u0011agD\n\u0004\u001f]T\bCA$y\u0013\tI\bJ\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000fnL!\u0001 %\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003U\f\u0011bZ3o\u0007&\u00148\r\\3\u0015\r\u0005\u0005\u00111CA\f!\u00159\u00151AA\u0004\u0013\r\t)\u0001\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\b\u000f\u0006%\u0011QBA\u0007\u0013\r\tY\u0001\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u001d\u000by!C\u0002\u0002\u0012!\u0013a\u0001R8vE2,\u0007bBA\u000b#\u0001\u0007\u0011QB\u0001\u0002e\"9\u0011\u0011D\tA\u0002\u0005m\u0011!\u00018\u0011\u0007\u001d\u000bi\"C\u0002\u0002 !\u00131!\u00138u\u0003\r\u0019\u0018.\u001c\u000b\u0007\u0003\u001b\t)#!\u000b\t\u000f\u0005\u001d\"\u00031\u0001\u0002\b\u0005\t\u0001\u0010C\u0004\u0002,I\u0001\r!a\u0002\u0002\u0003e\fqbZ3oKJ\fG/\u001a)J\u0007\u0012\u000bG/\u0019\u000b\r\u0003c\t)&!\u0018\u0002`\u0005\u0005\u00141\r\t\u0005\u0003g\tyE\u0004\u0003\u00026\u0005-c\u0002BA\u001c\u0003\u0013rA!!\u000f\u0002H9!\u00111HA#\u001d\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!A\u00051AH]8pizJ\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005uR\u0012bAA'y\u00059\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u00055C\b\u0003\u0004\u001c'\u0001\u0007\u0011q\u000b\t\u0004w\u0005e\u0013bAA.y\ta1\u000b]1sWN+7o]5p]\"1al\u0005a\u0001\u0003\u001bAa\u0001[\nA\u0002\u00055\u0001BB2\u0014\u0001\u0004\tY\u0002\u0003\u0004n'\u0001\u0007\u00111D\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0004PE*,7\r\u001e")
public class PowerIterationClusteringSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Dataset<Row> generatePICData(SparkSession sparkSession, double d, double d2, int n, int n2) {
        return PowerIterationClusteringSuite$.MODULE$.generatePICData(sparkSession, d, d2, n, n2);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Dataset<?> data() {
        return this.data;
    }

    public void data_$eq(Dataset<?> x$1) {
        this.data = x$1;
    }

    public final double r1() {
        return 1.0;
    }

    public final int n1() {
        return 10;
    }

    public final double r2() {
        return 4.0;
    }

    public final int n2() {
        return 40;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.data_$eq(PowerIterationClusteringSuite$.MODULE$.generatePICData(this.spark(), 1.0, 4.0, 10, 40));
    }

    private final void testImplicits$lzycompute$1() {
        PowerIterationClusteringSuite powerIterationClusteringSuite = this;
        synchronized (powerIterationClusteringSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    private final void runTest$1(DataType srcType, DataType dstType, DataType weightType, PowerIterationClustering pic$1) {
        Dataset typedData = this.data().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("src").cast(srcType).alias("src"), functions$.MODULE$.col("dst").cast(dstType).alias("dst"), functions$.MODULE$.col("weight").cast(weightType).alias("weight")}));
        pic$1.assignClusters(typedData).collect();
    }

    public PowerIterationClusteringSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("default parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PowerIterationClustering pic = new PowerIterationClustering();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pic.getK()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pic.getMaxIter()));
            int $org_scalatest_assert_macro_right2 = 20;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(pic.getInitMode());
            String $org_scalatest_assert_macro_right3 = "random";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(pic.getSrcCol());
            String $org_scalatest_assert_macro_right4 = "src";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(pic.getDstCol());
            String $org_scalatest_assert_macro_right5 = "dst";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(pic.isDefined(pic.weightCol()), "pic.isDefined(pic.weightCol)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("parameter validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PowerIterationClustering().setK(1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PowerIterationClustering().setInitMode("no_such_a_mode"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PowerIterationClustering().setSrcCol(""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new PowerIterationClustering().setDstCol(""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("power iteration clustering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int n = 50;
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PowerIterationClusteringSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator4$1(PowerIterationClusteringSuite $outer) {
                }
            }
            Tuple2[] assignments = (Tuple2[])new PowerIterationClustering().setK(2).setMaxIter(40).setWeightCol("weight").assignClusters(this.data()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cluster"})).as(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator4$1(null)))).collect();
            Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignments)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long id = tuple2._1$mcJ$sp();
                int cluster = tuple2._2$mcI$sp();
                Set set = (Set)predictions[cluster].$plus$eq((Object)BoxesRunTime.boxToLong((long)id));
                return set;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).toSet());
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), n).toSet()}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(PowerIterationClusteringSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator5$1(PowerIterationClusteringSuite $outer) {
                }
            }
            Tuple2[] assignments2 = (Tuple2[])new PowerIterationClustering().setK(2).setMaxIter(10).setInitMode("degree").setWeightCol("weight").assignClusters(this.data()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cluster"})).as(this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator5$1(null)))).collect();
            Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty(), ClassTag$.MODULE$.apply(Set.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignments2)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long id = tuple2._1$mcJ$sp();
                int cluster = tuple2._2$mcI$sp();
                Set set = (Set)predictions2[cluster].$plus$eq((Object)BoxesRunTime.boxToLong((long)id));
                return set;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions2)).toSet());
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).toSet(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), n).toSet()}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("supported input types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PowerIterationClustering pic = new PowerIterationClustering().setK(2).setMaxIter(1).setWeightCol("weight");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, LongType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)srcType -> {
                this.runTest$1((DataType)srcType, (DataType)LongType$.MODULE$, (DataType)DoubleType$.MODULE$, pic);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, LongType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)dstType -> {
                this.runTest$1((DataType)LongType$.MODULE$, (DataType)dstType, (DataType)DoubleType$.MODULE$, pic);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)weightType -> {
                this.runTest$1((DataType)LongType$.MODULE$, (DataType)LongType$.MODULE$, (DataType)weightType, pic);
                return BoxedUnit.UNIT;
            });
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("invalid input: negative similarity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String msg;
            PowerIterationClustering pic = new PowerIterationClustering().setMaxIter(1).setWeightCol("weight");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PowerIterationClusteringSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator9$1(PowerIterationClusteringSuite $outer) {
                }
            }
            Dataset badData = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)-1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)-1.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator9$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "dst", "weight"}));
            String $org_scalatest_assert_macro_left = msg = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> pic.assignClusters(badData), ClassTag$.MODULE$.apply(SparkException.class), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142))).getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Similarity must be nonnegative";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("test default weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataWithoutWeight = this.data().sample(0.5, 1L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "src")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "dst"))}));
            Dataset assignments = new PowerIterationClustering().setK(2).setMaxIter(40).assignClusters(dataWithoutWeight);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PowerIterationClusteringSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator10$1(PowerIterationClusteringSuite $outer) {
                }
            }
            scala.collection.immutable.Set localAssignments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignments.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "cluster"))})).as(this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator10$1(null)))).collect())).toSet();
            Dataset dataWithWeightOne = dataWithoutWeight.withColumn("weight", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
            Dataset assignments2 = new PowerIterationClustering().setK(2).setMaxIter(40).assignClusters(dataWithWeightOne);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(PowerIterationClusteringSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator14$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator14$1(PowerIterationClusteringSuite $outer) {
                }
            }
            scala.collection.immutable.Set localAssignments2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])assignments2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "cluster"))})).as(this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_PowerIterationClusteringSuite$$typecreator14$1(null)))).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(localAssignments);
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = localAssignments2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PowerIterationClustering t = new PowerIterationClustering().setK(4).setMaxIter(100).setInitMode("degree").setSrcCol("src1").setDstCol("dst1").setWeightCol("weight");
            return this.testDefaultReadWrite(t, this.testDefaultReadWrite$default$2());
        }, new Position("PowerIterationClusteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }
}

