/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.evaluation.ClusteringEvaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\b\u0011\u0001mAQ!\f\u0001\u0005\u00029B\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001a\t\u00135\u0003\u0001\u0019!a\u0001\n\u0003q\u0005\"\u0003 \u0001\u0001\u0004\u0005\t\u0015)\u00034\u0011%A\u0006\u00011AA\u0002\u0013\u0005\u0011\fC\u0005b\u0001\u0001\u0007\t\u0019!C\u0001E\"Iq\f\u0001a\u0001\u0002\u0003\u0006KA\u0017\u0005\nQ\u0002\u0001\r\u00111A\u0005\u0002%D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013=\u0004\u0001\u0019!A!B\u0013Q\u0007\"\u0003=\u0001\u0001\u0004\u0005\r\u0011\"\u0001z\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%\t!!\u0002\t\u0013}\u0004\u0001\u0019!A!B\u0013Q\bbBA\t\u0001\u0011\u0005\u00131\u0003\u0002\u0019\u00072,8\u000f^3sS:<WI^1mk\u0006$xN]*vSR,'BA\t\u0013\u0003))g/\u00197vCRLwN\u001c\u0006\u0003'Q\t!!\u001c7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00019\u0001B\u0003CA\u000f\u001f\u001b\u0005!\u0012BA\u0010\u0015\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGN\u0003\u0002&)\u0005)Q\u000e\u001c7jE&\u0011qE\t\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tI3&D\u0001+\u0015\t\u0019##\u0003\u0002-U\t!B)\u001a4bk2$(+Z1e/JLG/\u001a+fgR\fa\u0001P5oSRtD#A\u0018\u0011\u0005A\u0002Q\"\u0001\t\u0002\u0017%\u0014\u0018n\u001d#bi\u0006\u001cX\r^\u000b\u0002gA\u0012A\u0007\u0010\t\u0004kaRT\"\u0001\u001c\u000b\u0005]\"\u0012aA:rY&\u0011\u0011H\u000e\u0002\b\t\u0006$\u0018m]3u!\tYD\b\u0004\u0001\u0005\u0013u\"\u0011\u0011!A\u0001\u0006\u00031%aA0%c\u0005a\u0011N]5t\t\u0006$\u0018m]3uA!\u0012A\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\niJ\fgn]5f]R\f\"a\u0012&\u0011\u0005\u0005C\u0015BA%C\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!Q&\n\u00051\u0013%aA!os\u0006y\u0011N]5t\t\u0006$\u0018m]3u?\u0012*\u0017\u000f\u0006\u0002P%B\u0011\u0011\tU\u0005\u0003#\n\u0013A!\u00168ji\"91kAA\u0001\u0002\u0004!\u0016a\u0001=%cA\u0012Qk\u0016\t\u0004ka2\u0006CA\u001eX\t%i$+!A\u0001\u0002\u000b\u0005a)\u0001\boK^L%/[:ECR\f7/\u001a;\u0016\u0003i\u0003$aW/\u0011\u0007UBD\f\u0005\u0002<;\u0012IalBA\u0001\u0002\u0003\u0015\tA\u0012\u0002\u0004?\u0012\u0012\u0014a\u00048fo&\u0013\u0018n\u001d#bi\u0006\u001cX\r\u001e\u0011)\u0005\u001d\u0001\u0015A\u00058fo&\u0013\u0018n\u001d#bi\u0006\u001cX\r^0%KF$\"aT2\t\u000fM3\u0011\u0011!a\u0001IB\u0012Qm\u001a\t\u0004ka2\u0007CA\u001eh\t%q6-!A\u0001\u0002\u000b\u0005a)A\boK^L%/[:ECR\f7/\u001a;E+\u0005Q\u0007GA6n!\r)\u0004\b\u001c\t\u0003w5$\u0011B\u001c\u0006\u0002\u0002\u0003\u0005)\u0011\u0001$\u0003\u0007}#3'\u0001\toK^L%/[:ECR\f7/\u001a;EA!\u0012!\u0002Q\u0001\u0014]\u0016<\u0018J]5t\t\u0006$\u0018m]3u\t~#S-\u001d\u000b\u0003\u001fNDqaU\u0005\u0002\u0002\u0003\u0007A\u000f\r\u0002voB\u0019Q\u0007\u000f<\u0011\u0005m:H!\u00038t\u0003\u0003\u0005\tQ!\u0001G\u0003=qWm^%sSN$\u0015\r^1tKR4U#\u0001>1\u0005ml\bcA\u001b9yB\u00111( \u0003\n}6\t\t\u0011!A\u0003\u0002\u0019\u00131a\u0018\u00135\u0003AqWm^%sSN$\u0015\r^1tKR4\u0005\u0005\u000b\u0002\u000e\u0001\u0006\u0019b.Z<Je&\u001cH)\u0019;bg\u0016$hi\u0018\u0013fcR\u0019q*a\u0002\t\u0011Mc\u0011\u0011!a\u0001\u0003\u0013\u0001D!a\u0003\u0002\u0010A!Q\u0007OA\u0007!\rY\u0014q\u0002\u0003\u000b}\u0006\u001d\u0011\u0011!A\u0001\u0006\u00031\u0015!\u00032fM>\u0014X-\u00117m)\u0005y\u0005")
public class ClusteringEvaluatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> irisDataset;
    private transient Dataset<?> newIrisDataset;
    private transient Dataset<?> newIrisDatasetD;
    private transient Dataset<?> newIrisDatasetF;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Dataset<?> irisDataset() {
        return this.irisDataset;
    }

    public void irisDataset_$eq(Dataset<?> x$1) {
        this.irisDataset = x$1;
    }

    public Dataset<?> newIrisDataset() {
        return this.newIrisDataset;
    }

    public void newIrisDataset_$eq(Dataset<?> x$1) {
        this.newIrisDataset = x$1;
    }

    public Dataset<?> newIrisDatasetD() {
        return this.newIrisDatasetD;
    }

    public void newIrisDatasetD_$eq(Dataset<?> x$1) {
        this.newIrisDatasetD = x$1;
    }

    public Dataset<?> newIrisDatasetF() {
        return this.newIrisDatasetF;
    }

    public void newIrisDatasetF_$eq(Dataset<?> x$1) {
        this.newIrisDatasetF = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.irisDataset_$eq(this.spark().read().format("libsvm").load("../data/mllib/iris_libsvm.txt"));
        Tuple3<Dataset<?>, Dataset<?>, Dataset<?>> datasets = MLTestingUtils$.MODULE$.generateArrayFeatureDataset(this.irisDataset(), MLTestingUtils$.MODULE$.generateArrayFeatureDataset$default$2());
        this.newIrisDataset_$eq((Dataset)datasets._1());
        this.newIrisDatasetD_$eq((Dataset)datasets._2());
        this.newIrisDatasetF_$eq((Dataset)datasets._3());
    }

    private final void testImplicits$lzycompute$1() {
        ClusteringEvaluatorSuite clusteringEvaluatorSuite = this;
        synchronized (clusteringEvaluatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public ClusteringEvaluatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParamsSuite$.MODULE$.checkParams((Params)new ClusteringEvaluator()), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setPredictionCol("myPrediction").setFeaturesCol("myLabel");
            return this.testDefaultReadWrite(evaluator, this.testDefaultReadWrite$default$2());
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("squared euclidean Silhouette", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.irisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.irisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetD())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetD)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetF())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetF)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("cosine Silhouette", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure("cosine");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.irisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.irisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDataset())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDataset)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetD())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetD)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(this.newIrisDatasetF())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(ClusteringEvaluatorSuite.this.newIrisDatasetF)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.7222369298).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("number of clusters must be greater than one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset singleClusterDataset = this.irisDataset().where(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0)));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"squaredEuclidean", "cosine"}))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
                ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label").setDistanceMeasure(distanceMeasure);
                AssertionError e = (AssertionError)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> evaluator.evaluate(singleClusterDataset), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                String $org_scalatest_assert_macro_left = ((Throwable)((Object)e)).getMessage();
                String $org_scalatest_assert_macro_right = "Number of clusters must be greater than one";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            });
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("SPARK-23568: we should use metadata to determine features number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int attributesNum = ((Vector)((Row)this.irisDataset().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().first()).getAs(0)).size();
            AttributeGroup attrGroup = new AttributeGroup("features", attributesNum);
            Dataset df = this.irisDataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}))).$((Seq)Nil$.MODULE$).as("features", attrGroup.toMetadata()), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$)}));
            Predef$.MODULE$.require(AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).numAttributes().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "numAttributes metadata should be defined");
            ClusteringEvaluator evaluator = new ClusteringEvaluator().setFeaturesCol("features").setPredictionCol("label");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(df)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(df)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6564679231).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            AttributeGroup wrongAttrGroup = new AttributeGroup("features", attributesNum + 1);
            Dataset dfWrong = this.irisDataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}))).$((Seq)Nil$.MODULE$).as("features", wrongAttrGroup.toMetadata()), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}))).$((Seq)Nil$.MODULE$)}));
            return (SparkException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> evaluator.evaluate(dfWrong), ClassTag$.MODULE$.apply(SparkException.class), new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("ClusteringEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }
}

