/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.StandardScaler;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.feature.VectorIndexerSuite;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.junit.Test;

public class JavaStandardScalerSuite
extends SharedSparkSession {
    @Test
    public void standardScaler() {
        List<VectorIndexerSuite.FeatureData> points = Arrays.asList(new VectorIndexerSuite.FeatureData(Vectors.dense((double)0.0, (double[])new double[]{-2.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{3.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{4.0})));
        Dataset dataFrame = this.spark.createDataFrame(this.jsc.parallelize(points, 2), VectorIndexerSuite.FeatureData.class);
        StandardScaler scaler = new StandardScaler().setInputCol("features").setOutputCol("scaledFeatures").setWithStd(true).setWithMean(false);
        StandardScalerModel scalerModel = scaler.fit(dataFrame);
        Dataset scaledData = scalerModel.transform(dataFrame);
        scaledData.count();
    }
}

