/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregatorSuite$;
import org.apache.spark.ml.optim.aggregator.HuberAggregator;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000114A!\u0004\b\u00017!)\u0001\u0006\u0001C\u0001S!IA\u0006\u0001a\u0001\u0002\u0004%\t!\f\u0005\nu\u0001\u0001\r\u00111A\u0005\u0002mB\u0011\"\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0018\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u0003i\u0003\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0001I\u0011%Q\u0005\u00011A\u0001B\u0003&a\u0006C\u0005M\u0001\u0001\u0007\t\u0019!C\u0001[!IQ\n\u0001a\u0001\u0002\u0004%\tA\u0014\u0005\n!\u0002\u0001\r\u0011!Q!\n9BQA\u0015\u0001\u0005BMCQ\u0001\u0016\u0001\u0005\nU\u0013A\u0003S;cKJ\fum\u001a:fO\u0006$xN]*vSR,'BA\b\u0011\u0003)\twm\u001a:fO\u0006$xN\u001d\u0006\u0003#I\tQa\u001c9uS6T!a\u0005\u000b\u0002\u00055d'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\b\u0011\u0011\u0005uqR\"\u0001\u000b\n\u0005}!\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!Q\u000f^5m\u0015\t)C#A\u0003nY2L'-\u0003\u0002(E\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u000f\u0003%Ign\u001d;b]\u000e,7/F\u0001/!\ry#\u0007N\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t)\u0011I\u001d:bsB\u0011Q\u0007O\u0007\u0002m)\u0011qGE\u0001\bM\u0016\fG/\u001e:f\u0013\tIdG\u0001\u0005J]N$\u0018M\\2f\u00035Ign\u001d;b]\u000e,7o\u0018\u0013fcR\u0011Ah\u0010\t\u0003_uJ!A\u0010\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u000e\t\t\u00111\u0001/\u0003\rAH%M\u0001\u000bS:\u001cH/\u00198dKN\u0004\u0003F\u0001\u0003D!\tyC)\u0003\u0002Fa\tIAO]1og&,g\u000e^\u0001\u0019S:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,\u0017\u0001H5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK~#S-\u001d\u000b\u0003y%Cq\u0001\u0011\u0004\u0002\u0002\u0003\u0007a&A\rj]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u0016\u0004\u0003FA\u0004D\u0003\u0001Jgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/\u001a$jYR,'/\u001a3\u0002I%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014XMR5mi\u0016\u0014X\rZ0%KF$\"\u0001P(\t\u000f\u0001K\u0011\u0011!a\u0001]\u0005\t\u0013N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3GS2$XM]3eA!\u0012!bQ\u0001\nE\u00164wN]3BY2$\u0012\u0001P\u0001\u0011O\u0016$h*Z<BO\u001e\u0014XmZ1u_J$RAV-[E\u001e\u0004\"aK,\n\u0005as!a\u0004%vE\u0016\u0014\u0018iZ4sK\u001e\fGo\u001c:\t\u000b1b\u0001\u0019\u0001\u0018\t\u000bmc\u0001\u0019\u0001/\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0002^A6\taL\u0003\u0002`%\u00051A.\u001b8bY\u001eL!!\u00190\u0003\rY+7\r^8s\u0011\u0015\u0019G\u00021\u0001e\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u!\tyS-\u0003\u0002ga\t9!i\\8mK\u0006t\u0007\"\u00025\r\u0001\u0004I\u0017aB3qg&dwN\u001c\t\u0003_)L!a\u001b\u0019\u0003\r\u0011{WO\u00197f\u0001")
public class HuberAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
    }

    private HuberAggregator getNewAggregator(Instance[] instances, Vector parameters, boolean fitIntercept, double epsilon) {
        MultivariateOnlineSummarizer featuresSummarizer;
        Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getRegressionSummarizers(instances);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MultivariateOnlineSummarizer multivariateOnlineSummarizer = featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
        MultivariateOnlineSummarizer featuresSummarizer2 = multivariateOnlineSummarizer;
        double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcParameters = this.spark().sparkContext().broadcast((Object)parameters, ClassTag$.MODULE$.apply(Vector.class));
        return new HuberAggregator(fitIntercept, epsilon, bcFeaturesStd, bcParameters);
    }

    private final void testImplicits$lzycompute$1() {
        HuberAggregatorSuite huberAggregatorSuite = this;
        synchronized (huberAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$15(double[] stdCoef$1, double intercept$1, double sigma$1, double epsilon$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double label = instance.label();
        double weight = instance.weight();
        Vector features = instance.features();
        double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$1), features) + intercept$1;
        double linearLoss = label - margin;
        double d = package$.MODULE$.abs(linearLoss) <= sigma$1 * epsilon$1 ? 0.5 * weight * (sigma$1 + package$.MODULE$.pow(linearLoss, 2.0) / sigma$1) : 0.5 * weight * (sigma$1 + 2.0 * epsilon$1 * package$.MODULE$.abs(linearLoss) - sigma$1 * epsilon$1 * epsilon$1);
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$16(double[] stdCoef$1, double intercept$1, double sigma$1, double epsilon$1, double[] gradientCoef$1, double[] featuresStd$1, Instance x0$2) {
        BoxedUnit boxedUnit;
        Instance instance = x0$2;
        if (instance != null) {
            double label = instance.label();
            double weight = instance.weight();
            Vector features = instance.features();
            double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$1), features) + intercept$1;
            double linearLoss = label - margin;
            if (package$.MODULE$.abs(linearLoss) <= sigma$1 * epsilon$1) {
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + -1.0 * weight * (linearLoss / sigma$1) * (features.apply(i) / featuresStd$1[i]);
                });
                gradientCoef$1[2] = gradientCoef$1[2] + -1.0 * weight * (linearLoss / sigma$1);
                gradientCoef$1[3] = gradientCoef$1[3] + 0.5 * weight * (1.0 - package$.MODULE$.pow(linearLoss / sigma$1, 2.0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + weight * sign * epsilon$1 * (features.apply(i) / featuresStd$1[i]);
                });
                gradientCoef$1[2] = gradientCoef$1[2] + weight * sign * epsilon$1;
                gradientCoef$1[3] = gradientCoef$1[3] + 0.5 * weight * (1.0 - epsilon$1 * epsilon$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void validateGradient$1(Vector grad, Vector gradFiltered) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad.apply(0)));
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(grad.apply(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(grad.apply(1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(0.01))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
    }

    public HuberAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method should check input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, 1.35);
            return (IllegalArgumentException)this.withClue("HuberAggregator features dimension must match parameters dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69)));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, 1.35);
            return (IllegalArgumentException)this.withClue("HuberAggregator does not support negative instance weights.", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector paramWithIntercept = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            Vector paramWithoutIntercept = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 4.0}));
            HuberAggregator aggIntercept = this.getNewAggregator(this.instances(), paramWithIntercept, true, 1.35);
            HuberAggregator aggNoIntercept = this.getNewAggregator(this.instances(), paramWithoutIntercept, false, 1.35);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MultivariateOnlineSummarizer featuresSummarizer;
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            int numFeatures = 2;
            Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getRegressionSummarizers(this.instances());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MultivariateOnlineSummarizer multivariateOnlineSummarizer = featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultivariateOnlineSummarizer featuresSummarizer2 = multivariateOnlineSummarizer;
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double epsilon = 1.35;
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, epsilon);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] coefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters.toArray())).slice(0, 2);
            double intercept = parameters.apply(2);
            double sigma = parameters.apply(3);
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefficients)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefficients[i] / featuresStd[i], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            double lossSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)HuberAggregatorSuite.$anonfun$new$15(stdCoef, intercept, sigma, epsilon, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = lossSum / weightSum;
            double[] gradientCoef = new double[numFeatures + 2];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HuberAggregatorSuite.$anonfun$new$16(stdCoef, intercept, sigma, epsilon, gradientCoef, featuresStd, x0$2);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            Vector parametersFiltered = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
            HuberAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), parameters, true, 1.35);
            HuberAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), parametersFiltered, true, 1.35);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureFiltered.add(instance));
            this.validateGradient$1(aggConstantFeature.gradient(), aggConstantFeatureFiltered.gradient());
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }
}

