/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ALSSuite$
implements Logging,
scala.Serializable {
    public static ALSSuite$ MODULE$;
    private final Map<String, Object> allModelParamSettings;
    private final Map<String, Object> allEstimatorParamSettings;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ALSSuite$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<String, Object> allModelParamSettings() {
        return this.allModelParamSettings;
    }

    public Map<String, Object> allEstimatorParamSettings() {
        return this.allEstimatorParamSettings;
    }

    public Seq<Tuple2<Object, float[]>> org$apache$spark$ml$recommendation$ALSSuite$$genFactors(int size, int rank, Random random, float a, float b) {
        Predef$.MODULE$.require(size > 0 && size < 0x2AAAAAAA);
        Predef$.MODULE$.require(b > a);
        Set ids = Set$.MODULE$.empty();
        while (ids.size() < size) {
            ids.$plus$eq((Object)BoxesRunTime.boxToInteger((int)random.nextInt()));
        }
        float width = b - a;
        return (Seq)((TraversableLike)ids.toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)id -> ALSSuite$.$anonfun$genFactors$1(rank, a, random, width, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
    }

    private float genFactors$default$4() {
        return -1.0f;
    }

    private float genFactors$default$5() {
        return 1.0f;
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genImplicitTestData(SparkContext sc, int numUsers, int numItems, int rank, double noiseStd, long seed) {
        double positiveFraction = 0.8;
        double negativeFraction = 1.0 - positiveFraction;
        double trainingFraction = 0.6;
        double testFraction = 0.3;
        double totalFraction = trainingFraction + testFraction;
        Random random = new Random(seed);
        Seq<Tuple2<Object, float[]>> userFactors = this.org$apache$spark$ml$recommendation$ALSSuite$$genFactors(numUsers, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        Seq<Tuple2<Object, float[]>> itemFactors = this.org$apache$spark$ml$recommendation$ALSSuite$$genFactors(numItems, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        ArrayBuffer training = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer test = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        userFactors.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)ALSSuite$.$anonfun$genImplicitTestData$1(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$38 -> {
            ALSSuite$.$anonfun$genImplicitTestData$2(itemFactors, rank, positiveFraction, negativeFraction, random, totalFraction, trainingFraction, noiseStd, training, test, x$38);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Generated an implicit feedback dataset with ").append(training.size()).append(" ratings for training ").append(new StringBuilder(14).append("and ").append(test.size()).append(" for test.").toString()).toString());
        return new Tuple2((Object)sc.parallelize((Seq)training, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)), (Object)sc.parallelize((Seq)test, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)));
    }

    public double genImplicitTestData$default$5() {
        return 0.0;
    }

    public long genImplicitTestData$default$6() {
        return 11L;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$genFactors$1(int rank$2, float a$1, Random random$3, float width$1, int id) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), Array$.MODULE$.fill(rank$2, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> a$1 + random$3.nextFloat() * width$1, ClassTag$.MODULE$.Float()));
    }

    public static final /* synthetic */ boolean $anonfun$genImplicitTestData$1(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$genImplicitTestData$3(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$genImplicitTestData$2(Seq itemFactors$2, int rank$3, double positiveFraction$1, double negativeFraction$1, Random random$4, double totalFraction$2, double trainingFraction$2, double noiseStd$2, ArrayBuffer training$3, ArrayBuffer test$3, Tuple2 x$38) {
        Tuple2 tuple2 = x$38;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int userId = tuple2._1$mcI$sp();
        float[] userFactor = (float[])tuple2._2();
        itemFactors$2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)ALSSuite$.$anonfun$genImplicitTestData$3(check$ifrefutable$6))).foreach((Function1 & Serializable & scala.Serializable)x$37 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$37;
            if (tuple2 != null) {
                boolean observed;
                int itemId = tuple2._1$mcI$sp();
                float[] itemFactor = (float[])tuple2._2();
                float rating = BLAS.getInstance().sdot(rank$3, userFactor, 1, itemFactor, 1);
                double threshold = rating > 0.0f ? positiveFraction$1 : negativeFraction$1;
                boolean bl = observed = random$4.nextDouble() < threshold;
                if (observed) {
                    double x = random$4.nextDouble();
                    if (x < totalFraction$2) {
                        if (x < trainingFraction$2) {
                            double noise = noiseStd$2 * random$4.nextGaussian();
                            boxedUnit = training$3.$plus$eq((Object)new ALS.Rating.mcI.sp(userId, itemId, rating + (float)noise));
                        } else {
                            boxedUnit = test$3.$plus$eq((Object)new ALS.Rating.mcI.sp(userId, itemId, rating));
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ALSSuite$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.allModelParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predictionCol"), (Object)"myPredictionCol")}));
        this.allEstimatorParamSettings = this.allModelParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numUserBlocks"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numItemBlocks"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"implicitPrefs"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alpha"), (Object)BoxesRunTime.boxToDouble((double)0.9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonnegative"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpointInterval"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"intermediateStorageLevel"), (Object)"MEMORY_ONLY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"finalStorageLevel"), (Object)"MEMORY_AND_DISK_SER")})));
    }
}

