/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniCalculator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.collection.OpenHashMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ArrayStack;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0007\u000e\u0001iAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\u0006i\u0001!\t!N\u0004\u0006\u00056AIa\u0011\u0004\u0006\u00195AI\u0001\u0012\u0005\u0006O\u0019!\ta\u0013\u0005\u0006\u0019\u001a!\t!\u0014\u0005\u0006I\u001a!I!\u001a\u0005\n\u0003\u00071\u0011\u0013!C\u0005\u0003\u000bA\u0011\"a\u0006\u0007\u0003\u0003%I!!\u0007\u0003#I\u000bg\u000eZ8n\r>\u0014Xm\u001d;Tk&$XM\u0003\u0002\u000f\u001f\u0005!\u0011.\u001c9m\u0015\t\u0001\u0012#\u0001\u0003ue\u0016,'B\u0001\n\u0014\u0003\tiGN\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000e !\taR$D\u0001\u0014\u0013\tq2CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nA!\u001e;jY*\u0011AeE\u0001\u0006[2d\u0017NY\u0005\u0003M\u0005\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u001b\u0005!1/Z3e+\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#aA%oi\u0006)1/Z3eA\u0005\u0019%-\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:$Vm\u001d;XSRD7i\u001c8uS:,x.^:GK\u0006$XO]3t\u0003:$7+\u001e2tC6\u0004H.\u001a3GK\u0006$XO]3t)\t1\u0014\b\u0005\u0002/o%\u0011\u0001h\f\u0002\u0005+:LG\u000fC\u0003;\t\u0001\u00071(\u0001\u0005tiJ\fG/Z4z!\ta\u0004)D\u0001>\u0015\tqt(A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0003!\rJ!!Q\u001f\u0003\u0011M#(/\u0019;fOf\f\u0011CU1oI>lgi\u001c:fgR\u001cV/\u001b;f!\tQcaE\u0002\u0007\u000b\"\u0003\"A\f$\n\u0005\u001d{#AB!osJ+g\r\u0005\u0002/\u0013&\u0011!j\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002\u0007\u0006AQ.\u00199U_Z+7\r\u0006\u0002O)B\u0011qJU\u0007\u0002!*\u0011\u0011+E\u0001\u0007Y&t\u0017\r\\4\n\u0005M\u0003&A\u0002,fGR|'\u000fC\u0003V\u0011\u0001\u0007a+A\u0002nCB\u0004Ba\u00160.C:\u0011\u0001\f\u0018\t\u00033>j\u0011A\u0017\u0006\u00037f\ta\u0001\u0010:p_Rt\u0014BA/0\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0004\u001b\u0006\u0004(BA/0!\tq#-\u0003\u0002d_\t1Ai\\;cY\u0016\f!cZ3u'VlG*Z1g\u0007>,h\u000e^3sgR\u0019a-\u001b=\u0011\u00059:\u0017B\u000150\u0005\u0011auN\\4\t\u000b)L\u0001\u0019A6\u0002\u000b9|G-Z:\u0011\u00071\fHO\u0004\u0002n_:\u0011\u0011L\\\u0005\u0002a%\u0011\u0001oL\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118O\u0001\u0003MSN$(B\u000190!\t)h/D\u0001\u0010\u0013\t9xB\u0001\u0003O_\u0012,\u0007bB=\n!\u0003\u0005\rAZ\u0001\u0004C\u000e\u001c\u0007FA\u0005|!\tax0D\u0001~\u0015\tqx&\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001~\u0005\u001d!\u0018-\u001b7sK\u000e\fAdZ3u'VlG*Z1g\u0007>,h\u000e^3sg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\b)\u001aa-!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EQ0A\u0005v]\u000eDWmY6fI&!\u0011QCA\b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\tyB\u0001\u0004PE*,7\r\u001e")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int seed;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Vector mapToVec(Map<Object, Object> map) {
        return RandomForestSuite$.MODULE$.mapToVec(map);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private int seed() {
        return this.seed;
    }

    public void binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(Strategy strategy2) {
        int numFeatures = 50;
        org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(numFeatures, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class));
        this.checkFeatureSubsetStrategy$1(1, "auto", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "all", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), rdd, strategy2, numFeatures);
        String[] realStrategies = (String[])((Object[])new String[]{".1", ".10", "0.10", "0.1", "0.9", "1.0"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$9(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        String[] integerStrategies = (String[])((Object[])new String[]{"1", "10", "100", "1000", "10000"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])integerStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$10(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        String[] invalidStrategies = (String[])((Object[])new String[]{"-.1", "-.10", "-0.10", ".0", "0.0", "1.1", "0"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidStrategies)).foreach((Function1 & Serializable & scala.Serializable)invalidStrategy -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy2, 1, invalidStrategy);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533)));
        this.checkFeatureSubsetStrategy$1(2, "all", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "auto", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), rdd, strategy2, numFeatures);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$13(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])integerStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$14(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidStrategies)).foreach((Function1 & Serializable & scala.Serializable)invalidStrategy -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy2, 2, invalidStrategy);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556)));
    }

    private final void testImplicits$lzycompute$1() {
        RandomForestSuite randomForestSuite = this;
        synchronized (randomForestSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    private final void checkCategoricalSplit$1(Split s, int featureIndex, double[] leftCategories) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)s.featureIndex()));
        int $org_scalatest_assert_macro_right = featureIndex;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        Split $org_scalatest_assert_macro_left2 = s;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.CategoricalSplit", $org_scalatest_assert_macro_left2 instanceof CategoricalSplit, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        CategoricalSplit s0 = (CategoricalSplit)s;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(s0.leftCategories());
        double[] $org_scalatest_assert_macro_right2 = leftCategories;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)s0.numCategories()));
        int $org_scalatest_assert_macro_right3 = 3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
    }

    private final InternalNode[] getChildren$1(Node rootNode) {
        Node node = rootNode;
        if (!(node instanceof InternalNode)) {
            throw new AssertionError((Object)"rootNode was not an InternalNode");
        }
        InternalNode internalNode = (InternalNode)node;
        Node $org_scalatest_assert_macro_left = internalNode.leftChild();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left instanceof InternalNode, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        Node $org_scalatest_assert_macro_left2 = internalNode.rightChild();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left2 instanceof InternalNode, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        InternalNode[] internalNodeArray = (InternalNode[])((Object[])new InternalNode[]{(InternalNode)internalNode.leftChild(), (InternalNode)internalNode.rightChild()});
        return internalNodeArray;
    }

    public static final /* synthetic */ Assertion $anonfun$new$36(RandomForestSuite $this, InternalNode[] children1$1, InternalNode[] children2$1, int i) {
        double $org_scalatest_assert_macro_left = children1$1[i].gain();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        double $org_scalatest_assert_macro_left2 = children2$1[i].gain();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(children1$1[i].split());
        Split $org_scalatest_assert_macro_right3 = children2$1[i].split();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].impurity()));
        double $org_scalatest_assert_macro_right4 = children2$1[i].impurity();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(children1$1[i].impurityStats().stats());
        double[] $org_scalatest_assert_macro_right5 = children2$1[i].impurityStats().stats();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].leftChild().impurity()));
        double $org_scalatest_assert_macro_right6 = children2$1[i].leftChild().impurity();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].rightChild().impurity()));
        double $org_scalatest_assert_macro_right7 = children2$1[i].rightChild().impurity();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].prediction()));
        double $org_scalatest_assert_macro_right8 = children2$1[i].prediction();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$4(LearningNode[] x$20) {
        return x$20.length == 1;
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$6(RandomForest.NodeIndexInfo x$22) {
        return x$22.featureSubset().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$5(Map x$21) {
        return x$21.values().forall((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$6(x$22)));
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$8(RandomForestSuite $this, int numFeaturesPerNode$1, RandomForest.NodeIndexInfo x$24) {
        return $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])x$24.featureSubset().get()).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numFeaturesPerNode$1), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$7(RandomForestSuite $this, int numFeaturesPerNode$1, Map x$23) {
        return x$23.values().forall((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$8($this, numFeaturesPerNode$1, x$24)));
    }

    public static final /* synthetic */ Assertion $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$2(RandomForestSuite $this, int numTrees$1, String featureSubsetStrategy$1, int numFeaturesPerNode$1, long maxMemoryUsage$1, DecisionTreeMetadata metadata$1, int numFeatures$1, int seed) {
        Assertion assertion;
        Map map;
        Map treeToNodeToIndexInfo;
        String failString;
        block6: {
            Tuple2 tuple2;
            block5: {
                failString = new StringBuilder(20).append("Failed on test with:").append(new StringBuilder(34).append("numTrees=").append(numTrees$1).append(", featureSubsetStrategy=").append(featureSubsetStrategy$1).append(",").toString()).append(new StringBuilder(27).append(" numFeaturesPerNode=").append(numFeaturesPerNode$1).append(", seed=").append(seed).toString()).toString();
                ArrayStack nodeStack = new ArrayStack();
                LearningNode[] topNodes = new LearningNode[numTrees$1];
                scala.package$.MODULE$.Range().apply(0, numTrees$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)treeIndex -> {
                    topNodes$1[treeIndex] = LearningNode$.MODULE$.emptyNode(1);
                    nodeStack.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)topNodes[treeIndex]));
                });
                Random rng = new Random(seed);
                tuple2 = RandomForest$.MODULE$.selectNodesToSplit(nodeStack, maxMemoryUsage$1, metadata$1, rng);
                if (tuple2 == null) break block5;
                Map nodesForGroup = (Map)tuple2._1();
                treeToNodeToIndexInfo = (Map)tuple2._2();
                if (nodesForGroup == null) break block5;
                map = nodesForGroup;
                if (treeToNodeToIndexInfo != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Map map2 = treeToNodeToIndexInfo;
        Tuple2 tuple2 = new Tuple2((Object)map, (Object)map2);
        Tuple2 tuple22 = tuple2;
        Map nodesForGroup = (Map)tuple22._1();
        Map treeToNodeToIndexInfo2 = (Map)tuple22._2();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)nodesForGroup.size()));
        int $org_scalatest_assert_macro_right = numTrees$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(nodesForGroup.values().forall((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$4(x$20))), "nodesForGroup.values.forall(((x$20: Array[org.apache.spark.ml.tree.LearningNode]) => x$20.length.==(1)))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        if (numFeaturesPerNode$1 == numFeatures$1) {
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$5(x$21))), "treeToNodeToIndexInfo.values.forall(((x$21: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$21.values.forall(((x$22: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => x$22.featureSubset.isEmpty))))", Prettifier$.MODULE$.default());
            assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        } else {
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$7($this, numFeaturesPerNode$1, x$23))), "treeToNodeToIndexInfo.values.forall(((x$23: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$23.values.forall(((x$24: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => RandomForestSuite.this.convertToEqualizer[Int](x$24.featureSubset.get.length).===(numFeaturesPerNode)(scalactic.this.Equality.default[Int])))))", Prettifier$.MODULE$.default());
            assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        }
        return assertion;
    }

    private final void checkFeatureSubsetStrategy$1(int numTrees, String featureSubsetStrategy, int numFeaturesPerNode, RDD rdd$2, Strategy strategy$2, int numFeatures$1) {
        int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
        long maxMemoryUsage = 0x8000000L;
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd$2, strategy$2, numTrees, featureSubsetStrategy);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$2(this, numTrees, featureSubsetStrategy, numFeaturesPerNode, maxMemoryUsage, metadata, numFeatures$1, BoxesRunTime.unboxToInt((Object)seed)));
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$9(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)numFeatures$1));
        $this.checkFeatureSubsetStrategy$1(1, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$10(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : numFeatures$1;
        $this.checkFeatureSubsetStrategy$1(1, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$13(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)numFeatures$1));
        $this.checkFeatureSubsetStrategy$1(2, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$14(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : numFeatures$1;
        $this.checkFeatureSubsetStrategy$1(2, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    private final void testNode$1(Node node, Map expected) {
        OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        TreeEnsembleModel$.MODULE$.computeFeatureImportance(node, (OpenHashMap)map);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.$conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.Predef.$conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
    }

    public RandomForestSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.seed = 42;
        this.test("Binary classification with continuous features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            SparkContext qual$1 = this.sc();
            WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$12, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 99;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Binary classification with binary (ordered) categorical features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$5 = Algo$.MODULE$.Classification();
            Gini$ x$6 = Gini$.MODULE$;
            int x$7 = 2;
            int x$8 = 2;
            int x$9 = 100;
            Map x$10 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Enumeration.Value x$11 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$12 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$13 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$14 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$15 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$16 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$17 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$5, (Impurity)x$6, x$7, x$8, x$9, x$11, x$10, x$12, x$13, x$14, x$15, x$16, x$17);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Binary classification with 3-ary (ordered) categorical features, with no samples for one category: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            SparkContext qual$3 = this.sc();
            WrappedArray x$18 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$19 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$18, x$19, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$20 = Algo$.MODULE$.Classification();
            Gini$ x$21 = Gini$.MODULE$;
            int x$22 = 2;
            int x$23 = 2;
            int x$24 = 100;
            Map x$25 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$26 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$27 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$28 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$29 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$30 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$31 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$32 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$20, (Impurity)x$21, x$22, x$23, x$24, x$26, x$25, x$27, x$28, x$29, x$30, x$31, x$32);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("find splits for a continuous feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata fakeMetadata = new DecisionTreeMetadata(1, 200000L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{6}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(10000, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> package$.MODULE$.random(), ClassTag$.MODULE$.Double()))).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 != 0.0);
            double[] splits = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples), fakeMetadata, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numSplits(0)));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numBins()[0]));
            int $org_scalatest_assert_macro_right3 = 6;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).distinct()).length));
            int $org_scalatest_assert_macro_right4 = splits.length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            DecisionTreeMetadata fakeMetadata2 = new DecisionTreeMetadata(1, 8L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples2 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 1, 0, 0, 1, 0, 1, 1})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$5 -> x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 != 0.0);
            double[] splits2 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples2), fakeMetadata2, 0);
            double[] expectedSplits = new double[]{0.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(splits2);
            double[] $org_scalatest_assert_macro_right5 = expectedSplits;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            double[] featureSamples3 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 0, 1, 1, 2, 2, 3, 3})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$7 -> x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$8 -> x$8 != 0.0);
            double[] splits3 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples3), fakeMetadata2, 0);
            double[] expectedSplits2 = new double[]{0.5, 2.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(splits3);
            double[] $org_scalatest_assert_macro_right6 = expectedSplits2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            DecisionTreeMetadata fakeMetadata3 = new DecisionTreeMetadata(1, 12L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{5}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples4 = (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$9 -> x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] splits4 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples4), fakeMetadata3, 0);
            double[] expectedSplits3 = new double[]{1.5, 2.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(splits4);
            double[] $org_scalatest_assert_macro_right7 = expectedSplits3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits4)).distinct()).length));
            int $org_scalatest_assert_macro_right8 = splits4.length;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            DecisionTreeMetadata fakeMetadata4 = new DecisionTreeMetadata(1, 18L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples5 = (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 5})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$10 -> x$10, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] splits5 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples5), fakeMetadata4, 0);
            double[] expectedSplits4 = new double[]{2.5, 3.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(splits5);
            double[] $org_scalatest_assert_macro_right9 = expectedSplits4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            DecisionTreeMetadata fakeMetadata5 = new DecisionTreeMetadata(1, 17L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{2}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples6 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$11 -> x$11, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$12 -> x$12 != 0.0);
            double[] splits6 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples6), fakeMetadata5, 0);
            double[] expectedSplits5 = new double[]{1.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(splits6);
            double[] $org_scalatest_assert_macro_right10 = expectedSplits5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            DecisionTreeMetadata fakeMetadata6 = new DecisionTreeMetadata(1, 3L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
            double[] featureSamples7 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 0, 0})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$13 -> x$13, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$14 -> x$14 != 0.0);
            double[] featureSamplesEmpty = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            double[] splits7 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamples7), fakeMetadata6, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(splits7);
            double[] $org_scalatest_assert_macro_right11 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            double[] splitsEmpty = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapDoubleArray(featureSamplesEmpty), fakeMetadata6, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(splitsEmpty);
            double[] $org_scalatest_assert_macro_right12 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("train with empty arrays", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint lp = new LabeledPoint(1.0, Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())));
            LabeledPoint[] data = (LabeledPoint[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> lp, ClassTag$.MODULE$.apply(LabeledPoint.class));
            SparkContext qual$4 = this.sc();
            WrappedArray x$33 = Predef$.MODULE$.wrapRefArray((Object[])data);
            int x$34 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$33, x$34, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$35 = Algo$.MODULE$.Regression();
            Gini$ x$36 = Gini$.MODULE$;
            int x$37 = 2;
            int x$38 = 5;
            int x$39 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$40 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$41 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$42 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$43 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$44 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$45 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$46 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$47 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$35, (Impurity)x$36, x$37, x$39, x$38, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47);
            return (IllegalArgumentException)this.withClue("DecisionTree requires number of features > 0, but was given an empty features vector", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205)));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("train with constant features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeModel tree2;
            DecisionTreeModel tree;
            int x$62;
            boolean x$61;
            double x$60;
            int x$59;
            double x$58;
            int x$57;
            LabeledPoint lp = new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})));
            LabeledPoint[] data = (LabeledPoint[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> lp, ClassTag$.MODULE$.apply(LabeledPoint.class));
            SparkContext qual$5 = this.sc();
            WrappedArray x$48 = Predef$.MODULE$.wrapRefArray((Object[])data);
            int x$49 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$48, x$49, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$50 = Algo$.MODULE$.Classification();
            Gini$ x$51 = Gini$.MODULE$;
            int x$52 = 2;
            int x$53 = 2;
            int x$54 = 5;
            Map x$55 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)5))}));
            Enumeration.Value x$56 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Strategy strategy = new Strategy(x$50, (Impurity)x$51, x$52, x$53, x$54, x$56, x$55, x$57 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$58 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$59 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$60 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$61 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$62 = Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel[] decisionTreeModelArray = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray);
            }
            DecisionTreeModel decisionTreeModel = tree = (DecisionTreeModel)((SeqLike)option.get()).apply(0);
            DecisionTreeModel tree3 = decisionTreeModel;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree3.rootNode().impurity()));
            double $org_scalatest_assert_macro_right = -1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree3.depth()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree3.rootNode().prediction()));
            double $org_scalatest_assert_macro_right3 = lp.label();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            Enumeration.Value x$63 = Algo$.MODULE$.Regression();
            Variance$ x$64 = Variance$.MODULE$;
            int x$65 = 2;
            int x$66 = 5;
            int x$67 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$68 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$69 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$70 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$71 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$72 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$73 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$74 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$75 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy2 = new Strategy(x$63, (Impurity)x$64, x$65, x$67, x$66, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75);
            DecisionTreeModel[] decisionTreeModelArray2 = RandomForest$.MODULE$.run(rdd, strategy2, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option2 = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray2);
            if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray2);
            }
            DecisionTreeModel decisionTreeModel2 = tree2 = (DecisionTreeModel)((SeqLike)option2.get()).apply(0);
            DecisionTreeModel tree22 = decisionTreeModel2;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree22.rootNode().impurity()));
            double $org_scalatest_assert_macro_right4 = -1.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree22.depth()));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree22.rootNode().prediction()));
            double $org_scalatest_assert_macro_right6 = lp.label();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("Multiclass classification with unordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            SparkContext qual$6 = this.sc();
            WrappedArray x$76 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$77 = qual$6.parallelize$default$2();
            RDD rdd = qual$6.parallelize((Seq)x$76, x$77, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$78 = Algo$.MODULE$.Classification();
            Gini$ x$79 = Gini$.MODULE$;
            int x$80 = 2;
            int x$81 = 100;
            int x$82 = 100;
            Map x$83 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$84 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$85 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$86 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$87 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$88 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$89 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$90 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$78, (Impurity)x$79, x$80, x$81, x$82, x$84, x$83, x$85, x$86, x$87, x$88, x$89, x$90);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(0)));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[0]));
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(1)));
            int $org_scalatest_assert_macro_right6 = 3;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[1]));
            int $org_scalatest_assert_macro_right7 = 3;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            this.checkCategoricalSplit$1(splits[0][0], 0, new double[]{0.0});
            this.checkCategoricalSplit$1(splits[0][1], 0, new double[]{1.0});
            this.checkCategoricalSplit$1(splits[0][2], 0, new double[]{0.0, 1.0});
            this.checkCategoricalSplit$1(splits[1][0], 1, new double[]{0.0});
            this.checkCategoricalSplit$1(splits[1][1], 1, new double[]{1.0});
            this.checkCategoricalSplit$1(splits[1][2], 1, new double[]{0.0, 1.0});
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("Multiclass classification with ordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures())).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 3000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            SparkContext qual$7 = this.sc();
            WrappedArray x$91 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$92 = qual$7.parallelize$default$2();
            RDD rdd = qual$7.parallelize((Seq)x$91, x$92, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$93 = Algo$.MODULE$.Classification();
            Gini$ x$94 = Gini$.MODULE$;
            int x$95 = 2;
            int x$96 = 100;
            int x$97 = 100;
            Map x$98 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$99 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$100 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$101 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$102 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$103 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$104 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$105 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$93, (Impurity)x$94, x$95, x$96, x$97, x$99, x$98, x$100, x$101, x$102, x$103, x$104, x$105);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("extract categories from a number for multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            List l = RandomForest$.MODULE$.extractMultiClassCategories(13, 10);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)l.length()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 0.0})));
            List $org_scalatest_assert_macro_right2 = l;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("Avoid aggregation on the last level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
            SparkContext qual$8 = this.sc();
            WrappedArray x$106 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$107 = qual$8.parallelize$default$2();
            RDD input = qual$8.parallelize((Seq)x$106, x$107, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$108 = Algo$.MODULE$.Classification();
            Gini$ x$109 = Gini$.MODULE$;
            int x$110 = 1;
            int x$111 = 2;
            Map x$112 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$113 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$114 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$115 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$116 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$117 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$118 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$119 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$120 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$108, (Impurity)x$109, x$110, x$111, x$113, x$114, x$112, x$115, x$116, x$117, x$118, x$119, x$120);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
            RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
            RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
            LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new LearningNode[]{topNode})}));
            Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topNode.id())), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
            ArrayStack nodeStack = new ArrayStack();
            RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)topNode)})), nodesForGroup, treeToNodeToIndexInfo, splits, nodeStack, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9());
            ArrayStack $org_scalatest_assert_macro_left3 = nodeStack;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right8 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("Avoid aggregation if impurity is 0.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
            SparkContext qual$9 = this.sc();
            WrappedArray x$121 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$122 = qual$9.parallelize$default$2();
            RDD input = qual$9.parallelize((Seq)x$121, x$122, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$123 = Algo$.MODULE$.Classification();
            Gini$ x$124 = Gini$.MODULE$;
            int x$125 = 5;
            int x$126 = 2;
            Map x$127 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$128 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$129 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$130 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$131 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$132 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$133 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$134 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$135 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$123, (Impurity)x$124, x$125, x$126, x$128, x$129, x$127, x$130, x$131, x$132, x$133, x$134, x$135);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
            RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
            RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
            LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new LearningNode[]{topNode})}));
            Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topNode.id())), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
            ArrayStack nodeStack = new ArrayStack();
            RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)topNode)})), nodesForGroup, treeToNodeToIndexInfo, splits, nodeStack, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9());
            ArrayStack $org_scalatest_assert_macro_left3 = nodeStack;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right8 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("Use soft prediction for binary classification with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            int x$150;
            boolean x$149;
            double x$148;
            int x$147;
            double x$146;
            int x$145;
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
            SparkContext qual$10 = this.sc();
            WrappedArray x$136 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$137 = qual$10.parallelize$default$2();
            RDD input = qual$10.parallelize((Seq)x$136, x$137, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$138 = Algo$.MODULE$.Classification();
            Gini$ x$139 = Gini$.MODULE$;
            int x$140 = 1;
            int x$141 = 2;
            Map x$142 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$143 = 3;
            Enumeration.Value x$144 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Strategy strategy = new Strategy(x$138, (Impurity)x$139, x$140, x$141, x$143, x$144, x$142, x$145 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$146 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$147 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$148 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$149 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$150 = Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel model = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(input, strategy, 1, "all", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            Node node = model.rootNode();
            if (node instanceof InternalNode) {
                InternalNode internalNode = (InternalNode)node;
                Split split = internalNode.split();
                if (!(split instanceof CategoricalSplit)) {
                    throw new AssertionError((Object)"model.rootNode.split was not a CategoricalSplit");
                }
                CategoricalSplit categoricalSplit = (CategoricalSplit)split;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(categoricalSplit.leftCategories());
                double[] $org_scalatest_assert_macro_right = new double[]{1.0};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            } else {
                throw new AssertionError((Object)"model.rootNode was not an InternalNode");
            }
            Assertion assertion2 = assertion;
            return assertion2;
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("Second level node building with vs. without groups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints())).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.asML(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LabeledPoint.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            SparkContext qual$11 = this.sc();
            WrappedArray x$151 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$152 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize((Seq)x$151, x$152, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$153 = Algo$.MODULE$.Classification();
            Entropy$ x$154 = Entropy$.MODULE$;
            int x$155 = 3;
            int x$156 = 2;
            int x$157 = 100;
            int x$158 = 1000;
            Enumeration.Value x$159 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$160 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$161 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$162 = Strategy$.MODULE$.$lessinit$greater$default$9();
            double x$163 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$164 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$165 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy1 = new Strategy(x$153, (Impurity)x$154, x$155, x$156, x$157, x$159, x$160, x$161, x$162, x$158, x$163, x$164, x$165);
            Enumeration.Value x$166 = Algo$.MODULE$.Classification();
            Entropy$ x$167 = Entropy$.MODULE$;
            int x$168 = 3;
            int x$169 = 2;
            int x$170 = 100;
            int x$171 = 0;
            Enumeration.Value x$172 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$173 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$174 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$175 = Strategy$.MODULE$.$lessinit$greater$default$9();
            double x$176 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$177 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$178 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy2 = new Strategy(x$166, (Impurity)x$167, x$168, x$169, x$170, x$172, x$173, x$174, x$175, x$171, x$176, x$177, x$178);
            DecisionTreeModel tree1 = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy1, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel tree2 = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy2, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            InternalNode[] children1 = this.getChildren$1(tree1.rootNode());
            InternalNode[] children2 = this.getChildren$1(tree2.rootNode());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable & scala.Serializable)i -> RandomForestSuite.$anonfun$new$36(this, children1, children2, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("Binary classification with continuous features: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$179 = Algo$.MODULE$.Classification();
            Gini$ x$180 = Gini$.MODULE$;
            int x$181 = 2;
            int x$182 = 2;
            Map x$183 = categoricalFeaturesInfo;
            int x$184 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$185 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$186 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$187 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$188 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$189 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$190 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$191 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$179, (Impurity)x$180, x$181, x$182, x$184, x$185, x$183, x$186, x$187, x$188, x$189, x$190, x$191);
            this.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        this.test("Binary classification with continuous features and node Id cache: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$192 = Algo$.MODULE$.Classification();
            Gini$ x$193 = Gini$.MODULE$;
            int x$194 = 2;
            int x$195 = 2;
            Map x$196 = categoricalFeaturesInfo;
            boolean x$197 = true;
            int x$198 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$199 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$200 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$201 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$202 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$203 = Strategy$.MODULE$.$lessinit$greater$default$11();
            int x$204 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$192, (Impurity)x$193, x$194, x$195, x$198, x$199, x$196, x$200, x$201, x$202, x$203, x$197, x$204);
            this.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        this.test("computeFeatureImportance, featureImportances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GiniCalculator leftImp = new GiniCalculator(new double[]{3.0, 2.0, 1.0});
            LeafNode left = new LeafNode(0.0, leftImp.calculate(), (ImpurityCalculator)leftImp);
            GiniCalculator rightImp = new GiniCalculator(new double[]{1.0, 2.0, 5.0});
            LeafNode right = new LeafNode(2.0, rightImp.calculate(), (ImpurityCalculator)rightImp);
            Node parent = TreeTests$.MODULE$.buildParentNode((Node)left, (Node)right, (Split)new ContinuousSplit(0, 0.5));
            ImpurityCalculator parentImp = parent.impurityStats();
            GiniCalculator left2Imp = new GiniCalculator(new double[]{1.0, 6.0, 1.0});
            LeafNode left2 = new LeafNode(0.0, left2Imp.calculate(), (ImpurityCalculator)left2Imp);
            Node grandParent = TreeTests$.MODULE$.buildParentNode((Node)left2, parent, (Split)new ContinuousSplit(1, 1.0));
            ImpurityCalculator grandImp = grandParent.impurityStats();
            this.testNode$1((Node)left, Predef$.MODULE$.Map().empty());
            double feature0importance = parentImp.calculate() * (double)parentImp.count() - (leftImp.calculate() * (double)leftImp.count() + rightImp.calculate() * (double)rightImp.count());
            this.testNode$1(parent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance))})));
            double feature1importance = grandImp.calculate() * (double)grandImp.count() - (left2Imp.calculate() * (double)left2Imp.count() + parentImp.calculate() * (double)parentImp.count());
            this.testNode$1(grandParent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)feature1importance))})));
            DecisionTreeModel[] trees = (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Node[]{parent, grandParent})).map((Function1 & Serializable & scala.Serializable)root -> new DecisionTreeClassificationModel(root, 2, 3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
            Vector importances = TreeEnsembleModel$.MODULE$.featureImportances(trees, 2);
            double tree2norm = feature0importance + feature1importance;
            Vector expected = Vectors$.MODULE$.dense((1.0 + feature0importance / tree2norm) / 2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{feature1importance / tree2norm / 2.0}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(importances).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(importances).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("normalizeMapValues", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
            map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)0), 1.0);
            map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)2), 2.0);
            TreeEnsembleModel$.MODULE$.normalizeMapValues((OpenHashMap)map);
            Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)0.6666666666666666))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.$conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.Predef.$conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        this.test("SPARK-3159 tree model redundancy - classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))});
            SparkContext qual$12 = this.sc();
            WrappedArray x$205 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$206 = qual$12.parallelize$default$2();
            RDD rdd = qual$12.parallelize((Seq)x$205, x$206, ClassTag$.MODULE$.apply(LabeledPoint.class));
            int numClasses = 2;
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, numClasses, 32, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel prunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel unprunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)prunedTree.numNodes()));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)unprunedTree.numNodes()));
            int $org_scalatest_assert_macro_right2 = 7;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters((List<Node>)new .colon.colon((Object)prunedTree.rootNode(), (List)Nil$.MODULE$), RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters$default$2())));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
        this.test("SPARK-3159 tree model redundancy - regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))});
            SparkContext qual$13 = this.sc();
            WrappedArray x$207 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$208 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize((Seq)x$207, x$208, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Regression(), (Impurity)Variance$.MODULE$, 4, 0, 32, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel prunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel unprunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)prunedTree.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)unprunedTree.numNodes()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters((List<Node>)new .colon.colon((Object)prunedTree.rootNode(), (List)Nil$.MODULE$), RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters$default$2())));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
    }
}

