/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LocalClusterSparkContext;
import org.apache.spark.rdd.RDD;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\tqBj\\4jgRL7MU3he\u0016\u001c8/[8o\u00072,8\u000f^3s'VLG/\u001a\u0006\u0003\t\u0015\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0007\u000f\u0005)Q\u000e\u001c7jE*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y1\u0003\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001F\f\u000e\u0003UQ!AF\u0003\u0002\tU$\u0018\u000e\\\u0005\u00031U\u0011\u0001\u0004T8dC2\u001cE.^:uKJ\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t1\u0001")
public class LogisticRegressionClusterSuite
extends SparkFunSuite
implements LocalClusterSparkContext {
    private transient SparkContext sc;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$LocalClusterSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$LocalClusterSparkContext$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        LocalClusterSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        LocalClusterSparkContext.afterAll$(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public static final /* synthetic */ LabeledPoint $anonfun$new$31(int n$1, Random random$1, int i) {
        return new LabeledPoint(1.0, Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(n$1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random$1.nextDouble(), ClassTag$.MODULE$.Double())));
    }

    public static final /* synthetic */ Iterator $anonfun$new$30(int n$1, int idx, Iterator iter) {
        Random random = new Random(idx);
        return iter.map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionClusterSuite.$anonfun$new$31(n$1, random, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ LabeledPoint $anonfun$new$36(int n$2, Random random$2, int i) {
        return new LabeledPoint(1.0, Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(n$2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> random$2.nextDouble(), ClassTag$.MODULE$.Double())));
    }

    public static final /* synthetic */ Iterator $anonfun$new$35(int n$2, int idx, Iterator iter) {
        Random random = new Random(idx);
        return iter.map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionClusterSuite.$anonfun$new$36(n$2, random, BoxesRunTime.unboxToInt((Object)i)));
    }

    public LogisticRegressionClusterSuite() {
        LocalClusterSparkContext.$init$(this);
        this.test("task size should be small in both training and prediction using SGD optimizer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            int m = 4;
            int n = 200000;
            RDD qual$1 = this.sc().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m), 2, ClassTag$.MODULE$.Int());
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(idx, iter) -> LogisticRegressionClusterSuite.$anonfun$new$30(n, BoxesRunTime.unboxToInt((Object)idx), iter);
            boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
            RDD points = qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LogisticRegressionModel model = LogisticRegressionWithSGD$.MODULE$.train(points, 2);
            RDD predictions = model.predict(points.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.features(), ClassTag$.MODULE$.apply(Vector.class)));
            return predictions.count();
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
        this.test("task size should be small in both training and prediction using LBFGS optimizer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            int m = 4;
            int n = 200000;
            RDD qual$2 = this.sc().parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), m), 2, ClassTag$.MODULE$.Int());
            Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(idx, iter) -> LogisticRegressionClusterSuite.$anonfun$new$35(n, BoxesRunTime.unboxToInt((Object)idx), iter);
            boolean x$4 = qual$2.mapPartitionsWithIndex$default$2();
            RDD points = qual$2.mapPartitionsWithIndex((Function2)x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LogisticRegressionWithLBFGS lr = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
            lr.optimizer().setNumIterations(2);
            LogisticRegressionModel model = lr.run(points);
            RDD predictions = model.predict(points.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.features(), ClassTag$.MODULE$.apply(Vector.class)));
            return predictions.count();
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
    }
}

