/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.control.Breaks$;

public final class LogisticRegressionSuite$
implements scala.Serializable {
    public static LogisticRegressionSuite$ MODULE$;
    private final LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel;
    private final LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel;

    static {
        new LogisticRegressionSuite$();
    }

    public List<LabeledPoint> generateLogisticInputAsList(double offset, double scale, int nPoints, int seed) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.generateLogisticInput(offset, scale, nPoints, seed)).asJava();
    }

    public Seq<LabeledPoint> generateLogisticInput(double offset, double scale, int nPoints, int seed) {
        Random rnd = new Random(seed);
        double[] x1 = (double[])Array$.MODULE$.fill(nPoints, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd.nextGaussian(), ClassTag$.MODULE$.Double());
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double p = 1.0 / (1.0 + package$.MODULE$.exp(-(offset + scale * x1[i])));
            return rnd.nextDouble() < p ? 1.0 : 0.0;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.$anonfun$generateLogisticInput$3(y, x1, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    public Seq<LabeledPoint> generateMultinomialLogisticInput(double[] weights, double[] xMean, double[] xVariance, boolean addIntercept, int nPoints, int seed) {
        Random rnd = new Random(seed);
        int xDim = xMean.length;
        int xWithInterceptsDim = addIntercept ? xDim + 1 : xDim;
        int nClasses = weights.length / xWithInterceptsDim + 1;
        Vector[] x = (Vector[])Array$.MODULE$.fill(nPoints, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(xDim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            LogisticRegressionSuite$.$anonfun$generateMultinomialLogisticInput$3(xVariance, xMean, vector);
            return BoxedUnit.UNIT;
        });
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)idx -> {
            double[] xArray = x[idx].toArray();
            double[] margins = (double[])Array$.MODULE$.ofDim(nClasses, ClassTag$.MODULE$.Double());
            double[] probs = (double[])Array$.MODULE$.ofDim(nClasses, ClassTag$.MODULE$.Double());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block0: {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), xDim).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                        int n = i + 1;
                        margins$1[n] = margins[n] + weights[i * xWithInterceptsDim + j] * xArray[j];
                    });
                    if (!addIntercept) break block0;
                    int n = i + 1;
                    margins$1[n] = margins[n] + weights[(i + 1) * xWithInterceptsDim - 1];
                }
            });
            double maxMargin = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margins)).max((Ordering)Ordering.Double$.MODULE$));
            if (maxMargin > 0.0) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    margins$1[i] = margins[i] - maxMargin;
                });
            }
            DoubleRef temp = DoubleRef.create((double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = package$.MODULE$.exp(margins[i]);
                temp$1.elem += probs[i];
            });
            double norm = temp.elem;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = probs[i] / norm;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = probs[i] + probs[i - 1];
            });
            double p = rnd.nextDouble();
            IntRef y = IntRef.create((int)0);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (p < probs[i]) {
                    y$2.elem = i;
                    throw Breaks$.MODULE$.break();
                }
            }));
            return y.elem;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.$anonfun$generateMultinomialLogisticInput$13(y, x, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    public LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel;
    }

    public LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel;
    }

    public void org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(LogisticRegressionModel a, LogisticRegressionModel b) {
        Vector vector = a.weights();
        Vector vector2 = b.weights();
        Predef$.MODULE$.assert(!(vector != null ? !vector.equals(vector2) : vector2 != null));
        Predef$.MODULE$.assert(a.intercept() == b.intercept());
        Predef$.MODULE$.assert(a.numClasses() == b.numClasses());
        Predef$.MODULE$.assert(a.numFeatures() == b.numFeatures());
        Option option = a.getThreshold();
        Option option2 = b.getThreshold();
        Predef$.MODULE$.assert(!(option != null ? !option.equals(option2) : option2 != null));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateLogisticInput$3(IndexedSeq y$1, double[] x1$1, int i) {
        return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)y$1.apply(i)), Vectors$.MODULE$.dense(new double[]{x1$1[i]}));
    }

    public static final /* synthetic */ void $anonfun$generateMultinomialLogisticInput$3(double[] xVariance$1, double[] xMean$1, Vector vector) {
        double[] vectorArray = vector.toArray();
        int len = vectorArray.length;
        for (int i = 0; i < len; ++i) {
            vectorArray[i] = vectorArray[i] * package$.MODULE$.sqrt(xVariance$1[i]) + xMean$1[i];
        }
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateMultinomialLogisticInput$13(IndexedSeq y$3, Vector[] x$10, int i) {
        return new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)y$3.apply(i)), x$10[i]);
    }

    private LogisticRegressionSuite$() {
        MODULE$ = this;
        this.org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel = new LogisticRegressionModel(Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3})), 0.5, 3, 2);
        this.org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel = new LogisticRegressionModel(Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4})), 1.0, 2, 3);
    }
}

