/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import breeze.generic.UFunc;
import breeze.linalg.Vector$;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.LogisticRegressionSuite;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Entry;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005}u!B\u000b\u0017\u0011\u0003\tc!B\u0012\u0017\u0011\u0003!\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002(\u0002\t\u0003y\u0005\"\u00021\u0002\t\u0003\t\u0007b\u0002:\u0002\u0005\u0004%Ia\u001d\u0005\u0007o\u0006\u0001\u000b\u0011\u0002;\t\u000fa\f!\u0019!C\u0005g\"1\u00110\u0001Q\u0001\nQDQA_\u0001\u0005\nmD\u0011\"a\u0002\u0002\u0003\u0003%I!!\u0003\u0007\u000b\r2\u0002!a\u0006\t\r9bA\u0011AA\u001c\u0011-\tY\u0004\u0004a\u0001\u0002\u0004%\t!!\u0010\t\u0017\u0005-C\u00021AA\u0002\u0013\u0005\u0011Q\n\u0005\f\u0003'b\u0001\u0019!A!B\u0013\ty\u0004C\u0004\u0002^1!\t%a\u0018\t\u000f\u0005\u0005D\u0002\"\u0001\u0002d!I\u00111\u000f\u0007\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\b\u0003\u0017cA\u0011BAG\u0003]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Tk&$XM\u0003\u0002\u00181\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\r\u001b\u0003\u0015iG\u000e\\5c\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001\u0001\t\u0003E\u0005i\u0011A\u0006\u0002\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|gnU;ji\u0016\u001c2!A\u0013,!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fMB\u0011a\u0005L\u0005\u0003[\u001d\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0011\u00027\u001d,g.\u001a:bi\u0016dunZ5ti&\u001c\u0017J\u001c9vi\u0006\u001bH*[:u)\u0015\u0011\u0004)R$M!\r\u0019\u0004HO\u0007\u0002i)\u0011QGN\u0001\u0005kRLGNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$\u0001\u0002'jgR\u0004\"a\u000f \u000e\u0003qR!!\u0010\r\u0002\u0015I,wM]3tg&|g.\u0003\u0002@y\taA*\u00192fY\u0016$\u0007k\\5oi\")\u0011i\u0001a\u0001\u0005\u00061qN\u001a4tKR\u0004\"AJ\"\n\u0005\u0011;#A\u0002#pk\ndW\rC\u0003G\u0007\u0001\u0007!)A\u0003tG\u0006dW\rC\u0003I\u0007\u0001\u0007\u0011*A\u0004o!>Lg\u000e^:\u0011\u0005\u0019R\u0015BA&(\u0005\rIe\u000e\u001e\u0005\u0006\u001b\u000e\u0001\r!S\u0001\u0005g\u0016,G-A\u000bhK:,'/\u0019;f\u0019><\u0017n\u001d;jG&s\u0007/\u001e;\u0015\u000bAcVLX0\u0011\u0007EK&H\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011Q\u000bI\u0001\u0007yI|w\u000e\u001e \n\u0003!J!\u0001W\u0014\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\u0004'\u0016\f(B\u0001-(\u0011\u0015\tE\u00011\u0001C\u0011\u00151E\u00011\u0001C\u0011\u0015AE\u00011\u0001J\u0011\u0015iE\u00011\u0001J\u0003\u0001:WM\\3sCR,W*\u001e7uS:|W.[1m\u0019><\u0017n\u001d;jG&s\u0007/\u001e;\u0015\u000fA\u0013w-[6qc\")1-\u0002a\u0001I\u00069q/Z5hQR\u001c\bc\u0001\u0014f\u0005&\u0011am\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006Q\u0016\u0001\r\u0001Z\u0001\u0006q6+\u0017M\u001c\u0005\u0006U\u0016\u0001\r\u0001Z\u0001\nqZ\u000b'/[1oG\u0016DQ\u0001\\\u0003A\u00025\fA\"\u00193e\u0013:$XM]2faR\u0004\"A\n8\n\u0005=<#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0011\u0016\u0001\r!\u0013\u0005\u0006\u001b\u0016\u0001\r!S\u0001\fE&t\u0017M]=N_\u0012,G.F\u0001u!\t\u0011S/\u0003\u0002w-\t9Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\\u0001\rE&t\u0017M]=N_\u0012,G\u000eI\u0001\u0010[VdG/[2mCN\u001cXj\u001c3fY\u0006\u0001R.\u001e7uS\u000ed\u0017m]:N_\u0012,G\u000eI\u0001\u0011G\",7m['pI\u0016d7/R9vC2$B\u0001`@\u0002\u0004A\u0011a%`\u0005\u0003}\u001e\u0012A!\u00168ji\"1\u0011\u0011\u0001\u0006A\u0002Q\f\u0011!\u0019\u0005\u0007\u0003\u000bQ\u0001\u0019\u0001;\u0002\u0003\t\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u001c\u0002\t1\fgnZ\u0005\u0005\u0003+\tyA\u0001\u0004PE*,7\r^\n\b\u0019\u0005e\u0011\u0011EA\u0016!\u0011\tY\"!\b\u000e\u0003iI1!a\b\u001b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB!\u00111EA\u0014\u001b\t\t)C\u0003\u000261%!\u0011\u0011FA\u0013\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cq\u0012!C:dC2\fG/Z:u\u0013\u0011\t)$a\f\u0003\u00115\u000bGo\u00195feN$\"!!\u000f\u0011\u0005\tb\u0011!\u00042j]\u0006\u0014\u0018\u0010R1uCN,G/\u0006\u0002\u0002@A)\u0011\u0011IA$u5\u0011\u00111\t\u0006\u0004\u0003\u000bR\u0012a\u0001:eI&!\u0011\u0011JA\"\u0005\r\u0011F\tR\u0001\u0012E&t\u0017M]=ECR\f7/\u001a;`I\u0015\fHc\u0001?\u0002P!I\u0011\u0011K\b\u0002\u0002\u0003\u0007\u0011qH\u0001\u0004q\u0012\n\u0014A\u00042j]\u0006\u0014\u0018\u0010R1uCN,G\u000f\t\u0015\u0004!\u0005]\u0003c\u0001\u0014\u0002Z%\u0019\u00111L\u0014\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u00032fM>\u0014X-\u00117m)\u0005a\u0018A\u0005<bY&$\u0017\r^3Qe\u0016$\u0017n\u0019;j_:$r\u0001`A3\u0003W\ny\u0007C\u0004\u0002hI\u0001\r!!\u001b\u0002\u0017A\u0014X\rZ5di&|gn\u001d\t\u0004#f\u0013\u0005BBA7%\u0001\u0007\u0001+A\u0003j]B,H\u000f\u0003\u0005\u0002rI\u0001\n\u00111\u0001C\u0003-)\u0007\u0010]3di\u0016$\u0017iY2\u00029Y\fG.\u001b3bi\u0016\u0004&/\u001a3jGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u000f\u0016\u0004\u0005\u0006e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015u%\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0013Q,7\u000f\u001e'C\r\u001e\u001bFc\u0001?\u0002\u0010\"9\u0011\u0011\u0013\u000bA\u0002\u0005M\u0015!C7z+B$\u0017\r^3s!\u0011\t)*a'\u000e\u0005\u0005]%bAAM1\u0005aq\u000e\u001d;j[&T\u0018\r^5p]&!\u0011QTAL\u0005\u001d)\u0006\u000fZ1uKJ\u0004")
public class LogisticRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private transient RDD<LabeledPoint> binaryDataset;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Seq<LabeledPoint> generateMultinomialLogisticInput(double[] dArray, double[] dArray2, double[] dArray3, boolean bl, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(dArray, dArray2, dArray3, bl, n, n2);
    }

    public static Seq<LabeledPoint> generateLogisticInput(double d, double d2, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(d, d2, n, n2);
    }

    public static java.util.List<LabeledPoint> generateLogisticInputAsList(double d, double d2, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateLogisticInputAsList(d, d2, n, n2);
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public RDD<LabeledPoint> binaryDataset() {
        return this.binaryDataset;
    }

    public void binaryDataset_$eq(RDD<LabeledPoint> x$1) {
        this.binaryDataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        int nPoints = 10000;
        double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191};
        double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
        double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
        Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 42);
        this.binaryDataset_$eq((RDD<LabeledPoint>)this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input, double expectedAcc) {
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogisticRegressionSuite.$anonfun$validatePrediction$1(x0$1)));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)((double)(input.length() - numOffPredictions) / (double)input.length())), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).should(this.be().$greater((Object)BoxesRunTime.boxToDouble((double)expectedAcc), (Ordering)Ordering.Double$.MODULE$));
    }

    public double validatePrediction$default$3() {
        return 0.83;
    }

    private void testLBFGS(Updater myUpdater) {
        int nPoints = 10000;
        double A = 2.0;
        double B = -1.5;
        Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
        RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
        testRDD.cache();
        public class Org_apache_spark_mllib_classification_LogisticRegressionSuite$LogisticRegressionWithLBFGSCustomUpdater$1
        extends LogisticRegressionWithLBFGS {
            private final LBFGS optimizer;

            public LBFGS optimizer() {
                return this.optimizer;
            }

            public Org_apache_spark_mllib_classification_LogisticRegressionSuite$LogisticRegressionWithLBFGSCustomUpdater$1(LogisticRegressionSuite $outer, Updater myUpdater$1) {
                this.optimizer = new LBFGS((Gradient)new LogisticGradient(), myUpdater$1);
            }
        }
        Org_apache_spark_mllib_classification_LogisticRegressionSuite$LogisticRegressionWithLBFGSCustomUpdater$1 lr = (Org_apache_spark_mllib_classification_LogisticRegressionSuite$LogisticRegressionWithLBFGSCustomUpdater$1)new Org_apache_spark_mllib_classification_LogisticRegressionSuite$LogisticRegressionWithLBFGSCustomUpdater$1(null, myUpdater).setIntercept(true);
        LogisticRegressionModel model = lr.run(testRDD);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
        RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
        this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.validatePrediction$default$3());
        this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData, this.validatePrediction$default$3());
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    private final void testImplicits$lzycompute$1() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
        return bl;
    }

    public static final /* synthetic */ int $anonfun$new$19(LabeledPoint x$6) {
        return x$6.features().size();
    }

    public LogisticRegressionSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.test("logistic regression with SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 2.0;
            double B = -1.5;
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
            lr.optimizer().setStepSize(10.0).setRegParam(0.0).setNumIterations(20).setConvergenceTol(5.0E-4);
            LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.validatePrediction$default$3());
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData, this.validatePrediction$default$3());
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            .colon.colon updaters = new .colon.colon((Object)new SquaredL2Updater(), (List)new .colon.colon((Object)new L1Updater(), (List)Nil$.MODULE$));
            updaters.foreach((Function1 & Serializable & scala.Serializable)myUpdater -> {
                this.testLBFGS(myUpdater);
                return BoxedUnit.UNIT;
            });
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("logistic regression with initial weights with SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 2.0;
            double B = -1.5;
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
            double initialB = -1.0;
            Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
            lr.optimizer().setStepSize(10.0).setRegParam(0.0).setNumIterations(10);
            LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.validatePrediction$default$3());
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData, this.validatePrediction$default$3());
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("logistic regression with initial weights and non-default regularization parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 2.0;
            double B = -1.5;
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
            double initialB = -1.0;
            Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
            lr.optimizer().setStepSize(1.0).setNumIterations(10).setRegParam(1.0);
            LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-0.14).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-0.14).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.25).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, 0.8);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData, 0.8);
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("logistic regression with initial weights with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 2.0;
            double B = -1.5;
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
            double initialB = -1.0;
            Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            LogisticRegressionWithLBFGS lr = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
            LogisticRegressionModel model = lr.run(testRDD, initialWeights);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.validatePrediction$default$3());
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData, this.validatePrediction$default$3());
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("numerical stability of scaling features using logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double A = 2.0;
            double B = -1.5;
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
            Vector initialWeights = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            RDD testRDD1 = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            RDD testRDD2 = this.sc().parallelize((Seq)testData.map((Function1 & Serializable & scala.Serializable)x -> new LabeledPoint(x.label(), Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.features().asBreeze().$times((Object)BoxesRunTime.boxToDouble((double)1000.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()))), Seq$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            RDD testRDD3 = this.sc().parallelize((Seq)testData.map((Function1 & Serializable & scala.Serializable)x -> new LabeledPoint(x.label(), Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.features().asBreeze().$times((Object)BoxesRunTime.boxToDouble((double)1000000.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()))), Seq$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD1.cache();
            testRDD2.cache();
            testRDD3.cache();
            int numIteration = 10;
            LogisticRegressionWithLBFGS lrA = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
            lrA.optimizer().setNumIterations(numIteration);
            LogisticRegressionWithLBFGS lrB = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(false);
            lrB.optimizer().setNumIterations(numIteration);
            LogisticRegressionModel modelA1 = lrA.run(testRDD1, initialWeights);
            LogisticRegressionModel modelA2 = lrA.run(testRDD2, initialWeights);
            LogisticRegressionModel modelA3 = lrA.run(testRDD3, initialWeights);
            LogisticRegressionModel modelB1 = lrB.run(testRDD1, initialWeights);
            LogisticRegressionModel modelB2 = lrB.run(testRDD2, initialWeights);
            LogisticRegressionModel modelB3 = lrB.run(testRDD3, initialWeights);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA2.weights().apply(0) * 1000.0).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA2.weights.apply(0).*(1000.0)).absTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA3.weights().apply(0) * 1000000.0).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA3.weights.apply(0).*(1000000.0)).absTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB2.weights().apply(0) * 1000.0).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB2.weights.apply(0).*(1000.0)).absTol(0.1))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB3.weights().apply(0) * 1000000.0).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB3.weights.apply(0).*(1000000.0)).absTol(0.1))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("multinomial logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double[] weights = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
            double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
            double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
            Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(weights, xMean, xVariance, true, nPoints, 42);
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(3);
            lr.optimizer().setConvergenceTol(1.0E-15).setNumIterations(200);
            LogisticRegressionModel model = lr.run(testRDD);
            int numFeatures = BoxesRunTime.unboxToInt((Object)testRDD.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)LogisticRegressionSuite.$anonfun$new$19(x$6)), ClassTag$.MODULE$.Int()).first());
            Vector initialWeights = Vectors$.MODULE$.dense(new double[(numFeatures + 1) * 2]);
            LogisticRegressionModel model2 = lr.run(testRDD, initialWeights);
            LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, model2);
            Vector weightsR = Vectors$.MODULE$.dense(new double[]{-0.5837166, 0.928526, -0.3783612, -0.8123411, 2.6228269, -0.1691865, -0.811048, -0.064638, -0.2919834, 4.1119745});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.weights()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(weightsR).relTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.weights).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(weightsR).relTol(0.05))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(weights, xMean, xVariance, true, nPoints, 17);
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, 0.47);
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("model save/load: binary classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            LogisticRegressionModel model = LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel();
            model.clearThreshold();
            Option $org_scalatest_assert_macro_left = model.getThreshold();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(this.sc(), path);
                LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel);
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            try {
                model.setThreshold(0.7);
                model.save(this.sc(), path);
                LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(this.sc(), path);
                LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
        this.test("model save/load: multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            LogisticRegressionModel model = LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel();
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(this.sc(), path);
                LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.test("binary logistic regression with intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(true);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(false);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR = 2.8366423;
            Vector coefficientsR = Vectors$.MODULE$.dense(-0.5895848, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8931147, -0.3925051, -0.7996864}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        this.test("binary logistic regression without intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(true);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(false);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR = 0.0;
            Vector coefficientsR = Vectors$.MODULE$.dense(-0.3534996, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2964482, -0.3571741, -0.7407946}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        this.test("binary logistic regression with intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(true);
            trainer1.optimizer().setUpdater((Updater)new L1Updater()).setRegParam(0.12);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(false);
            trainer2.optimizer().setUpdater((Updater)new L1Updater()).setRegParam(0.12);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR1 = -0.05627428;
            Vector coefficientsR1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.04325749, -0.02481551}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            double interceptR2 = 0.3722152;
            Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.1665453, 0.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        this.test("binary logistic regression without intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(true);
            trainer1.optimizer().setUpdater((Updater)new L1Updater()).setRegParam(0.12);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(false);
            trainer2.optimizer().setUpdater((Updater)new L1Updater()).setRegParam(0.12);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR1 = 0.0;
            Vector coefficientsR1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.05189203, -0.03891782}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            double interceptR2 = 0.0;
            Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.08420782, 0.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        this.test("binary logistic regression with intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(true);
            trainer1.optimizer().setUpdater((Updater)new SquaredL2Updater()).setRegParam(1.37);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(false);
            trainer2.optimizer().setUpdater((Updater)new SquaredL2Updater()).setRegParam(1.37);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR1 = 0.15021751;
            Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.07251837, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.10724191, -0.04865309, -0.10062872}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
            double interceptR2 = 0.48657516;
            Vector coefficientsR2 = Vectors$.MODULE$.dense(-0.05155371, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.02301057, -0.11482896, -0.06266838}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
        this.test("binary logistic regression without intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionWithLBFGS trainer1 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(true);
            trainer1.optimizer().setUpdater((Updater)new SquaredL2Updater()).setRegParam(1.37);
            LogisticRegressionWithLBFGS trainer2 = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(false).setFeatureScaling(false);
            trainer2.optimizer().setUpdater((Updater)new SquaredL2Updater()).setRegParam(1.37);
            LogisticRegressionModel model1 = trainer1.run(this.binaryDataset());
            LogisticRegressionModel model2 = trainer2.run(this.binaryDataset());
            double interceptR1 = 0.0;
            Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.06099165, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12857058, -0.0470877, -0.09799775}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
            double interceptR2 = 0.0;
            Vector coefficientsR2 = Vectors$.MODULE$.dense(-0.005679651, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.048967094, -0.093714016, -0.053314311}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.weights()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.weights).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        }, new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
    }
}

