/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.StreamingLogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e2Aa\u0002\u0005\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C!G!I!\u0006\u0001a\u0001\u0002\u0004%\ta\u000b\u0005\n_\u0001\u0001\r\u00111A\u0005\u0002AB\u0011B\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0017\t\u000b]\u0002A\u0011\t\u001d\u0003AM#(/Z1nS:<Gj\\4jgRL7MU3he\u0016\u001c8/[8o'VLG/\u001a\u0006\u0003\u0013)\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\f\u0019\u0005)Q\u000e\u001c7jE*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\u0002\u0004\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0007\u0002\u0013M$(/Z1nS:<\u0017BA\u000f\u001b\u00055!Vm\u001d;Tk&$XMQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011\u0001C\u0001\u0012[\u0006Dx+Y5u)&lW-T5mY&\u001cX#\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u0007%sG/A\u0002tg\u000e,\u0012\u0001\f\t\u000335J!A\f\u000e\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018aB:tG~#S-\u001d\u000b\u0003cQ\u0002\"!\n\u001a\n\u0005M2#\u0001B+oSRDq!\u000e\u0003\u0002\u0002\u0003\u0007A&A\u0002yIE\nAa]:dA\u0005i\u0011M\u001a;fe\u001a+hn\u0019;j_:$\u0012!\r")
public class StreamingLogisticRegressionSuite
extends SparkFunSuite
implements TestSuiteBase {
    private StreamingContext ssc;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    private String checkpointDir$lzycompute() {
        StreamingLogisticRegressionSuite streamingLogisticRegressionSuite = this;
        synchronized (streamingLogisticRegressionSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public void afterFunction() {
        block0: {
            TestSuiteBase.afterFunction$((TestSuiteBase)this);
            if (this.ssc() == null) break block0;
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() <= 0.1;
    }

    public static final /* synthetic */ int $anonfun$new$9(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() < 0.0 ? 1 : 0;
    }

    public static final /* synthetic */ double $anonfun$new$14(int nPoints$3, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$3;
    }

    public static final /* synthetic */ double $anonfun$new$21(int nPoints$4, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$4;
    }

    public StreamingLogisticRegressionSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("parameter accuracy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nPoints = 100;
            double B = 1.5;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 20;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((LogisticRegressionModel)model.latestModel()).weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.latestModel().weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.1))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("parameter convergence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double B = 1.5;
            int nPoints = 100;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 20;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            ArrayBuffer history = new ArrayBuffer(numBatches);
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                inputDStream.foreachRDD((Function1 & Serializable & scala.Serializable)x -> {
                    history.$plus$eq((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(((LogisticRegressionModel)model.latestModel()).weights().apply(0) - B)));
                    return BoxedUnit.UNIT;
                });
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            ArrayBuffer deltas = (ArrayBuffer)((IndexedSeqOptimized)history.drop(1)).zip((GenIterable)history.dropRight(1), ArrayBuffer$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(deltas.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)StreamingLogisticRegressionSuite.$anonfun$new$8(x))), "deltas.forall(((x: (Double, Double)) => x._1.-(x._2).<=(0.1)))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)StreamingLogisticRegressionSuite.$anonfun$new$9(x)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("predictions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double B = 1.5;
            int nPoints = 100;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Seq errors = (Seq)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLogisticRegressionSuite.$anonfun$new$14(nPoints, batch)), Seq$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(errors.forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x -> x <= 0.4), "errors.forall(((x: Double) => x.<=(0.4)))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("training and prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
            int numBatches = 10;
            int nPoints = 100;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, 5.0, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            List error = ((TraversableOnce)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLogisticRegressionSuite.$anonfun$new$21(nPoints, batch)), Seq$.MODULE$.canBuildFrom())).toList();
            double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)error.head());
            double $org_scalatest_assert_macro_right = 0.8;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToDouble((Object)error.last());
                double $org_scalatest_assert_macro_right2 = 0.2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("handling empty RDDs in a stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
            int numBatches = 10;
            Seq emptyInput = (Seq)Seq$.MODULE$.empty();
            this.ssc_$eq(this.setupStreams(emptyInput, (Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }
}

