/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KMeansSuite$
extends SparkFunSuite {
    public static KMeansSuite$ MODULE$;

    static {
        new KMeansSuite$();
    }

    public KMeansModel createModel(int dim, int k, boolean isSparse) {
        Vector singlePoint = isSparse ? Vectors$.MODULE$.sparse(dim, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()));
        return new KMeansModel((Vector[])Array$.MODULE$.fill(k, (Function0 & Serializable & scala.Serializable)() -> singlePoint, ClassTag$.MODULE$.apply(Vector.class)));
    }

    public void checkEqual(KMeansModel a, KMeansModel b) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)a.k()));
        int $org_scalatest_assert_macro_right = b.k();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a.clusterCenters())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])b.clusterCenters()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Vector ca = (Vector)tuple2._1();
                Vector cb = (Vector)tuple2._2();
                if (ca instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)ca;
                    if (cb instanceof SparseVector) {
                        SparseVector sparseVector2 = (SparseVector)cb;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = MODULE$.convertToEqualizer(sparseVector);
                        SparseVector $org_scalatest_assert_macro_right = sparseVector2;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
                    }
                }
            }
            if (tuple2 == null) throw new AssertionError((Object)"checkEqual failed since the two clusters were not identical.\n");
            Vector ca = (Vector)tuple2._1();
            Vector cb = (Vector)tuple2._2();
            if (!(ca instanceof DenseVector)) throw new AssertionError((Object)"checkEqual failed since the two clusters were not identical.\n");
            DenseVector denseVector = (DenseVector)ca;
            if (!(cb instanceof DenseVector)) throw new AssertionError((Object)"checkEqual failed since the two clusters were not identical.\n");
            DenseVector denseVector2 = (DenseVector)cb;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = MODULE$.convertToEqualizer(denseVector);
            DenseVector $org_scalatest_assert_macro_right = denseVector2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KMeansSuite$() {
        MODULE$ = this;
    }
}

