/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.argmax$;
import breeze.linalg.argtopk$;
import breeze.linalg.max$;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDASuite$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001E\t\u00019!)q\u0005\u0001C\u0001Q\u001d11&\u0005E\u0001#12a\u0001E\t\t\u0002Ei\u0003\"B\u0014\u0004\t\u00039\u0004\"\u0002\u001d\u0004\t\u0003I\u0004\"B\u001f\u0004\t\u0003I\u0004\"\u0002 \u0004\t\u0003y\u0004\"B$\u0004\t\u0003A\u0005\"B(\u0004\t\u0003\u0001\u0006\"\u0002,\u0004\t\u00039\u0006\"\u00021\u0004\t\u0003\t\u0007\"\u00023\u0004\t\u00039\u0006\"B3\u0004\t\u00031\u0007\"\u0002;\u0004\t\u0003)\bbB=\u0004\u0003\u0003%IA\u001f\u0002\t\u0019\u0012\u000b5+^5uK*\u0011!cE\u0001\u000bG2,8\u000f^3sS:<'B\u0001\u000b\u0016\u0003\u0015iG\u000e\\5c\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0004\u0001u\t\u0003C\u0001\u0010 \u001b\u0005)\u0012B\u0001\u0011\u0016\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!%J\u0007\u0002G)\u0011AeE\u0001\u0005kRLG.\u0003\u0002'G\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0012\u0003!aE)Q*vSR,\u0007C\u0001\u0016\u0004'\r\u0019a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=*\u0014B\u0001\u001c1\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005a\u0013!\u0002;j]f\\U#\u0001\u001e\u0011\u0005=Z\u0014B\u0001\u001f1\u0005\rIe\u000e^\u0001\u000ei&t\u0017PV8dC\n\u001c\u0016N_3\u0002#QLg.\u001f+pa&\u001c7/Q:BeJ\f\u00170F\u0001A!\ry\u0013iQ\u0005\u0003\u0005B\u0012Q!\u0011:sCf\u00042aL!E!\tyS)\u0003\u0002Ga\t1Ai\\;cY\u0016\f!\u0002^5osR{\u0007/[2t+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0014\u0003\u0019a\u0017N\\1mO&\u0011aj\u0013\u0002\u0007\u001b\u0006$(/\u001b=\u0002)QLg.\u001f+pa&\u001cG)Z:de&\u0004H/[8o+\u0005\t\u0006cA\u0018B%B!qfU+D\u0013\t!\u0006G\u0001\u0004UkBdWM\r\t\u0004_\u0005S\u0014A\u0003;j]f\u001cuN\u001d9vgV\t\u0001\fE\u00020\u0003f\u0003BaL*[;B\u0011qfW\u0005\u00039B\u0012A\u0001T8oOB\u0011!JX\u0005\u0003?.\u0013aAV3di>\u0014\u0018AD4fi:{g.R7qif$un\u0019\u000b\u00031\nDQaY\u0006A\u0002a\u000baaY8saV\u001c\u0018a\u0002;ps\u0012\u000bG/Y\u0001\fU\u00064\u0018\rV8z\t\u0006$\u0018-F\u0001h!\rAGN\\\u0007\u0002S*\u0011AE\u001b\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0017NA\u0005BeJ\f\u0017\u0010T5tiB!qfU8^!\t\u00018/D\u0001r\u0015\t\u0011(.\u0001\u0003mC:<\u0017B\u0001/r\u0003!!x._'pI\u0016dW#\u0001<\u0011\u0005):\u0018B\u0001=\u0012\u00055aunY1m\u0019\u0012\u000bUj\u001c3fY\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Y\bC\u00019}\u0013\ti\u0018O\u0001\u0004PE*,7\r\u001e")
public class LDASuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LocalLDAModel toyModel() {
        return LDASuite$.MODULE$.toyModel();
    }

    public static ArrayList<Tuple2<Long, Vector>> javaToyData() {
        return LDASuite$.MODULE$.javaToyData();
    }

    public static Tuple2<Object, Vector>[] toyData() {
        return LDASuite$.MODULE$.toyData();
    }

    public static Tuple2<Object, Vector>[] getNonEmptyDoc(Tuple2<Object, Vector>[] tuple2Array) {
        return LDASuite$.MODULE$.getNonEmptyDoc(tuple2Array);
    }

    public static Tuple2<Object, Vector>[] tinyCorpus() {
        return LDASuite$.MODULE$.tinyCorpus();
    }

    public static Tuple2<int[], double[]>[] tinyTopicDescription() {
        return LDASuite$.MODULE$.tinyTopicDescription();
    }

    public static Matrix tinyTopics() {
        return LDASuite$.MODULE$.tinyTopics();
    }

    public static double[][] tinyTopicsAsArray() {
        return LDASuite$.MODULE$.tinyTopicsAsArray();
    }

    public static int tinyVocabSize() {
        return LDASuite$.MODULE$.tinyVocabSize();
    }

    public static int tinyK() {
        return LDASuite$.MODULE$.tinyK();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        LDASuite lDASuite = this;
        synchronized (lDASuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$18(int topic$1, Tuple2 x$5) {
        return -((Vector)x$5._2()).apply(topic$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$17(Tuple2[] topicDistributions$1, int n$1, int topic) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicDistributions$1)).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LDASuite.$anonfun$new$18(topic, x$5)), (Ordering)Ordering.Double$.MODULE$))).take(n$1))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Vector.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long[] doc = (long[])tuple2._1();
        Vector[] docWeights = (Vector[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)doc, (Object)docWeights);
        Tuple2 tuple23 = tuple22;
        long[] doc2 = (long[])tuple23._1();
        Vector[] docWeights2 = (Vector[])tuple23._2();
        return new Tuple2(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(doc2)).toArray(ClassTag$.MODULE$.Long()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])docWeights2)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)x$7.apply(topic)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ Tuple2[] $anonfun$new$16(int k$1, Tuple2[] topicDistributions$1, int n) {
        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, k$1).map((Function1 & Serializable & scala.Serializable)topic -> LDASuite.$anonfun$new$17(topicDistributions$1, n, BoxesRunTime.unboxToInt((Object)topic)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private static final Tuple2[] docs$1(int vocabSize$1) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(vocabSize$1, new int[]{0, 1, 2}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(vocabSize$1, new int[]{3, 4, 5}, new double[]{1.0, 1.0, 1.0})})).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector wordCounts = (Vector)tuple2._1();
            int docId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ boolean $anonfun$new$45(Tuple2 t) {
        return t._2$mcD$sp() < 0.1;
    }

    public static final /* synthetic */ boolean $anonfun$new$60(Tuple2 x0$18) {
        Tuple2 tuple2 = x0$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double p = tuple2._2$mcD$sp();
        boolean bl = TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.167).absTol(0.05));
        return bl;
    }

    public LDASuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("LocalLDAModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLDAModel model = new LocalLDAModel(LDASuite$.MODULE$.tinyTopics(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(LDASuite$.MODULE$.tinyTopics().numRows(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)LDASuite$.MODULE$.tinyTopics().numRows(), ClassTag$.MODULE$.Double())), 1.0, 100.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.k()));
            int $org_scalatest_assert_macro_right = LDASuite$.MODULE$.tinyK();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
            int $org_scalatest_assert_macro_right2 = LDASuite$.MODULE$.tinyVocabSize();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(model.topicsMatrix());
            Matrix $org_scalatest_assert_macro_right3 = LDASuite$.MODULE$.tinyTopics();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Tuple2[] fullTopicSummary = model.describeTopics();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fullTopicSummary.length));
            int $org_scalatest_assert_macro_right4 = LDASuite$.MODULE$.tinyK();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullTopicSummary)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyTopicDescription()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double[] algTermWeights;
                int[] algTerms;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        algTerms = (int[])tuple23._1();
                        algTermWeights = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(algTerms);
                int[] $org_scalatest_assert_macro_right = terms;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(algTermWeights);
                double[] $org_scalatest_assert_macro_right2 = termWeights;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
                return assertion;
            });
            int smallNumTerms = 3;
            Tuple2[] smallTopicSummary = model.describeTopics(smallNumTerms);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])smallTopicSummary)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyTopicDescription()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                double[] algTermWeights;
                int[] algTerms;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        algTerms = (int[])tuple23._1();
                        algTermWeights = (double[])tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(algTerms);
                int[] $org_scalatest_assert_macro_right = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms)).slice(0, smallNumTerms);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(algTermWeights);
                double[] $org_scalatest_assert_macro_right2 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights)).slice(0, smallNumTerms);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                return assertion;
            });
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("running and DistributedLDAModel with default Optimizer (EM)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int k = 3;
            double topicSmoothing = 1.2;
            double termSmoothing = 1.2;
            LDA lda = new LDA();
            lda.setK(k).setOptimizer((LDAOptimizer)new EMLDAOptimizer()).setDocConcentration(topicSmoothing).setTopicConcentration(termSmoothing).setMaxIterations(5).setSeed(12345L);
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            DistributedLDAModel model = (DistributedLDAModel)lda.run(corpus);
            LocalLDAModel localModel = model.toLocal();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.k()));
            int $org_scalatest_assert_macro_right = k;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)localModel.k()));
            int $org_scalatest_assert_macro_right2 = k;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
            int $org_scalatest_assert_macro_right3 = LDASuite$.MODULE$.tinyVocabSize();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)localModel.vocabSize()));
            int $org_scalatest_assert_macro_right4 = LDASuite$.MODULE$.tinyVocabSize();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(model.topicsMatrix());
            Matrix $org_scalatest_assert_macro_right5 = localModel.topicsMatrix();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Vector[] topicSummary = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.describeTopics())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                Vector vector = Vectors$.MODULE$.sparse(LDASuite$.MODULE$.tinyVocabSize(), terms, termWeights);
                return vector;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$);
            Vector[] localTopicSummary = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localModel.describeTopics())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                Vector vector = Vectors$.MODULE$.sparse(LDASuite$.MODULE$.tinyVocabSize(), terms, termWeights);
                return vector;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), (Ordering)Ordering.String$.MODULE$);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicSummary)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])localTopicSummary), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector topics = (Vector)tuple2._1();
                Vector topicsLocal = (Vector)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topics).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(topicsLocal).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topics).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topicsLocal).absTol(0.01))", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                return assertion;
            });
            Tuple2[] topicDistributions = (Tuple2[])model.topicDistributions().collect();
            Tuple2<Object, Vector>[] nonEmptyTinyCorpus = LDASuite$.MODULE$.getNonEmptyDoc(LDASuite$.MODULE$.tinyCorpus());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)topicDistributions.length));
            int $org_scalatest_assert_macro_right6 = nonEmptyTinyCorpus.length;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyTinyCorpus)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._1$mcJ$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet());
            Set $org_scalatest_assert_macro_right7 = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicDistributions)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._1$mcJ$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicDistributions)).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector topicDistribution = (Vector)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)topicDistribution.size()));
                int $org_scalatest_assert_macro_right = LDASuite$.MODULE$.tinyK();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(topicDistribution.toArray())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(topicDistribution.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                return assertion;
            });
            RDD top2TopicsPerDoc = model.topTopicsPerDocument(2).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._1(), (Object)new Tuple2(t._2(), t._3())), ClassTag$.MODULE$.apply(Tuple2.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(model.topicDistributions(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).join(top2TopicsPerDoc).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2;
                Vector topicDistribution;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        Tuple2 tuple23;
                        tuple22 = x0$7;
                        if (tuple22 == null || (tuple23 = (Tuple2)tuple22._2()) == null) break block2;
                        topicDistribution = (Vector)tuple23._1();
                        tuple2 = (Tuple2)tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int[] indices = (int[])tuple2._1();
                double[] weights = (double[])tuple2._2();
                int[] $org_scalatest_assert_macro_left = indices;
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                double[] $org_scalatest_assert_macro_left2 = weights;
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                breeze.linalg.Vector bdvTopicDist = topicDistribution.asBreeze();
                IndexedSeq top2Indices = (IndexedSeq)argtopk$.MODULE$.apply((Object)bdvTopicDist, (Object)BoxesRunTime.boxToInteger((int)2), argtopk$.MODULE$.argtopkWithQT(Predef$.MODULE$.$conforms(), (Ordering)Ordering.Double$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(top2Indices.toSet());
                Set $org_scalatest_assert_macro_right3 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).toSet();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((breeze.linalg.Vector)bdvTopicDist.apply((Object)top2Indices, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()))).toSet());
                Set $org_scalatest_assert_macro_right4 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).toSet();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                return assertion;
            });
            double $org_scalatest_assert_macro_left8 = model.logLikelihood();
            double $org_scalatest_assert_macro_right8 = 0.0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            double $org_scalatest_assert_macro_left9 = model.logPrior();
            double $org_scalatest_assert_macro_right9 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 < $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Function1 & Serializable & scala.Serializable topDocsByTopicDistributions = (Function1 & Serializable & scala.Serializable)n -> LDASuite.$anonfun$new$16(k, topicDistributions, BoxesRunTime.unboxToInt((Object)n));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.topDocumentsPerTopic(3))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])topDocsByTopicDistributions.apply((Object)BoxesRunTime.boxToInteger((int)3))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 t1 = (Tuple2)tuple2._1();
                Tuple2 t2 = (Tuple2)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1._1());
                long[] $org_scalatest_assert_macro_right = (long[])t2._1();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t1._2());
                double[] $org_scalatest_assert_macro_right2 = (double[])t2._2();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                return assertion;
            });
            int q = LDASuite$.MODULE$.tinyCorpus().length;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.topDocumentsPerTopic(q))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])topDocsByTopicDistributions.apply((Object)BoxesRunTime.boxToInteger((int)q))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 t1 = (Tuple2)tuple2._1();
                Tuple2 t2 = (Tuple2)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(t1._1());
                long[] $org_scalatest_assert_macro_right = (long[])t2._1();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(t1._2());
                double[] $org_scalatest_assert_macro_right2 = (double[])t2._2();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                return assertion;
            });
            Map topTopicAssignments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.topicAssignments().collect())).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)new Tuple2(x._2(), x._3())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            long $org_scalatest_assert_macro_left10 = BoxesRunTime.unboxToLong((Object)topTopicAssignments.keys().max((Ordering)Ordering.Long$.MODULE$));
            int $org_scalatest_assert_macro_right10 = LDASuite$.MODULE$.tinyCorpus().length;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left10), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 < (long)$org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LDASuite$.MODULE$.tinyCorpus())).foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Assertion assertion;
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                long docID = tuple2._1$mcJ$sp();
                Vector doc = (Vector)tuple2._2();
                long l = docID;
                if (doc == null) throw new MatchError((Object)tuple2);
                Vector vector = doc;
                if (topTopicAssignments.contains((Object)BoxesRunTime.boxToLong((long)l))) {
                    Tuple2 tuple22 = (Tuple2)topTopicAssignments.apply((Object)BoxesRunTime.boxToLong((long)l));
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    int[] inds = (int[])tuple22._1();
                    int[] vals = (int[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)inds, (Object)vals);
                    Tuple2 tuple24 = tuple23;
                    int[] inds2 = (int[])tuple24._1();
                    int[] vals2 = (int[])tuple24._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)inds2.length));
                    int $org_scalatest_assert_macro_right = vector.numNonzeros();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                    vector.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(term, wcnt) -> {
                        Bool bool;
                        int $org_scalatest_assert_macro_right;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)wcnt));
                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 0)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        if ($org_scalatest_assert_macro_left2.value()) {
                            bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                        } else {
                            int[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.intArrayOps(inds2);
                            int $org_scalatest_assert_macro_right2 = term;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofInt($org_scalatest_assert_macro_left3), "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), new ArrayOps.ofInt($org_scalatest_assert_macro_left3).contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                        }
                        Bool $org_scalatest_assert_macro_right3 = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                    });
                    assertion = BoxedUnit.UNIT;
                    return assertion;
                } else {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vector.numNonzeros()));
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                }
                return assertion;
            });
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("vertex indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int[] docIds;
            int[] docVertexIds = docIds = new int[]{0, 1, 2};
            int[] termIds = new int[]{0, 1, 2};
            int[] termVertexIds = new int[]{-1, -2, -3};
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(docVertexIds)).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !LDA$.MODULE$.isTermVertex((Tuple2)new Tuple2.mcJI.sp((long)i, 0))), "scala.Predef.intArrayOps(docVertexIds).forall(((i: Int) => LDA.isTermVertex(scala.Tuple2.apply[Long, Int](i.toLong, 0)).unary_!))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(termIds)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)term -> LDA$.MODULE$.term2index(term), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())));
            int[] $org_scalatest_assert_macro_right = termVertexIds;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(termVertexIds)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> LDA$.MODULE$.index2term((long)i), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            int[] $org_scalatest_assert_macro_right2 = termIds;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(termVertexIds)).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> LDA$.MODULE$.isTermVertex((Tuple2)new Tuple2.mcJI.sp((long)i, 0))), "scala.Predef.intArrayOps(termVertexIds).forall(((i: Int) => LDA.isTermVertex(scala.Tuple2.apply[Long, Int](i.toLong, 0))))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("setter alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LDA lda = new LDA().setAlpha(2.0).setBeta(3.0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lda.getAsymmetricAlpha().toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$9 -> this.convertToEqualizer(BoxesRunTime.boxToDouble((double)x$9)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default())), "scala.Predef.doubleArrayOps(lda.getAsymmetricAlpha.toArray).forall(((x$9: Double) => LDASuite.this.convertToEqualizer[Double](x$9).===(2.0)(scalactic.this.Equality.default[Double])))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lda.getAsymmetricDocConcentration().toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$10 -> this.convertToEqualizer(BoxesRunTime.boxToDouble((double)x$10)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default())), "scala.Predef.doubleArrayOps(lda.getAsymmetricDocConcentration.toArray).forall(((x$10: Double) => LDASuite.this.convertToEqualizer[Double](x$10).===(2.0)(scalactic.this.Equality.default[Double])))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)lda.getBeta()));
            double $org_scalatest_assert_macro_right = 3.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)lda.getTopicConcentration()));
            double $org_scalatest_assert_macro_right2 = 3.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("initializing with alpha length != k or 1 fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            LDA lda = new LDA().setK(2).setAlpha(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0})));
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            return lda.run(corpus);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190)), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("initializing with elements in alpha < 0 fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            LDA lda = new LDA().setK(4).setAlpha(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0})));
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            return lda.run(corpus);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198)), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("OnlineLDAOptimizer initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LDA lda = new LDA().setK(2);
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer().initialize(corpus, lda);
            op.setKappa(0.9876).setMiniBatchFraction(0.123).setTau0(567.0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(op.getAlpha().toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$11 -> this.convertToEqualizer(BoxesRunTime.boxToDouble((double)x$11)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.5), Equality$.MODULE$.default())), "scala.Predef.doubleArrayOps(op.getAlpha.toArray).forall(((x$11: Double) => LDASuite.this.convertToEqualizer[Double](x$11).===(0.5)(scalactic.this.Equality.default[Double])))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getEta()));
            double $org_scalatest_assert_macro_right = 0.5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getKappa()));
            double $org_scalatest_assert_macro_right2 = 0.9876;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getMiniBatchFraction()));
            double $org_scalatest_assert_macro_right3 = 0.123;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getTau0()));
            int $org_scalatest_assert_macro_right4 = 567;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("OnlineLDAOptimizer one iteration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int k = 2;
            int vocabSize = 6;
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite.docs$1(vocabSize)), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer().setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E40).setMiniBatchFraction(1.0);
            LDA lda = new LDA().setK(k).setMaxIterations(1).setOptimizer((LDAOptimizer)op).setSeed(12345L);
            OnlineLDAOptimizer state = op.initialize(corpus, lda);
            op.setLambda((DenseMatrix)new DenseMatrix.mcD.sp(k, vocabSize, new double[]{1.1, 0.9, 1.2, 0.8, 1.3, 0.7, 0.9, 1.1, 0.8, 1.2, 0.7, 1.3}));
            state.submitMiniBatch(corpus);
            Vector topic1 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)((ImmutableNumericOps)op.getLambda().apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()));
            Vector topic2 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)((ImmutableNumericOps)op.getLambda().apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()));
            Vector expectedTopic1 = Vectors$.MODULE$.dense(1.1101, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2076, 1.305, 0.8899, 0.7924, 0.695}));
            Vector expectedTopic2 = Vectors$.MODULE$.dense(0.8899, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.7924, 0.695, 1.1101, 1.2076, 1.305}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topic1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedTopic1).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topic1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expectedTopic1).absTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topic2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedTopic2).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topic2).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expectedTopic2).absTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("OnlineLDAOptimizer with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
            int x$2 = qual$1.parallelize$default$2();
            RDD docs = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E10);
            LDA lda = new LDA().setK(2).setDocConcentration(0.01).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
            LDAModel ldaModel = lda.run(docs);
            Tuple2[] topicIndices = ldaModel.describeTopics(10);
            Tuple2[][] topics = (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicIndices)).map((Function1 & Serializable & scala.Serializable)x0$11 -> {
                Tuple2 tuple2 = x0$11;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                Tuple2[] tuple2Array = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                return tuple2Array;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                Bool bool;
                double[] smalls;
                double[] $org_scalatest_assert_macro_left = smalls = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topic)).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)LDASuite.$anonfun$new$45(t))))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(smalls)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    double $org_scalatest_assert_macro_right2 = 0.2;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            });
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("LocalLDAModel logLikelihood", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(6, new int[]{0}, new double[]{1.0})})).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$12 -> {
                Tuple2 tuple2 = x0$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector wordCounts = (Vector)tuple2._1();
                int docId = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
            int x$4 = qual$2.parallelize$default$2();
            RDD docsSingleWord = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(6, new int[]{0}, new double[]{5.0})})).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$13 -> {
                Tuple2 tuple2 = x0$13;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector wordCounts = (Vector)tuple2._1();
                int docId = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
            int x$6 = qual$3.parallelize$default$2();
            RDD docsRepeatedWord = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsSingleWord)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-25.971).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsSingleWord)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-25.971).relTol(0.001))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsRepeatedWord)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-31.441).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsRepeatedWord)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-31.441).relTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("LocalLDAModel logPerplexity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$4 = this.sc();
            WrappedArray x$7 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
            int x$8 = qual$4.parallelize$default$2();
            RDD docs = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(Tuple2.class));
            LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logPerplexity(docs)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(3.69).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logPerplexity(docs)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(3.69).relTol(0.001))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("LocalLDAModel predict", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
            int x$10 = qual$5.parallelize$default$2();
            RDD docs = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class));
            LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
            .colon.colon expectedPredictions = new .colon.colon((Object)new Tuple2.mcID.sp(0, 0.99504), (List)new .colon.colon((Object)new Tuple2.mcID.sp(0, 0.99504), (List)new .colon.colon((Object)new Tuple2.mcID.sp(0, 0.99504), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.99504), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.99504), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 0.99504), (List)Nil$.MODULE$))))));
            RDD actualPredictions = ldaModel.topicDistributions(docs).cache();
            OrderedRDDFunctions qual$6 = RDD$.MODULE$.rddToOrderedRDDFunctions(actualPredictions.map((Function1 & Serializable & scala.Serializable)x0$14 -> {
                Tuple2 tuple2 = x0$14;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long id = tuple2._1$mcJ$sp();
                Vector topics = (Vector)tuple2._2();
                DenseVector topicsBz = topics.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)argmax$.MODULE$.apply((Object)topicsBz, argmax$.MODULE$.reduce_Double(DenseVector$.MODULE$.canTraverseKeyValuePairs()))), BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)topicsBz, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())))));
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class));
            boolean x$11 = qual$6.sortByKey$default$1();
            int x$12 = qual$6.sortByKey$default$2();
            Tuple2[] topTopics = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(qual$6.sortByKey(x$11, x$12), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).values().collect();
            ((List)expectedPredictions.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])topTopics), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$15 -> {
                int $org_scalatest_assert_macro_right;
                Tuple2 tuple2 = x0$15;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 expected = (Tuple2)tuple2._1();
                Tuple2 actual = (Tuple2)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected._1$mcI$sp()));
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = actual._1$mcI$sp())), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(expected._2$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(actual._2$mcD$sp()).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(expected._2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(actual._2).relTol(0.001))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
                return assertion;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])docs.collect())).map((Function1 & Serializable & scala.Serializable)doc -> ldaModel.topicDistribution((Vector)doc._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])actualPredictions.map((Function1 & Serializable & scala.Serializable)x$13 -> (Vector)x$13._2(), ClassTag$.MODULE$.apply(Vector.class)).collect()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$16 -> {
                Tuple2 tuple2 = x0$16;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector single = (Vector)tuple2._1();
                Vector batch = (Vector)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(single).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(batch).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(single).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(batch).relTol(0.001))", Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
                return assertion;
            });
            return actualPredictions.unpersist(actualPredictions.unpersist$default$1());
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("OnlineLDAOptimizer with asymmetric prior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$7 = this.sc();
            WrappedArray x$13 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
            int x$14 = qual$7.parallelize$default$2();
            RDD docs = qual$7.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E10);
            LDA lda = new LDA().setK(2).setDocConcentration(Vectors$.MODULE$.dense(1.0E-5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1}))).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
            LDAModel ldaModel = lda.run(docs);
            Tuple2[] topicIndices = ldaModel.describeTopics(10);
            Tuple2[][] topics = (Tuple2[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicIndices)).map((Function1 & Serializable & scala.Serializable)x0$17 -> {
                Tuple2 tuple2 = x0$17;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] terms = (int[])tuple2._1();
                double[] termWeights = (double[])tuple2._2();
                Tuple2[] tuple2Array = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                return tuple2Array;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topic)).forall((Function1 & Serializable & scala.Serializable)x0$18 -> BoxesRunTime.boxToBoolean((boolean)LDASuite.$anonfun$new$60(x0$18))), "scala.Predef.refArrayOps[(Int, Double)](topic).forall(((x0$18: (Int, Double)) => x0$18 match {\n  case (_1: Int, _2: Double)(Int, Double)(_, (p @ _)) => org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.167).absTol(0.05))\n}))", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            });
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("OnlineLDAOptimizer alpha hyperparameter optimization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int k = 2;
            SparkContext qual$8 = this.sc();
            WrappedArray x$15 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
            int x$16 = qual$8.parallelize$default$2();
            RDD docs = qual$8.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(100.0).setOptimizeDocConcentration(true).setSampleWithReplacement(false);
            LDA lda = new LDA().setK(k).setDocConcentration(1.0 / (double)k).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
            LocalLDAModel ldaModel = (LocalLDAModel)lda.run(docs);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(ldaModel.docConcentration()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.42582646, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.43511073}))).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(ldaModel.docConcentration).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.42582646, 0.43511073)).absTol(0.05))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            LocalLDAModel localModel = new LocalLDAModel(LDASuite$.MODULE$.tinyTopics(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(LDASuite$.MODULE$.tinyTopics().numRows(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.01, ClassTag$.MODULE$.Double())), 0.5, 10.0);
            File tempDir1 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path1 = tempDir1.toURI().toString();
            int k = 3;
            double docConcentration = 1.2;
            double topicConcentration = 1.5;
            LDA lda = new LDA();
            lda.setK(k).setDocConcentration(docConcentration).setTopicConcentration(topicConcentration).setMaxIterations(5).setSeed(12345L);
            RDD corpus = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            DistributedLDAModel distributedModel = (DistributedLDAModel)lda.run(corpus);
            File tempDir2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path2 = tempDir2.toURI().toString();
            try {
                localModel.save(this.sc(), path1);
                distributedModel.save(this.sc(), path2);
                LocalLDAModel samelocalModel = LocalLDAModel$.MODULE$.load(this.sc(), path1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(samelocalModel.topicsMatrix());
                Matrix $org_scalatest_assert_macro_right = localModel.topicsMatrix();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)samelocalModel.k()));
                int $org_scalatest_assert_macro_right2 = localModel.k();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)samelocalModel.vocabSize()));
                int $org_scalatest_assert_macro_right3 = localModel.vocabSize();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(samelocalModel.docConcentration());
                Vector $org_scalatest_assert_macro_right4 = localModel.docConcentration();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)samelocalModel.topicConcentration()));
                double $org_scalatest_assert_macro_right5 = localModel.topicConcentration();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)samelocalModel.gammaShape()));
                double $org_scalatest_assert_macro_right6 = localModel.gammaShape();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
                DistributedLDAModel sameDistributedModel = DistributedLDAModel$.MODULE$.load(this.sc(), path2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(distributedModel.topicsMatrix());
                Matrix $org_scalatest_assert_macro_right7 = sameDistributedModel.topicsMatrix();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)distributedModel.k()));
                int $org_scalatest_assert_macro_right8 = sameDistributedModel.k();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)distributedModel.vocabSize()));
                int $org_scalatest_assert_macro_right9 = sameDistributedModel.vocabSize();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(distributedModel.iterationTimes());
                double[] $org_scalatest_assert_macro_right10 = sameDistributedModel.iterationTimes();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(distributedModel.docConcentration());
                Vector $org_scalatest_assert_macro_right11 = sameDistributedModel.docConcentration();
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)distributedModel.topicConcentration()));
                double $org_scalatest_assert_macro_right12 = sameDistributedModel.topicConcentration();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)distributedModel.gammaShape()));
                double $org_scalatest_assert_macro_right13 = sameDistributedModel.gammaShape();
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(distributedModel.globalTopicTotals());
                DenseVector $org_scalatest_assert_macro_right14 = sameDistributedModel.globalTopicTotals();
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(distributedModel.logLikelihood()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sameDistributedModel.logLikelihood()).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(distributedModel.logLikelihood).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sameDistributedModel.logLikelihood).absTol(1.0E-6))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(distributedModel.logPrior()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sameDistributedModel.logPrior()).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(distributedModel.logPrior).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sameDistributedModel.logPrior).absTol(1.0E-6))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
                Graph graph = distributedModel.graph();
                Graph sameGraph = sameDistributedModel.graph();
                OrderedRDDFunctions qual$9 = RDD$.MODULE$.rddToOrderedRDDFunctions((RDD)graph.vertices(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class));
                boolean x$17 = qual$9.sortByKey$default$1();
                int x$18 = qual$9.sortByKey$default$2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(qual$9.sortByKey(x$17, x$18).collect());
                OrderedRDDFunctions qual$10 = RDD$.MODULE$.rddToOrderedRDDFunctions((RDD)sameGraph.vertices(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class));
                boolean x$19 = qual$10.sortByKey$default$1();
                int x$20 = qual$10.sortByKey$default$2();
                Tuple2[] $org_scalatest_assert_macro_right15 = (Tuple2[])qual$10.sortByKey(x$19, x$20).collect();
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
                RDD qual$11 = graph.edges().map((Function1 & Serializable & scala.Serializable)x0$19 -> {
                    Edge edge = x0$19;
                    if (edge == null) {
                        throw new MatchError((Object)edge);
                    }
                    long sid = edge.srcId();
                    long did = edge.dstId();
                    double nos = edge.attr$mcD$sp();
                    long l = sid;
                    long l2 = did;
                    double d = nos;
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToDouble((double)d));
                    return tuple3;
                }, ClassTag$.MODULE$.apply(Tuple3.class));
                Function1 & Serializable & scala.Serializable x$21 = (Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)x._1()), BoxesRunTime.unboxToLong((Object)x._2()));
                boolean x$22 = qual$11.sortBy$default$2();
                int x$23 = qual$11.sortBy$default$3();
                Tuple3[] edge = (Tuple3[])qual$11.sortBy((Function1)x$21, x$22, x$23, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                RDD qual$12 = sameGraph.edges().map((Function1 & Serializable & scala.Serializable)x0$20 -> {
                    Edge edge = x0$20;
                    if (edge == null) {
                        throw new MatchError((Object)edge);
                    }
                    long sid = edge.srcId();
                    long did = edge.dstId();
                    double nos = edge.attr$mcD$sp();
                    long l = sid;
                    long l2 = did;
                    double d = nos;
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToDouble((double)d));
                    return tuple3;
                }, ClassTag$.MODULE$.apply(Tuple3.class));
                Function1 & Serializable & scala.Serializable x$24 = (Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)x._1()), BoxesRunTime.unboxToLong((Object)x._2()));
                boolean x$25 = qual$12.sortBy$default$2();
                int x$26 = qual$12.sortBy$default$3();
                Tuple3[] sameEdge = (Tuple3[])qual$12.sortBy((Function1)x$24, x$25, x$26, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(edge);
                Tuple3[] $org_scalatest_assert_macro_right16 = sameEdge;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir1);
                Utils$.MODULE$.deleteRecursively(tempDir2);
            }
            return assertion;
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("EMLDAOptimizer with empty docs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int vocabSize = 6;
            Vector[] emptyDocsArray = (Vector[])Array$.MODULE$.fill(6, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.sparse(vocabSize, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class));
            Tuple2[] emptyDocs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emptyDocsArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$21 -> {
                Tuple2 tuple2 = x0$21;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector wordCounts = (Vector)tuple2._1();
                int docId = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            RDD distributedEmptyDocs = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])emptyDocs), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            EMLDAOptimizer op = new EMLDAOptimizer();
            LDA lda = new LDA().setK(3).setMaxIterations(5).setSeed(12345L).setOptimizer((LDAOptimizer)op);
            LDAModel model = lda.run(distributedEmptyDocs);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
            int $org_scalatest_assert_macro_right = vocabSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        this.test("OnlineLDAOptimizer with empty docs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int vocabSize = 6;
            Vector[] emptyDocsArray = (Vector[])Array$.MODULE$.fill(6, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.sparse(vocabSize, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class));
            Tuple2[] emptyDocs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emptyDocsArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$22 -> {
                Tuple2 tuple2 = x0$22;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector wordCounts = (Vector)tuple2._1();
                int docId = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            RDD distributedEmptyDocs = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])emptyDocs), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            OnlineLDAOptimizer op = new OnlineLDAOptimizer();
            LDA lda = new LDA().setK(3).setMaxIterations(5).setSeed(12345L).setOptimizer((LDAOptimizer)op);
            LDAModel model = lda.run(distributedEmptyDocs);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
            int $org_scalatest_assert_macro_right = vocabSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        }, new Position("LDASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
    }
}

