/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.StreamingKMeans;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0003\u0006\u0001+!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C!K!IA\u0006\u0001a\u0001\u0002\u0004%\t!\f\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011\u0002\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0018\t\u000be\u0002A\u0011\t\u001e\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f\u001d\u0004\u0011\u0013!C\u0001Q\n!2\u000b\u001e:fC6LgnZ&NK\u0006t7oU;ji\u0016T!a\u0003\u0007\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u000e\u001d\u0005)Q\u000e\u001c7jE*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\ta\"\u0003\u0002\u001a\u001d\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\b\u0002\u0013M$(/Z1nS:<\u0017BA\u0010\u001d\u00055!Vm\u001d;Tk&$XMQ1tK\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011AC\u0001\u0012[\u0006Dx+Y5u)&lW-T5mY&\u001cX#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u0007%sG/A\u0002tg\u000e,\u0012A\f\t\u00037=J!\u0001\r\u000f\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018aB:tG~#S-\u001d\u000b\u0003gY\u0002\"a\n\u001b\n\u0005UB#\u0001B+oSRDqa\u000e\u0003\u0002\u0002\u0003\u0007a&A\u0002yIE\nAa]:dA\u0005i\u0011M\u001a;fe\u001a+hn\u0019;j_:$\u0012aM\u0001\u001d'R\u0014X-Y7j]\u001e\\U*Z1og\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^8s)!id\u000b\u0017.]=\u000e,\u0007\u0003B\u0014?\u0001NK!a\u0010\u0015\u0003\rQ+\b\u000f\\33!\r\t\u0015\n\u0014\b\u0003\u0005\u001es!a\u0011$\u000e\u0003\u0011S!!\u0012\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013B\u0001%)\u0003\u001d\u0001\u0018mY6bO\u0016L!AS&\u0003\u0015%sG-\u001a=fIN+\u0017O\u0003\u0002IQA\u0019\u0011)S'\u0011\u00059\u000bV\"A(\u000b\u0005Ac\u0011A\u00027j]\u0006dw-\u0003\u0002S\u001f\n1a+Z2u_J\u00042a\n+N\u0013\t)\u0006FA\u0003BeJ\f\u0017\u0010C\u0003X\u000f\u0001\u0007a%A\u0005ok6\u0004v.\u001b8ug\")\u0011l\u0002a\u0001M\u0005Qa.^7CCR\u001c\u0007.Z:\t\u000bm;\u0001\u0019\u0001\u0014\u0002\u0003-DQ!X\u0004A\u0002\u0019\n\u0011\u0001\u001a\u0005\u0006?\u001e\u0001\r\u0001Y\u0001\u0002eB\u0011q%Y\u0005\u0003E\"\u0012a\u0001R8vE2,\u0007\"\u00023\b\u0001\u00041\u0013\u0001B:fK\u0012DqAZ\u0004\u0011\u0002\u0003\u00071+A\u0006j]&$8)\u001a8uKJ\u001c\u0018AJ*ue\u0016\fW.\u001b8h\u00176+\u0017M\\:ECR\fw)\u001a8fe\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\t\u0011N\u000b\u0002TU.\n1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003a\"\n!\"\u00198o_R\fG/[8o\u0013\t\u0011XNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class StreamingKMeansSuite
extends SparkFunSuite
implements TestSuiteBase {
    private StreamingContext ssc;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    private String checkpointDir$lzycompute() {
        StreamingKMeansSuite streamingKMeansSuite = this;
        synchronized (streamingKMeansSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public void afterFunction() {
        block0: {
            TestSuiteBase.afterFunction$((TestSuiteBase)this);
            if (this.ssc() == null) break block0;
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
    }

    public Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> StreamingKMeansDataGenerator(int numPoints, int numBatches, int k, int d, double r, int seed, Vector[] initCenters) {
        XORShiftRandom rand = new XORShiftRandom((long)seed);
        Vector[] vectorArray = initCenters;
        Vector[] vectorArray2 = vectorArray == null ? (Vector[])Array$.MODULE$.fill(k, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(d, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Vector.class)) : initCenters;
        Vector[] centers = vectorArray2;
        scala.collection.immutable.IndexedSeq data = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> StreamingKMeansSuite.$anonfun$StreamingKMeansDataGenerator$3(numPoints, centers, k, d, rand, r, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)data, (Object)centers);
    }

    public Vector[] StreamingKMeansDataGenerator$default$7() {
        return null;
    }

    public static final /* synthetic */ Vector $anonfun$StreamingKMeansDataGenerator$4(Vector[] centers$1, int k$1, int d$1, XORShiftRandom rand$1, double r$1, int idx) {
        Vector center = centers$1[idx % k$1];
        return Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(d$1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> center.apply(x) + rand$1.nextGaussian() * r$1, ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ scala.collection.immutable.IndexedSeq $anonfun$StreamingKMeansDataGenerator$3(int numPoints$1, Vector[] centers$1, int k$1, int d$1, XORShiftRandom rand$1, double r$1, int i) {
        return (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPoints$1).map((Function1 & Serializable & scala.Serializable)idx -> StreamingKMeansSuite.$anonfun$StreamingKMeansDataGenerator$4(centers$1, k$1, d$1, rand$1, r$1, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public StreamingKMeansSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("accuracy for single center and equivalence to grand average", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numBatches = 10;
            int numPoints = 50;
            int k = 1;
            int d = 5;
            double r = 0.1;
            StreamingKMeans model = new StreamingKMeans().setK(1).setDecayFactor(1.0).setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}))}), new double[]{0.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, this.StreamingKMeansDataGenerator$default$7());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            IndexedSeq input = (IndexedSeq)tuple2._1();
            Vector[] centers = (Vector[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)input, (Object)centers);
            Tuple2 tuple23 = tuple22;
            IndexedSeq input2 = (IndexedSeq)tuple23._1();
            Vector[] centers2 = (Vector[])tuple23._2();
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(centers2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(centers.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).absTol(0.1))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            breeze.linalg.Vector grandMean = (breeze.linalg.Vector)((ImmutableNumericOps)((TraversableOnce)((TraversableLike)input2.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x -> x.asBreeze(), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (breeze.linalg.Vector)x$2.$plus(x$3, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()))).$div((Object)BoxesRunTime.boxToDouble((double)(numBatches * numPoints)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(grandMean.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(grandMean.toArray((ClassTag.Double: scala.reflect.ClassTag[Double])))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("accuracy for two centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            int numBatches = 10;
            int numPoints = 5;
            int k = 2;
            int d = 5;
            double r = 0.1;
            StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(2.0, "batches").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, -0.2, -0.3, -0.1})), Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.2, 0.0, 0.2, 0.1}))}), new double[]{5.0, 5.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple22 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, this.StreamingKMeansDataGenerator$default$7());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            IndexedSeq input = (IndexedSeq)tuple22._1();
            Vector[] centers = (Vector[])tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)input, (Object)centers);
            Tuple2 tuple24 = tuple23;
            IndexedSeq input2 = (IndexedSeq)tuple24._1();
            Vector[] centers2 = (Vector[])tuple24._2();
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                kMeans.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            double d0 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[0]);
            double d1 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[1]);
            Tuple2 tuple25 = tuple2 = d0 < d1 ? new Tuple2((Object)centers2[0], (Object)centers2[1]) : new Tuple2((Object)centers2[1], (Object)centers2[0]);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector c0 = (Vector)tuple2._1();
            Vector c1 = (Vector)tuple2._2();
            Tuple2 tuple26 = new Tuple2((Object)c0, (Object)c1);
            Tuple2 tuple27 = tuple26;
            Vector c02 = (Vector)tuple27._1();
            Vector c12 = (Vector)tuple27._2();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c02).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c0).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(0)).absTol(0.1))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c12).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[1]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(1)).absTol(0.1))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("detecting dying clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq input;
            int numBatches = 10;
            int numPoints = 5;
            int k = 1;
            int d = 1;
            double r = 1.0;
            StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(0.5, "points").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1000.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}), new double[]{1.0, 1.0});
            Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            IndexedSeq indexedSeq = input = (IndexedSeq)tuple2._1();
            IndexedSeq input2 = indexedSeq;
            this.ssc_$eq(this.setupStreams((Seq)input2, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                kMeans.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(Vector.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            StreamingKMeansModel model = kMeans.latestModel();
            double c0 = model.clusterCenters()[0].apply(0);
            double c1 = model.clusterCenters()[1].apply(0);
            double $org_scalatest_assert_macro_left = c0 * c1;
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should have one positive center and one negative center", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("SPARK-7946 setDecayFactor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamingKMeans kMeans = new StreamingKMeans();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            kMeans.setDecayFactor(2.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
            double $org_scalatest_assert_macro_right2 = 2.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("StreamingKMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
    }
}

