/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.ElementwiseProduct;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\t9R\t\\3nK:$x/[:f!J|G-^2u'VLG/\u001a\u0006\u0003\t\u0015\tqAZ3biV\u0014XM\u0003\u0002\u0007\u000f\u0005)Q\u000e\u001c7jE*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y1\u0003\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001F\f\u000e\u0003UQ!AF\u0003\u0002\tU$\u0018\u000e\\\u0005\u00031U\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0007\u0001")
public class ElementwiseProductSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        ElementwiseProductSuite elementwiseProductSuite = this;
        synchronized (elementwiseProductSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$7(Vector x0$1, Vector x1$1, Vector x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$1, (Object)x1$1, (Object)x2$1);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$10(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public ElementwiseProductSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("elementwise (hadamard) product should properly apply vector to dense data set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector[] denseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 1.9, -9.0}))});
            Vector scalingVec = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5, 0.0, 0.25}));
            ElementwiseProduct transformer = new ElementwiseProduct(scalingVec);
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])denseData);
            int x$2 = qual$1.makeRDD$default$2();
            RDD transformedData = transformer.transform(qual$1.makeRDD((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] transformedVecs = (Vector[])transformedData.collect();
            Vector transformedVec = transformedVecs[0];
            Vector expectedVec = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0, -2.25}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(transformedVec).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedVec).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(transformedVec).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expectedVec).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(39).append("Expected transformed vector ").append(expectedVec).append(" but found ").append(transformedVec).toString(), Prettifier$.MODULE$.default(), new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        }, new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("elementwise (hadamard) product should properly apply vector to sparse data set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector[] sparseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -1.0), new Tuple2.mcID.sp(2, -3.0)})))});
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])sparseData), 3, ClassTag$.MODULE$.apply(Vector.class));
            Vector scalingVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5}));
            ElementwiseProduct transformer = new ElementwiseProduct(scalingVec);
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparseData)).map((Function1 & Serializable & scala.Serializable)vector -> transformer.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data2RDD = transformer.transform(dataRDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)sparseData, (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToBoolean((boolean)ElementwiseProductSuite.$anonfun$new$7(x0$1, x1$1, x2$1))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](sparseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$1: org.apache.spark.mllib.linalg.Vector, x1$1: org.apache.spark.mllib.linalg.Vector, x2$1: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$1, x1$1, x2$1) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after hadamard product", Prettifier$.MODULE$.default(), new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)ElementwiseProductSuite.$anonfun$new$10(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.0), new Tuple2.mcID.sp(2, -1.5)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.0), scala.Tuple2.apply[Int, Double](2, -1.5)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        }, new Position("ElementwiseProductSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }
}

