/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\tA\u0011\n\u0012$Tk&$XM\u0003\u0002\u0005\u000b\u00059a-Z1ukJ,'B\u0001\u0004\b\u0003\u0015iG\u000e\\5c\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0004\u0001=\u0019\u0002C\u0001\t\u0012\u001b\u00059\u0011B\u0001\n\b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011AcF\u0007\u0002+)\u0011a#B\u0001\u0005kRLG.\u0003\u0002\u0019+\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0004\u0001")
public class IDFSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        IDFSuite iDFSuite = this;
        synchronized (iDFSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public IDFSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("idf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int n = 4;
            Seq localTermFrequencies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(n, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(n, new int[]{1}, new double[]{1.0})}));
            int m = localTermFrequencies.size();
            RDD termFrequencies = this.sc().parallelize(localTermFrequencies, 2, ClassTag$.MODULE$.apply(Vector.class));
            IDF idf = new IDF();
            IDFModel model = idf.fit(termFrequencies);
            Vector expected = Vectors$.MODULE$.dense((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(((double)m + 1.0) / ((double)x + 1.0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.idf()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.idf).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-12))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Function1 & Serializable & scala.Serializable assertHelper = (Function1 & Serializable & scala.Serializable)tfidf -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tfidf)).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                SparseVector tfidf0 = (SparseVector)tfidf[0];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(tfidf0.indices());
                int[] $org_scalatest_assert_macro_right2 = new int[]{1, 3};
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf0.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0 * expected.apply(1), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0 * expected.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf0.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0.*(expected.apply(1)), 2.0.*(expected.apply(3)))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
                DenseVector tfidf1 = (DenseVector)tfidf[1];
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf1.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0 * expected.apply(1), 2.0 * expected.apply(2), 3.0 * expected.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf1.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 1.0.*(expected.apply(1)), 2.0.*(expected.apply(2)), 3.0.*(expected.apply(3)))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
                SparseVector tfidf2 = (SparseVector)tfidf[2];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(tfidf2.indices());
                int[] $org_scalatest_assert_macro_right3 = new int[]{1};
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tfidf2.values()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0 * expected.apply(1)).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(tfidf2.values.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0.*(expected.apply(1))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            };
            Vector[] tfidf2 = (Vector[])model.transform(termFrequencies).collect();
            assertHelper.apply((Object)tfidf2);
            Vector[] localTfidf = (Vector[])((TraversableOnce)localTermFrequencies.map((Function1 & Serializable & scala.Serializable)x$1 -> model.transform(x$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Vector.class));
            return (Assertion)assertHelper.apply((Object)localTfidf);
        }, new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("idf minimum document frequency filtering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int n = 4;
            Seq localTermFrequencies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(n, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(n, new int[]{1}, new double[]{1.0})}));
            int m = localTermFrequencies.size();
            RDD termFrequencies = this.sc().parallelize(localTermFrequencies, 2, ClassTag$.MODULE$.apply(Vector.class));
            IDF idf = new IDF(1);
            IDFModel model = idf.fit(termFrequencies);
            Vector expected = Vectors$.MODULE$.dense((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2})).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> x > 0 ? package$.MODULE$.log(((double)m + 1.0) / ((double)x + 1.0)) : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.idf()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.idf).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-12))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Function1 & Serializable & scala.Serializable assertHelper = (Function1 & Serializable & scala.Serializable)tfidf -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tfidf)).size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                SparseVector tfidf0 = (SparseVector)tfidf[0];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(tfidf0.indices());
                int[] $org_scalatest_assert_macro_right2 = new int[]{1, 3};
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf0.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0 * expected.apply(1), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0 * expected.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf0.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0.*(expected.apply(1)), 2.0.*(expected.apply(3)))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                DenseVector tfidf1 = (DenseVector)tfidf[1];
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf1.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0 * expected.apply(1), 2.0 * expected.apply(2), 3.0 * expected.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf1.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 1.0.*(expected.apply(1)), 2.0.*(expected.apply(2)), 3.0.*(expected.apply(3)))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
                SparseVector tfidf2 = (SparseVector)tfidf[2];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(tfidf2.indices());
                int[] $org_scalatest_assert_macro_right3 = new int[]{1};
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tfidf2.values()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0 * expected.apply(1)).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(tfidf2.values.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0.*(expected.apply(1))).absTol(1.0E-12))", Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            };
            Vector[] tfidf2 = (Vector[])model.transform(termFrequencies).collect();
            assertHelper.apply((Object)tfidf2);
            Vector[] localTfidf = (Vector[])((TraversableOnce)localTermFrequencies.map((Function1 & Serializable & scala.Serializable)x$2 -> model.transform(x$2), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Vector.class));
            return (Assertion)assertHelper.apply((Object)localTfidf);
        }, new Position("IDFSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }
}

