/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.mllib.fpm.FPGrowthModel$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\tia\tU$s_^$\bnU;ji\u0016T!\u0001B\u0003\u0002\u0007\u0019\u0004XN\u0003\u0002\u0007\u000f\u0005)Q\u000e\u001c7jE*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y1\u0003\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001F\f\u000e\u0003UQ!AF\u0003\u0002\tU$\u0018\u000e\\\u0005\u00031U\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0007\u0001")
public class FPGrowthSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        FPGrowthSuite fPGrowthSuite = this;
        synchronized (fPGrowthSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$6(AssociationRules.Rule rule) {
        return package$.MODULE$.abs(rule.confidence() - 1.0) < 1.0E-6;
    }

    public static final /* synthetic */ int $anonfun$new$9(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ int $anonfun$new$17(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
    }

    public FPGrowthSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("FP-Growth using String type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq transactions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r z h k p", "z y x w v u t s", "s x o n r", "x z y m t s q e", "z", "x z y r q t p"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split(" "), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(transactions, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).cache();
            FPGrowth fpg = new FPGrowth();
            FPGrowthModel model6 = fpg.setMinSupport(0.9).setNumPartitions(1).run(rdd, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model6.freqItemsets().count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            FPGrowthModel model3 = fpg.setMinSupport(0.5).setNumPartitions(2).run(rdd, ClassTag$.MODULE$.apply(String.class));
            Tuple2[] freqItemsets3 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model3.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])itemset.items())).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"z"})), (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"})), (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "y"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "x"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s", "x"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "x"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y", "x", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "x", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "y", "z"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "y", "x"})), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "y", "x", "z"})), (Object)BoxesRunTime.boxToLong((long)3L))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsets3)).toSet());
            Set $org_scalatest_assert_macro_right2 = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            FPGrowthModel model2 = fpg.setMinSupport(0.3).setNumPartitions(4).run(rdd, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model2.freqItemsets().count()));
            int $org_scalatest_assert_macro_right3 = 54;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            FPGrowthModel model1 = fpg.setMinSupport(0.1).setNumPartitions(8).run(rdd, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model1.freqItemsets().count()));
            int $org_scalatest_assert_macro_right4 = 625;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("FP-Growth String type association rule generation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq transactions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r z h k p", "z y x w v u t s", "s x o n r", "x z y m t s q e", "z", "x z y r q t p"}))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(" "), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(transactions, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).cache();
            AssociationRules.Rule[] rules = (AssociationRules.Rule[])new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd, ClassTag$.MODULE$.apply(String.class)).generateAssociationRules(0.9).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rules)).size()));
            int $org_scalatest_assert_macro_right = 23;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            int $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rules)).count((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)FPGrowthSuite.$anonfun$new$6(rule)));
            int $org_scalatest_assert_macro_right2 = 23;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("FP-Growth using Int type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq transactions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 2 3", "1 2 3 4", "5 4 3 2 1", "6 5 4 3 2 1", "2 4", "1 3", "1 7"}))).map((Function1 & Serializable & scala.Serializable)x$3 -> (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(" "))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)FPGrowthSuite.$anonfun$new$9(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toArray(ClassTag$.MODULE$.Int()), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(transactions, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).cache();
            FPGrowth fpg = new FPGrowth();
            FPGrowthModel model6 = fpg.setMinSupport(0.9).setNumPartitions(1).run(rdd, ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model6.freqItemsets().count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            FPGrowthModel model3 = fpg.setMinSupport(0.5).setNumPartitions(2).run(rdd, ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((FPGrowth.FreqItemset)model3.freqItemsets().first()).items().getClass());
            Class<?> $org_scalatest_assert_macro_right2 = new int[]{1}.getClass();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"frequent itemsets should use primitive arrays", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            Tuple2[] freqItemsets3 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model3.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])itemset.items())).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)BoxesRunTime.boxToLong((long)6L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)BoxesRunTime.boxToLong((long)4L))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsets3)).toSet());
            Set $org_scalatest_assert_macro_right3 = expected;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            FPGrowthModel model2 = fpg.setMinSupport(0.3).setNumPartitions(4).run(rdd, ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model2.freqItemsets().count()));
            int $org_scalatest_assert_macro_right4 = 15;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            FPGrowthModel model1 = fpg.setMinSupport(0.1).setNumPartitions(8).run(rdd, ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)model1.freqItemsets().count()));
            int $org_scalatest_assert_macro_right5 = 65;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("model save/load with String type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq transactions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r z h k p", "z y x w v u t s", "s x o n r", "x z y m t s q e", "z", "x z y r q t p"}))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.split(" "), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(transactions, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).cache();
            FPGrowthModel model3 = new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd, ClassTag$.MODULE$.apply(String.class));
            Tuple2[] freqItemsets3 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model3.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])itemset.items())).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model3.save(this.sc(), path);
                FPGrowthModel newModel = FPGrowthModel$.MODULE$.load(this.sc(), path);
                Tuple2[] newFreqItemsets = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newModel.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)Predef$.MODULE$.genericArrayOps(itemset.items()).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsets3)).toSet());
                Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFreqItemsets)).toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("model save/load with Int type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq transactions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 2 3", "1 2 3 4", "5 4 3 2 1", "6 5 4 3 2 1", "2 4", "1 3", "1 7"}))).map((Function1 & Serializable & scala.Serializable)x$6 -> (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6.split(" "))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)FPGrowthSuite.$anonfun$new$17(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toArray(ClassTag$.MODULE$.Int()), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(transactions, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).cache();
            FPGrowthModel model3 = new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd, ClassTag$.MODULE$.Int());
            Tuple2[] freqItemsets3 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model3.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])itemset.items())).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model3.save(this.sc(), path);
                FPGrowthModel newModel = FPGrowthModel$.MODULE$.load(this.sc(), path);
                Tuple2[] newFreqItemsets = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newModel.freqItemsets().collect())).map((Function1 & Serializable & scala.Serializable)itemset -> new Tuple2((Object)Predef$.MODULE$.genericArrayOps(itemset.items()).toSet(), (Object)BoxesRunTime.boxToLong((long)itemset.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])freqItemsets3)).toSet());
                Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFreqItemsets)).toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }
}

