/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.GradientDescentSuite$;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Entry;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction2;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u000e\u001d\u0001\u001dBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004E\u0001\u0001\u0006IA\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019Q\u0005\u0001)A\u0005\u000f\"91\n\u0001b\u0001\n\u00031\u0005B\u0002'\u0001A\u0003%q\tC\u0004N\u0001\t\u0007I\u0011\u0001$\t\r9\u0003\u0001\u0015!\u0003H\u0011\u001dy\u0005A1A\u0005\u0002ACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%\tA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000fm\u0003!\u0019!C\u0001{!1A\f\u0001Q\u0001\nyBq!\u0018\u0001C\u0002\u0013\u0005a\t\u0003\u0004_\u0001\u0001\u0006Ia\u0012\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u0019!\u0007\u0001)A\u0005C\"9Q\r\u0001b\u0001\n\u00031\u0007B\u00026\u0001A\u0003%q\rC\u0004l\u0001\t\u0007I\u0011\u00017\t\r}\u0004\u0001\u0015!\u0003n\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0003\u0011)\t\u0019\u0003\u0001EC\u0002\u0013\u0005\u0011Q\u0005\u0002\u000b\u0019\n3uiU*vSR,'BA\u000f\u001f\u00031y\u0007\u000f^5nSj\fG/[8o\u0015\ty\u0002%A\u0003nY2L'M\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0015-eA\u0011\u0011FK\u0007\u0002A%\u00111\u0006\t\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=r\u0012\u0001B;uS2L!!\r\u0018\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yiB\u00111GN\u0007\u0002i)\u0011Q\u0007J\u0001\ng\u000e\fG.\u0019;fgRL!a\u000e\u001b\u0003\u00115\u000bGo\u00195feN\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005m\u0002Q\"\u0001\u000f\u0002\u000f9\u0004v.\u001b8ugV\ta\b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0002J]R\f\u0001B\u001c)pS:$8\u000fI\u0001\u0002\u0003V\tq\t\u0005\u0002@\u0011&\u0011\u0011\n\u0011\u0002\u0007\t>,(\r\\3\u0002\u0005\u0005\u0003\u0013!\u0001\"\u0002\u0005\t\u0003\u0013\u0001C5oSRL\u0017\r\u001c\"\u0002\u0013%t\u0017\u000e^5bY\n\u0003\u0013AD5oSRL\u0017\r\\,fS\u001eDGo]\u000b\u0002#B\u0019qHU$\n\u0005M\u0003%!B!se\u0006L\u0018aD5oSRL\u0017\r\\,fS\u001eDGo\u001d\u0011\u0002\u0011\u001d\u0014\u0018\rZ5f]R,\u0012a\u0016\t\u0003waK!!\u0017\u000f\u0003!1{w-[:uS\u000e<%/\u00193jK:$\u0018!C4sC\u0012LWM\u001c;!\u00039qW/\\\"peJ,7\r^5p]N\fqB\\;n\u0007>\u0014(/Z2uS>t7\u000fI\u0001\u000e[&t\u0017NQ1uG\"4%/Y2\u0002\u001d5Lg.\u001b\"bi\u000eDgI]1dA\u0005i1/[7qY\u0016,\u0006\u000fZ1uKJ,\u0012!\u0019\t\u0003w\tL!a\u0019\u000f\u0003\u001bMKW\u000e\u001d7f+B$\u0017\r^3s\u00039\u0019\u0018.\u001c9mKV\u0003H-\u0019;fe\u0002\n\u0001c]9vCJ,G\r\u0014\u001aVa\u0012\fG/\u001a:\u0016\u0003\u001d\u0004\"a\u000f5\n\u0005%d\"\u0001E*rk\u0006\u0014X\r\u001a'3+B$\u0017\r^3s\u0003E\u0019\u0018/^1sK\u0012d%'\u00169eCR,'\u000fI\u0001\ti\u0016\u001cH\u000fR1uCV\tQ\u000eE\u0002omft!a\u001c;\u000f\u0005A\u001cX\"A9\u000b\u0005I4\u0013A\u0002\u001fs_>$h(C\u0001B\u0013\t)\b)A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(aA*fc*\u0011Q\u000f\u0011\t\u0003uvl\u0011a\u001f\u0006\u0003yz\t!B]3he\u0016\u001c8/[8o\u0013\tq8P\u0001\u0007MC\n,G.\u001a3Q_&tG/A\u0005uKN$H)\u0019;bA\u0005!A-\u0019;b+\t\t)\u0001\u0005\u0004\u0002\b\u00055\u0011qB\u0007\u0003\u0003\u0013Q1!a\u0003A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004o\u0006%\u0001CB \u0002\u0012\u001d\u000b)\"C\u0002\u0002\u0014\u0001\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005ma$\u0001\u0004mS:\fGnZ\u0005\u0005\u0003?\tIB\u0001\u0004WK\u000e$xN]\u0001\u0006I\u0006$\u0018\rI\u0001\bI\u0006$\u0018M\u0015#E+\t\t9\u0003\u0005\u0004\u0002*\u0005=\u0012qB\u0007\u0003\u0003WQ1!!\f!\u0003\r\u0011H\rZ\u0005\u0005\u0003c\tYCA\u0002S\t\u0012\u0003")
public class LBFGSSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private RDD<Tuple2<Object, Vector>> dataRDD;
    private final int nPoints;
    private final double A;
    private final double B;
    private final double initialB;
    private final double[] initialWeights;
    private final LogisticGradient gradient;
    private final int numCorrections;
    private final double miniBatchFrac;
    private final SimpleUpdater simpleUpdater;
    private final SquaredL2Updater squaredL2Updater;
    private final Seq<LabeledPoint> testData;
    private final Seq<Tuple2<Object, Vector>> data;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int nPoints() {
        return this.nPoints;
    }

    public double A() {
        return this.A;
    }

    public double B() {
        return this.B;
    }

    public double initialB() {
        return this.initialB;
    }

    public double[] initialWeights() {
        return this.initialWeights;
    }

    public LogisticGradient gradient() {
        return this.gradient;
    }

    public int numCorrections() {
        return this.numCorrections;
    }

    public double miniBatchFrac() {
        return this.miniBatchFrac;
    }

    public SimpleUpdater simpleUpdater() {
        return this.simpleUpdater;
    }

    public SquaredL2Updater squaredL2Updater() {
        return this.squaredL2Updater;
    }

    public Seq<LabeledPoint> testData() {
        return this.testData;
    }

    public Seq<Tuple2<Object, Vector>> data() {
        return this.data;
    }

    private RDD<Tuple2<Object, Vector>> dataRDD$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize(this.data(), 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                this.bitmap$0 = true;
            }
        }
        return this.dataRDD;
    }

    public RDD<Tuple2<Object, Vector>> dataRDD() {
        return !this.bitmap$0 ? this.dataRDD$lzycompute() : this.dataRDD;
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    private final void testImplicits$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public LBFGSSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.nPoints = 10000;
        this.A = 2.0;
        this.B = -1.5;
        this.initialB = -1.0;
        this.initialWeights = new double[]{this.initialB()};
        this.gradient = new LogisticGradient();
        this.numCorrections = 10;
        this.miniBatchFrac = 1.0;
        this.simpleUpdater = new SimpleUpdater();
        this.squaredL2Updater = new SquaredL2Updater();
        this.testData = GradientDescentSuite$.MODULE$.generateGDInput(this.A(), this.B(), this.nPoints(), 42);
        this.data = (Seq)this.testData().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint == null) {
                throw new MatchError((Object)labeledPoint);
            }
            double label = labeledPoint.label();
            Vector features = labeledPoint.features();
            double d = 1.0;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)label)), (Object)Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        this.test("LBFGS loss should be decreasing and match the result of Gradient Descent.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] lossGD;
            double[] loss;
            boolean regParam = false;
            double d = 1.0;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.initialWeights())).toArray(ClassTag$.MODULE$.Double()))).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double()));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.simpleUpdater(), this.numCorrections(), convergenceTol, numIterations, (double)regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] dArray = loss = (double[])tuple2._2();
            double[] loss2 = dArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)loss2, new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).tail())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs))), (Function2)(JFunction2.mcZDD.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 > x$4), "scala.Predef.tuple2ToZippedOps[Array[Double], Array[Double]](scala.Tuple2.apply[Array[Double], Array[Double]](loss, scala.Predef.doubleArrayOps(loss).tail)).zipped[Double, Array[Double], Double, Array[Double]]({\n  ((xs: Array[Double]) => scala.Predef.doubleArrayOps(xs))\n}, {\n  ((xs: Array[Double]) => scala.Predef.doubleArrayOps(xs))\n}).forall(((x$3: Double, x$4: Double) => x$3.>(x$4)))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"loss should be monotonically decreasing.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            double stepSize = 1.0;
            int numGDIterations = 50;
            Tuple2 tuple22 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.simpleUpdater(), stepSize, numGDIterations, (double)regParam, this.miniBatchFrac(), initialWeightsWithIntercept);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double[] dArray2 = lossGD = (double[])tuple22._2();
            double[] lossGD2 = dArray2;
            double $org_scalatest_assert_macro_left = package$.MODULE$.abs((BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossGD2)).last()) - BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).last())) / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).last()));
            double $org_scalatest_assert_macro_right = 0.02;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"LBFGS should match GD result within 2% difference.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("LBFGS and Gradient Descent with L2 regularization should get the same result.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double regParam = 0.2;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector weightLBFGS = (Vector)tuple2._1();
            double[] lossLBFGS = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weightLBFGS, (Object)lossLBFGS);
            Tuple2 tuple23 = tuple22;
            Vector weightLBFGS2 = (Vector)tuple23._1();
            double[] lossLBFGS2 = (double[])tuple23._2();
            int numGDIterations = 50;
            double stepSize = 1.0;
            Tuple2 tuple24 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), stepSize, numGDIterations, regParam, this.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Vector weightGD = (Vector)tuple24._1();
            double[] lossGD = (double[])tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)weightGD, (Object)lossGD);
            Tuple2 tuple26 = tuple25;
            Vector weightGD2 = (Vector)tuple26._1();
            double[] lossGD2 = (double[])tuple26._2();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossGD2[0]).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossLBFGS2[0]).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossGD.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossLBFGS.apply(0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The first losses of LBFGS and GD should be the same.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossGD2)).last())).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossLBFGS2)).last())).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(lossGD).last).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(lossLBFGS).last).relTol(0.02))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The last losses of LBFGS and GD should be within 2% difference.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The weight differences between LBFGS and GD should be within 2%.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("The convergence criteria should work as we expect.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] lossLBFGS3;
            double[] lossLBFGS2;
            double[] lossLBFGS22;
            double[] lossLBFGS1;
            double[] lossLBFGS12;
            double regParam = 0.0;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            int numIterations = 8;
            double convergenceTol = 0.0;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] dArray = lossLBFGS12 = (double[])tuple2._2();
            double[] $org_scalatest_assert_macro_left = lossLBFGS1 = dArray;
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            convergenceTol = 0.1;
            Tuple2 tuple22 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double[] dArray2 = lossLBFGS22 = (double[])tuple22._2();
            double[] $org_scalatest_assert_macro_left2 = lossLBFGS2 = dArray2;
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            double $org_scalatest_assert_macro_left3 = (lossLBFGS2[2] - lossLBFGS2[3]) / lossLBFGS2[2];
            double $org_scalatest_assert_macro_right3 = convergenceTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            convergenceTol = 0.01;
            Tuple2 tuple23 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            double[] dArray3 = lossLBFGS3 = (double[])tuple23._2();
            double[] lossLBFGS32 = dArray3;
            int $org_scalatest_assert_macro_left4 = lossLBFGS32.length;
            int $org_scalatest_assert_macro_right4 = lossLBFGS2.length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            double[] $org_scalatest_assert_macro_left5 = lossLBFGS32;
            int $org_scalatest_assert_macro_right5 = 6;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            double $org_scalatest_assert_macro_left6 = (lossLBFGS32[4] - lossLBFGS32[5]) / lossLBFGS32[4];
            double $org_scalatest_assert_macro_right6 = convergenceTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("Optimize via class LBFGS.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector weightGD;
            double regParam = 0.2;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            LBFGS lbfgsOptimizer = new LBFGS((Gradient)this.gradient(), (Updater)this.squaredL2Updater()).setNumCorrections(this.numCorrections()).setConvergenceTol(convergenceTol).setNumIterations(numIterations).setRegParam(regParam);
            Vector weightLBFGS = lbfgsOptimizer.optimize(this.dataRDD(), initialWeightsWithIntercept);
            int numGDIterations = 50;
            double stepSize = 1.0;
            Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), stepSize, numGDIterations, regParam, this.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector vector = weightGD = (Vector)tuple2._1();
            Vector weightGD2 = vector;
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The weight differences between LBFGS and GD should be within 2%.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("SPARK-18471: LBFGS aggregator on empty partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            boolean regParam = false;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            double convergenceTol = 1.0E-12;
            int numIterations = 1;
            RDD dataWithEmptyPartitions = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            return LBFGS$.MODULE$.runLBFGS(dataWithEmptyPartitions, (Gradient)this.gradient(), (Updater)this.simpleUpdater(), this.numCorrections(), convergenceTol, numIterations, (double)regParam, initialWeightsWithIntercept);
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }
}

