/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport;
import org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport;
import org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExportFactory$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tY\u0002+T'M\u001b>$W\r\\#ya>\u0014HOR1di>\u0014\u0018pU;ji\u0016T!\u0001B\u0003\u0002\r\u0015D\bo\u001c:u\u0015\t1q!\u0001\u0003q[6d'B\u0001\u0005\n\u0003\u0015iG\u000e\\5c\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t1\u0001")
public class PMMLModelExportFactorySuite
extends SparkFunSuite {
    public PMMLModelExportFactorySuite() {
        this.test("PMMLModelExportFactory create KMeansPMMLModelExport when passing a KMeansModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PMMLModelExport modelExport;
            Vector[] clusterCenters = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0}))});
            KMeansModel kmeansModel = new KMeansModel(clusterCenters);
            PMMLModelExport $org_scalatest_assert_macro_left = modelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)kmeansModel);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport", $org_scalatest_assert_macro_left instanceof KMeansPMMLModelExport, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        }, new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("PMMLModelExportFactory create GeneralizedLinearPMMLModelExport when passing a LinearRegressionModel, RidgeRegressionModel or LassoModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PMMLModelExport lassoModelExport;
            PMMLModelExport ridgeModelExport;
            PMMLModelExport linearModelExport;
            Seq linearInput = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 1, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            LinearRegressionModel linearRegressionModel = new LinearRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
            PMMLModelExport $org_scalatest_assert_macro_left = linearModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)linearRegressionModel);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left instanceof GeneralizedLinearPMMLModelExport, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            RidgeRegressionModel ridgeRegressionModel = new RidgeRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
            PMMLModelExport $org_scalatest_assert_macro_left2 = ridgeModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)ridgeRegressionModel);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left2 instanceof GeneralizedLinearPMMLModelExport, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            LassoModel lassoModel = new LassoModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
            PMMLModelExport $org_scalatest_assert_macro_left3 = lassoModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)lassoModel);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport", $org_scalatest_assert_macro_left3 instanceof GeneralizedLinearPMMLModelExport, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("PMMLModelExportFactory create BinaryClassificationPMMLModelExport when passing a LogisticRegressionModel or SVMModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PMMLModelExport svmModelExport;
            PMMLModelExport logisticRegressionModelExport;
            Seq linearInput = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 1, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            LogisticRegressionModel logisticRegressionModel = new LogisticRegressionModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
            PMMLModelExport $org_scalatest_assert_macro_left = logisticRegressionModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)logisticRegressionModel);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport", $org_scalatest_assert_macro_left instanceof BinaryClassificationPMMLModelExport, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            SVMModel svmModel = new SVMModel(((LabeledPoint)linearInput.apply(0)).features(), ((LabeledPoint)linearInput.apply(0)).label());
            PMMLModelExport $org_scalatest_assert_macro_left2 = svmModelExport = PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)svmModel);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport", $org_scalatest_assert_macro_left2 instanceof BinaryClassificationPMMLModelExport, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("PMMLModelExportFactory throw IllegalArgumentException when passing a Multinomial Logistic Regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LogisticRegressionModel multiclassLogisticRegressionModel = new LogisticRegressionModel(Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4})), 1.0, 2, 3);
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> PMMLModelExportFactory$.MODULE$.createPMMLModelExport((Object)multiclassLogisticRegressionModel), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("PMMLModelExportFactory throw IllegalArgumentException when passing an unsupported model", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object invalidModel = new Object();
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> PMMLModelExportFactory$.MODULE$.createPMMLModelExport(invalidModel), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("PMMLModelExportFactorySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }
}

