/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.MockDistro;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.random.UniformGenerator;
import org.apache.spark.mllib.rdd.RandomRDD;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.StatCounter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00154AAB\u0004\u0001%!)1\u0005\u0001C\u0001I!)q\u0005\u0001C\u0001Q!9a\tAI\u0001\n\u00039\u0005\"\u0002*\u0001\t\u0003\u0019\u0006b\u00023\u0001#\u0003%\ta\u0012\u0002\u0010%\u0006tGm\\7S\t\u0012\u001b8+^5uK*\u0011\u0001\"C\u0001\u0007e\u0006tGm\\7\u000b\u0005)Y\u0011!B7mY&\u0014'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M!\u0001aE\f\u001e!\t!R#D\u0001\f\u0013\t12BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00031mi\u0011!\u0007\u0006\u00035%\tA!\u001e;jY&\u0011A$\u0007\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\tq!\u0001\tuKN$x)\u001a8fe\u0006$X\r\u001a*E\tR9\u0011\u0006\f\u001c<\u0001\n#\u0005C\u0001\u0010+\u0013\tYsD\u0001\u0003V]&$\b\"B\u0017\u0003\u0001\u0004q\u0013a\u0001:eIB\u0019q&M\u001a\u000e\u0003AR!!L\u0006\n\u0005I\u0002$a\u0001*E\tB\u0011a\u0004N\u0005\u0003k}\u0011a\u0001R8vE2,\u0007\"B\u001c\u0003\u0001\u0004A\u0014\u0001D3ya\u0016\u001cG/\u001a3TSj,\u0007C\u0001\u0010:\u0013\tQtD\u0001\u0003M_:<\u0007\"\u0002\u001f\u0003\u0001\u0004i\u0014!F3ya\u0016\u001cG/\u001a3Ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003=yJ!aP\u0010\u0003\u0007%sG\u000fC\u0003B\u0005\u0001\u00071'\u0001\u0007fqB,7\r^3e\u001b\u0016\fg\u000eC\u0003D\u0005\u0001\u00071'\u0001\bfqB,7\r^3e'R$G-\u001a<\t\u000f\u0015\u0013\u0001\u0013!a\u0001g\u00059Q\r]:jY>t\u0017A\u0007;fgR<UM\\3sCR,GM\u0015#EI\u0011,g-Y;mi\u00122T#\u0001%+\u0005MJ5&\u0001&\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015!C;oG\",7m[3e\u0015\tyu$\u0001\u0006b]:|G/\u0019;j_:L!!\u0015'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fuKN$x)\u001a8fe\u0006$X\r\u001a,fGR|'O\u0015#E)!IC\u000b\u00180aC\n\u001c\u0007\"B\u0017\u0005\u0001\u0004)\u0006cA\u00182-B\u0011qKW\u0007\u00021*\u0011\u0011,C\u0001\u0007Y&t\u0017\r\\4\n\u0005mC&A\u0002,fGR|'\u000fC\u0003^\t\u0001\u0007\u0001(\u0001\u0007fqB,7\r^3e%><8\u000fC\u0003`\t\u0001\u0007Q(A\bfqB,7\r^3e\u0007>dW/\u001c8t\u0011\u0015aD\u00011\u0001>\u0011\u0015\tE\u00011\u00014\u0011\u0015\u0019E\u00011\u00014\u0011\u001d)E\u0001%AA\u0002M\n\u0001\u0005^3ti\u001e+g.\u001a:bi\u0016$g+Z2u_J\u0014F\t\u0012\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class RandomRDDsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void testGeneratedRDD(RDD<Object> rdd, long expectedSize, int expectedNumPartitions, double expectedMean, double expectedStddev, double epsilon) {
        StatCounter stats = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(rdd).stats();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedSize));
        long $org_scalatest_assert_macro_right = stats.count();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedNumPartitions));
        int $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        double $org_scalatest_assert_macro_left3 = package$.MODULE$.abs(stats.mean() - expectedMean);
        double $org_scalatest_assert_macro_right3 = epsilon;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        double $org_scalatest_assert_macro_left4 = package$.MODULE$.abs(stats.stdev() - expectedStddev);
        double $org_scalatest_assert_macro_right4 = epsilon;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public double testGeneratedRDD$default$6() {
        return 0.01;
    }

    public void testGeneratedVectorRDD(RDD<Vector> rdd, long expectedRows, int expectedColumns, int expectedNumPartitions, double expectedMean, double expectedStddev, double epsilon) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedNumPartitions));
        int $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        ArrayBuffer values = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vector.size()));
            int $org_scalatest_assert_macro_right = expectedColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            return values.$plus$plus$eq((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector.toArray())));
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedRows));
        int $org_scalatest_assert_macro_right2 = values.size() / expectedColumns;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        StatCounter stats = new StatCounter((TraversableOnce)values);
        double $org_scalatest_assert_macro_left3 = package$.MODULE$.abs(stats.mean() - expectedMean);
        double $org_scalatest_assert_macro_right3 = epsilon;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        double $org_scalatest_assert_macro_left4 = package$.MODULE$.abs(stats.stdev() - expectedStddev);
        double $org_scalatest_assert_macro_right4 = epsilon;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    public double testGeneratedVectorRDD$default$7() {
        return 0.01;
    }

    private final void testImplicits$lzycompute$1() {
        RandomRDDsSuite randomRDDsSuite = this;
        synchronized (randomRDDsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$new$4(Partition p) {
        return ((RandomRDDPartition)p).size();
    }

    public static final /* synthetic */ long $anonfun$new$5(long count, Partition part) {
        return count + (long)((RandomRDDPartition)part).size();
    }

    public RandomRDDsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("RandomRDD sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            new .colon.colon((Object)new Tuple2.mcII.sp(10000, 6), (List)new .colon.colon((Object)new Tuple2.mcII.sp(12345, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(1000, 101), (List)Nil$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RandomRDDsSuite.$anonfun$new$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int size = tuple2._1$mcI$sp();
                int numPartitions = tuple2._2$mcI$sp();
                RandomRDD rdd = new RandomRDD(this.sc(), (long)size, numPartitions, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
                int $org_scalatest_assert_macro_right = size;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size()));
                int $org_scalatest_assert_macro_right2 = numPartitions;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                double[] partSizes = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)RandomRDDsSuite.$anonfun$new$4(p)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                StatCounter partStats = new StatCounter((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(partSizes)));
                double $org_scalatest_assert_macro_left3 = partStats.max() - partStats.min();
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 <= (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                return assertion;
            });
            long size = (long)Integer.MAX_VALUE * 100L;
            int numPartitions = 101;
            RandomRDD rdd = new RandomRDD(this.sc(), size, numPartitions, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size()));
            int $org_scalatest_assert_macro_right = numPartitions;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            long count2 = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(count, part) -> BoxesRunTime.boxToLong((long)RandomRDDsSuite.$anonfun$new$5(BoxesRunTime.unboxToLong((Object)count), part))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)count2));
            long $org_scalatest_assert_macro_right2 = size;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new RandomRDD(this.sc(), 0L, 10, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new RandomRDD(this.sc(), 100L, 0, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new RandomRDD(this.sc(), (long)Integer.MAX_VALUE * 100L, 99, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("randomRDD for different distributions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long size = 100000L;
            int numPartitions = 10;
            double logNormalMean = package$.MODULE$.exp(0.5);
            double logNormalStd = package$.MODULE$.sqrt(4.670774270471604);
            double gammaScale = 1.0;
            double gammaShape = 2.0;
            double gammaMean = gammaShape * gammaScale;
            double gammaStd = package$.MODULE$.sqrt(gammaShape * gammaScale * gammaScale);
            double poissonMean = 100.0;
            double exponentialMean = 1.0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seed -> {
                RDD uniform = RandomRDDs$.MODULE$.uniformRDD(this.sc(), size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)uniform, size, numPartitions, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.testGeneratedRDD$default$6());
                RDD normal = RandomRDDs$.MODULE$.normalRDD(this.sc(), size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)normal, size, numPartitions, 0.0, 1.0, this.testGeneratedRDD$default$6());
                RDD logNormal = RandomRDDs$.MODULE$.logNormalRDD(this.sc(), 0.0, 1.0, size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)logNormal, size, numPartitions, logNormalMean, logNormalStd, 0.1);
                RDD poisson = RandomRDDs$.MODULE$.poissonRDD(this.sc(), poissonMean, size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)poisson, size, numPartitions, poissonMean, package$.MODULE$.sqrt(poissonMean), 0.1);
                RDD exponential = RandomRDDs$.MODULE$.exponentialRDD(this.sc(), exponentialMean, size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)exponential, size, numPartitions, exponentialMean, exponentialMean, 0.1);
                RDD gamma = RandomRDDs$.MODULE$.gammaRDD(this.sc(), gammaShape, gammaScale, size, numPartitions, (long)seed);
                this.testGeneratedRDD((RDD<Object>)gamma, size, numPartitions, gammaMean, gammaStd, 0.1);
            });
            RDD random = RandomRDDs$.MODULE$.randomRDD(this.sc(), (RandomDataGenerator)new MockDistro(), 1000L, 1000, 0L, ClassTag$.MODULE$.Double());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])random.collect())).size()));
            int $org_scalatest_assert_macro_right = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])random.collect())).distinct())).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("randomVectorRDD for different distributions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long rows = 1000L;
            int cols = 100;
            int parts = 10;
            double logNormalMean = package$.MODULE$.exp(0.5);
            double logNormalStd = package$.MODULE$.sqrt(4.670774270471604);
            double gammaScale = 1.0;
            double gammaShape = 2.0;
            double gammaMean = gammaShape * gammaScale;
            double gammaStd = package$.MODULE$.sqrt(gammaShape * gammaScale * gammaScale);
            double poissonMean = 100.0;
            double exponentialMean = 1.0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seed -> {
                RDD uniform = RandomRDDs$.MODULE$.uniformVectorRDD(this.sc(), rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)uniform, rows, cols, parts, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.testGeneratedVectorRDD$default$7());
                RDD normal = RandomRDDs$.MODULE$.normalVectorRDD(this.sc(), rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)normal, rows, cols, parts, 0.0, 1.0, this.testGeneratedVectorRDD$default$7());
                RDD logNormal = RandomRDDs$.MODULE$.logNormalVectorRDD(this.sc(), 0.0, 1.0, rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)logNormal, rows, cols, parts, logNormalMean, logNormalStd, 0.1);
                RDD poisson = RandomRDDs$.MODULE$.poissonVectorRDD(this.sc(), poissonMean, rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)poisson, rows, cols, parts, poissonMean, package$.MODULE$.sqrt(poissonMean), 0.1);
                RDD exponential = RandomRDDs$.MODULE$.exponentialVectorRDD(this.sc(), exponentialMean, rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)exponential, rows, cols, parts, exponentialMean, exponentialMean, 0.1);
                RDD gamma = RandomRDDs$.MODULE$.gammaVectorRDD(this.sc(), gammaShape, gammaScale, rows, cols, parts, (long)seed);
                this.testGeneratedVectorRDD((RDD<Vector>)gamma, rows, cols, parts, gammaMean, gammaStd, 0.1);
            });
        }, new Position("RandomRDDsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
    }
}

