/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoModel$;
import org.apache.spark.mllib.regression.LassoSuite$;
import org.apache.spark.mllib.regression.LassoWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u;Q!\u0003\u0006\t\nU1Qa\u0006\u0006\t\naAQAI\u0001\u0005\u0002\rBq\u0001J\u0001C\u0002\u0013\u0005Q\u0005\u0003\u0004*\u0003\u0001\u0006IA\n\u0005\bU\u0005\t\t\u0011\"\u0003,\r\u00119\"\u0002\u0001\u001b\t\u000b\t2A\u0011A \t\u000b\u00053A\u0011\u0001\"\u0002\u00151\u000b7o]8Tk&$XM\u0003\u0002\f\u0019\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u00055q\u0011!B7mY&\u0014'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001A\u0011a#A\u0007\u0002\u0015\tQA*Y:t_N+\u0018\u000e^3\u0014\u0007\u0005Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u00035\u0001J!!I\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005)\u0012!B7pI\u0016dW#\u0001\u0014\u0011\u0005Y9\u0013B\u0001\u0015\u000b\u0005)a\u0015m]:p\u001b>$W\r\\\u0001\u0007[>$W\r\u001c\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005Y\u0006twMC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#AB(cU\u0016\u001cGoE\u0002\u0007ke\u0002\"AN\u001c\u000e\u00039I!\u0001\u000f\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tQT(D\u0001<\u0015\taD\"\u0001\u0003vi&d\u0017B\u0001 <\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR$\u0012\u0001\u0011\t\u0003-\u0019\t!C^1mS\u0012\fG/\u001a)sK\u0012L7\r^5p]R\u00191IR,\u0011\u0005i!\u0015BA#\u001c\u0005\u0011)f.\u001b;\t\u000b\u001dC\u0001\u0019\u0001%\u0002\u0017A\u0014X\rZ5di&|gn\u001d\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\tiE#\u0001\u0004=e>|GOP\u0005\u00029%\u0011\u0001kG\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001U\u000e\u0011\u0005i)\u0016B\u0001,\u001c\u0005\u0019!u.\u001e2mK\")\u0001\f\u0003a\u00013\u0006)\u0011N\u001c9viB\u0019\u0011*\u0015.\u0011\u0005YY\u0016B\u0001/\u000b\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0001")
public class LassoSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LassoModel model() {
        return LassoSuite$.MODULE$.model();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LassoSuite.$anonfun$validatePrediction$1(x0$1)));
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }

    private final void testImplicits$lzycompute$1() {
        LassoSuite lassoSuite = this;
        synchronized (lassoSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
        return bl;
    }

    public LassoSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Lasso local random SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            int nPoints = 1000;
            double A = 2.0;
            double B = -1.5;
            double C = 0.01;
            Seq testData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint == null) {
                    throw new MatchError((Object)labeledPoint);
                }
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double d = 1.0;
                LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
                return labeledPoint2;
            }, Seq$.MODULE$.canBuildFrom());
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LassoWithSGD ls = new LassoWithSGD();
            ls.optimizer().setStepSize(1.0).setRegParam(0.01).setNumIterations(40);
            LassoModel model = (LassoModel)ls.run(testRDD);
            double weight0 = model.weights().apply(0);
            double weight1 = model.weights().apply(1);
            double weight2 = model.weights().apply(2);
            double $org_scalatest_assert_macro_left = weight0;
            double $org_scalatest_assert_macro_right = 1.9;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = weight0;
                double $org_scalatest_assert_macro_right2 = 2.1;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(18).append(weight0).append(" not in [1.9, 2.1]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            double $org_scalatest_assert_macro_left4 = weight1;
            double $org_scalatest_assert_macro_right4 = -1.6;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = weight1;
                double $org_scalatest_assert_macro_right5 = -1.4;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(20).append(weight1).append(" not in [-1.6, -1.4]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            double $org_scalatest_assert_macro_left7 = weight2;
            double $org_scalatest_assert_macro_right7 = -0.001;
            Bool $org_scalatest_assert_macro_left8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 >= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left8.value()) {
                double $org_scalatest_assert_macro_left9 = weight2;
                double $org_scalatest_assert_macro_right8 = 0.001;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9 <= $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right9 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "&&", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left8.$amp$amp($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(23).append(weight2).append(" not in [-0.001, 0.001]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Seq validationData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                LabeledPoint labeledPoint = x0$2;
                if (labeledPoint == null) {
                    throw new MatchError((Object)labeledPoint);
                }
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double d = 1.0;
                LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
                return labeledPoint2;
            }, Seq$.MODULE$.canBuildFrom());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
        }, new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Lasso local random SGD with initial weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            int nPoints = 1000;
            double A = 2.0;
            double B = -1.5;
            double C = 0.01;
            Seq testData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                LabeledPoint labeledPoint = x0$3;
                if (labeledPoint == null) {
                    throw new MatchError((Object)labeledPoint);
                }
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double d = 1.0;
                LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
                return labeledPoint2;
            }, Seq$.MODULE$.canBuildFrom());
            double initialA = -1.0;
            double initialB = -1.0;
            double initialC = -1.0;
            Vector initialWeights = Vectors$.MODULE$.dense(initialA, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{initialB, initialC}));
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LassoWithSGD ls = new LassoWithSGD();
            ls.optimizer().setStepSize(1.0).setRegParam(0.01).setNumIterations(40).setConvergenceTol(5.0E-4);
            LassoModel model = (LassoModel)ls.run(testRDD, initialWeights);
            double weight0 = model.weights().apply(0);
            double weight1 = model.weights().apply(1);
            double weight2 = model.weights().apply(2);
            double $org_scalatest_assert_macro_left = weight0;
            double $org_scalatest_assert_macro_right = 1.9;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = weight0;
                double $org_scalatest_assert_macro_right2 = 2.1;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(18).append(weight0).append(" not in [1.9, 2.1]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            double $org_scalatest_assert_macro_left4 = weight1;
            double $org_scalatest_assert_macro_right4 = -1.6;
            Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 >= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left5.value()) {
                double $org_scalatest_assert_macro_left6 = weight1;
                double $org_scalatest_assert_macro_right5 = -1.4;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right6 = bool2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(20).append(weight1).append(" not in [-1.6, -1.4]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            double $org_scalatest_assert_macro_left7 = weight2;
            double $org_scalatest_assert_macro_right7 = -0.001;
            Bool $org_scalatest_assert_macro_left8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 >= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left8.value()) {
                double $org_scalatest_assert_macro_left9 = weight2;
                double $org_scalatest_assert_macro_right8 = 0.001;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9 <= $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right9 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "&&", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left8.$amp$amp($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(23).append(weight2).append(" not in [-0.001, 0.001]").toString(), Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            Seq validationData = (Seq)LinearDataGenerator$.MODULE$.generateLinearInput(A, (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{B, C}), ClassTag$.MODULE$.Double()), nPoints, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                LabeledPoint labeledPoint = x0$4;
                if (labeledPoint == null) {
                    throw new MatchError((Object)labeledPoint);
                }
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double d = 1.0;
                LabeledPoint labeledPoint2 = new LabeledPoint(label, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
                return labeledPoint2;
            }, Seq$.MODULE$.canBuildFrom());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
        }, new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            LassoModel model = LassoSuite$.MODULE$.model();
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                LassoModel sameModel = LassoModel$.MODULE$.load(this.sc(), path);
                Vector $org_scalatest_assert_macro_left = model.weights();
                Vector $org_scalatest_assert_macro_right = sameModel.weights();
                Vector vector = $org_scalatest_assert_macro_left;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
                double $org_scalatest_assert_macro_left2 = model.intercept();
                double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("LassoSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }
}

