/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.support.LiteralRow$;
import breeze.storage.Zero;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.Correlations$;
import org.apache.spark.mllib.stat.correlation.PearsonCorrelation$;
import org.apache.spark.mllib.stat.correlation.SpearmanCorrelation$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Q4AAD\b\u00015!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001e\u0001A\u0003%\u0011\u0007C\u0004<\u0001\t\u0007I\u0011\u0001\u0019\t\rq\u0002\u0001\u0015!\u00032\u0011\u001di\u0004A1A\u0005\u0002ABaA\u0010\u0001!\u0002\u0013\t\u0004bB \u0001\u0005\u0004%\t\u0001\u0011\u0005\u0007\u001b\u0002\u0001\u000b\u0011B!\t\u000b9\u0003A\u0011A(\t\u000fe\u0003\u0011\u0013!C\u00015\")Q\r\u0001C\u0001M\"91\u000fAI\u0001\n\u0003Q&\u0001E\"peJ,G.\u0019;j_:\u001cV/\u001b;f\u0015\t\u0001\u0012#\u0001\u0003ti\u0006$(B\u0001\n\u0014\u0003\u0015iG\u000e\\5c\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0005\u0001myR\u0005\u0005\u0002\u001d;5\t1#\u0003\u0002\u001f'\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\t\u0002\tU$\u0018\u000e\\\u0005\u0003I\u0005\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002'S5\tqE\u0003\u0002)'\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002+O\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u0010\u0003\u0015AH)\u0019;b+\u0005\t\u0004c\u0001\u001a6o5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0003BeJ\f\u0017\u0010\u0005\u00023q%\u0011\u0011h\r\u0002\u0007\t>,(\r\\3\u0002\ra$\u0015\r^1!\u0003\u0015IH)\u0019;b\u0003\u0019IH)\u0019;bA\u0005)!0\u001a:pg\u00061!0\u001a:pg\u0002\nA\u0001Z1uCV\t\u0011\tE\u0002C\u000b\u001ek\u0011a\u0011\u0006\u0003\tN\n!bY8mY\u0016\u001cG/[8o\u0013\t15IA\u0002TKF\u0004\"\u0001S&\u000e\u0003%S!AS\t\u0002\r1Lg.\u00197h\u0013\ta\u0015J\u0001\u0004WK\u000e$xN]\u0001\u0006I\u0006$\u0018\rI\u0001\fCB\u0004(o\u001c=FcV\fG\u000e\u0006\u0003Q'V;\u0006C\u0001\u001aR\u0013\t\u00116GA\u0004C_>dW-\u00198\t\u000bQS\u0001\u0019A\u001c\u0002\u0005Y\f\u0004\"\u0002,\u000b\u0001\u00049\u0014A\u0001<3\u0011\u001dA&\u0002%AA\u0002]\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0002+\u0005\u0004\bO]8y\u000bF,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\t1L\u000b\u000289.\nQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003EN\n!\"\u00198o_R\fG/[8o\u0013\t!wLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011#\\1ue&D\u0018\t\u001d9s_b,\u0015/^1m)\u0011\u0001v\r\u001d:\t\u000b!d\u0001\u0019A5\u0002\u0003\u0005\u00032A\u001b88\u001b\u0005Y'B\u0001&m\u0015\u0005i\u0017A\u00022sK\u0016TX-\u0003\u0002pW\n1Q*\u0019;sSbDQ!\u001d\u0007A\u0002%\f\u0011A\u0011\u0005\b12\u0001\n\u00111\u00018\u0003mi\u0017\r\u001e:jq\u0006\u0003\bO]8y\u000bF,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class CorrelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final double[] xData;
    private final double[] yData;
    private final double[] zeros;
    private final Seq<Vector> data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public double[] xData() {
        return this.xData;
    }

    public double[] yData() {
        return this.yData;
    }

    public double[] zeros() {
        return this.zeros;
    }

    public Seq<Vector> data() {
        return this.data;
    }

    public boolean approxEqual(double v1, double v2, double threshold) {
        return Predef$.MODULE$.double2Double(v1).isNaN() ? Predef$.MODULE$.double2Double(v2).isNaN() : package$.MODULE$.abs(v1 - v2) <= threshold;
    }

    public double approxEqual$default$3() {
        return 1.0E-6;
    }

    public boolean matrixApproxEqual(Matrix<Object> A, Matrix<Object> B, double threshold) {
        boolean bl;
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.cols()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                if (!this.approxEqual(A.apply$mcD$sp(i, j), B.apply$mcD$sp(i, j), threshold)) {
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("i, j = ").append(i).append(", ").append(j).append(" actual: ").append(A.apply$mcD$sp(i, j)).append(" expected:").append(B.apply$mcD$sp(i, j)).toString());
                    throw new NonLocalReturnControl.mcZ.sp(object, false);
                }
            }));
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public double matrixApproxEqual$default$3() {
        return 1.0E-6;
    }

    private final void testImplicits$lzycompute$1() {
        CorrelationSuite correlationSuite = this;
        synchronized (correlationSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$5(CorrelationSuite $this, double expected$1, int numParts) {
        RDD x1 = $this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray($this.xData()), numParts, ClassTag$.MODULE$.Double());
        RDD y1 = $this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray($this.yData()), numParts, ClassTag$.MODULE$.Double());
        double p2 = Statistics$.MODULE$.corr(x1, y1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.approxEqual(expected$1, p2, $this.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p2, CorrelationSuite.this.approxEqual$default$3)", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(CorrelationSuite $this, double expected$2, int numParts) {
        RDD x1 = $this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray($this.xData()), numParts, ClassTag$.MODULE$.Double());
        RDD y1 = $this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray($this.yData()), numParts, ClassTag$.MODULE$.Double());
        double s2 = Statistics$.MODULE$.corr(x1, y1, "spearman");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.approxEqual(expected$2, s2, $this.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s2, CorrelationSuite.this.approxEqual$default$3)", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }

    public CorrelationSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.xData = new double[]{1.0, 0.0, -2.0};
        this.yData = new double[]{4.0, 5.0, 3.0};
        this.zeros = new double[3];
        this.data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, -2.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 0.0, 3.0})), Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 0.0, 8.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0}))}));
        this.test("corr(x, y) pearson, 1 value in data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.0});
            int x$2 = qual$1.parallelize$default$2();
            RDD x = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Double());
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{4.0});
            int x$4 = qual$2.parallelize$default$2();
            RDD y = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
            this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Statistics$.MODULE$.corr(x, y, "pearson"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Statistics$.MODULE$.corr(x, y, "spearman"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("corr(x, y) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapDoubleArray(this.xData());
            int x$6 = qual$3.parallelize$default$2();
            RDD x = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.Double());
            SparkContext qual$4 = this.sc();
            WrappedArray x$7 = Predef$.MODULE$.wrapDoubleArray(this.yData());
            int x$8 = qual$4.parallelize$default$2();
            RDD y = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.Double());
            double expected = 0.6546537;
            double d = Statistics$.MODULE$.corr(x, y);
            double p1 = Statistics$.MODULE$.corr(x, y, "pearson");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.approxEqual(expected, d, this.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, default, CorrelationSuite.this.approxEqual$default$3)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.approxEqual(expected, p1, this.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p1, CorrelationSuite.this.approxEqual$default$3)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.xData())).size(), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.xData())).size() * 2})).foreach((Function1 & Serializable & scala.Serializable)numParts -> CorrelationSuite.$anonfun$new$5(this, expected, BoxesRunTime.unboxToInt((Object)numParts)));
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapDoubleArray(this.zeros());
            int x$10 = qual$5.parallelize$default$2();
            RDD z = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z)).isNaN(), "scala.Predef.double2Double(Statistics.corr(x, z)).isNaN()", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("corr(x, y) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$6 = this.sc();
            WrappedArray x$11 = Predef$.MODULE$.wrapDoubleArray(this.xData());
            int x$12 = qual$6.parallelize$default$2();
            RDD x = qual$6.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.Double());
            SparkContext qual$7 = this.sc();
            WrappedArray x$13 = Predef$.MODULE$.wrapDoubleArray(this.yData());
            int x$14 = qual$7.parallelize$default$2();
            RDD y = qual$7.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.Double());
            double expected = 0.5;
            double s1 = Statistics$.MODULE$.corr(x, y, "spearman");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.approxEqual(expected, s1, this.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s1, CorrelationSuite.this.approxEqual$default$3)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.xData())).size(), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.xData())).size() * 2})).foreach((Function1 & Serializable & scala.Serializable)numParts -> CorrelationSuite.$anonfun$new$7(this, expected, BoxesRunTime.unboxToInt((Object)numParts)));
            SparkContext qual$8 = this.sc();
            WrappedArray x$15 = Predef$.MODULE$.wrapDoubleArray(this.zeros());
            int x$16 = qual$8.parallelize$default$2();
            RDD z = qual$8.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z, "spearman")).isNaN(), "scala.Predef.double2Double(Statistics.corr(x, z, \"spearman\")).isNaN()", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("corr(X) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$9 = this.sc();
            Seq<Vector> x$17 = this.data();
            int x$18 = qual$9.parallelize$default$2();
            RDD X = qual$9.parallelize(x$17, x$18, ClassTag$.MODULE$.apply(Vector.class));
            org.apache.spark.mllib.linalg.Matrix defaultMat = Statistics$.MODULE$.corr(X);
            org.apache.spark.mllib.linalg.Matrix pearsonMat = Statistics$.MODULE$.corr(X, "pearson");
            DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4004714)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9135959)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.40047142), (Object)BoxesRunTime.boxToDouble((double)0.91359586), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.matrixApproxEqual((Matrix<Object>)defaultMat.asBreeze(), (Matrix<Object>)expected, this.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(defaultMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.matrixApproxEqual((Matrix<Object>)pearsonMat.asBreeze(), (Matrix<Object>)expected, this.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(pearsonMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("corr(X) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$10 = this.sc();
            Seq<Vector> x$19 = this.data();
            int x$20 = qual$10.parallelize$default$2();
            RDD X = qual$10.parallelize(x$19, x$20, ClassTag$.MODULE$.apply(Vector.class));
            org.apache.spark.mllib.linalg.Matrix spearmanMat = Statistics$.MODULE$.corr(X, "spearman");
            DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9486833)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.4), (Object)BoxesRunTime.boxToDouble((double)0.9486833), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.matrixApproxEqual((Matrix<Object>)spearmanMat.asBreeze(), (Matrix<Object>)expected, this.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(spearmanMat.asBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("method identification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PearsonCorrelation$ pearson = PearsonCorrelation$.MODULE$;
            SpearmanCorrelation$ spearman = SpearmanCorrelation$.MODULE$;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("pearson"));
            PearsonCorrelation$ $org_scalatest_assert_macro_right = pearson;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("spearman"));
            SpearmanCorrelation$ $org_scalatest_assert_macro_right2 = spearman;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Correlations$.MODULE$.getCorrelationFromName("kendall"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.ignore("Pearson correlation of very large uncorrelated values (SPARK-14533)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD a = RandomRDDs$.MODULE$.normalRDD(this.sc(), 100000L, 10, RandomRDDs$.MODULE$.normalRDD$default$4()).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1 + 1.0E9, ClassTag$.MODULE$.Double());
            RDD b = RandomRDDs$.MODULE$.normalRDD(this.sc(), 100000L, 10, RandomRDDs$.MODULE$.normalRDD$default$4()).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 + 1.0E9, ClassTag$.MODULE$.Double());
            double p = Statistics$.MODULE$.corr(a, b, "pearson");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.approxEqual(p, 0.0, 0.01), "CorrelationSuite.this.approxEqual(p, 0.0, 0.01)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("CorrelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }
}

