/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\f\u0019\u0001\rBQA\f\u0001\u0005\u0002=:QA\r\r\t\u0002M2Qa\u0006\r\t\u0002QBQAL\u0002\u0005\u0002UBQAN\u0002\u0005\u0002]BQAX\u0002\u0005\u0002}CQ\u0001Z\u0002\u0005\u0002\u0015DQ![\u0002\u0005\u0002\u0015DQA[\u0002\u0005\u0002\u0015DQa[\u0002\u0005\u0002\u0015DQ\u0001\\\u0002\u0005\u00025DQ!^\u0002\u0005\u0002\u0015DQA^\u0002\u0005\u0002\u0015DQa^\u0002\u0005\u0002\u0015DQ\u0001_\u0002\u0005\neDq!!\u0002\u0004\t\u0013\t9\u0001\u0003\u0005\u0002:\r!\t\u0001HA\u001e\u0011%\tye\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002V\r\u0001\u000b\u0011BA*\u0011!\t9f\u0001C\u00015\u0005e\u0003bBA,\u0007\u0011%\u00111\r\u0005\n\u0003S\u001a\u0011\u0011!C\u0005\u0003W\u0012\u0011\u0003R3dSNLwN\u001c+sK\u0016\u001cV/\u001b;f\u0015\tI\"$\u0001\u0003ue\u0016,'BA\u000e\u001d\u0003\u0015iG\u000e\\5c\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011B\u0003CA\u0013'\u001b\u0005a\u0012BA\u0014\u001d\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0011\u0006L\u0007\u0002U)\u00111FG\u0001\u0005kRLG.\u0003\u0002.U\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001\u0019\u0003E!UmY5tS>tGK]3f'VLG/\u001a\t\u0003c\r\u0019\"a\u0001\u0013\u0015\u0003M\n!C^1mS\u0012\fG/Z\"mCN\u001c\u0018NZ5feR!\u0001HP#Z!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011)f.\u001b;\t\u000b}*\u0001\u0019\u0001!\u0002\u000b5|G-\u001a7\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005}B\u0012B\u0001#C\u0005E!UmY5tS>tGK]3f\u001b>$W\r\u001c\u0005\u0006\r\u0016\u0001\raR\u0001\u0006S:\u0004X\u000f\u001e\t\u0004\u0011B\u001bfBA%O\u001d\tQU*D\u0001L\u0015\ta%%\u0001\u0004=e>|GOP\u0005\u0002w%\u0011qJO\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002TKFT!a\u0014\u001e\u0011\u0005Q;V\"A+\u000b\u0005YS\u0012A\u0003:fOJ,7o]5p]&\u0011\u0001,\u0016\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u00065\u0016\u0001\raW\u0001\u0011e\u0016\fX/\u001b:fI\u0006\u001b7-\u001e:bGf\u0004\"!\u000f/\n\u0005uS$A\u0002#pk\ndW-A\twC2LG-\u0019;f%\u0016<'/Z:t_J$B\u0001\u000f1bE\")qH\u0002a\u0001\u0001\")aI\u0002a\u0001\u000f\")1M\u0002a\u00017\u0006Y!/Z9vSJ,G-T*F\u0003\u0019:WM\\3sCR,wJ\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G\u000e\r\u000b\u0002MB\u0019\u0011hZ*\n\u0005!T$!B!se\u0006L\u0018AJ4f]\u0016\u0014\u0018\r^3Pe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo],ji\"d\u0015MY3mc\u0005ar-\u001a8fe\u0006$Xm\u0014:eKJ,G\rT1cK2,G\rU8j]R\u001c\u0018!H4f]\u0016\u0014\u0018\r^3DCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:\u0002O\u001d,g.\u001a:bi\u0016\u001c\u0015\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN\f5OS1wC2K7\u000f\u001e\u000b\u0002]B\u0019qn]*\u000e\u0003AT!aK9\u000b\u0003I\fAA[1wC&\u0011A\u000f\u001d\u0002\u0005\u0019&\u001cH/\u0001\u0016hK:,'/\u0019;f\u0007\u0006$XmZ8sS\u000e\fG\u000eR1uCB{\u0017N\u001c;t\r>\u0014X*\u001e7uS\u000ed\u0017m]:\u0002S\u001d,g.\u001a:bi\u0016\u001cuN\u001c;j]V|Wo\u001d#bi\u0006\u0004v.\u001b8ug\u001a{'/T;mi&\u001cG.Y:t\u0003q:WM\\3sCR,7)\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001chi\u001c:Nk2$\u0018n\u00197bgN4uN](sI\u0016\u0014X\r\u001a$fCR,(/Z:\u0002\u001d\r\u0014X-\u0019;f\u0019\u0016\fgMT8eKR\u0011!0 \t\u0003\u0003nL!\u0001 \"\u0003\t9{G-\u001a\u0005\u0006}>\u0001\ra`\u0001\u0003S\u0012\u00042!OA\u0001\u0013\r\t\u0019A\u000f\u0002\u0004\u0013:$\u0018AE2sK\u0006$X-\u00138uKJt\u0017\r\u001c(pI\u0016$RA_A\u0005\u0003\u0017AQA \tA\u0002}Dq!!\u0004\u0011\u0001\u0004\ty!A\u0006gK\u0006$XO]3UsB,\u0007\u0003BA\t\u0003gqA!a\u0005\u0002.9!\u0011QCA\u0015\u001d\u0011\t9\"a\n\u000f\t\u0005e\u0011Q\u0005\b\u0005\u00037\t\u0019C\u0004\u0003\u0002\u001e\u0005\u0005bb\u0001&\u0002 %\t\u0011%\u0003\u0002 A%\u0011QDH\u0005\u00037qI!!\u0007\u000e\n\u0007\u0005-\u0002$A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003_\t\t$A\u0006GK\u0006$XO]3UsB,'bAA\u00161%!\u0011QGA\u001c\u0005-1U-\u0019;ve\u0016$\u0016\u0010]3\u000b\t\u0005=\u0012\u0011G\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0002A\u0003{Aq!a\u0010\u0012\u0001\u0004\t\t%\u0001\u0003bY\u001e|\u0007\u0003BA\"\u0003\u0013rA!a\u0005\u0002F%!\u0011qIA\u0019\u0003\u0011\tEnZ8\n\t\u0005-\u0013Q\n\u0002\u0005\u00032<wN\u0003\u0003\u0002H\u0005E\u0012aE2sK\u0006$X\rZ'pI\u0016dgj\u001c3f\u0013\u0012\u001cXCAA*!\rItm`\u0001\u0015GJ,\u0017\r^3e\u001b>$W\r\u001c(pI\u0016LEm\u001d\u0011\u0002\u0015\rDWmY6FcV\fG\u000eF\u00039\u00037\ny\u0006\u0003\u0004\u0002^Q\u0001\r\u0001Q\u0001\u0002C\"1\u0011\u0011\r\u000bA\u0002\u0001\u000b\u0011A\u0019\u000b\u0006q\u0005\u0015\u0014q\r\u0005\u0007\u0003;*\u0002\u0019\u0001>\t\r\u0005\u0005T\u00031\u0001{\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0004\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0014/\u0001\u0003mC:<\u0017\u0002BA<\u0003c\u0012aa\u00142kK\u000e$\b")
public class DecisionTreeSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
    }

    public static java.util.List<org.apache.spark.mllib.regression.LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsAsJavaList();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateCategoricalDataPoints() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPoints() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
    }

    public static org.apache.spark.mllib.regression.LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
    }

    public static void validateRegressor(DecisionTreeModel decisionTreeModel, Seq<org.apache.spark.mllib.regression.LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateRegressor(decisionTreeModel, seq, d);
    }

    public static void validateClassifier(DecisionTreeModel decisionTreeModel, Seq<org.apache.spark.mllib.regression.LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateClassifier(decisionTreeModel, seq, d);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        DecisionTreeSuite decisionTreeSuite = this;
        synchronized (decisionTreeSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$28(DecisionTreeSuite $this, double predict) {
        double $org_scalatest_assert_macro_left = predict;
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
    }

    public static final /* synthetic */ Assertion $anonfun$new$32(DecisionTreeSuite $this, double predict) {
        double $org_scalatest_assert_macro_left = predict;
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }

    public static final /* synthetic */ void $anonfun$new$36(DecisionTreeSuite $this, String path$1, File tempDir$1, Enumeration.Value algo) {
        DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(algo);
        try {
            model.save($this.sc(), path$1);
            DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load($this.sc(), path$1);
            DecisionTreeSuite$.MODULE$.checkEqual(model, sameModel);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir$1);
        }
    }

    public DecisionTreeSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Binary classification stump with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$3 = Algo$.MODULE$.Classification();
            Gini$ x$4 = Gini$.MODULE$;
            int x$5 = 2;
            int x$6 = 2;
            int x$7 = 100;
            Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$9 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$10 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$11 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$12 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$13 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$14 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$15 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$3, (Impurity)x$4, x$6, x$5, x$7, x$9, x$8, x$10, x$11, x$12, x$13, x$14, x$15);
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.categories());
            List $org_scalatest_assert_macro_right2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right3 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
            double $org_scalatest_assert_macro_left4 = stats.gain();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            double $org_scalatest_assert_macro_left6 = stats.impurity();
            double $org_scalatest_assert_macro_right6 = 0.2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Regression stump with 3-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            SparkContext qual$2 = this.sc();
            WrappedArray x$16 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$17 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$16, x$17, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$18 = Algo$.MODULE$.Regression();
            Variance$ x$19 = Variance$.MODULE$;
            int x$20 = 2;
            int x$21 = 100;
            Map x$22 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$23 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$24 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$25 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$26 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$27 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$28 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$29 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$30 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$18, (Impurity)x$19, x$20, x$23, x$21, x$24, x$22, x$25, x$26, x$27, x$28, x$29, x$30);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            List $org_scalatest_assert_macro_left3 = split.categories();
            double $org_scalatest_assert_macro_right3 = 1.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
            double $org_scalatest_assert_macro_left5 = stats.gain();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            double $org_scalatest_assert_macro_right6 = 0.6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            double $org_scalatest_assert_macro_left7 = stats.impurity();
            double $org_scalatest_assert_macro_right7 = 0.2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Regression stump with binary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            SparkContext qual$3 = this.sc();
            WrappedArray x$31 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$32 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$31, x$32, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$33 = Algo$.MODULE$.Regression();
            Variance$ x$34 = Variance$.MODULE$;
            int x$35 = 2;
            int x$36 = 100;
            Map x$37 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            int x$38 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$39 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$40 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$41 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$42 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$43 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$44 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$45 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$33, (Impurity)x$34, x$35, x$38, x$36, x$39, x$37, x$40, x$41, x$42, x$43, x$44, x$45);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateRegressor(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("Binary classification stump with fixed label 0 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            SparkContext qual$4 = this.sc();
            WrappedArray x$46 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$47 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$46, x$47, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("Binary classification stump with fixed label 1 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            SparkContext qual$5 = this.sc();
            WrappedArray x$48 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$49 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$48, x$49, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Binary classification stump with fixed label 0 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            SparkContext qual$6 = this.sc();
            WrappedArray x$50 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$51 = qual$6.parallelize$default$2();
            RDD rdd = qual$6.parallelize((Seq)x$50, x$51, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("Binary classification stump with fixed label 1 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            SparkContext qual$7 = this.sc();
            WrappedArray x$52 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$53 = qual$7.parallelize$default$2();
            RDD rdd = qual$7.parallelize((Seq)x$52, x$53, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Multiclass classification stump with 3-ary (unordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
            SparkContext qual$8 = this.sc();
            WrappedArray x$54 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$55 = qual$8.parallelize$default$2();
            RDD rdd = qual$8.parallelize((Seq)x$54, x$55, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$56 = Algo$.MODULE$.Classification();
            Gini$ x$57 = Gini$.MODULE$;
            int x$58 = 4;
            int x$59 = 3;
            Map x$60 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$61 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$62 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$63 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$64 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$65 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$66 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$67 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$68 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$56, (Impurity)x$57, x$58, x$59, x$61, x$62, x$60, x$63, x$64, x$65, x$66, x$67, x$68);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            List $org_scalatest_assert_macro_left3 = split.categories();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Binary classification stump with 1 continuous feature, to check off-by-1 error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
            SparkContext qual$9 = this.sc();
            WrappedArray x$69 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$70 = qual$9.parallelize$default$2();
            RDD rdd = qual$9.parallelize((Seq)x$69, x$70, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("Binary classification stump with 2 continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}))))});
            SparkContext qual$10 = this.sc();
            WrappedArray x$71 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$72 = qual$10.parallelize$default$2();
            RDD rdd = qual$10.parallelize((Seq)x$71, x$72, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Split)model.topNode().split().get()).feature()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("Multiclass classification stump with unordered categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int maxBins = 2 * ((int)package$.MODULE$.pow(2.0, 2.0) - 1);
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
            SparkContext qual$11 = this.sc();
            WrappedArray x$73 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$74 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize((Seq)x$73, x$74, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$75 = Algo$.MODULE$.Classification();
            Gini$ x$76 = Gini$.MODULE$;
            int x$77 = 4;
            int x$78 = 3;
            int x$79 = maxBins;
            Map x$80 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$81 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$82 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$83 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$84 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$85 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$86 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$87 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$75, (Impurity)x$76, x$77, x$78, x$79, x$81, x$80, x$82, x$83, x$84, x$85, x$86, x$87);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            List $org_scalatest_assert_macro_left5 = split.categories();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right6 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            InformationGainStats gain = (InformationGainStats)rootNode.stats().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.leftImpurity()));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.rightImpurity()));
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("Multiclass classification stump with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
            SparkContext qual$12 = this.sc();
            WrappedArray x$88 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$89 = qual$12.parallelize$default$2();
            RDD rdd = qual$12.parallelize((Seq)x$88, x$89, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 3, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            double $org_scalatest_assert_macro_left3 = split.threshold();
            int $org_scalatest_assert_macro_right3 = 1980;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            double $org_scalatest_assert_macro_left4 = split.threshold();
            int $org_scalatest_assert_macro_right4 = 2020;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("Multiclass classification stump with continuous + unordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
            SparkContext qual$13 = this.sc();
            WrappedArray x$90 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$91 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize((Seq)x$90, x$91, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$92 = Algo$.MODULE$.Classification();
            Gini$ x$93 = Gini$.MODULE$;
            int x$94 = 4;
            int x$95 = 3;
            int x$96 = 100;
            Map x$97 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$98 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$99 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$100 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$101 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$102 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$103 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$104 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$92, (Impurity)x$93, x$94, x$95, x$96, x$98, x$97, x$99, x$100, x$101, x$102, x$103, x$104);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            double $org_scalatest_assert_macro_left3 = split.threshold();
            int $org_scalatest_assert_macro_right3 = 1980;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            double $org_scalatest_assert_macro_left4 = split.threshold();
            int $org_scalatest_assert_macro_right4 = 2020;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("Multiclass classification stump with 10-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
            SparkContext qual$14 = this.sc();
            WrappedArray x$105 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$106 = qual$14.parallelize$default$2();
            RDD rdd = qual$14.parallelize((Seq)x$105, x$106, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$107 = Algo$.MODULE$.Classification();
            Gini$ x$108 = Gini$.MODULE$;
            int x$109 = 4;
            int x$110 = 3;
            int x$111 = 100;
            Map x$112 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$113 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$114 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$115 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$116 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$117 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$118 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$119 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$107, (Impurity)x$108, x$109, x$110, x$111, x$113, x$112, x$114, x$115, x$116, x$117, x$118, x$119);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.asML(), ClassTag$.MODULE$.apply(LabeledPoint.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            List $org_scalatest_assert_macro_left3 = split.categories();
            double $org_scalatest_assert_macro_right3 = 1.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("Multiclass classification tree with 10-ary (ordered) categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
            SparkContext qual$15 = this.sc();
            WrappedArray x$120 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$121 = qual$15.parallelize$default$2();
            RDD rdd = qual$15.parallelize((Seq)x$120, x$121, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$122 = Algo$.MODULE$.Classification();
            Gini$ x$123 = Gini$.MODULE$;
            int x$124 = 4;
            int x$125 = 3;
            int x$126 = 10;
            Map x$127 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$128 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$129 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$130 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$131 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$132 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$133 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$134 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$122, (Impurity)x$123, x$124, x$125, x$126, x$128, x$127, x$129, x$130, x$131, x$132, x$133, x$134);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<org.apache.spark.mllib.regression.LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.6);
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("split must satisfy min instances per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
            SparkContext qual$16 = this.sc();
            WrappedArray x$135 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$136 = qual$16.parallelize$default$2();
            RDD rdd = qual$16.parallelize((Seq)x$135, x$136, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$137 = Algo$.MODULE$.Classification();
            Gini$ x$138 = Gini$.MODULE$;
            int x$139 = 2;
            int x$140 = 2;
            int x$141 = 2;
            int x$142 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$143 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$144 = Strategy$.MODULE$.$lessinit$greater$default$7();
            double x$145 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$146 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$147 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$148 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$149 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$137, (Impurity)x$138, x$139, x$140, x$142, x$143, x$144, x$141, x$145, x$146, x$147, x$148, x$149);
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            double[] predicts = (double[])rdd.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)model.predict(p.features())), ClassTag$.MODULE$.Double()).collect();
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicts)).foreach((Function1 & Serializable & scala.Serializable)predict -> DecisionTreeSuite.$anonfun$new$28(this, BoxesRunTime.unboxToDouble((Object)predict)));
            Node rootNode = model.topNode();
            Option $org_scalatest_assert_macro_left2 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("do not choose split that does not satisfy min instance per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})))});
            SparkContext qual$17 = this.sc();
            WrappedArray x$150 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$151 = qual$17.parallelize$default$2();
            RDD rdd = qual$17.parallelize((Seq)x$150, x$151, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$152 = Algo$.MODULE$.Classification();
            Gini$ x$153 = Gini$.MODULE$;
            int x$154 = 2;
            int x$155 = 2;
            Map x$156 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            int x$157 = 2;
            int x$158 = 2;
            Enumeration.Value x$159 = Strategy$.MODULE$.$lessinit$greater$default$6();
            double x$160 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$161 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$162 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$163 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$164 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$152, (Impurity)x$153, x$155, x$157, x$154, x$159, x$156, x$158, x$160, x$161, x$162, x$163, x$164);
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            InformationGainStats gainStats = (InformationGainStats)rootNode.stats().get();
            int $org_scalatest_assert_macro_left = split.feature();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            double $org_scalatest_assert_macro_left2 = gainStats.gain();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            double $org_scalatest_assert_macro_left3 = gainStats.impurity();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("split must satisfy min info gain requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = (org.apache.spark.mllib.regression.LabeledPoint[])((Object[])new org.apache.spark.mllib.regression.LabeledPoint[]{new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new org.apache.spark.mllib.regression.LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
            SparkContext qual$18 = this.sc();
            WrappedArray x$165 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$166 = qual$18.parallelize$default$2();
            RDD input = qual$18.parallelize((Seq)x$165, x$166, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class));
            Enumeration.Value x$167 = Algo$.MODULE$.Classification();
            Gini$ x$168 = Gini$.MODULE$;
            int x$169 = 2;
            int x$170 = 2;
            double x$171 = 1.0;
            int x$172 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$173 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$174 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$175 = Strategy$.MODULE$.$lessinit$greater$default$8();
            int x$176 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$177 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$178 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$179 = Strategy$.MODULE$.$lessinit$greater$default$13();
            Strategy strategy = new Strategy(x$167, (Impurity)x$168, x$169, x$170, x$172, x$173, x$174, x$175, x$171, x$176, x$177, x$178, x$179);
            DecisionTreeModel model = DecisionTree$.MODULE$.train(input, strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            double[] predicts = (double[])input.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)model.predict(p.features())), ClassTag$.MODULE$.Double()).collect();
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicts)).foreach((Function1 & Serializable & scala.Serializable)predict -> DecisionTreeSuite.$anonfun$new$32(this, BoxesRunTime.unboxToDouble((Object)predict)));
            Option $org_scalatest_assert_macro_left2 = model.topNode().stats();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("Node.subtreeIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Classification());
            int[] nodeIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])model.topNode().subtreeIterator().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id())).toArray(ClassTag$.MODULE$.Int()))).sorted((Ordering)Ordering.Int$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(nodeIds);
            int[] $org_scalatest_assert_macro_right = DecisionTreeSuite$.MODULE$.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()})).foreach((Function1 & Serializable & scala.Serializable)algo -> {
                DecisionTreeSuite.$anonfun$new$36(this, path, tempDir, algo);
                return BoxedUnit.UNIT;
            });
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
    }
}

