/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.Serializable;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.util.StatCounter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class EnsembleTestHelper$ {
    public static EnsembleTestHelper$ MODULE$;

    static {
        new EnsembleTestHelper$();
    }

    public void testRandomArrays(double[][] data, int numCols, double expectedMean, double expectedStddev, double epsilon) {
        ArrayBuffer values = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            Predef$.MODULE$.assert(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(row)).size() == numCols);
            return values.$plus$plus$eq((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(row)));
        });
        StatCounter stats = new StatCounter((TraversableOnce)values);
        Predef$.MODULE$.assert(package$.MODULE$.abs(stats.mean() - expectedMean) < epsilon);
        Predef$.MODULE$.assert(package$.MODULE$.abs(stats.stdev() - expectedStddev) < epsilon);
    }

    public void validateClassifier(TreeEnsembleModel model, Seq<LabeledPoint> input, double requiredAccuracy) {
        Seq predictions = (Seq)input.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)model.predict(x.features())), Seq$.MODULE$.canBuildFrom());
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EnsembleTestHelper$.$anonfun$validateClassifier$2(x0$1)));
        double accuracy = (double)(input.length() - numOffPredictions) / (double)input.length();
        Predef$.MODULE$.assert(accuracy >= requiredAccuracy, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("validateClassifier calculated accuracy ").append(accuracy).append(" but required ").append(requiredAccuracy).append(".").toString());
    }

    public void validateRegressor(TreeEnsembleModel model, Seq<LabeledPoint> input, double required, String metricName) {
        double d;
        Seq predictions = (Seq)input.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)model.predict(x.features())), Seq$.MODULE$.canBuildFrom());
        Seq errors = (Seq)((TraversableLike)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)EnsembleTestHelper$.$anonfun$validateRegressor$2(x0$1)), Seq$.MODULE$.canBuildFrom());
        String string = metricName;
        if ("mse".equals(string)) {
            d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)err -> err * err, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)errors.size();
        } else if ("mae".equals(string)) {
            d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.abs(x), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)errors.size();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        Predef$.MODULE$.assert(metric <= required, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("validateRegressor calculated ").append(metricName).append(" ").append(metric).append(" but required ").append(required).append(".").toString());
    }

    public String validateRegressor$default$4() {
        return "mse";
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPoints(int numFeatures, int numInstances) {
        void var3_3;
        LabeledPoint[] arr = new LabeledPoint[numInstances];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInstances).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double label = i < numInstances / 10 ? 0.0 : (i < numInstances / 2 ? 1.0 : ((double)i < (double)numInstances * 0.9 ? 0.0 : 1.0));
            double[] features = (double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> i, ClassTag$.MODULE$.Double());
            arr$1[i] = new LabeledPoint(label, Vectors$.MODULE$.dense(features));
        });
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$validateClassifier$2(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
        return bl;
    }

    public static final /* synthetic */ double $anonfun$validateRegressor$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        LabeledPoint point = (LabeledPoint)tuple2._2();
        double d = point.label() - prediction;
        return d;
    }

    private EnsembleTestHelper$() {
        MODULE$ = this;
    }
}

