/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u001d;\u0001\u0015C\u0001\u0002\u001c\u0001\u0003\u0006\u0004%\t%\u001c\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n9D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011BA\u0006\u0011)\t\u0019\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003+\u0001!Q1A\u0005\n\u0005]\u0001BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u00111\u0005\u0001\u0003\u0006\u0004%\t%!\n\t\u0015\u0005=\u0002A!A!\u0002\u0013\t9\u0003\u0003\u0006\u00024\u0001\u0011)\u0019!C!\u0003KA!\"a\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011!\ty\u0004\u0001C\u0001y\u0005\u0005\u0003\u0002CA \u0001\u0011\u0005A(a\u0015\t\u000f\u0005}\u0002\u0001\"\u0001\u0002^!9\u0011q\r\u0001\u0005B\u0005-\u0001\"CA8\u0001\t\u0007I\u0011AA\u0013\u0011!\t9\b\u0001Q\u0001\n\u0005\u001d\u0002bBA>\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003\u007f\u0002A\u0011KAA\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!!5\u0001\t#\n\u0019\u000eC\u0004\u0002X\u0002!\t&!7\t\u0013\u0005}\u0007A1A\u0005\u0002\u0005\u0015\u0002\u0002CAq\u0001\u0001\u0006I!a\n\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u0011\u0011 \u0001\u0005B\u0005m\bBCA\u0000\u0001!\u0015\r\u0011\"\u0001\u0003\u0002!9!Q\u0001\u0001\u0005\n\t\u001d\u0001\u0002\u0003B\u0006\u0001\u0011\u0005AH!\u0004\t\u0013\t\u0005\u0002A1A\u0005\n\t\r\u0002\u0002\u0003B\u0018\u0001\u0001\u0006IA!\n\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!q\t\u0001\u0005B\t%sa\u0002B+u!\u0005!q\u000b\u0004\u0007siB\tA!\u0017\t\u000f\u0005}\"\u0005\"\u0001\u0003h!A!\u0011\u000e\u0012C\u0002\u0013%Q\u000eC\u0004\u0003l\t\u0002\u000b\u0011\u00028\t\u0011\t5$E1A\u0005\n5DqAa\u001c#A\u0003%a\u000eC\u0004\u0003r\t\"\tEa\u001d\t\u000f\tu$\u0005\"\u0011\u0003\u0000\u00199!q\u0011\u0012\u0001E\t%\u0005\"\u0003BFU\t\u0005\t\u0015!\u0003Q\u0011\u001d\tyD\u000bC\u0001\u0005\u001bCqA!&+\t#\u00129J\u0002\u0004\u0003\"\n\"!1\u0015\u0005\b\u0003\u007fqC\u0011\u0001BS\u0011%\u0011IK\fb\u0001\n\u0013\u0011Y\u000b\u0003\u0005\u0003<:\u0002\u000b\u0011\u0002BW\u0011%\u0011iL\fb\u0001\n\u0013\u0011Y\u000b\u0003\u0005\u0003@:\u0002\u000b\u0011\u0002BW\u0011\u001d\u0011iH\fC!\u0005\u0003D\u0001B!2#\t\u0003a$q\u0019\u0005\u000b\u0005K\u0014\u0013\u0013!C\u0001y\t\u001d\bB\u0003B~EE\u0005I\u0011\u0001\u001f\u0003h\"I!Q \u0012\u0002\u0002\u0013%!q \u0002\u0017\u000f\n#6\t\\1tg&4\u0017nY1uS>tWj\u001c3fY*\u00111\bP\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tid(\u0001\u0002nY*\u0011q\bQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011\u0015k\u00161g!\u00119\u0005J\u0013)\u000e\u0003iJ!!\u0013\u001e\u0003AA\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001br\na\u0001\\5oC2<\u0017BA(M\u0005\u00191Vm\u0019;peB\u0011q\t\u0001\t\u0003%Vk\u0011a\u0015\u0006\u0003)r\nA\u0001\u001e:fK&\u0011ak\u0015\u0002\u0014\u000f\n#6\t\\1tg&4\u0017.\u001a:QCJ\fWn\u001d\t\u0004%bS\u0016BA-T\u0005E!&/Z3F]N,WN\u00197f\u001b>$W\r\u001c\t\u00037zk\u0011\u0001\u0018\u0006\u0003;r\n!B]3he\u0016\u001c8/[8o\u0013\tyFLA\u000eEK\u000eL7/[8o)J,WMU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gr\nA!\u001e;jY&\u0011QM\u0019\u0002\u000b\u001b2;&/\u001b;bE2,\u0007CA4k\u001b\u0005A'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D'\u0001D*fe&\fG.\u001b>bE2,\u0017aA;jIV\ta\u000e\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c\"l\u0011A\u001d\u0006\u0003g\u0012\u000ba\u0001\u0010:p_Rt\u0014BA;i\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005UD\u0007\u0006B\u0001{\u0003\u0003\u0001\"a\u001f@\u000e\u0003qT!!  \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u0000y\n)1+\u001b8dK\u0006\u0012\u00111A\u0001\u0006c92d\u0006M\u0001\u0005k&$\u0007\u0005\u000b\u0003\u0003u\u0006\u0005\u0011AB0ue\u0016,7/\u0006\u0002\u0002\u000eA!q-a\u0004[\u0013\r\t\t\u0002\u001b\u0002\u0006\u0003J\u0014\u0018-_\u0001\b?R\u0014X-Z:!\u00031yFO]3f/\u0016Lw\r\u001b;t+\t\tI\u0002E\u0003h\u0003\u001f\tY\u0002E\u0002h\u0003;I1!a\bi\u0005\u0019!u.\u001e2mK\u0006iq\f\u001e:fK^+\u0017n\u001a5ug\u0002\n1B\\;n\r\u0016\fG/\u001e:fgV\u0011\u0011q\u0005\t\u0004O\u0006%\u0012bAA\u0016Q\n\u0019\u0011J\u001c;)\t\u001dQ\u0018\u0011A\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0005\u0011i\f\t!\u0001\u0006ok6\u001cE.Y:tKNDC!\u0003>\u00028\u0005\u0012\u0011\u0011H\u0001\u0006e9\u0012d\u0006M\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005\u000b\u0003\u000bu\u0006]\u0012A\u0002\u001fj]&$h\bF\u0006Q\u0003\u0007\n9%!\u0013\u0002L\u0005=\u0003\"\u00027\f\u0001\u0004q\u0007&BA\"u\u0006\u0005\u0001bBA\u0005\u0017\u0001\u0007\u0011Q\u0002\u0005\b\u0003+Y\u0001\u0019AA\r\u0011\u001d\t\u0019c\u0003a\u0001\u0003OAS!a\u0013{\u0003\u0003Aq!a\r\f\u0001\u0004\t9\u0003K\u0003\u0002Pi\f9\u0004F\u0005Q\u0003+\n9&!\u0017\u0002\\!)A\u000e\u0004a\u0001]\"9\u0011\u0011\u0002\u0007A\u0002\u00055\u0001bBA\u000b\u0019\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003Ga\u0001\u0019AA\u0014)\u001d\u0001\u0016qLA1\u0003GBQ\u0001\\\u0007A\u00029Dq!!\u0003\u000e\u0001\u0004\ti\u0001C\u0004\u0002\u00165\u0001\r!!\u0007)\t5Q\u0018\u0011A\u0001\u0006iJ,Wm\u001d\u0015\u0005\u001di\fY'\t\u0002\u0002n\u0005)\u0011G\f\u001b/a\u0005Yq-\u001a;Ok6$&/Z3tQ\u0011y!0a\u001d\"\u0005\u0005U\u0014!\u0002\u001a/a9\u0002\u0014\u0001D4fi:+X\u000e\u0016:fKN\u0004\u0003\u0006\u0002\t{\u0003g\n1\u0002\u001e:fK^+\u0017n\u001a5ug\"\"\u0011C_A6\u00035!(/\u00198tM>\u0014X.S7qYR!\u00111QAS!\u0011\t))a(\u000f\t\u0005\u001d\u0015\u0011\u0014\b\u0005\u0003\u0013\u000b)J\u0004\u0003\u0002\f\u0006Me\u0002BAG\u0003#s1!]AH\u0013\u0005\u0019\u0015BA!C\u0013\ty\u0004)C\u0002\u0002\u0018z\n1a]9m\u0013\u0011\tY*!(\u0002\u000fA\f7m[1hK*\u0019\u0011q\u0013 \n\t\u0005\u0005\u00161\u0015\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a'\u0002\u001e\"9\u0011q\u0015\nA\u0002\u0005%\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003W\u000b9\f\u0005\u0004\u0002.\u0006=\u00161W\u0007\u0003\u0003;KA!!-\u0002\u001e\n9A)\u0019;bg\u0016$\b\u0003BA[\u0003oc\u0001\u0001\u0002\u0007\u0002:\u0006\u0015\u0016\u0011!A\u0001\u0006\u0003\tYLA\u0002`IM\nB!!0\u0002DB\u0019q-a0\n\u0007\u0005\u0005\u0007NA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\f)-C\u0002\u0002H\"\u00141!\u00118z\u0003\u001d\u0001(/\u001a3jGR$B!a\u0007\u0002N\"1\u0011qZ\nA\u0002)\u000b\u0001BZ3biV\u0014Xm]\u0001\u000baJ,G-[2u%\u0006<Hc\u0001&\u0002V\"1\u0011q\u001a\u000bA\u0002)\u000baC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0004\u0015\u0006m\u0007BBAo+\u0001\u0007!*A\u0007sC^\u0004&/\u001a3jGRLwN\\\u0001\t]VlGK]3fg\u0006Ia.^7Ue\u0016,7\u000fI\u0001\u0005G>\u0004\u0018\u0010F\u0002Q\u0003ODq!!;\u0019\u0001\u0004\tY/A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\t\u0010P\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003k\fyO\u0001\u0005QCJ\fW.T1qQ\u0011A\"0a\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001c\u0015\u00053i\fY'\u0001\ngK\u0006$XO]3J[B|'\u000f^1oG\u0016\u001cX#\u0001&)\tiQ\u00181O\u0001\u0007[\u0006\u0014x-\u001b8\u0015\t\u0005m!\u0011\u0002\u0005\u0007\u0003\u001f\\\u0002\u0019\u0001&\u0002\u000bQ|w\n\u001c3\u0016\u0005\t=\u0001\u0003\u0002B\t\u0005;i!Aa\u0005\u000b\t\tU!qC\u0001\u0006[>$W\r\u001c\u0006\u0004)\ne!b\u0001B\u000e}\u0005)Q\u000e\u001c7jE&!!q\u0004B\n\u0005e9%/\u00193jK:$(i\\8ti\u0016$GK]3fg6{G-\u001a7\u0002\t1|7o]\u000b\u0003\u0005K\u0001BAa\n\u0003,5\u0011!\u0011\u0006\u0006\u0005\u0005C\u00119\"\u0003\u0003\u0003.\t%\"AE\"mCN\u001c\u0018NZ5dCRLwN\u001c'pgN\fQ\u0001\\8tg\u0002\nQ#\u001a<bYV\fG/Z#bG\"LE/\u001a:bi&|g\u000e\u0006\u0003\u0002\u001a\tU\u0002bBAT?\u0001\u0007!q\u0007\u0019\u0005\u0005s\u0011i\u0004\u0005\u0004\u0002.\u0006=&1\b\t\u0005\u0003k\u0013i\u0004\u0002\u0007\u0003@\tU\u0012\u0011!A\u0001\u0006\u0003\tYLA\u0002`IQBCa\b>\u0003D\u0005\u0012!QI\u0001\u0006e9\"d\u0006M\u0001\u0006oJLG/Z\u000b\u0003\u0005\u0017\u00022!\u0019B'\u0013\r\u0011yE\u0019\u0002\t\u001b2;&/\u001b;fe\"\"\u0001E_A:Q\u0011\u0001!0!\u0001\u0002-\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u0012\u0012\u0014\r\t\u0012YF!\u0019g!\r9'QL\u0005\u0004\u0005?B'AB!osJ+g\r\u0005\u0003b\u0005G\u0002\u0016b\u0001B3E\nQQ\n\u0014*fC\u0012\f'\r\\3\u0015\u0005\t]\u0013A\u00048v[\u001a+\u0017\r^;sKN\\U-_\u0001\u0010]Vlg)Z1ukJ,7oS3zA\u0005Ya.^7Ue\u0016,7oS3z\u00031qW/\u001c+sK\u0016\u001c8*Z=!\u0003\u0011\u0011X-\u00193\u0016\u0005\tU\u0004\u0003B1\u0003xAK1A!\u001fc\u0005!iEJU3bI\u0016\u0014\b\u0006\u0002\u0015{\u0003g\nA\u0001\\8bIR\u0019\u0001K!!\t\r\t\r\u0015\u00061\u0001o\u0003\u0011\u0001\u0018\r\u001e5)\t%R\u00181\u000f\u0002\u001d\u000f\n#6\t\\1tg&4\u0017nY1uS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\rQ#1J\u0001\tS:\u001cH/\u00198dKR!!q\u0012BJ!\r\u0011\tJK\u0007\u0002E!1!1\u0012\u0017A\u0002A\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u00053\u0013y\nE\u0002h\u00057K1A!(i\u0005\u0011)f.\u001b;\t\r\t\rU\u00061\u0001o\u0005q9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2A\fB;)\t\u00119\u000bE\u0002\u0003\u0012:\n\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\t5\u0006\u0003\u0002BX\u0005sk!A!-\u000b\t\tM&QW\u0001\u0005Y\u0006twM\u0003\u0002\u00038\u0006!!.\u0019<b\u0013\r9(\u0011W\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0013!\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW-\u0001\bue\u0016,7\t\\1tg:\u000bW.\u001a\u0011\u0015\u0007A\u0013\u0019\r\u0003\u0004\u0003\u0004R\u0002\rA\\\u0001\bMJ|Wn\u00147e)-\u0001&\u0011\u001aBg\u0005/\u0014\tOa9\t\u000f\t-W\u00071\u0001\u0003\u0010\u0005Aq\u000e\u001c3N_\u0012,G\u000eC\u0004\u0003PV\u0002\rA!5\u0002\rA\f'/\u001a8u!\r9%1[\u0005\u0004\u0005+T$!D$C)\u000ec\u0017m]:jM&,'\u000fC\u0004\u0003ZV\u0002\rAa7\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000f=\u0014i.a\n\u0002(%\u0019!q\u001c=\u0003\u00075\u000b\u0007\u000fC\u0005\u0002$U\u0002\n\u00111\u0001\u0002(!I\u00111G\u001b\u0011\u0002\u0003\u0007\u0011qE\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012\"TC\u0001BuU\u0011\t9Ca;,\u0005\t5\b\u0003\u0002Bx\u0005ol!A!=\u000b\t\tM(Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T!! 5\n\t\te(\u0011\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019\t\u0001\u0005\u0003\u00030\u000e\r\u0011\u0002BB\u0003\u0005c\u0013aa\u00142kK\u000e$\b\u0006\u0002\u0012{\u0003gBC!\t>\u0002t\u0001")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final int numTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTClassificationModel load(String string) {
        return GBTClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams.setMaxIter$(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams.setStepSize$(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        return this.isDefined(this.thresholds()) ? super.predict(features) : (this.margin(features) > 0.0 ? 1.0 : 0.0);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
        denseVector.values()[1] = 1.0 - denseVector.values()[0];
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(41).append("GBTClassificationModel (uid=").append(this.uid()).append(") with ").append(this.numTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration((RDD<LabeledPoint>)data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((GBTClassificationModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeClassifierParams.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("GBTClassificationModel given trees, treeWeights").append(new StringBuilder(44).append(" of non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString()).toString());
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
        this.loss = this.getOldLossType();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    public static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("GBTClassificationModel.load expected ").append(numTrees).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

