/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0005\n\u0001-yA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!!\u0005A!A!\u0002\u0013Y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b5\u0003A\u0011\u0001(\t\u000fY\u0003!\u0019!C\u0005/\"11\f\u0001Q\u0001\naCq\u0001\u0018\u0001C\u0002\u0013Es\u000b\u0003\u0004^\u0001\u0001\u0006I\u0001\u0017\u0005\t=\u0002A)\u0019!C\u0005?\"AA\r\u0001EC\u0002\u0013%Q\r\u0003\u0005k\u0001!\u0015\r\u0011\"\u0003l\u0011!i\u0007\u0001#b\u0001\n\u0013q\u0007\"\u00029\u0001\t\u0003\t(A\u0006'fCN$8+];be\u0016\u001c\u0018iZ4sK\u001e\fGo\u001c:\u000b\u0005M!\u0012AC1hOJ,w-\u0019;pe*\u0011QCF\u0001\u0006_B$\u0018.\u001c\u0006\u0003/a\t!!\u001c7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c2\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB!aeJ\u00150\u001b\u0005\u0011\u0012B\u0001\u0015\u0013\u0005q!\u0015N\u001a4fe\u0016tG/[1cY\u0016dun]:BO\u001e\u0014XmZ1u_J\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\f\u0002\u000f\u0019,\u0017\r^;sK&\u0011af\u000b\u0002\t\u0013:\u001cH/\u00198dKB\u0011a\u0005A\u0001\tY\u0006\u0014W\r\\*uI\u000e\u0001\u0001C\u0001\u00114\u0013\t!\u0014E\u0001\u0004E_V\u0014G.Z\u0001\nY\u0006\u0014W\r\\'fC:\fABZ5u\u0013:$XM]2faR\u0004\"\u0001\t\u001d\n\u0005e\n#a\u0002\"p_2,\u0017M\\\u0001\u000eE\u000e4U-\u0019;ve\u0016\u001c8\u000b\u001e3\u0011\u0007qz\u0014)D\u0001>\u0015\tq\u0004$A\u0005ce>\fGmY1ti&\u0011\u0001)\u0010\u0002\n\u0005J|\u0017\rZ2bgR\u00042\u0001\t\"3\u0013\t\u0019\u0015EA\u0003BeJ\f\u00170\u0001\bcG\u001a+\u0017\r^;sKNlU-\u00198\u0002\u001d\t\u001c7i\\3gM&\u001c\u0017.\u001a8ugB\u0019AhP$\u0011\u0005![U\"A%\u000b\u0005)3\u0012A\u00027j]\u0006dw-\u0003\u0002M\u0013\n1a+Z2u_J\fa\u0001P5oSRtDCB(R%N#V\u000b\u0006\u00020!\")Qi\u0002a\u0001\r\")\u0001g\u0002a\u0001e!)Qg\u0002a\u0001e!)ag\u0002a\u0001o!)!h\u0002a\u0001w!)Ai\u0002a\u0001w\u0005Ya.^7GK\u0006$XO]3t+\u0005A\u0006C\u0001\u0011Z\u0013\tQ\u0016EA\u0002J]R\fAB\\;n\r\u0016\fG/\u001e:fg\u0002\n1\u0001Z5n\u0003\u0011!\u0017.\u001c\u0011\u0002\u0017\u0019,\u0017\r^;sKN\u001cF\u000fZ\u000b\u0002\u0003\"\u0012A\"\u0019\t\u0003A\tL!aY\u0011\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AF3gM\u0016\u001cG/\u001b<f\u0007>,g-\u00118e\u001f\u001a47/\u001a;\u0016\u0003\u0019\u0004B\u0001I4He%\u0011\u0001.\t\u0002\u0007)V\u0004H.\u001a\u001a)\u00055\t\u0017aG3gM\u0016\u001cG/\u001b<f\u0007>,gMZ5dS\u0016tGo\u001d,fGR|'/F\u0001HQ\tq\u0011-\u0001\u0004pM\u001a\u001cX\r^\u000b\u0002e!\u0012q\"Y\u0001\u0004C\u0012$GCA\u0018s\u0011\u0015\u0019\b\u00031\u0001*\u0003!Ign\u001d;b]\u000e,\u0007")
public class LeastSquaresAggregator
implements DifferentiableLossAggregator<Instance, LeastSquaresAggregator> {
    private transient double[] featuresStd;
    private transient Tuple2<Vector, Object> effectiveCoefAndOffset;
    private transient Vector effectiveCoefficientsVector;
    private transient double offset;
    private final double labelStd;
    private final double labelMean;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<double[]> bcFeaturesMean;
    private final Broadcast<Vector> bcCoefficients;
    private final int numFeatures;
    private final int dim;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] featuresStd$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.featuresStd = (double[])this.bcFeaturesStd.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.featuresStd;
    }

    private double[] featuresStd() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.featuresStd$lzycompute() : this.featuresStd;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] coefficientsArray = (double[])((Vector)this.bcCoefficients.value()).toArray().clone();
                double[] featuresMean = (double[])this.bcFeaturesMean.value();
                double sum = 0.0;
                int len = coefficientsArray.length;
                for (int i = 0; i < len; ++i) {
                    if (this.featuresStd()[i] != 0.0) {
                        int n = i;
                        coefficientsArray[n] = coefficientsArray[n] / this.featuresStd()[i];
                        sum += coefficientsArray[i] * featuresMean[i];
                        continue;
                    }
                    coefficientsArray[i] = 0.0;
                }
                double offset = this.fitIntercept ? this.labelMean / this.labelStd - sum : 0.0;
                this.effectiveCoefAndOffset = new Tuple2((Object)Vectors$.MODULE$.dense(coefficientsArray), (Object)BoxesRunTime.boxToDouble((double)offset));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.effectiveCoefAndOffset;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.effectiveCoefAndOffset$lzycompute() : this.effectiveCoefAndOffset;
    }

    private Vector effectiveCoefficientsVector$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.effectiveCoefficientsVector = (Vector)this.effectiveCoefAndOffset()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.effectiveCoefficientsVector;
    }

    private Vector effectiveCoefficientsVector() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.effectiveCoefficientsVector$lzycompute() : this.effectiveCoefficientsVector;
    }

    private double offset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.offset = this.effectiveCoefAndOffset()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.offset;
    }

    private double offset() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.offset$lzycompute() : this.offset;
    }

    @Override
    public LeastSquaresAggregator add(Instance instance) {
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Dimensions mismatch when adding new sample.").append(new StringBuilder(21).append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString()).toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            double diff = BLAS$.MODULE$.dot(features, this.effectiveCoefficientsVector()) - label / this.labelStd + this.offset();
            if (diff != 0.0) {
                double[] localGradientSumArray = this.gradientSumArray();
                double[] localFeaturesStd = this.featuresStd();
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        double fStd = localFeaturesStd[index];
                        if (fStd == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + weight * diff * value / fStd;
                    }
                });
                this.lossSum_$eq(this.lossSum() + weight * diff * diff / 2.0);
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.weightSum_$eq(this.weightSum() + weight);
        LeastSquaresAggregator leastSquaresAggregator = this;
        return leastSquaresAggregator;
    }

    public LeastSquaresAggregator(double labelStd, double labelMean, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd, Broadcast<double[]> bcFeaturesMean, Broadcast<Vector> bcCoefficients) {
        this.labelStd = labelStd;
        this.labelMean = labelMean;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcFeaturesMean = bcFeaturesMean;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator.$init$(this);
        Predef$.MODULE$.require(labelStd > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(54).append(this.getClass().getName()).append(" requires the label standard ").append("deviation to be positive.").toString());
        this.numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.dim = this.numFeatures();
    }
}

