/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r%c\u0001\u0002!B\u00011C\u0001\"\u0019\u0001\u0003\u0006\u0004%\tE\u0019\u0005\ts\u0002\u0011\t\u0011)A\u0005G\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003R\u0011)\t\t\u0001\u0001BC\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001\u0002CA\n\u0001\u0011\u00051)!\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!Q\u0011q\u0006\u0001\t\u0006\u0004%I!!\r\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011\u0011\t\u0001\u0005\n\u0005%\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\u0019\u000b\u0001C)\u0003KC\u0011\"a-\u0001\u0001\u0004%I!!.\t\u0013\u0005\r\u0007\u00011A\u0005\n\u0005\u0015\u0007\u0002CAi\u0001\u0001\u0006K!a.\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007\u0002CAs\u0001\u0011\u0005\u0011)a:\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B\r\u0001\u0011\u0005#1\u0004\u0005\n\u0005K\u0001!\u0019!C!\u0005OA\u0001Ba\f\u0001A\u0003%!\u0011F\u0004\b\u0005w\t\u0005\u0012\u0001B\u001f\r\u0019\u0001\u0015\t#\u0001\u0003@!9\u00111C\u000e\u0005\u0002\tM\u0003b\u0002B+7\u0011\u0005#q\u000b\u0005\b\u0005CZB\u0011\tB2\r\u001d\u0011Yg\u0007\u0001\u001c\u0005[B\u0011Ba\u001f \u0005\u0003\u0005\u000b\u0011B,\t\u000f\u0005Mq\u0004\"\u0001\u0003~\u00191!QQ\u0010E\u0005\u000fC!\"!\u0001#\u0005+\u0007I\u0011AA\u0002\u0011)\tyA\tB\tB\u0003%\u0011Q\u0001\u0005\tw\n\u0012)\u001a!C\u0001y\"AaP\tB\tB\u0003%\u0011\u000bC\u0004\u0002\u0014\t\"\tAa$\t\u0013\t\r!%!A\u0005\u0002\te\u0005\"\u0003BPEE\u0005I\u0011\u0001BQ\u0011%\u0011)LII\u0001\n\u0003\u00119\fC\u0005\u0003<\n\n\t\u0011\"\u0011\u0003>\"I!Q\u001a\u0012\u0002\u0002\u0013\u0005!q\u0005\u0005\n\u0005\u001f\u0014\u0013\u0011!C\u0001\u0005#D\u0011B!6#\u0003\u0003%\tEa6\t\u0013\t\u0015(%!A\u0005\u0002\t\u001d\b\"\u0003BvE\u0005\u0005I\u0011\tBw\u0011%\u0011yOIA\u0001\n\u0003\u0012\t\u0010C\u0005\u0003t\n\n\t\u0011\"\u0011\u0003v\u001eI!\u0011`\u0010\u0002\u0002#%!1 \u0004\n\u0005\u000b{\u0012\u0011!E\u0005\u0005{Dq!a\u00055\t\u0003\u0019Y\u0001C\u0005\u0003pR\n\t\u0011\"\u0012\u0003r\"I1Q\u0002\u001b\u0002\u0002\u0013\u00055q\u0002\u0005\n\u0007+!\u0014\u0011!CA\u0007/Aqa!\n \t#\u001a9C\u0002\u0004\u0004,m!1Q\u0006\u0005\b\u0003'QD\u0011AB\u0018\u0011%\u0019\u0019D\u000fb\u0001\n\u0013\u0011i\f\u0003\u0005\u00046i\u0002\u000b\u0011\u0002B`\u0011\u001d\u0011\tG\u000fC!\u0007oA\u0011ba\u000f\u001c\u0003\u0003%Ia!\u0010\u0003A\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003\u0005\u000e\u000b!B]3he\u0016\u001c8/[8o\u0015\t!U)\u0001\u0002nY*\u0011aiR\u0001\u0006gB\f'o\u001b\u0006\u0003\u0011&\u000ba!\u00199bG\",'\"\u0001&\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001i\u0005l\u0017\t\u0005\u001d>\u000bv+D\u0001B\u0013\t\u0001\u0016IA\bSK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u0011V+D\u0001T\u0015\t!6)\u0001\u0004mS:\fGnZ\u0005\u0003-N\u0013aAV3di>\u0014\bC\u0001(\u0001!\tq\u0015,\u0003\u0002[\u0003\nyr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u0014\u0015m]3\u0011\u0005q{V\"A/\u000b\u0005y\u001b\u0015\u0001B;uS2L!\u0001Y/\u0003\u00155cuK]5uC\ndW-A\u0002vS\u0012,\u0012a\u0019\t\u0003I6t!!Z6\u0011\u0005\u0019LW\"A4\u000b\u0005!\\\u0015A\u0002\u001fs_>$hHC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017.\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017jQ\r\t\u0011o\u001e\t\u0003eVl\u0011a\u001d\u0006\u0003i\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\t18OA\u0003TS:\u001cW-I\u0001y\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t\tx/\u0001\u0007d_\u00164g-[2jK:$8/F\u0001RQ\r\u0019\u0011o^\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\u0007\u0011\tx/A\u0005j]R,'oY3qiV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI!D\u0001j\u0013\r\tY!\u001b\u0002\u0007\t>,(\r\\3)\u0007\u0015\tx/\u0001\u0006j]R,'oY3qi\u0002B3AB9x\u0003\u0019a\u0014N\\5u}Q9q+a\u0006\u0002\u001c\u0005}\u0001\"B1\b\u0001\u0004\u0019\u0007\u0006BA\fc^DQa_\u0004A\u0002ECC!a\u0007ro\"9\u0011\u0011A\u0004A\u0002\u0005\u0015\u0001\u0006BA\u0010c^\fAc]3u\u0019&t7\u000e\u0015:fI&\u001cG/[8o\u0007>dG\u0003BA\u0014\u0003Si\u0011\u0001\u0001\u0005\u0007\u0003WA\u0001\u0019A2\u0002\u000bY\fG.^3)\u0007!\tx/A\u0007gC6LG._!oI2Kgn[\u000b\u0003\u0003g\u0001B!!\u000e\u0002<9\u0019a*a\u000e\n\u0007\u0005e\u0012)A\u000eHK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\\u0005\u0005\u0003{\tyDA\u0007GC6LG._!oI2Kgn\u001b\u0006\u0004\u0003s\t\u0015a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003\u000b\t)\u0005\u0003\u0004\u0002H)\u0001\r!U\u0001\tM\u0016\fG/\u001e:fgR1\u0011QAA&\u0003\u001bBa!a\u0012\f\u0001\u0004\t\u0006bBA(\u0017\u0001\u0007\u0011QA\u0001\u0007_\u001a47/\u001a;\u0002\u0017A\u0014X\rZ5di2Kgn\u001b\u000b\u0007\u0003\u000b\t)&a\u0016\t\r\u0005\u001dC\u00021\u0001R\u0011\u001d\ty\u0005\u0004a\u0001\u0003\u000b\t\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005u\u0013q\u0010\t\u0005\u0003?\nIH\u0004\u0003\u0002b\u0005Md\u0002BA2\u0003_rA!!\u001a\u0002n9!\u0011qMA6\u001d\r1\u0017\u0011N\u0005\u0002\u0015&\u0011\u0001*S\u0005\u0003\r\u001eK1!!\u001dF\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003k\n9(A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005ET)\u0003\u0003\u0002|\u0005u$!\u0003#bi\u00064%/Y7f\u0015\u0011\t)(a\u001e\t\u000f\u0005\u0005U\u00021\u0001\u0002\u0004\u00069A-\u0019;bg\u0016$\b\u0007BAC\u0003#\u0003b!a\"\u0002\n\u00065UBAA<\u0013\u0011\tY)a\u001e\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qRAI\u0019\u0001!A\"a%\u0002\u0000\u0005\u0005\t\u0011!B\u0001\u0003+\u00131a\u0018\u00133#\u0011\t9*!(\u0011\t\u0005\u001d\u0011\u0011T\u0005\u0004\u00037K'a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u000f\ty*C\u0002\u0002\"&\u00141!\u00118z\u00035!(/\u00198tM>\u0014X.S7qYR!\u0011QLAT\u0011\u001d\t\tI\u0004a\u0001\u0003S\u0003D!a+\u00020B1\u0011qQAE\u0003[\u0003B!a$\u00020\u0012a\u0011\u0011WAT\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\n\u0019q\fJ\u001a\u0002\u001fQ\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef,\"!a.\u0011\r\u0005\u001d\u0011\u0011XA_\u0013\r\tY,\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00079\u000by,C\u0002\u0002B\u0006\u0013!fR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\nue\u0006Lg.\u001b8h'VlW.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002H\u00065\u0007\u0003BA\u0004\u0003\u0013L1!a3j\u0005\u0011)f.\u001b;\t\u0013\u0005=\u0007#!AA\u0002\u0005]\u0016a\u0001=%c\u0005\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010I\u0001\bgVlW.\u0019:z+\t\ti\fK\u0002\u0013c^\f!\u0002[1t'VlW.\u0019:z+\t\ti\u000e\u0005\u0003\u0002\b\u0005}\u0017bAAqS\n9!i\\8mK\u0006t\u0007fA\nro\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\t\u0005\u001d\u0012\u0011\u001e\u0005\b\u0003'$\u0002\u0019AA\\\u0003!)g/\u00197vCR,G\u0003BAx\u0003k\u00042ATAy\u0013\r\t\u00190\u0011\u0002#\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u000f\u0005\u0005U\u00031\u0001\u0002xB\"\u0011\u0011`A\u007f!\u0019\t9)!#\u0002|B!\u0011qRA\u007f\t1\ty0!>\u0002\u0002\u0003\u0005)\u0011AAK\u0005\ryF\u0005\u000e\u0015\u0004+E<\u0018\u0001B2paf$2a\u0016B\u0004\u0011\u001d\u0011IA\u0006a\u0001\u0005\u0017\tQ!\u001a=ue\u0006\u0004BA!\u0004\u0003\u00145\u0011!q\u0002\u0006\u0004\u0005#\u0019\u0015!\u00029be\u0006l\u0017\u0002\u0002B\u000b\u0005\u001f\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004-E<\u0018!B<sSR,WC\u0001B\u000f!\ra&qD\u0005\u0004\u0005Ci&\u0001C'M/JLG/\u001a:)\u0007]\tx/A\u0006ok64U-\u0019;ve\u0016\u001cXC\u0001B\u0015!\u0011\t9Aa\u000b\n\u0007\t5\u0012NA\u0002J]R\fAB\\;n\r\u0016\fG/\u001e:fg\u0002B3\u0001A9xQ\r\u0001!Q\u0007\t\u0004e\n]\u0012b\u0001B\u001dg\naQ\t\u001f9fe&lWM\u001c;bY\u0006\u0001s)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tq5dE\u0004\u001c\u0005\u0003\u00129E!\u0014\u0011\t\u0005\u001d!1I\u0005\u0004\u0005\u000bJ'AB!osJ+g\r\u0005\u0003]\u0005\u0013:\u0016b\u0001B&;\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\u0005\u001d!qJ\u0005\u0004\u0005#J'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u001f\u0003\u0011\u0011X-\u00193\u0016\u0005\te\u0003\u0003\u0002/\u0003\\]K1A!\u0018^\u0005!iEJU3bI\u0016\u0014\bfA\u000fro\u0006!An\\1e)\r9&Q\r\u0005\u0007\u0005Or\u0002\u0019A2\u0002\tA\fG\u000f\u001b\u0015\u0004=E<(AJ$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3beJ+wM]3tg&|g.T8eK2<&/\u001b;feN)qD!\b\u0003pA!!\u0011\u000fB<\u001b\t\u0011\u0019HC\u0002\u0003v\u0015\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005s\u0012\u0019HA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016$BAa \u0003\u0004B\u0019!\u0011Q\u0010\u000e\u0003mAaAa\u001f\"\u0001\u00049&\u0001\u0002#bi\u0006\u001crA\tB!\u0005\u0013\u0013i\u0005\u0005\u0003\u0002\b\t-\u0015b\u0001BGS\n9\u0001K]8ek\u000e$HC\u0002BI\u0005+\u00139\nE\u0002\u0003\u0014\nj\u0011a\b\u0005\b\u0003\u00039\u0003\u0019AA\u0003\u0011\u0015Yx\u00051\u0001R)\u0019\u0011\tJa'\u0003\u001e\"I\u0011\u0011\u0001\u0015\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\bw\"\u0002\n\u00111\u0001R\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa)+\t\u0005\u0015!QU\u0016\u0003\u0005O\u0003BA!+\u000326\u0011!1\u0016\u0006\u0005\u0005[\u0013y+A\u0005v]\u000eDWmY6fI*\u0011A/[\u0005\u0005\u0005g\u0013YKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003:*\u001a\u0011K!*\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011y\f\u0005\u0003\u0003B\n-WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013\fAA[1wC&\u0019aNa1\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0014Bj\u0011%\ty-LA\u0001\u0002\u0004\u0011I#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u000e\u0005\u0004\u0003\\\n\u0005\u0018QT\u0007\u0003\u0005;T1Aa8j\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0014iN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAo\u0005SD\u0011\"a40\u0003\u0003\u0005\r!!(\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa0\u0002\r\u0015\fX/\u00197t)\u0011\tiNa>\t\u0013\u0005=''!AA\u0002\u0005u\u0015\u0001\u0002#bi\u0006\u00042Aa%5'\u0015!$q B'!%\u0019\taa\u0002\u0002\u0006E\u0013\t*\u0004\u0002\u0004\u0004)\u00191QA5\u0002\u000fI,h\u000e^5nK&!1\u0011BB\u0002\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005w\fQ!\u00199qYf$bA!%\u0004\u0012\rM\u0001bBA\u0001o\u0001\u0007\u0011Q\u0001\u0005\u0006w^\u0002\r!U\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Ib!\t\u0011\r\u0005\u001d\u0011\u0011XB\u000e!\u001d\t9a!\b\u0002\u0006EK1aa\bj\u0005\u0019!V\u000f\u001d7fe!I11\u0005\u001d\u0002\u0002\u0003\u0007!\u0011S\u0001\u0004q\u0012\u0002\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005\u001d7\u0011\u0006\u0005\u0007\u0005OJ\u0004\u0019A2\u0003M\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002;\u00053\"\"a!\r\u0011\u0007\t\u0005%(A\u0005dY\u0006\u001c8OT1nK\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0015\u0007]\u001bI\u0004\u0003\u0004\u0003hy\u0002\raY\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004@A!!\u0011YB!\u0013\u0011\u0019\u0019Ea1\u0003\r=\u0013'.Z2uQ\rY\u0012o\u001e\u0015\u00045E<\b")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable {
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> family;
    private final DoubleParam variancePower;
    private final Param<String> link;
    private final DoubleParam linkPower;
    private final Param<String> linkPredictionCol;
    private final Param<String> offsetCol;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase.getFamily$(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase.getVariancePower$(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase.getLink$(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase.getLinkPower$(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.getLinkPredictionCol$(this);
    }

    @Override
    public String getOffsetCol() {
        return GeneralizedLinearRegressionBase.getOffsetCol$(this);
    }

    @Override
    public boolean hasWeightCol() {
        return GeneralizedLinearRegressionBase.hasWeightCol$(this);
    }

    @Override
    public boolean hasOffsetCol() {
        return GeneralizedLinearRegressionBase.hasOffsetCol$(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase.hasLinkPredictionCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public final Param<String> offsetCol() {
        return this.offsetCol;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param<String> x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param<String> x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$offsetCol_$eq(Param<String> x$1) {
        this.offsetCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
        }
        return this.familyAndLink;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return !this.bitmap$0 ? this.familyAndLink$lzycompute() : this.familyAndLink;
    }

    @Override
    public double predict(Vector features) {
        return this.predict(features, 0.0);
    }

    private double predict(Vector features, double offset) {
        double eta = this.predictLink(features, offset);
        return this.familyAndLink().fitted(eta);
    }

    private double predictLink(Vector features, double offset) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept() + offset;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Dataset output;
        block1: {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predict(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictLinkUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(features, offset) -> BoxesRunTime.boxToDouble((double)this.predictLink(features, BoxesRunTime.unboxToDouble((Object)offset))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
            Column offset2 = !this.hasOffsetCol() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)) : functions$.MODULE$.col(this.$(this.offsetCol())).cast((DataType)DoubleType$.MODULE$);
            output = dataset;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                output = output.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})));
            }
            if (!this.hasLinkPredictionCol()) break block1;
            output = output.withColumn(this.$(this.linkPredictionCol()), predictLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset2})));
        }
        return output.toDF();
    }

    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this GeneralizedLinearRegressionModel");
        });
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GeneralizedLinearRegressionModel setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasFitIntercept.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        GeneralizedLinearRegressionBase.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients.size();
    }

    public static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients, intercept);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data$module;
        private final GeneralizedLinearRegressionModel instance;

        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                }
            }
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients) {
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

