/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeModelReadWrite$ {
    public static DecisionTreeModelReadWrite$ MODULE$;

    static {
        new DecisionTreeModelReadWrite$();
    }

    public Node loadTreeNodes(String path, DefaultParamsReader.Metadata metadata, SparkSession sparkSession) {
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        JsonAST.JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, (Formats)format)));
        String dataPath = new Path(path, "data").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator4$1() {
            }
        }
        Dataset data = sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator4$1())));
        return this.buildTreeFromNodes((DecisionTreeModelReadWrite.NodeData[])data.collect(), impurityType);
    }

    public Node buildTreeFromNodes(DecisionTreeModelReadWrite.NodeData[] data, String impurityType) {
        DecisionTreeModelReadWrite.NodeData[] nodes = (DecisionTreeModelReadWrite.NodeData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.id()), (Ordering)Ordering.Int$.MODULE$);
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).head()).id() == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Decision Tree load failed.  Expected smallest node ID to be 0,").append(new StringBuilder(11).append(" but found ").append(((DecisionTreeModelReadWrite.NodeData)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).head()).id()).toString()).toString());
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).last()).id() == nodes.length - 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Decision Tree load failed.  Expected largest").append(new StringBuilder(27).append(" node ID to be ").append(nodes.length - 1).append(", but found ").append(((DecisionTreeModelReadWrite.NodeData)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).last()).id()).toString()).toString());
        Node[] finalNodes = new Node[nodes.length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).reverseIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DecisionTreeModelReadWrite$.$anonfun$buildTreeFromNodes$4(impurityType, finalNodes, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Node)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalNodes)).head();
    }

    public static final /* synthetic */ void $anonfun$buildTreeFromNodes$4(String impurityType$1, Node[] finalNodes$1, DecisionTreeModelReadWrite.NodeData x0$1) {
        Node node;
        DecisionTreeModelReadWrite.NodeData nodeData = x0$1;
        if (nodeData != null) {
            DecisionTreeModelReadWrite.NodeData nodeData2 = nodeData;
            ImpurityCalculator impurityStats = ImpurityCalculator$.MODULE$.getCalculator(impurityType$1, nodeData2.impurityStats());
            if (nodeData2.leftChild() != -1) {
                Node leftChild = finalNodes$1[nodeData2.leftChild()];
                Node rightChild = finalNodes$1[nodeData2.rightChild()];
                node = new InternalNode(nodeData2.prediction(), nodeData2.impurity(), nodeData2.gain(), leftChild, rightChild, nodeData2.split().getSplit(), impurityStats);
            } else {
                node = new LeafNode(nodeData2.prediction(), nodeData2.impurity(), impurityStats);
            }
        } else {
            throw new MatchError((Object)nodeData);
        }
        LeafNode node2 = node;
        finalNodes$1[nodeData2.id()] = node2;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DecisionTreeModelReadWrite$() {
        MODULE$ = this;
    }
}

