/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.EntropyAggregator;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniAggregator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityAggregator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.impurity.VarianceAggregator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u000e\u001d\u0001\tB\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011e\u0002!\u0011!Q\u0001\nUB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019!\u0006\u0001)A\u0005\u0017\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB,\u0001A\u0003%\u0011\tC\u0004Y\u0001\t\u0007I\u0011B-\t\ri\u0003\u0001\u0015!\u0003?\u0011\u001dY\u0006A1A\u0005\neCa\u0001\u0018\u0001!\u0002\u0013q\u0004bB/\u0001\u0005\u0004%IA\u0016\u0005\u0007=\u0002\u0001\u000b\u0011B!\t\u000f}\u0003!\u0019!C\u0005A\"1Q\r\u0001Q\u0001\n\u0005DqA\u001a\u0001C\u0002\u0013%\u0001\r\u0003\u0004h\u0001\u0001\u0006I!\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0005E!Ek\u0015;biN\fum\u001a:fO\u0006$xN\u001d\u0006\u0003;y\tA![7qY*\u0011q\u0004I\u0001\u0005iJ,WM\u0003\u0002\"E\u0005\u0011Q\u000e\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sON\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\tQ\u0003'\u0003\u00022W\ta1+\u001a:jC2L'0\u00192mK\u0006AQ.\u001a;bI\u0006$\u0018m\u0001\u0001\u0016\u0003U\u0002\"AN\u001c\u000e\u0003qI!\u0001\u000f\u000f\u0003)\u0011+7-[:j_:$&/Z3NKR\fG-\u0019;b\u0003%iW\r^1eCR\f\u0007%A\u0007gK\u0006$XO]3Tk\n\u001cX\r\u001e\t\u0004Uqr\u0014BA\u001f,\u0005\u0019y\u0005\u000f^5p]B\u0019!fP!\n\u0005\u0001[#!B!se\u0006L\bC\u0001\u0016C\u0013\t\u00195FA\u0002J]R\fa\u0001P5oSRtDc\u0001$H\u0011B\u0011a\u0007\u0001\u0005\u0006e\u0011\u0001\r!\u000e\u0005\u0006u\u0011\u0001\raO\u0001\u0013S6\u0004XO]5us\u0006;wM]3hCR|'/F\u0001L!\ta%+D\u0001N\u0015\tqu*\u0001\u0005j[B,(/\u001b;z\u0015\ty\u0002K\u0003\u0002RE\u0005)Q\u000e\u001c7jE&\u00111+\u0014\u0002\u0013\u00136\u0004XO]5us\u0006;wM]3hCR|'/A\nj[B,(/\u001b;z\u0003\u001e<'/Z4bi>\u0014\b%A\u0005ti\u0006$8oU5{KV\t\u0011)\u0001\u0006ti\u0006$8oU5{K\u0002\nqA\\;n\u0005&t7/F\u0001?\u0003!qW/\u001c\"j]N\u0004\u0013A\u00044fCR,(/Z(gMN,Go]\u0001\u0010M\u0016\fG/\u001e:f\u001f\u001a47/\u001a;tA\u0005a\u0011\r\u001c7Ti\u0006$8oU5{K\u0006i\u0011\r\u001c7Ti\u0006$8oU5{K\u0002\n\u0001\"\u00197m'R\fGo]\u000b\u0002CB\u0019!f\u00102\u0011\u0005)\u001a\u0017B\u00013,\u0005\u0019!u.\u001e2mK\u0006I\u0011\r\u001c7Ti\u0006$8\u000fI\u0001\fa\u0006\u0014XM\u001c;Ti\u0006$8/\u0001\u0007qCJ,g\u000e^*uCR\u001c\b%A\u000bhKRLU\u000e];sSRL8)\u00197dk2\fGo\u001c:\u0015\u0007)lw\u000e\u0005\u0002MW&\u0011A.\u0014\u0002\u0013\u00136\u0004XO]5us\u000e\u000bGnY;mCR|'\u000fC\u0003o'\u0001\u0007\u0011)A\u0007gK\u0006$XO]3PM\u001a\u001cX\r\u001e\u0005\u0006aN\u0001\r!Q\u0001\tE&t\u0017J\u001c3fq\u0006Yr-\u001a;QCJ,g\u000e^%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_J$\u0012A[\u0001\u0007kB$\u0017\r^3\u0015\u000bUD(p_?\u0011\u0005)2\u0018BA<,\u0005\u0011)f.\u001b;\t\u000be,\u0002\u0019A!\u0002\u0019\u0019,\u0017\r^;sK&sG-\u001a=\t\u000bA,\u0002\u0019A!\t\u000bq,\u0002\u0019\u00012\u0002\u000b1\f'-\u001a7\t\u000by,\u0002\u0019\u00012\u0002\u001d%t7\u000f^1oG\u0016<V-[4ii\u0006aQ\u000f\u001d3bi\u0016\u0004\u0016M]3oiR)Q/a\u0001\u0002\u0006!)AP\u0006a\u0001E\")aP\u0006a\u0001E\u0006ia-Z1ukJ,W\u000b\u001d3bi\u0016$\u0012\"^A\u0006\u0003\u001b\ty!!\u0005\t\u000b9<\u0002\u0019A!\t\u000bA<\u0002\u0019A!\t\u000bq<\u0002\u0019\u00012\t\u000by<\u0002\u0019\u00012\u0002!\u001d,GOR3biV\u0014Xm\u00144gg\u0016$HcA!\u0002\u0018!)\u0011\u0010\u0007a\u0001\u0003\u0006yQ.\u001a:hK\u001a{'OR3biV\u0014X\rF\u0004v\u0003;\ty\"!\t\t\u000b9L\u0002\u0019A!\t\u000bAL\u0002\u0019A!\t\r\u0005\r\u0012\u00041\u0001B\u00035yG\u000f[3s\u0005&t\u0017J\u001c3fq\u0006)Q.\u001a:hKR\u0019a)!\u000b\t\r\u0005-\"\u00041\u0001G\u0003\u0015yG\u000f[3s\u0001")
public class DTStatsAggregator
implements scala.Serializable {
    private final DecisionTreeMetadata metadata;
    private final ImpurityAggregator impurityAggregator;
    private final int statsSize;
    private final int[] numBins;
    private final int[] featureOffsets;
    private final int allStatsSize;
    private final double[] allStats;
    private final double[] parentStats;

    public DecisionTreeMetadata metadata() {
        return this.metadata;
    }

    public ImpurityAggregator impurityAggregator() {
        return this.impurityAggregator;
    }

    private int statsSize() {
        return this.statsSize;
    }

    private int[] numBins() {
        return this.numBins;
    }

    private int[] featureOffsets() {
        return this.featureOffsets;
    }

    private int allStatsSize() {
        return this.allStatsSize;
    }

    private double[] allStats() {
        return this.allStats;
    }

    private double[] parentStats() {
        return this.parentStats;
    }

    public ImpurityCalculator getImpurityCalculator(int featureOffset, int binIndex) {
        return this.impurityAggregator().getCalculator(this.allStats(), featureOffset + binIndex * this.statsSize());
    }

    public ImpurityCalculator getParentImpurityCalculator() {
        return this.impurityAggregator().getCalculator(this.parentStats(), 0);
    }

    public void update(int featureIndex, int binIndex, double label, double instanceWeight) {
        int i = this.featureOffsets()[featureIndex] + binIndex * this.statsSize();
        this.impurityAggregator().update(this.allStats(), i, label, instanceWeight);
    }

    public void updateParent(double label, double instanceWeight) {
        this.impurityAggregator().update(this.parentStats(), 0, label, instanceWeight);
    }

    public void featureUpdate(int featureOffset, int binIndex, double label, double instanceWeight) {
        this.impurityAggregator().update(this.allStats(), featureOffset + binIndex * this.statsSize(), label, instanceWeight);
    }

    public int getFeatureOffset(int featureIndex) {
        return this.featureOffsets()[featureIndex];
    }

    public void mergeForFeature(int featureOffset, int binIndex, int otherBinIndex) {
        this.impurityAggregator().merge(this.allStats(), featureOffset + binIndex * this.statsSize(), featureOffset + otherBinIndex * this.statsSize());
    }

    public DTStatsAggregator merge(DTStatsAggregator other) {
        Predef$.MODULE$.require(this.allStatsSize() == other.allStatsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("DTStatsAggregator.merge requires that both aggregators have the same length stats vectors.").append(new StringBuilder(50).append(" This aggregator is of length ").append(this.allStatsSize()).append(", but the other is ").append(other.allStatsSize()).append(".").toString()).toString());
        for (int i = 0; i < this.allStatsSize(); ++i) {
            int n = i;
            this.allStats()[n] = this.allStats()[n] + other.allStats()[i];
        }
        Predef$.MODULE$.require(this.statsSize() == other.statsSize(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("DTStatsAggregator.merge requires that both aggregators have the same length parent ").append(new StringBuilder(59).append("stats vectors. This aggregator's parent stats are length ").append(this.statsSize()).append(", ").toString()).append(new StringBuilder(18).append("but the other is ").append(other.statsSize()).append(".").toString()).toString());
        for (int j = 0; j < this.statsSize(); ++j) {
            int n = j;
            this.parentStats()[n] = this.parentStats()[n] + other.parentStats()[j];
        }
        return this;
    }

    public DTStatsAggregator(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        ImpurityAggregator impurityAggregator;
        this.metadata = metadata;
        Impurity impurity = metadata.impurity();
        if (Gini$.MODULE$.equals(impurity)) {
            impurityAggregator = new GiniAggregator(metadata.numClasses());
        } else if (Entropy$.MODULE$.equals(impurity)) {
            impurityAggregator = new EntropyAggregator(metadata.numClasses());
        } else if (Variance$.MODULE$.equals(impurity)) {
            impurityAggregator = new VarianceAggregator();
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad impurity parameter: ").append(metadata.impurity()).toString());
        }
        this.impurityAggregator = impurityAggregator;
        this.statsSize = this.impurityAggregator().statsSize();
        this.numBins = featureSubset.isDefined() ? (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])featureSubset.get())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$1 -> this.metadata().numBins()[x$1], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())) : metadata.numBins();
        this.featureOffsets = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.numBins())).scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(total, nBins) -> total + this.statsSize() * nBins, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.allStatsSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.featureOffsets())).last());
        this.allStats = new double[this.allStatsSize()];
        this.parentStats = new double[this.statsSize()];
    }
}

