/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.api.python.SerDeBase;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uvAB\u0012%\u0011\u0003Q\u0003G\u0002\u00043I!\u0005!f\r\u0005\u0006{\u0005!\ta\u0010\u0005\b\u0001\u0006\u0011\r\u0011\"\u0011B\u0011\u0019Q\u0015\u0001)A\u0005\u0005\u001a)1*\u0001\u0001%\u0019\")Q(\u0002C\u0001/\")\u0011,\u0002C\u00015\")q/\u0002C\u0001q\u001a)a0\u0001\u0001%\u007f\"1Q(\u0003C\u0001\u0003\u0013Aa!W\u0005\u0005\u0002\u00055\u0001BB<\n\t\u0003\t)BB\u0004\u0002\u001a\u0005\u0001A%a\u0007\t\rujA\u0011AA\u0013\u0011\u0019IV\u0002\"\u0001\u0002*!1q/\u0004C\u0001\u0003c1q!!\u000e\u0002\u0001\u0011\n9\u0004\u0003\u0004>#\u0011\u0005\u0011\u0011\t\u0005\u00073F!\t!!\u0012\t\r]\fB\u0011AA'\r\u001d\t\t&\u0001\u0001%\u0003'Ba!P\u000b\u0005\u0002\u0005\r\u0004BB-\u0016\t\u0003\t9\u0007\u0003\u0004x+\u0011\u0005\u0011q\u000e\u0004\b\u0003g\n\u0001\u0001JA;\u0011\u0019i\u0014\u0004\"\u0001\u0002\u0006\"1\u0011,\u0007C\u0001\u0003\u0013Caa^\r\u0005\u0002\u0005E\u0005bBAK3\u0011%\u0011q\u0013\u0005\n\u0003C\u000b\u0001\u0019!C\u0001\u0003GC\u0011\"a+\u0002\u0001\u0004%\t!!,\t\u0011\u0005M\u0016\u0001)Q\u0005\u0003KCq!!.\u0002\t\u0003\n9\fC\u0005\u0002:\u0006\t\t\u0011\"\u0003\u0002<\u0006)1+\u001a:EK*\u0011QEJ\u0001\u0007af$\bn\u001c8\u000b\u0005\u001dB\u0013aA1qS*\u0011\u0011FK\u0001\u0006[2d\u0017N\u0019\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sOB\u0011\u0011'A\u0007\u0002I\t)1+\u001a:EKN\u0019\u0011\u0001N\u001c\u0011\u0005E*\u0014B\u0001\u001c%\u0005%\u0019VM\u001d#f\u0005\u0006\u001cX\r\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0014a\u0004)Z'B\u000b%kS0Q\u0003\u000e[\u0015iR#\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004TiJLgnZ\u0001\u0011!f\u001b\u0006+\u0011*L?B\u000b5iS!H\u000b\u0002\u0012!\u0003R3og\u00164Vm\u0019;peBK7m\u001b7feN\u0011Q!\u0014\t\u0004\u001d>\u000bV\"A\u0001\n\u0005A+$a\u0003\"bg\u0016\u0004\u0016nY6mKJ\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0015\u0002\r1Lg.\u00197h\u0013\t16KA\u0006EK:\u001cXMV3di>\u0014H#\u0001-\u0011\u00059+\u0011!C:bm\u0016\u001cF/\u0019;f)\u0011YflY6\u0011\u0005ab\u0016BA/:\u0005\u0011)f.\u001b;\t\u000b};\u0001\u0019\u00011\u0002\u0007=\u0014'\u000e\u0005\u0002DC&\u0011!\r\u0012\u0002\u0007\u001f\nTWm\u0019;\t\u000b\u0011<\u0001\u0019A3\u0002\u0007=,H\u000f\u0005\u0002gS6\tqM\u0003\u0002i\r\u0006\u0011\u0011n\\\u0005\u0003U\u001e\u0014AbT;uaV$8\u000b\u001e:fC6DQ\u0001\\\u0004A\u00025\fq\u0001]5dW2,'\u000f\u0005\u0002ok6\tqN\u0003\u0002qc\u00061\u0001/[2lY\u0016T!A]:\u0002\u0013I\f'p\u001c:wS:,'\"\u0001;\u0002\u00079,G/\u0003\u0002w_\n9\u0001+[2lY\u0016\u0014\u0018!C2p]N$(/^2u)\t\u0001\u0017\u0010C\u0003{\u0011\u0001\u000710\u0001\u0003be\u001e\u001c\bc\u0001\u001d}A&\u0011Q0\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0002\u0013\t\u0016t7/Z'biJL\u0007\u0010U5dW2,'oE\u0002\n\u0003\u0003\u0001BAT(\u0002\u0004A\u0019!+!\u0002\n\u0007\u0005\u001d1KA\u0006EK:\u001cX-T1ue&DHCAA\u0006!\tq\u0015\u0002F\u0004\\\u0003\u001f\t\t\"a\u0005\t\u000b}[\u0001\u0019\u00011\t\u000b\u0011\\\u0001\u0019A3\t\u000b1\\\u0001\u0019A7\u0015\u0007\u0001\f9\u0002C\u0003{\u0019\u0001\u00071PA\nTa\u0006\u00148/Z'biJL\u0007\u0010U5dW2,'oE\u0002\u000e\u0003;\u0001BAT(\u0002 A\u0019!+!\t\n\u0007\u0005\r2K\u0001\u0007Ta\u0006\u00148/Z'biJL\u0007\u0010\u0006\u0002\u0002(A\u0011a*\u0004\u000b\b7\u0006-\u0012QFA\u0018\u0011\u0015yv\u00021\u0001a\u0011\u0015!w\u00021\u0001f\u0011\u0015aw\u00021\u0001n)\r\u0001\u00171\u0007\u0005\u0006uB\u0001\ra\u001f\u0002\u0014'B\f'o]3WK\u000e$xN\u001d)jG.dWM]\n\u0004#\u0005e\u0002\u0003\u0002(P\u0003w\u00012AUA\u001f\u0013\r\tyd\u0015\u0002\r'B\f'o]3WK\u000e$xN\u001d\u000b\u0003\u0003\u0007\u0002\"AT\t\u0015\u000fm\u000b9%!\u0013\u0002L!)ql\u0005a\u0001A\")Am\u0005a\u0001K\")An\u0005a\u0001[R\u0019\u0001-a\u0014\t\u000bi$\u0002\u0019A>\u0003'1\u000b'-\u001a7fIB{\u0017N\u001c;QS\u000e\\G.\u001a:\u0014\u0007U\t)\u0006\u0005\u0003O\u001f\u0006]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u0003&\u0001\u0006sK\u001e\u0014Xm]:j_:LA!!\u0019\u0002\\\taA*\u00192fY\u0016$\u0007k\\5oiR\u0011\u0011Q\r\t\u0003\u001dV!raWA5\u0003W\ni\u0007C\u0003`/\u0001\u0007\u0001\rC\u0003e/\u0001\u0007Q\rC\u0003m/\u0001\u0007Q\u000eF\u0002a\u0003cBQA\u001f\rA\u0002m\u0014QBU1uS:<\u0007+[2lY\u0016\u00148cA\r\u0002xA!ajTA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@Q\u0005q!/Z2p[6,g\u000eZ1uS>t\u0017\u0002BAB\u0003{\u0012aAU1uS:<GCAAD!\tq\u0015\u0004F\u0004\\\u0003\u0017\u000bi)a$\t\u000b}[\u0002\u0019\u00011\t\u000b\u0011\\\u0002\u0019A3\t\u000b1\\\u0002\u0019A7\u0015\u0007\u0001\f\u0019\nC\u0003{9\u0001\u000710\u0001\nsCRLgnZ:JI\u000eCWmY6M_:<G\u0003BAM\u0003?\u00032\u0001OAN\u0013\r\ti*\u000f\u0002\u0004\u0013:$\b\"B0\u001e\u0001\u0004\u0001\u0017aC5oSRL\u0017\r\\5{K\u0012,\"!!*\u0011\u0007a\n9+C\u0002\u0002*f\u0012qAQ8pY\u0016\fg.A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\rY\u0016q\u0016\u0005\n\u0003c{\u0012\u0011!a\u0001\u0003K\u000b1\u0001\u001f\u00132\u00031Ig.\u001b;jC2L'0\u001a3!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u00027\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\u0007")
public final class SerDe {
    public static void initialize() {
        SerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        SerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return SerDe$.MODULE$.initialized();
    }

    public static String PYSPARK_PACKAGE() {
        return SerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return SerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return SerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return SerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return SerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return SerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return SerDe$.MODULE$.dumps(object);
    }

    public static class DenseMatrixPickler
    extends SerDeBase.BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * m.values().length];
            ByteOrder order = ByteOrder.nativeOrder();
            int isTransposed = m.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 4) {
                throw new PickleException("should be 4");
            }
            byte[] bytes = this.getBytes(args[2]);
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[3]) == 1;
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values, isTransposed);
        }

        public DenseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class DenseVectorPickler
    extends SerDeBase.BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            Predef$.MODULE$.require(args.length == 1);
            if (args.length != 1) {
                throw new PickleException("should be 1");
            }
            byte[] bytes = this.getBytes(args[0]);
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class LabeledPointPickler
    extends SerDeBase.BasePickler<LabeledPoint> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            LabeledPoint point = (LabeledPoint)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)point.label()), point.features()}));
        }

        public Object construct(Object[] args) {
            if (args.length != 2) {
                throw new PickleException("should be 2");
            }
            return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)args[0]), (Vector)args[1]);
        }

        public LabeledPointPickler() {
            super(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
    }

    public static class RatingPickler
    extends SerDeBase.BasePickler<Rating> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            Rating rating = (Rating)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rating.user()), BoxesRunTime.boxToInteger((int)rating.product()), BoxesRunTime.boxToDouble((double)rating.rating())}));
        }

        public Object construct(Object[] args) {
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            return new Rating(this.ratingsIdCheckLong(args[0]), this.ratingsIdCheckLong(args[1]), BoxesRunTime.unboxToDouble((Object)args[2]));
        }

        private int ratingsIdCheckLong(Object obj) {
            int n;
            try {
                n = BoxesRunTime.unboxToInt((Object)obj);
            }
            catch (ClassCastException ex) {
                throw new PickleException(new StringBuilder(20).append("Ratings id ").append(obj.toString()).append(" exceeds ").append(new StringBuilder(21).append("max integer value of ").append(Integer.MAX_VALUE).toString()).toString(), (Throwable)ex);
            }
            return n;
        }

        public RatingPickler() {
            super(ClassTag$.MODULE$.apply(Rating.class));
        }
    }

    public static class SparseMatrixPickler
    extends SerDeBase.BasePickler<SparseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseMatrix s = (SparseMatrix)obj;
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = new byte[4 * s.colPtrs().length];
            byte[] indicesBytes = new byte[4 * s.rowIndices().length];
            byte[] valuesBytes = new byte[8 * s.values().length];
            int isTransposed = s.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().put(s.colPtrs());
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().put(s.rowIndices());
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().put(s.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)colPtrsBytes.length));
            out.write(colPtrsBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indicesBytes.length));
            out.write(indicesBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valuesBytes.length));
            out.write(valuesBytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 6) {
                throw new PickleException("should be 6");
            }
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = this.getBytes(args[2]);
            byte[] indicesBytes = this.getBytes(args[3]);
            byte[] valuesBytes = this.getBytes(args[4]);
            int[] colPtrs = new int[colPtrsBytes.length / 4];
            int[] rowIndices = new int[indicesBytes.length / 4];
            double[] values = new double[valuesBytes.length / 8];
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().get(colPtrs);
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().get(rowIndices);
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[5]) == 1;
            return new SparseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), colPtrs, rowIndices, values, isTransposed);
        }

        public SparseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(SparseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends SerDeBase.BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = v.indices().length;
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = this.getBytes(args[1]);
            byte[] valueBytes = this.getBytes(args[2]);
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }
}

