/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.VectorTransformer;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0002\u0004\u0001#!AA\u0004\u0001BC\u0002\u0013\u0005Q\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003\u001f\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015)\u0004\u0001\"\u00117\u0005I)E.Z7f]R<\u0018n]3Qe>$Wo\u0019;\u000b\u0005\u001dA\u0011a\u00024fCR,(/\u001a\u0006\u0003\u0013)\tQ!\u001c7mS\nT!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"\u0001\u0004\n\u0005m1!!\u0005,fGR|'\u000f\u0016:b]N4wN]7fe\u0006Q1oY1mS:<g+Z2\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0005\u0002\r1Lg.\u00197h\u0013\t\u0019\u0003E\u0001\u0004WK\u000e$xN\u001d\u0015\u0004\u0003\u0015Z\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0003U\u001d\u0012QaU5oG\u0016\f\u0013\u0001L\u0001\u0006c9\"d\u0006M\u0001\fg\u000e\fG.\u001b8h-\u0016\u001c\u0007\u0005K\u0002\u0003K-\na\u0001P5oSRtDCA\u00193!\tI\u0002\u0001C\u0003\u001d\u0007\u0001\u0007a\u0004K\u00023K-B3aA\u0013,\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002\u001fo!)\u0001\b\u0002a\u0001=\u00051a/Z2u_JD3\u0001B\u0013,Q\r\u0001Qe\u000b")
public class ElementwiseProduct
implements VectorTransformer {
    private final Vector scalingVec;

    @Override
    public RDD<Vector> transform(RDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    @Override
    public JavaRDD<Vector> transform(JavaRDD<Vector> data) {
        return VectorTransformer.transform$((VectorTransformer)this, data);
    }

    public Vector scalingVec() {
        return this.scalingVec;
    }

    @Override
    public Vector transform(Vector vector) {
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        Vector vector2;
        Predef$.MODULE$.require(vector.size() == this.scalingVec().size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("vector sizes do not match: Expected ").append(this.scalingVec().size()).append(" but found ").append(vector.size()).toString());
        Vector vector3 = vector;
        if (vector3 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector3;
            double[] values = (double[])denseVector.values().clone();
            int dim = this.scalingVec().size();
            for (int i = 0; i < dim; ++i) {
                int n = i;
                values[n] = values[n] * this.scalingVec().apply(i);
            }
            vector2 = Vectors$.MODULE$.dense(values);
        } else if (vector3 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector3)).isEmpty()) {
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
            int[] indices = (int[])((Tuple3)option.get())._2();
            double[] vs = (double[])((Tuple3)option.get())._3();
            double[] values = (double[])vs.clone();
            int dim = values.length;
            for (int i = 0; i < dim; ++i) {
                int n = i;
                values[n] = values[n] * this.scalingVec().apply(indices[i]);
            }
            vector2 = Vectors$.MODULE$.sparse(size, indices, values);
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Does not support vector type ").append(vector3.getClass()).toString());
        }
        return vector2;
    }

    public ElementwiseProduct(Vector scalingVec) {
        this.scalingVec = scalingVec;
        VectorTransformer.$init$(this);
    }
}

