/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix;
import java.io.Serializable;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.test.ChiSqTest;
import org.apache.spark.mllib.stat.test.ChiSqTest$NullHypothesis$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class ChiSqTest$
implements Logging {
    public static ChiSqTest$ MODULE$;
    private final ChiSqTest.Method PEARSON;
    private final int maxCategories;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ChiSqTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ChiSqTest.Method PEARSON() {
        return this.PEARSON;
    }

    private ChiSqTest.Method methodFromString(String methodName) {
        String string = methodName;
        String string2 = this.PEARSON().name();
        String string3 = string;
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            throw new IllegalArgumentException("Unrecognized method for Chi squared test.");
        }
        ChiSqTest.Method method = this.PEARSON();
        return method;
    }

    public int maxCategories() {
        return this.maxCategories;
    }

    public ChiSqTestResult[] chiSquaredFeatures(RDD<LabeledPoint> data, String methodName) {
        int numCols = ((LabeledPoint)data.first()).features().size();
        ChiSqTestResult[] results = new ChiSqTestResult[numCols];
        ObjectRef labels = ObjectRef.create(null);
        int batchSize = 1000;
        int batch = 0;
        while (batch * batchSize < numCols) {
            int startCol = batch * batchSize;
            int endCol = startCol + package$.MODULE$.min(batchSize, numCols - startCol);
            Map pairCounts = data.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                HashSet distinctLabels = HashSet$.MODULE$.empty();
                scala.collection.immutable.Map allDistinctFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startCol), endCol).map((Function1 & Serializable & scala.Serializable)col -> ChiSqTest$.$anonfun$chiSquaredFeatures$2(BoxesRunTime.unboxToInt((Object)col)), IndexedSeq$.MODULE$.canBuildFrom()));
                IntRef i = IntRef.create((int)1);
                return iter.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Vector features;
                    double label;
                    LabeledPoint labeledPoint = x0$1;
                    if (labeledPoint != null) {
                        label = labeledPoint.label();
                        features = labeledPoint.features();
                        if (i$1.elem % 1000 == 0) {
                            if (distinctLabels.size() > MODULE$.maxCategories()) {
                                throw new SparkException(new StringBuilder(56).append("Chi-square test expect factors (categorical values) but ").append(new StringBuilder(39).append("found more than ").append(MODULE$.maxCategories()).append(" distinct label values.").toString()).toString());
                            }
                            allDistinctFeatures.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                ChiSqTest$.$anonfun$chiSquaredFeatures$4(x0$2);
                                return BoxedUnit.UNIT;
                            });
                        }
                        ++i$1.elem;
                    } else {
                        throw new MatchError((Object)labeledPoint);
                    }
                    distinctLabels.$plus$eq((Object)BoxesRunTime.boxToDouble((double)label));
                    breeze.linalg.Vector<Object> brzFeatures = features.asBreeze();
                    IndexedSeq indexedSeq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startCol), endCol).map((Function1 & Serializable & scala.Serializable)col -> ChiSqTest$.$anonfun$chiSquaredFeatures$5(brzFeatures, allDistinctFeatures, label, BoxesRunTime.unboxToInt((Object)col)), IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                });
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).countByValue(Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
            if ((scala.collection.immutable.Map)labels.elem == null) {
                labels.elem = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])((TraversableOnce)((TraversableLike)pairCounts.keys().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChiSqTest$.$anonfun$chiSquaredFeatures$6(startCol, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$chiSquaredFeatures$7(x$2)), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()))).distinct())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            }
            int numLabels = ((scala.collection.immutable.Map)labels.elem).size();
            pairCounts.keys().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ChiSqTest$.$anonfun$chiSquaredFeatures$8(x$3))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                ChiSqTest$.$anonfun$chiSquaredFeatures$9(numLabels, labels, pairCounts, results, methodName, x0$3);
                return BoxedUnit.UNIT;
            });
            ++batch;
        }
        return results;
    }

    public ChiSqTestResult chiSquared(Vector observed, Vector expected, String methodName) {
        ChiSqTestResult chiSqTestResult;
        Object object = new Object();
        try {
            double[] expArr;
            ChiSqTest.Method method = this.methodFromString(methodName);
            if (expected.size() != 0 && observed.size() != expected.size()) {
                throw new IllegalArgumentException("observed and expected must be of the same size.");
            }
            int size = observed.size();
            if (size > 1000) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Chi-squared approximation may not be accurate due to low expected frequencies ").append(new StringBuilder(47).append(" as a result of a large number of categories: ").append(size).append(".").toString()).toString());
            }
            double[] obsArr = observed.toArray();
            double[] dArray = expArr = expected.size() == 0 ? (double[])Array$.MODULE$.tabulate(size, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$5 -> 1.0 / (double)size, ClassTag$.MODULE$.Double()) : expected.toArray();
            if (!new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(obsArr)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0.0)) {
                throw new IllegalArgumentException("Negative entries disallowed in the observed vector.");
            }
            if (expected.size() != 0 && !new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expArr)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$7 -> x$7 >= 0.0)) {
                throw new IllegalArgumentException("Negative entries disallowed in the expected vector.");
            }
            double obsSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(obsArr)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double expSum = (double)expected.size() == 0.0 ? 1.0 : BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expArr)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double scale = package$.MODULE$.abs(obsSum - expSum) < 1.0E-7 ? 1.0 : obsSum / expSum;
            double statistic = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(obsArr)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(expArr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$chiSquared$5(object, size, scale, method, BoxesRunTime.unboxToDouble((Object)x0$1), x1$1))));
            int df = size - 1;
            double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
            chiSqTestResult = new ChiSqTestResult(pValue, df, statistic, this.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                chiSqTestResult = (ChiSqTestResult)ex.value();
            }
            throw ex;
        }
        return chiSqTestResult;
    }

    public String chiSquaredFeatures$default$2() {
        return this.PEARSON().name();
    }

    public Vector chiSquared$default$2() {
        return Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
    }

    public String chiSquared$default$3() {
        return this.PEARSON().name();
    }

    public ChiSqTestResult chiSquaredMatrix(org.apache.spark.mllib.linalg.Matrix counts, String methodName) {
        ChiSqTestResult chiSqTestResult;
        ChiSqTest.Method method = this.methodFromString(methodName);
        int numRows = counts.numRows();
        int numCols = counts.numCols();
        double[] colSums = new double[numCols];
        double[] rowSums = new double[numRows];
        double[] colMajorArr = counts.toArray();
        int colMajorArrLen = colMajorArr.length;
        for (int i = 0; i < colMajorArrLen; ++i) {
            double elem = colMajorArr[i];
            if (elem < 0.0) {
                throw new IllegalArgumentException("Contingency table cannot contain negative entries.");
            }
            int n = i / numRows;
            colSums[n] = colSums[n] + elem;
            int n2 = i % numRows;
            rowSums[n2] = rowSums[n2] + elem;
        }
        double total = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colSums)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double statistic = 0.0;
        for (int j = 0; j < colMajorArrLen; ++j) {
            int col = j / numRows;
            double colSum = colSums[col];
            if (colSum == 0.0) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Chi-squared statistic undefined for input matrix due to").append(new StringBuilder(19).append("0 sum in column [").append(col).append("].").toString()).toString());
            }
            int row = j % numRows;
            double rowSum = rowSums[row];
            if (rowSum == 0.0) {
                throw new IllegalArgumentException(new StringBuilder(55).append("Chi-squared statistic undefined for input matrix due to").append(new StringBuilder(16).append("0 sum in row [").append(row).append("].").toString()).toString());
            }
            double expected = colSum * rowSum / total;
            statistic += method.chiSqFunc().apply$mcDDD$sp(colMajorArr[j], expected);
        }
        int df = (numCols - 1) * (numRows - 1);
        if (df == 0) {
            chiSqTestResult = new ChiSqTestResult(1.0, 0, 0.0, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
        } else {
            double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
            chiSqTestResult = new ChiSqTestResult(pValue, df, statistic, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
        }
        return chiSqTestResult;
    }

    public String chiSquaredMatrix$default$2() {
        return this.PEARSON().name();
    }

    public static final /* synthetic */ Tuple2 $anonfun$chiSquaredFeatures$2(int col) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)HashSet$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$chiSquaredFeatures$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int col = tuple2._1$mcI$sp();
            HashSet distinctFeatures = (HashSet)tuple2._2();
            if (distinctFeatures.size() > MODULE$.maxCategories()) {
                throw new SparkException(new StringBuilder(56).append("Chi-square test expect factors (categorical values) but ").append(new StringBuilder(44).append("found more than ").append(MODULE$.maxCategories()).append(" distinct values in column ").append(col).append(".").toString()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple3 $anonfun$chiSquaredFeatures$5(breeze.linalg.Vector brzFeatures$1, scala.collection.immutable.Map allDistinctFeatures$1, double label$1, int col) {
        double feature = brzFeatures$1.apply$mcID$sp(col);
        ((HashSet)allDistinctFeatures$1.apply((Object)BoxesRunTime.boxToInteger((int)col))).$plus$eq((Object)BoxesRunTime.boxToDouble((double)feature));
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)label$1));
    }

    public static final /* synthetic */ boolean $anonfun$chiSquaredFeatures$6(int startCol$1, Tuple3 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1()) == startCol$1;
    }

    public static final /* synthetic */ double $anonfun$chiSquaredFeatures$7(Tuple3 x$2) {
        return BoxesRunTime.unboxToDouble((Object)x$2._3());
    }

    public static final /* synthetic */ int $anonfun$chiSquaredFeatures$8(Tuple3 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public static final /* synthetic */ double $anonfun$chiSquaredFeatures$10(Tuple3 x$4) {
        return BoxesRunTime.unboxToDouble((Object)x$4._2());
    }

    public static final /* synthetic */ void $anonfun$chiSquaredFeatures$11(scala.collection.immutable.Map features$1, ObjectRef labels$1, DenseMatrix contingency$1, Map pairCounts$1, int col$1, Tuple3 x0$4) {
        Tuple3 tuple3 = x0$4;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double feature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double label = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        int i = BoxesRunTime.unboxToInt((Object)features$1.apply((Object)BoxesRunTime.boxToDouble((double)feature)));
        int j = BoxesRunTime.unboxToInt((Object)((scala.collection.immutable.Map)labels$1.elem).apply((Object)BoxesRunTime.boxToDouble((double)label)));
        contingency$1.update$mcD$sp(i, j, contingency$1.apply$mcD$sp(i, j) + (double)BoxesRunTime.unboxToLong((Object)pairCounts$1.apply((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)col$1), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)label)))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$chiSquaredFeatures$9(int numLabels$1, ObjectRef labels$1, Map pairCounts$1, ChiSqTestResult[] results$1, String methodName$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int col = tuple2._1$mcI$sp();
        Iterable keys = (Iterable)tuple2._2();
        scala.collection.immutable.Map features = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)ChiSqTest$.$anonfun$chiSquaredFeatures$10(x$4)), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()))).distinct())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        int numRows = features.size();
        DenseMatrix.mcD.sp contingency = new DenseMatrix.mcD.sp(numRows, numLabels$1, new double[numRows * numLabels$1]);
        keys.foreach(arg_0 -> ChiSqTest$.$anonfun$chiSquaredFeatures$11$adapted(features, labels$1, (DenseMatrix)contingency, pairCounts$1, col, arg_0));
        results$1[col] = MODULE$.chiSquaredMatrix(Matrices$.MODULE$.fromBreeze((Matrix<Object>)contingency), methodName$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$chiSquared$5(Object nonLocalReturnKey1$1, int size$1, double scale$1, ChiSqTest.Method method$1, double x0$1, Tuple2 x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$1), (Object)x1$1);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        double stat = tuple2._1$mcD$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        double obs = tuple22._1$mcD$sp();
        double exp = tuple22._2$mcD$sp();
        if (exp != 0.0) return scale$1 == 1.0 ? stat + method$1.chiSqFunc().apply$mcDDD$sp(obs, exp) : stat + method$1.chiSqFunc().apply$mcDDD$sp(obs, exp * scale$1);
        if (obs != 0.0) throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new ChiSqTestResult(0.0, size$1 - 1, Double.POSITIVE_INFINITY, MODULE$.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString()));
        throw new IllegalArgumentException("Chi-squared statistic undefined for input vectors due to 0.0 values in both observed and expected.");
    }

    private ChiSqTest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.PEARSON = new ChiSqTest.Method("pearson", (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(observed, expected) -> {
            double dev = observed - expected;
            return dev * dev / expected;
        });
        this.maxCategories = 10000;
    }

    public static final /* synthetic */ Object $anonfun$chiSquaredFeatures$11$adapted(scala.collection.immutable.Map features$1, ObjectRef labels$1, DenseMatrix contingency$1, Map pairCounts$1, int col$1, Tuple3 x0$4) {
        ChiSqTest$.$anonfun$chiSquaredFeatures$11(features$1, labels$1, contingency$1, pairCounts$1, col$1, x0$4);
        return BoxedUnit.UNIT;
    }
}

