/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@DeveloperApi
public final class KMeansDataGenerator$ {
    public static KMeansDataGenerator$ MODULE$;

    static {
        new KMeansDataGenerator$();
    }

    public RDD<double[]> generateKMeansRDD(SparkContext sc, int numPoints, int k, int d, double r, int numPartitions) {
        Random rand = new Random(42);
        double[][] centers = (double[][])Array$.MODULE$.fill(k, (Function0 & java.io.Serializable & Serializable)() -> (double[])Array$.MODULE$.fill(d, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> rand.nextGaussian() * r, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPoints), numPartitions, ClassTag$.MODULE$.Int()).map((Function1 & java.io.Serializable & Serializable)idx -> KMeansDataGenerator$.$anonfun$generateKMeansRDD$3(centers, k, d, BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public int generateKMeansRDD$default$6() {
        return 2;
    }

    public void main(String[] args) {
        if (args.length < 6) {
            Predef$.MODULE$.println((Object)"Usage: KMeansGenerator <master> <output_dir> <num_points> <k> <d> <r> [<num_partitions>]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int numPoints = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        int k = new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        int d = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
        double r = new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble();
        int parts = args.length >= 7 ? new StringOps(Predef$.MODULE$.augmentString(args[6])).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "KMeansDataGenerator");
        RDD<double[]> data = this.generateKMeansRDD(sc, numPoints, k, d, r, parts);
        data.map((Function1 & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$1)).mkString(" "), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        sc.stop();
        System.exit(0);
    }

    public static final /* synthetic */ double[] $anonfun$generateKMeansRDD$3(double[][] centers$1, int k$1, int d$1, int idx) {
        double[] center = centers$1[idx % k$1];
        Random rand2 = new Random(42 + idx);
        return (double[])Array$.MODULE$.tabulate(d$1, (Function1)(JFunction1.mcDI.sp & java.io.Serializable & Serializable)i -> center[i] + rand2.nextGaussian(), ClassTag$.MODULE$.Double());
    }

    private KMeansDataGenerator$() {
        MODULE$ = this;
    }
}

