/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!\u0002\u0004\b\u0003\u0003\u0011\u0002\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"B$\u0001\t#A\u0005\"\u00024\u0001\t#9\u0007b\u00029\u0001#\u0003%\t\"\u001d\u0002\u000b\u00072\f7o]5gS\u0016\u0014(B\u0001\u0005\n\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!AC\u0006\u0002\u00055d'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001U!1CG\u0014.'\r\u0001Ac\r\t\u0006+YAb\u0005L\u0007\u0002\u0013%\u0011q#\u0003\u0002\n!J,G-[2u_J\u0004\"!\u0007\u000e\r\u0001\u0011)1\u0004\u0001b\u00019\taa)Z1ukJ,7\u000fV=qKF\u0011Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b\u001d>$\b.\u001b8h!\tqB%\u0003\u0002&?\t\u0019\u0011I\\=\u0011\u0005e9C!\u0002\u0015\u0001\u0005\u0004I#!A#\u0012\u0005uQ\u0003#B\u0016\u00011\u0019bS\"A\u0004\u0011\u0005eiC!\u0002\u0018\u0001\u0005\u0004y#!A'\u0012\u0005u\u0001\u0004\u0003B\u0016211J!AM\u0004\u0003'\rc\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005-\"\u0014BA\u001b\b\u0005A\u0019E.Y:tS\u001aLWM\u001d)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u0002U\u0005\u00192/\u001a;SC^\u0004&/\u001a3jGRLwN\\\"pYR\u0011aE\u000f\u0005\u0006w\t\u0001\r\u0001P\u0001\u0006m\u0006dW/\u001a\t\u0003{\u0011s!A\u0010\"\u0011\u0005}zR\"\u0001!\u000b\u0005\u0005\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002D?\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019u$\u0001\u000bfqR\u0014\u0018m\u0019;MC\n,G.\u001a3Q_&tGo\u001d\u000b\u0004\u0013V\u000b\u0007c\u0001&N\u001f6\t1J\u0003\u0002M\u0017\u0005\u0019!\u000f\u001a3\n\u00059[%a\u0001*E\tB\u0011\u0001kU\u0007\u0002#*\u0011!+C\u0001\bM\u0016\fG/\u001e:f\u0013\t!\u0016K\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u0003W\u0007\u0001\u0007q+A\u0004eCR\f7/\u001a;1\u0005a{\u0006cA-]=6\t!L\u0003\u0002\\\u0017\u0005\u00191/\u001d7\n\u0005uS&a\u0002#bi\u0006\u001cX\r\u001e\t\u00033}#\u0011\u0002Y+\u0002\u0002\u0003\u0005)\u0011\u0001\u000f\u0003\u0007}#\u0013\u0007C\u0003c\u0007\u0001\u00071-\u0001\u0006ok6\u001cE.Y:tKN\u0004\"A\b3\n\u0005\u0015|\"aA%oi\u0006iq-\u001a;Ok6\u001cE.Y:tKN$2a\u00195o\u0011\u00151F\u00011\u0001ja\tQG\u000eE\u0002Z9.\u0004\"!\u00077\u0005\u00135D\u0017\u0011!A\u0001\u0006\u0003a\"aA0%e!9q\u000e\u0002I\u0001\u0002\u0004\u0019\u0017!D7bq:+Xn\u00117bgN,7/A\fhKRtU/\\\"mCN\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t!O\u000b\u0002dg.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003s~\t!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D#\u0001A?\u0011\u0007y\f\t!D\u0001\u0000\u0015\tI8\"C\u0002\u0002\u0004}\u0014A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public abstract class Classifier<FeaturesType, E extends Classifier<FeaturesType, E, M>, M extends ClassificationModel<FeaturesType, M>>
extends Predictor<FeaturesType, E, M>
implements ClassifierParams {
    private final Param<String> rawPredictionCol;

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    public E setRawPredictionCol(String value) {
        return (E)((Classifier)this.set(this.rawPredictionCol(), value));
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
        Predef$.MODULE$.require(numClasses > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Classifier (in extractLabeledPoints) found numClasses =").append(" ").append(numClasses).append(", but requires numClasses > 0.").toString());
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            Predef$.MODULE$.require(d % 1.0 == 0.0 && d >= 0.0 && d < (double)numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Classifier was given").append(" dataset with invalid label ").append(d).append(".  Labels must be integers in range").append(" [0, ").append(numClasses).append(").").toString());
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int getNumClasses(Dataset<?> dataset, int maxNumClasses) {
        int n;
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
        if (option instanceof Some) {
            int n2;
            int n3;
            Some some = (Some)option;
            n = n3 = (n2 = BoxesRunTime.unboxToInt((Object)some.value()));
        } else if (None$.MODULE$.equals(option)) {
            Row[] maxLabelRow = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.$(this.labelCol()))})).take(1);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).isEmpty() || maxLabelRow[0].get(0) == null) {
                throw new SparkException("ML algorithm was given empty dataset.");
            }
            double maxDoubleLabel = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).head()).getDouble(0);
            Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Classifier found max label value =").append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString());
            int numClasses = (int)maxDoubleLabel + 1;
            Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(286).append("Classifier inferred ").append(numClasses).append(" from label values").append(" in column ").append(this.labelCol()).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append(this.getClass().getCanonicalName()).append(" inferred ").append(numClasses).append(" classes for").append(" labelCol=").append(this.labelCol()).append(" since numClasses was not specified in the column metadata.").toString());
            n = numClasses;
        } else {
            throw new MatchError(option);
        }
        return n;
    }

    public int getNumClasses$default$2() {
        return 100;
    }

    public Classifier() {
        HasRawPredictionCol.$init$(this);
        ClassifierParams.$init$(this);
    }
}

