/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.feature.Imputer$;
import org.apache.spark.ml.feature.ImputerModel;
import org.apache.spark.ml.feature.ImputerParams;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u000b\u0017\u0001\u0005B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005k!)Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001'\")Q\u000b\u0001C\u0001-\")q\f\u0001C\u0001A\")1\r\u0001C\u0001I\")q\r\u0001C\u0001Q\")a\u000e\u0001C!_\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u000f\u0001\u0011\u0005\u0013qD\u0004\b\u0003w1\u0002\u0012AA\u001f\r\u0019)b\u0003#\u0001\u0002@!1Q*\u0004C\u0001\u0003'B!\"!\u0016\u000e\u0005\u0004%\tAFA,\u0011!\t9'\u0004Q\u0001\n\u0005e\u0003BCA5\u001b\t\u0007I\u0011\u0001\f\u0002X!A\u00111N\u0007!\u0002\u0013\tI\u0006C\u0004\u0002n5!\t%a\u001c\t\u0013\u0005]T\"!A\u0005\n\u0005e$aB%naV$XM\u001d\u0006\u0003/a\tqAZ3biV\u0014XM\u0003\u0002\u001a5\u0005\u0011Q\u000e\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011\u0003\u0002\u0001#U5\u00022a\t\u0013'\u001b\u0005A\u0012BA\u0013\u0019\u0005%)5\u000f^5nCR|'\u000f\u0005\u0002(Q5\ta#\u0003\u0002*-\ta\u0011*\u001c9vi\u0016\u0014Xj\u001c3fYB\u0011qeK\u0005\u0003YY\u0011Q\"S7qkR,'\u000fU1sC6\u001c\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0019\u0003\u0011)H/\u001b7\n\u0005Iz#!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#A\u001b\u0011\u0005YzdBA\u001c>!\tA4(D\u0001:\u0015\tQ\u0004%\u0001\u0004=e>|GO\u0010\u0006\u0002y\u0005)1oY1mC&\u0011ahO\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?w!\u001a\u0011aQ%\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019S\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001*\u0012\u0002\u0006'&t7-Z\u0011\u0002\u0015\u0006)!G\f\u001a/a\u0005!Q/\u001b3!Q\r\u00111)S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0003\u0006CA\u0014\u0001\u0011\u0015\u00194\u00011\u00016Q\r\u00016)\u0013\u0015\u0004\u0007\rKE#A()\u0007\u0011\u0019\u0015*\u0001\u0007tKRLe\u000e];u\u0007>d7\u000f\u0006\u0002X16\t\u0001\u0001C\u0003Z\u000b\u0001\u0007!,A\u0003wC2,X\rE\u0002\\9Vj\u0011aO\u0005\u0003;n\u0012Q!\u0011:sCfD3!B\"J\u00035\u0019X\r^(viB,HoQ8mgR\u0011q+\u0019\u0005\u00063\u001a\u0001\rA\u0017\u0015\u0004\r\rK\u0015aC:fiN#(/\u0019;fOf$\"aV3\t\u000be;\u0001\u0019A\u001b)\u0007\u001d\u0019\u0015*A\btKRl\u0015n]:j]\u001e4\u0016\r\\;f)\t9\u0016\u000eC\u0003Z\u0011\u0001\u0007!\u000e\u0005\u0002\\W&\u0011An\u000f\u0002\u0007\t>,(\r\\3)\u0007!\u0019\u0015*A\u0002gSR$\"A\n9\t\u000bEL\u0001\u0019\u0001:\u0002\u000f\u0011\fG/Y:fiB\u00121o\u001f\t\u0004i^LX\"A;\u000b\u0005YT\u0012aA:rY&\u0011\u00010\u001e\u0002\b\t\u0006$\u0018m]3u!\tQ8\u0010\u0004\u0001\u0005\u0013q\u0004\u0018\u0011!A\u0001\u0006\u0003i(aA0%cE\u0019a0a\u0001\u0011\u0005m{\u0018bAA\u0001w\t9aj\u001c;iS:<\u0007cA.\u0002\u0006%\u0019\u0011qA\u001e\u0003\u0007\u0005s\u00170A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\ti!!\u0007\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005v\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9\"!\u0005\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\u001c)\u0001\r!!\u0004\u0002\rM\u001c\u0007.Z7b\u0003\u0011\u0019w\u000e]=\u0015\u0007=\u000b\t\u0003C\u0004\u0002$-\u0001\r!!\n\u0002\u000b\u0015DHO]1\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u0019\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ty#!\u000b\u0003\u0011A\u000b'/Y7NCBD3\u0001A\"JQ\r\u0001\u0011Q\u0007\t\u0004\t\u0006]\u0012bAA\u001d\u000b\naQ\t\u001f9fe&lWM\u001c;bY\u00069\u0011*\u001c9vi\u0016\u0014\bCA\u0014\u000e'\u001di\u0011\u0011IA$\u0003\u001b\u00022aWA\"\u0013\r\t)e\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\t9\nIeT\u0005\u0004\u0003\u0017z#!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u00047\u0006=\u0013bAA)w\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011QH\u0001\u0005[\u0016\fg.\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001\u00027b]\u001eT!!a\u0019\u0002\t)\fg/Y\u0005\u0004\u0001\u0006u\u0013!B7fC:\u0004\u0013AB7fI&\fg.A\u0004nK\u0012L\u0017M\u001c\u0011\u0002\t1|\u0017\r\u001a\u000b\u0004\u001f\u0006E\u0004BBA:'\u0001\u0007Q'\u0001\u0003qCRD\u0007fA\nD\u0013\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\b\u0005\u0003\u0002\\\u0005u\u0014\u0002BA@\u0003;\u0012aa\u00142kK\u000e$\bfA\u0007D\u0013\"\u001aAbQ%")
public class Imputer
extends Estimator<ImputerModel>
implements ImputerParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> strategy;
    private final DoubleParam missingValue;
    private final StringArrayParam outputCols;
    private final StringArrayParam inputCols;

    public static Imputer load(String string) {
        return Imputer$.MODULE$.load(string);
    }

    public static MLReader<Imputer> read() {
        return Imputer$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getStrategy() {
        return ImputerParams.getStrategy$(this);
    }

    @Override
    public double getMissingValue() {
        return ImputerParams.getMissingValue$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return ImputerParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String[] getOutputCols() {
        return HasOutputCols.getOutputCols$(this);
    }

    @Override
    public final String[] getInputCols() {
        return HasInputCols.getInputCols$(this);
    }

    @Override
    public final Param<String> strategy() {
        return this.strategy;
    }

    @Override
    public final DoubleParam missingValue() {
        return this.missingValue;
    }

    @Override
    public final void org$apache$spark$ml$feature$ImputerParams$_setter_$strategy_$eq(Param<String> x$1) {
        this.strategy = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$ImputerParams$_setter_$missingValue_$eq(DoubleParam x$1) {
        this.missingValue = x$1;
    }

    @Override
    public final StringArrayParam outputCols() {
        return this.outputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCols$_setter_$outputCols_$eq(StringArrayParam x$1) {
        this.outputCols = x$1;
    }

    @Override
    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Imputer setInputCols(String[] value) {
        return (Imputer)this.set(this.inputCols(), value);
    }

    public Imputer setOutputCols(String[] value) {
        return (Imputer)this.set(this.outputCols(), value);
    }

    public Imputer setStrategy(String value) {
        return (Imputer)this.set(this.strategy(), value);
    }

    public Imputer setMissingValue(double value) {
        return (Imputer)this.set(this.missingValue(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public ImputerModel fit(Dataset<?> dataset) {
        double[] dArray;
        this.transformSchema(dataset.schema(), true);
        SparkSession spark = dataset.sparkSession();
        Column[] cols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$(this.inputCols()))).map((Function1 & Serializable & scala.Serializable)inputCol -> functions$.MODULE$.when(functions$.MODULE$.col(inputCol).equalTo(this.$(this.missingValue())), null).when(functions$.MODULE$.col(inputCol).isNaN(), null).otherwise((Object)functions$.MODULE$.col(inputCol)).cast("double").as(inputCol), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        String string = this.$(this.strategy());
        String string2 = Imputer$.MODULE$.mean();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Row row = (Row)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).map((Function1 & Serializable & scala.Serializable)e -> functions$.MODULE$.avg(e), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).head();
            dArray = (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, this.$(this.inputCols()).length))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> row.isNullAt(i) ? Double.NaN : row.getDouble(i), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        } else {
            String string4 = Imputer$.MODULE$.median();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                dArray = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])cols)).stat().approxQuantile(this.$(this.inputCols()), new double[]{0.5}, 0.001))).map((Function1 & Serializable & scala.Serializable)array -> BoxesRunTime.boxToDouble((double)Imputer.$anonfun$fit$4(array)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            } else {
                throw new MatchError((Object)string);
            }
        }
        double[] results = dArray;
        String[] emptyCols = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$(this.inputCols()))).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(results), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Imputer.$anonfun$fit$5(x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emptyCols)).nonEmpty()) {
            throw new SparkException(new StringBuilder(80).append("surrogate cannot be computed. ").append("All the values in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])emptyCols)).mkString(",")).append(" are Null, Nan or ").append("missingValue(").append(this.$(this.missingValue())).append(")").toString());
        }
        RDD rows = spark.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapDoubleArray(results))})), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$(this.inputCols()))).map((Function1 & Serializable & scala.Serializable)col -> new StructField(col, (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Dataset surrogateDF = spark.createDataFrame(rows, schema);
        return this.copyValues(new ImputerModel(this.uid(), (Dataset<Row>)surrogateDF).setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public Imputer copy(ParamMap extra) {
        return (Imputer)this.defaultCopy(extra);
    }

    public static final /* synthetic */ double $anonfun$fit$4(double[] array) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(array)).isEmpty() ? Double.NaN : BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(array)).head());
    }

    public static final /* synthetic */ boolean $anonfun$fit$5(Tuple2 x$1) {
        return Predef$.MODULE$.double2Double(x$1._2$mcD$sp()).isNaN();
    }

    public Imputer(String uid) {
        this.uid = uid;
        HasInputCols.$init$(this);
        HasOutputCols.$init$(this);
        ImputerParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.strategy().$minus$greater(Imputer$.MODULE$.mean()), this.missingValue().$minus$greater(BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public Imputer() {
        this(Identifiable$.MODULE$.randomUID("imputer"));
    }
}

