/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001\u0002\u001f>\u0001!C\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t%\u0017\u0005\ta\u0002\u0011\t\u0011)A\u00055\"A!\u000f\u0001BC\u0002\u0013%1\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003u\u0011!\t\t\u0001\u0001C\u0001\u007f\u0005\r\u0001BCA\u0006\u0001!\u0015\r\u0011\"\u0001\u0002\u000e!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\u001d\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t9\u0007\u0001C\u0001\u0003\u000fCq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011Q\u001a\u0001\u0005B\u0005=\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\b\u0003{\u0004A\u0011IA\u0000\u000f\u001d\u0011y!\u0010E\u0001\u0005#1a\u0001P\u001f\t\u0002\tM\u0001bBA\u0001%\u0011\u0005!q\u0005\u0004\u0007\u0005S\u0011BIa\u000b\t\u0013\u0005}BC!f\u0001\n\u0003I\u0006\"\u0003B\u001a)\tE\t\u0015!\u0003[\u0011)\u0011)\u0004\u0006BK\u0002\u0013\u0005!q\u0007\u0005\u000b\u0005\u0003\"\"\u0011#Q\u0001\n\te\u0002bBA\u0001)\u0011\u0005!1\t\u0005\n\u0003G$\u0012\u0011!C\u0001\u0005\u001bB\u0011Ba\u0015\u0015#\u0003%\tA!\u0016\t\u0013\t%D#%A\u0005\u0002\t-\u0004\"\u0003B8)\u0005\u0005I\u0011\tB9\u0011%\u0011\t\tFA\u0001\n\u0003\u0011\u0019\tC\u0005\u0003\u0006R\t\t\u0011\"\u0001\u0003\b\"I!Q\u0012\u000b\u0002\u0002\u0013\u0005#q\u0012\u0005\n\u0005;#\u0012\u0011!C\u0001\u0005?C\u0011B!+\u0015\u0003\u0003%\tEa+\t\u0013\t5F#!A\u0005B\t=\u0006\"\u0003BY)\u0005\u0005I\u0011\tBZ\u000f%\u00119LEA\u0001\u0012\u0013\u0011ILB\u0005\u0003*I\t\t\u0011#\u0003\u0003<\"9\u0011\u0011\u0001\u0014\u0005\u0002\t%\u0007\"\u0003BWM\u0005\u0005IQ\tBX\u0011%\u0011YMJA\u0001\n\u0003\u0013i\rC\u0005\u0003T\u001a\n\t\u0011\"!\u0003V\"I!1\u001d\u0014\u0002\u0002\u0013%!Q\u001d\u0004\b\u0005[\u0014\u0002A\u0005Bx\u0011%\u0011\t\u0010\fB\u0001B\u0003%Q\nC\u0004\u0002\u00021\"\tAa=\t\u000f\teH\u0006\"\u0015\u0003|\u001eA1q\u0001\n\t\u0002u\u001aIA\u0002\u0005\u0003nJA\t!PB\u0006\u0011\u001d\t\t!\rC\u0001\u0007\u001bAqaa\u00042\t\u0003\u0019\tB\u0002\u0004\u0004&I!1q\u0005\u0005\b\u0003\u0003!D\u0011AB\u0018\u0011%\u0019\u0019\u0004\u000eb\u0001\n\u0013\u0011\t\b\u0003\u0005\u00046Q\u0002\u000b\u0011\u0002B:\u0011\u001d\u00199\u0004\u000eC!\u0007sAqa!\u0010\u0013\t\u0003\u001ay\u0004C\u0004\u00048I!\tea\u0011\t\u0013\t\r(#!A\u0005\n\t\u0015(!D,pe\u0012\u0014d+Z2N_\u0012,GN\u0003\u0002?\u007f\u00059a-Z1ukJ,'B\u0001!B\u0003\tiGN\u0003\u0002C\u0007\u0006)1\u000f]1sW*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A%P%B\u0019!jS'\u000e\u0003}J!\u0001T \u0003\u000b5{G-\u001a7\u0011\u00059\u0003Q\"A\u001f\u0011\u00059\u0003\u0016BA)>\u000519vN\u001d33-\u0016\u001c')Y:f!\t\u0019f+D\u0001U\u0015\t)v(\u0001\u0003vi&d\u0017BA,U\u0005)iEj\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#\u0001.\u0011\u0005m#gB\u0001/c!\ti\u0006-D\u0001_\u0015\tyv)\u0001\u0004=e>|GO\u0010\u0006\u0002C\u0006)1oY1mC&\u00111\rY\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002dA\"\u001a\u0011\u0001\u001b8\u0011\u0005%dW\"\u00016\u000b\u0005-\f\u0015AC1o]>$\u0018\r^5p]&\u0011QN\u001b\u0002\u0006'&t7-Z\u0011\u0002_\u0006)\u0011G\f\u001b/a\u0005!Q/\u001b3!Q\r\u0011\u0001N\\\u0001\fo>\u0014HMV3di>\u00148/F\u0001u!\t)\u00180D\u0001w\u0015\tqtO\u0003\u0002y\u0003\u0006)Q\u000e\u001c7jE&\u0011AH^\u0001\ro>\u0014HMV3di>\u00148\u000f\t\u0015\u0003\tq\u0004\"! @\u000e\u0003\u0001L!a 1\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002\u001fj]&$h\bF\u0003N\u0003\u000b\tI\u0001C\u0003Y\u000b\u0001\u0007!\f\u000b\u0003\u0002\u0006!t\u0007\"\u0002:\u0006\u0001\u0004!\u0018AC4fiZ+7\r^8sgV\u0011\u0011q\u0002\t\u0005\u0003#\tYC\u0004\u0003\u0002\u0014\u0005\u0015b\u0002BA\u000b\u0003CqA!a\u0006\u0002 9!\u0011\u0011DA\u000f\u001d\ri\u00161D\u0005\u0002\r&\u0011A)R\u0005\u0003\u0005\u000eK1!a\tB\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003O\tI#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\r\u0012)\u0003\u0003\u0002.\u0005=\"!\u0003#bi\u00064%/Y7f\u0015\u0011\t9#!\u000b)\u0005\u0019a\b\u0006\u0002\u0004i\u0003k\t#!a\u000e\u0002\u000bErSG\f\u0019\u0002\u0019\u0019Lg\u000eZ*z]>t\u00170\\:\u0015\r\u0005=\u0011QHA!\u0011\u0019\tyd\u0002a\u00015\u0006!qo\u001c:e\u0011\u001d\t\u0019e\u0002a\u0001\u0003\u000b\n1A\\;n!\ri\u0018qI\u0005\u0004\u0003\u0013\u0002'aA%oi\"\"q\u0001[A\u001b)\u0019\ty!a\u0014\u0002`!9\u0011\u0011\u000b\u0005A\u0002\u0005M\u0013a\u0001<fGB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z}\na\u0001\\5oC2<\u0017\u0002BA/\u0003/\u0012aAV3di>\u0014\bbBA\"\u0011\u0001\u0007\u0011Q\t\u0015\u0005\u0011!\f\u0019'\t\u0002\u0002f\u0005)!G\f\u0019/a\u0005\tb-\u001b8e'ftwN\\=ng\u0006\u0013(/Y=\u0015\r\u0005-\u0014QPA@!\u0015i\u0018QNA9\u0013\r\ty\u0007\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0007{\u0006M$,a\u001e\n\u0007\u0005U\u0004M\u0001\u0004UkBdWM\r\t\u0004{\u0006e\u0014bAA>A\n1Ai\\;cY\u0016Dq!!\u0015\n\u0001\u0004\t\u0019\u0006C\u0004\u0002D%\u0001\r!!\u0012)\t%A\u00171Q\u0011\u0003\u0003\u000b\u000bQA\r\u00183]A\"b!a\u001b\u0002\n\u0006-\u0005BBA \u0015\u0001\u0007!\fC\u0004\u0002D)\u0001\r!!\u0012)\t)A\u00171Q\u0001\fg\u0016$\u0018J\u001c9vi\u000e{G\u000e\u0006\u0003\u0002\u0014\u0006UU\"\u0001\u0001\t\r\u0005]5\u00021\u0001[\u0003\u00151\u0018\r\\;fQ\rY\u0001N\\\u0001\rg\u0016$x*\u001e;qkR\u001cu\u000e\u001c\u000b\u0005\u0003'\u000by\n\u0003\u0004\u0002\u00182\u0001\rA\u0017\u0015\u0004\u0019!t\u0017!\u0003;sC:\u001chm\u001c:n)\u0011\ty!a*\t\u000f\u0005%V\u00021\u0001\u0002,\u00069A-\u0019;bg\u0016$\b\u0007BAW\u0003s\u0003b!a,\u00022\u0006UVBAA\u0015\u0013\u0011\t\u0019,!\u000b\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qWA]\u0019\u0001!A\"a/\u0002(\u0006\u0005\t\u0011!B\u0001\u0003{\u00131a\u0018\u00133#\u0011\ty,!2\u0011\u0007u\f\t-C\u0002\u0002D\u0002\u0014qAT8uQ&tw\rE\u0002~\u0003\u000fL1!!3a\u0005\r\te.\u001f\u0015\u0005\u001b!\f\u0019'A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\t.!8\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+TA!a6\u0002*\u0005)A/\u001f9fg&!\u00111\\Ak\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003?t\u0001\u0019AAi\u0003\u0019\u00198\r[3nC\"\u001aa\u0002\u001b8\u0002\t\r|\u0007/\u001f\u000b\u0004\u001b\u0006\u001d\bbBAu\u001f\u0001\u0007\u00111^\u0001\u0006Kb$(/\u0019\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011_ \u0002\u000bA\f'/Y7\n\t\u0005U\u0018q\u001e\u0002\t!\u0006\u0014\u0018-\\'ba\"\"q\u0002[A}C\t\tY0A\u00032]Qr\u0013'A\u0003xe&$X-\u0006\u0002\u0003\u0002A\u00191Ka\u0001\n\u0007\t\u0015AK\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011\u0001\u0002N!\u0003\"\u0005\t-\u0011!B\u0019/m9\u0002\u0004f\u0001\u0001i]\u0006iqk\u001c:eeY+7-T8eK2\u0004\"A\u0014\n\u0014\u000fI\u0011)Ba\u0007\u0003\"A\u0019QPa\u0006\n\u0007\te\u0001M\u0001\u0004B]f\u0014VM\u001a\t\u0005'\nuQ*C\u0002\u0003 Q\u0013!\"\u0014'SK\u0006$\u0017M\u00197f!\ri(1E\u0005\u0004\u0005K\u0001'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\t\u0005\u0011!\u0015\r^1\u0014\u000fQ\u0011)B!\f\u0003\"A\u0019QPa\f\n\u0007\tE\u0002MA\u0004Qe>$Wo\u0019;\u0002\u000b]|'\u000f\u001a\u0011\u0002\rY,7\r^8s+\t\u0011I\u0004E\u0003~\u0003[\u0012Y\u0004E\u0002~\u0005{I1Aa\u0010a\u0005\u00151En\\1u\u0003\u001d1Xm\u0019;pe\u0002\"bA!\u0012\u0003J\t-\u0003c\u0001B$)5\t!\u0003\u0003\u0004\u0002@e\u0001\rA\u0017\u0005\b\u0005kI\u0002\u0019\u0001B\u001d)\u0019\u0011)Ea\u0014\u0003R!A\u0011q\b\u000e\u0011\u0002\u0003\u0007!\fC\u0005\u00036i\u0001\n\u00111\u0001\u0003:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B,U\rQ&\u0011L\u0016\u0003\u00057\u0002BA!\u0018\u0003f5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'A\u0005v]\u000eDWmY6fI*\u00111\u000eY\u0005\u0005\u0005O\u0012yFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003n)\"!\u0011\bB-\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u000f\t\u0005\u0005k\u0012y(\u0004\u0002\u0003x)!!\u0011\u0010B>\u0003\u0011a\u0017M\\4\u000b\u0005\tu\u0014\u0001\u00026bm\u0006L1!\u001aB<\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015'\u0011\u0012\u0005\n\u0005\u0017{\u0012\u0011!a\u0001\u0003\u000b\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BI!\u0019\u0011\u0019J!'\u0002F6\u0011!Q\u0013\u0006\u0004\u0005/\u0003\u0017AC2pY2,7\r^5p]&!!1\u0014BK\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u0005&q\u0015\t\u0004{\n\r\u0016b\u0001BSA\n9!i\\8mK\u0006t\u0007\"\u0003BFC\u0005\u0005\t\u0019AAc\u0003!A\u0017m\u001d5D_\u0012,GCAA#\u0003!!xn\u0015;sS:<GC\u0001B:\u0003\u0019)\u0017/^1mgR!!\u0011\u0015B[\u0011%\u0011Y\tJA\u0001\u0002\u0004\t)-\u0001\u0003ECR\f\u0007c\u0001B$MM)aE!0\u0003\"AI!q\u0018Bc5\ne\"QI\u0007\u0003\u0005\u0003T1Aa1a\u0003\u001d\u0011XO\u001c;j[\u0016LAAa2\u0003B\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\te\u0016!B1qa2LHC\u0002B#\u0005\u001f\u0014\t\u000e\u0003\u0004\u0002@%\u0002\rA\u0017\u0005\b\u0005kI\u0003\u0019\u0001B\u001d\u0003\u001d)h.\u00199qYf$BAa6\u0003`B)QP!7\u0003^&\u0019!1\u001c1\u0003\r=\u0003H/[8o!\u0019i\u00181\u000f.\u0003:!I!\u0011\u001d\u0016\u0002\u0002\u0003\u0007!QI\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa:\u0011\t\tU$\u0011^\u0005\u0005\u0005W\u00149H\u0001\u0004PE*,7\r\u001e\u0002\u0014/>\u0014HM\r,fG6{G-\u001a7Xe&$XM]\n\u0004Y\t\u0005\u0011\u0001C5ogR\fgnY3\u0015\t\tU(q\u001f\t\u0004\u0005\u000fb\u0003B\u0002By]\u0001\u0007Q*\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011ipa\u0001\u0011\u0007u\u0014y0C\u0002\u0004\u0002\u0001\u0014A!\u00168ji\"11QA\u0018A\u0002i\u000bA\u0001]1uQ\u0006\u0019rk\u001c:eeY+7-T8eK2<&/\u001b;feB\u0019!qI\u0019\u0014\u0007E\u0012)\u0002\u0006\u0002\u0004\n\u0005Y2-\u00197dk2\fG/\u001a(v[\n,'o\u00144QCJ$\u0018\u000e^5p]N$\u0002\"!\u0012\u0004\u0014\ru1\u0011\u0005\u0005\b\u0007+\u0019\u0004\u0019AB\f\u0003E\u0011WO\u001a4feNK'0Z%o\u0005f$Xm\u001d\t\u0004{\u000ee\u0011bAB\u000eA\n!Aj\u001c8h\u0011\u001d\u0019yb\ra\u0001\u0003\u000b\n\u0001B\\;n/>\u0014Hm\u001d\u0005\b\u0007G\u0019\u0004\u0019AA#\u0003)1Xm\u0019;peNK'0\u001a\u0002\u0014/>\u0014HM\r,fG6{G-\u001a7SK\u0006$WM]\n\u0004i\r%\u0002\u0003B*\u0004,5K1a!\fU\u0005!iEJU3bI\u0016\u0014HCAB\u0019!\r\u00119\u0005N\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!\u0003\u0011aw.\u00193\u0015\u00075\u001bY\u0004\u0003\u0004\u0004\u0006a\u0002\rAW\u0001\u0005e\u0016\fG-\u0006\u0002\u0004*!\"\u0011\b\u001bB\u0005)\ri5Q\t\u0005\u0007\u0007\u000bQ\u0004\u0019\u0001.)\tiB'\u0011\u0002\u0015\u0005%!\u0014I\u0001\u000b\u0003\u0012Q\n%\u0001")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private final IntParam vectorSize;
    private final IntParam windowSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final IntParam maxSentenceLength;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static Word2VecModel load(String string) {
        return Word2VecModel$.MODULE$.load(string);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vec -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        return !this.bitmap$trans$0 ? this.getVectors$lzycompute() : this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(word, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(vec, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(VectorImplicits$.MODULE$.mlVectorToMLlibVector(vec), num);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(Word2VecModel $outer) {
            }
        }
        this.transformSchema(dataset.schema(), true);
        Map vectors = (Map)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vv -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vv)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
        Broadcast bVectors = dataset.sparkSession().sparkContext().broadcast((Object)vectors, ClassTag$.MODULE$.apply(Map.class));
        int d = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction word2Vec = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)sentence -> {
            Vector vector;
            if (sentence.isEmpty()) {
                vector = Vectors$.MODULE$.sparse(d, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            } else {
                void var3_3;
                Vector sum = Vectors$.MODULE$.zeros(d);
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    Word2VecModel.$anonfun$transform$5(bVectors, sum, word);
                    return BoxedUnit.UNIT;
                });
                BLAS$.MODULE$.scal(1.0 / (double)sentence.size(), sum);
                vector = var3_3;
            }
            return vector;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), word2Vec.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    public static final /* synthetic */ void $anonfun$transform$5(Broadcast bVectors$1, Vector sum$1, String word) {
        ((MapLike)bVectors$1.value()).get((Object)word).foreach((Function1 & Serializable & scala.Serializable)v -> {
            BLAS$.MODULE$.axpy(1.0, v, sum$1);
            return BoxedUnit.UNIT;
        });
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String word;
        private final float[] vector;

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.word();
                    break;
                }
                case 1: {
                    object = this.vector();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    public static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            Tuple2.mcII.sp sp3 = sp2;
            int major2 = sp3._1$mcI$sp();
            int minor2 = sp3._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((TraversableOnce)data.getAs(1)).toArray(ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2(Word2VecModelReader $outer) {
                    }
                }
                Map wordVectorsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.read().parquet(dataPath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2(null)))).collect())).map((Function1 & Serializable & scala.Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get("spark.kryoserializer.buffer.max", "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            SparkSession spark = this.sparkSession();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1(Word2VecModelWriter $outer) {
                }
            }
            spark.createDataset(wordVectors.toSeq(), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1(null)))).repartition(numPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String word = (String)tuple2._1();
                float[] vector = (float[])tuple2._2();
                Data data = new Data(word, vector);
                return data;
            }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(null)))).toDF().write().parquet(dataPath);
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

