/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3Qa\u0002\u0005\u0001\u0019IAQa\u0006\u0001\u0005\u0002eAQa\u0007\u0001\u0005BqAQA\u000b\u0001\u0005B-BQ!\u000f\u0001\u0005BiBQ!\u0011\u0001\u0005B\tCQA\u0013\u0001\u0005B-\u0013QcQ8tS:,G)[:uC:\u001cW-T3bgV\u0014XM\u0003\u0002\n\u0015\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005-a\u0011!B7mY&\u0014'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005A\u0011B\u0001\f\t\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003i\u0001\"\u0001\u0006\u0001\u0002\u0011\u0011L7\u000f^1oG\u0016$2!H\u0012)!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019!u.\u001e2mK\")AE\u0001a\u0001K\u0005\u0011a/\r\t\u0003)\u0019J!a\n\u0005\u0003\u001dY+7\r^8s/&$\bNT8s[\")\u0011F\u0001a\u0001K\u0005\u0011aOM\u0001\u0011kB$\u0017\r^3DYV\u001cH/\u001a:Tk6$2\u0001L\u00182!\tqR&\u0003\u0002/?\t!QK\\5u\u0011\u0015\u00014\u00011\u0001&\u0003\u0015\u0001x.\u001b8u\u0011\u0015\u00114\u00011\u00014\u0003\r\u0019X/\u001c\t\u0003i]j\u0011!\u000e\u0006\u0003m)\ta\u0001\\5oC2<\u0017B\u0001\u001d6\u0005\u00191Vm\u0019;pe\u0006A1-\u001a8ue>LG\rF\u0002&wqBQA\r\u0003A\u0002MBQ!\u0010\u0003A\u0002y\nQaY8v]R\u0004\"AH \n\u0005\u0001{\"\u0001\u0002'p]\u001e\f1b\u00197vgR,'oQ8tiR)Qd\u0011#G\u0011\")\u0011(\u0002a\u0001K!)Q)\u0002a\u0001K\u0005I\u0001o\\5oiN\u001cV/\u001c\u0005\u0006\u000f\u0016\u0001\rAP\u0001\u000f]Vl'-\u001a:PMB{\u0017N\u001c;t\u0011\u0015IU\u00011\u0001\u001e\u0003E\u0001x.\u001b8ugN\u000bX/\u0019:fI:{'/\\\u0001\u0013gflW.\u001a;sS\u000e\u001cUM\u001c;s_&$7\u000f\u0006\u0003M\u001fF\u001b\u0006\u0003\u0002\u0010NK\u0015J!AT\u0010\u0003\rQ+\b\u000f\\33\u0011\u0015\u0001f\u00011\u0001\u001e\u0003\u0015aWM^3m\u0011\u0015\u0011f\u00011\u00014\u0003\u0015qw.[:f\u0011\u0015Id\u00011\u00014\u0001")
public class CosineDistanceMeasure
extends DistanceMeasure {
    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        Predef$.MODULE$.assert(v1.norm() > 0.0 && v2.norm() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Cosine distance is not defined for zero-length vectors.");
        return 1.0 - BLAS$.MODULE$.dot(v1.vector(), v2.vector()) / v1.norm() / v2.norm();
    }

    @Override
    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        Predef$.MODULE$.assert(point.norm() > 0.0, (Function0 & java.io.Serializable & Serializable)() -> "Cosine distance is not defined for zero-length vectors.");
        BLAS$.MODULE$.axpy(1.0 / point.norm(), point.vector(), sum);
    }

    @Override
    public VectorWithNorm centroid(Vector sum, long count) {
        BLAS$.MODULE$.scal(1.0 / (double)count, sum);
        double norm = Vectors$.MODULE$.norm(sum, 2.0);
        BLAS$.MODULE$.scal(1.0 / norm, sum);
        return new VectorWithNorm(sum, 1.0);
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, long numberOfPoints, double pointsSquaredNorm) {
        Vector costVector = pointsSum.vector().copy();
        return package$.MODULE$.max((double)numberOfPoints - BLAS$.MODULE$.dot(centroid.vector(), costVector) / centroid.norm(), 0.0);
    }

    @Override
    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Tuple2<VectorWithNorm, VectorWithNorm> tuple2 = super.symmetricCentroids(level, noise, centroid);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        VectorWithNorm left = (VectorWithNorm)tuple2._1();
        VectorWithNorm right = (VectorWithNorm)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Tuple2 tuple23 = tuple22;
        VectorWithNorm left2 = (VectorWithNorm)tuple23._1();
        VectorWithNorm right2 = (VectorWithNorm)tuple23._2();
        Vector leftVector = left2.vector();
        Vector rightVector = right2.vector();
        BLAS$.MODULE$.scal(1.0 / left2.norm(), leftVector);
        BLAS$.MODULE$.scal(1.0 / right2.norm(), rightVector);
        return new Tuple2((Object)new VectorWithNorm(leftVector, 1.0), (Object)new VectorWithNorm(rightVector, 1.0));
    }
}

