/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.feature.PCAUtil$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3AAB\u0004\u0001%!A\u0011\u0004\u0001BC\u0002\u0013\u0005!\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\u001c\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015\u0001\u0004\u0001\"\u0001E\u0005\r\u00016)\u0011\u0006\u0003\u0011%\tqAZ3biV\u0014XM\u0003\u0002\u000b\u0017\u0005)Q\u000e\u001c7jE*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\u0001l+\u0005Y\u0002C\u0001\u000b\u001d\u0013\tiRCA\u0002J]RD3!A\u0010&!\t\u00013%D\u0001\"\u0015\t\u00113\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001J\u0011\u0003\u000bMKgnY3\"\u0003\u0019\nQ!\r\u00185]A\n!a\u001b\u0011)\u0007\tyR%\u0001\u0004=S:LGO\u0010\u000b\u0003W5\u0002\"\u0001\f\u0001\u000e\u0003\u001dAQ!G\u0002A\u0002mA3!L\u0010&Q\r\u0019q$J\u0001\u0004M&$HC\u0001\u001a6!\ta3'\u0003\u00025\u000f\tA\u0001kQ!N_\u0012,G\u000eC\u00037\t\u0001\u0007q'A\u0004t_V\u00148-Z:\u0011\u0007aZT(D\u0001:\u0015\tQ4\"A\u0002sI\u0012L!\u0001P\u001d\u0003\u0007I#E\t\u0005\u0002?\u00036\tqH\u0003\u0002A\u0013\u00051A.\u001b8bY\u001eL!AQ \u0003\rY+7\r^8sQ\r!q$\n\u000b\u0003e\u0015CQAN\u0003A\u0002\u0019\u00032a\u0012'>\u001b\u0005A%BA%K\u0003\u0011Q\u0017M^1\u000b\u0005-[\u0011aA1qS&\u0011Q\n\u0013\u0002\b\u0015\u00064\u0018M\u0015#EQ\r)q$\n\u0015\u0004\u0001})\u0003")
public class PCA {
    private final int k;

    public int k() {
        return this.k;
    }

    public PCAModel fit(RDD<Vector> sources) {
        DenseVector denseVector;
        DenseMatrix denseMatrix;
        int numFeatures = ((Vector)sources.first()).size();
        Predef$.MODULE$.require(this.k() <= numFeatures, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("source vector size ").append(numFeatures).append(" must be no less than k=").append(this.k()).toString());
        Predef$.MODULE$.require(PCAUtil$.MODULE$.memoryCost(this.k(), numFeatures) < Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> "The param k and numFeatures is too large for SVD computation. Try reducing the parameter k for PCA, or reduce the input feature vector dimension to make this tractable.");
        RowMatrix mat = new RowMatrix(sources);
        Tuple2<Matrix, Vector> tuple2 = mat.computePrincipalComponentsAndExplainedVariance(this.k());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Matrix pc = (Matrix)tuple2._1();
        Vector explainedVariance = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pc, (Object)explainedVariance);
        Tuple2 tuple23 = tuple22;
        Matrix pc2 = (Matrix)tuple23._1();
        Vector explainedVariance2 = (Vector)tuple23._2();
        Matrix matrix = pc2;
        if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix2;
            denseMatrix = denseMatrix2 = (DenseMatrix)matrix;
        } else if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            denseMatrix = sparseMatrix.toDense();
        } else {
            throw new IllegalArgumentException(new StringBuilder(78).append("Unsupported matrix format. Expected ").append("SparseMatrix or DenseMatrix. Instead got: ").append(matrix.getClass()).toString());
        }
        DenseMatrix densePC = denseMatrix;
        Vector vector = explainedVariance2;
        if (vector instanceof DenseVector) {
            DenseVector denseVector2;
            denseVector = denseVector2 = (DenseVector)vector;
        } else if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            denseVector = sparseVector.toDense();
        } else {
            throw new MatchError((Object)vector);
        }
        DenseVector denseExplainedVariance = denseVector;
        return new PCAModel(this.k(), densePC, denseExplainedVariance);
    }

    public PCAModel fit(JavaRDD<Vector> sources) {
        return this.fit((RDD<Vector>)sources.rdd());
    }

    public PCA(int k) {
        this.k = k;
        Predef$.MODULE$.require(k > 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Number of principal components must be positive but got ").append(this.k()).toString());
    }
}

