/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u000f\u001f\u0001%B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005m!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000b}\u0003A\u0011\t1\t\u000b1\u0004A\u0011I'\t\u000b9\u0004A\u0011I8\t\rM\u0004A\u0011\t\u0012u\u0011\u0015Y\b\u0001\"\u0011}\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\u0007\u0003c\u0001A\u0011I\u001b\t\r\u0005e\u0002\u0001\"\u00116\u0011!\ti\u0004\u0001C!=\u0005}\u0002BBA#\u0001\u0011\u0005S\u0007\u0003\u0005\u0002N\u0001!\tAIA(\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!a\u0017\u0001\t\u0003\nifB\u0004\u0002\u0010zA\t!!%\u0007\ruq\u0002\u0012AAJ\u0011\u0019)\u0006\u0004\"\u0001\u0002\u001c\"9\u0011Q\u0014\r\u0005\u0002\u0005}\u0005bBA\\1\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003\u0003D\u0012\u0011!C\u0005\u0003\u0007\u0014Ab\u00159beN,g+Z2u_JT!a\b\u0011\u0002\r1Lg.\u00197h\u0015\t\t#%A\u0003nY2L'M\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011GM\u0007\u0002=%\u00111G\b\u0002\u0007-\u0016\u001cGo\u001c:\u0002\tML'0Z\u000b\u0002mA\u00111fN\u0005\u0003q1\u00121!\u00138uQ\r\t!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\t\n!\"\u00198o_R\fG/[8o\u0013\tyDHA\u0003TS:\u001cW-I\u0001B\u0003\u0015\td\u0006\r\u00181\u0003\u0015\u0019\u0018N_3!Q\r\u0011!\bQ\u0001\bS:$\u0017nY3t+\u00051\u0005cA\u0016Hm%\u0011\u0001\n\f\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004\u0007i\u0002\u0015\u0001C5oI&\u001cWm\u001d\u0011)\u0007\u0011Q\u0004)\u0001\u0004wC2,Xm]\u000b\u0002\u001dB\u00191fR(\u0011\u0005-\u0002\u0016BA)-\u0005\u0019!u.\u001e2mK\"\u001aQA\u000f!\u0002\u000fY\fG.^3tA!\u001aaA\u000f!\u0002\rqJg.\u001b;?)\u00119\u0006L\u0017/\u0011\u0005E\u0002\u0001\"\u0002\u001b\b\u0001\u00041\u0004f\u0001-;\u0001\")Ai\u0002a\u0001\r\"\u001a!L\u000f!\t\u000b1;\u0001\u0019\u0001()\u0007qS\u0004\tK\u0002\bu\u0001\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002CB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001\u001a\u0017\u000e\u0003\u0015T!A\u001a\u0015\u0002\rq\u0012xn\u001c;?\u0013\tAG&\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015-\u0003\u001d!x.\u0011:sCfD3!\u0003\u001eA\u0003\u0011\u0019w\u000e]=\u0016\u0003]C3A\u0003\u001erC\u0005\u0011\u0018!B\u0019/c9\u0002\u0014\u0001C1t\u0005J,WM_3\u0016\u0003U\u00042A\u001e>P\u001b\u00059(BA\u0010y\u0015\u0005I\u0018A\u00022sK\u0016TX-\u0003\u00024o\u0006)\u0011\r\u001d9msR\u0011q* \u0005\u0006}2\u0001\rAN\u0001\u0002S\u0006iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$B!a\u0001\u0002\nA\u00191&!\u0002\n\u0007\u0005\u001dAF\u0001\u0003V]&$\bbBA\u0006\u001b\u0001\u0007\u0011QB\u0001\u0002MB91&a\u00047\u001f\u0006\r\u0011bAA\tY\tIa)\u001e8di&|gN\r\u0015\u0005\u001bi\n)\"\t\u0002\u0002\u0018\u0005)\u0011G\f\u001c/a\u00051Q-];bYN$B!!\b\u0002$A\u00191&a\b\n\u0007\u0005\u0005BFA\u0004C_>dW-\u00198\t\u000f\u0005\u0015b\u00021\u0001\u0002(\u0005)q\u000e\u001e5feB\u00191&!\u000b\n\u0007\u0005-BFA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002m\u0005Qa.^7BGRLg/Z:)\tAQ\u0014QG\u0011\u0003\u0003o\tQ!\r\u00185]A\n1B\\;n\u001d>t'0\u001a:pg\"\"\u0011COA\u001b\u0003A!xn\u00159beN,w+\u001b;i'&TX\rF\u0002X\u0003\u0003Ba!a\u0011\u0013\u0001\u00041\u0014a\u00018ou\u00061\u0011M]4nCbDCa\u0005\u001e\u0002J\u0005\u0012\u00111J\u0001\u0006c9*d\u0006M\u0001\u0006g2L7-\u001a\u000b\u0004/\u0006E\u0003BBA*)\u0001\u0007a)A\btK2,7\r^3e\u0013:$\u0017nY3t\u0003\u0019!xNS:p]V\t\u0011\r\u000b\u0003\u0016u\u0005U\u0011\u0001B1t\u001b2+\"!a\u0018\u0011\t\u0005\u0005\u0014\u0011N\u0007\u0003\u0003GR1aHA3\u0015\r\t9GI\u0001\u0003[2L1!HA2Q\u00111\"(!\u001c\"\u0005\u0005=\u0014!\u0002\u001a/a9\u0002\u0004f\u0002\u0001\u0002t\u0005\r\u0015Q\u0011\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003\u0015!\u0018\u0010]3t\u0015\r\tiHI\u0001\u0004gFd\u0017\u0002BAA\u0003o\u0012!cU)M+N,'\u000fR3gS:,G\rV=qK\u0006\u0019Q\u000f\u001a;$\u0005\u0005\u001d\u0005cA\u0019\u0002\n&\u0019\u00111\u0012\u0010\u0003\u0013Y+7\r^8s+\u0012#\u0006f\u0001\u0001;\u0001\u0006a1\u000b]1sg\u00164Vm\u0019;peB\u0011\u0011\u0007G\n\u00051)\n)\nE\u0002,\u0003/K1!!'-\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t\t*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0016Q\u0016\t\u0006W\u0005\r\u0016qU\u0005\u0004\u0003Kc#AB(qi&|g\u000e\u0005\u0004,\u0003S3dIT\u0005\u0004\u0003Wc#A\u0002+va2,7\u0007\u0003\u0004\u00020j\u0001\raV\u0001\u0003gZDCA\u0007\u001e\u00024\u0006\u0012\u0011QW\u0001\u0006c9\u001ad\u0006M\u0001\u0007MJ|W.\u0014'\u0015\u0007]\u000bY\fC\u0004\u0002>n\u0001\r!a\u0018\u0002\u0003YDCa\u0007\u001e\u0002n\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\fAA[1wC&!\u00111[Ae\u0005\u0019y%M[3di\"\"\u0001DOAZQ\u00119\"(a-")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static SparseVector fromML(org.apache.spark.ml.linalg.SparseVector sparseVector) {
        return SparseVector$.MODULE$.fromML(sparseVector);
    }

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringBuilder(4).append("(").append(this.size()).append(",").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).mkString("[", ",", "]")).append(",").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]")).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public double apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException(new StringBuilder(26).append("Index ").append(i).append(" out of bounds [0, ").append(this.size()).append(")").toString());
        }
        int j = Arrays.binarySearch(this.indices(), i);
        return j < 0 ? 0.0 : this.values()[j];
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            block0: {
                if (v == 0.0) break block0;
                ++nnz$3.elem;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        SparseVector sparseVector;
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
                block0: {
                    if (v == 0.0) break block0;
                    ii$2[k$2.elem] = i;
                    vv$2[k$2.elem] = v;
                    ++k$2.elem;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else if (this.numActives() == 0) {
            n = 0;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = IntRef.create((int)0);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(selectedIndices)).flatMap((Function1 & Serializable & scala.Serializable)origIdx -> SparseVector.$anonfun$slice$1(this, currentIdx, BoxesRunTime.unboxToInt((Object)origIdx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] sliceInds = (int[])tuple2._1();
        double[] sliceVals = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
        Tuple2 tuple23 = tuple22;
        int[] sliceInds2 = (int[])tuple23._1();
        double[] sliceVals2 = (double[])tuple23._2();
        return new SparseVector(selectedIndices.length, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sliceInds2)).toArray(ClassTag$.MODULE$.Int()), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sliceVals2)).toArray(ClassTag$.MODULE$.Double()));
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$1 = jValue = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)0)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToInteger((int)this.size())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indices"), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)))));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public org.apache.spark.ml.linalg.SparseVector asML() {
        return new org.apache.spark.ml.linalg.SparseVector(this.size(), this.indices(), this.values());
    }

    public static final /* synthetic */ Iterator $anonfun$slice$1(SparseVector $this, IntRef currentIdx$1, int origIdx) {
        int iIdx = Arrays.binarySearch($this.indices(), origIdx);
        Iterator i_v = iIdx >= 0 ? package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(currentIdx$1.elem, $this.values()[iIdx])})) : package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
        ++currentIdx$1.elem;
        return i_v;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector.$init$(this);
        Predef$.MODULE$.require(size >= 0, (Function0 & Serializable & scala.Serializable)() -> "The size of the requested sparse vector must be no less than 0.");
        Predef$.MODULE$.require(indices.length == values.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Sparse vectors require that the dimension of the").append(" indices match the dimension of the values. You provided ").append(this.indices().length).append(" indices and ").append(" ").append(this.values().length).append(" values.").toString());
        Predef$.MODULE$.require(indices.length <= size, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("You provided ").append(this.indices().length).append(" indices and values, ").append("which exceeds the specified vector size ").append(this.size()).append(".").toString());
    }
}

