/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B/_\u0001%D\u0001B \u0001\u0003\u0006\u0004%\te \u0005\u000b\u0003[\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001BCA\u0019\u0001\t\u0015\r\u0011\"\u0001\u00024!Q\u0011\u0011\t\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005\u0015\u0003A!b\u0001\n\u0003\t9\u0005C\u0005\u0002L\u0001\u0011\t\u0011)A\u0005]\"Q\u0011q\n\u0001\u0003\u0006\u0004%\t%!\u0015\t\u0015\u0005\u0005\u0004A!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002f\u0001\u0011)\u0019!C\u0005\u0003OB!\"a\u001c\u0001\u0005\u0003\u0005\u000b\u0011BA5\u0011!\t\t\b\u0001C\u0001E\u0006M\u0004\u0002CA9\u0001\u0011\u0005!-a\"\t\u000f\u00055\u0005\u0001\"\u0001\u0002H!Q\u0011q\u0014\u0001\t\u0006\u0004%I!a\u0012\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\"\"Q\u0011Q\u0015\u0001\t\u0006\u0004%I!!)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011q\u0017\u0001\u0005B\u0005\u0005\u0006bBA^\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011%\ty\r\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BAj\u0011%\tY\u000e\u0001b\u0001\n\u0013\ti\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAp\u0011%\t\u0019\u000f\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAj\u0011%\t9\u000f\u0001b\u0001\n\u0003\n\t\u0006\u0003\u0005\u0002p\u0002\u0001\u000b\u0011BA*\u0011%\t\u0019\u0010\u0001a\u0001\n\u0013\t)\u0010C\u0005\u0003\u0004\u0001\u0001\r\u0011\"\u0003\u0003\u0006!A!\u0011\u0003\u0001!B\u0013\t9\u0010C\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!A!\u0011\u0006\u0001\u0005\u0002y\u0013Y\u0003\u0003\u0005\u00034\u0001!\tA\u0018B\u001b\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003OBqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\te\u0004\u0001\"\u0015\u0003|!9!\u0011\u0011\u0001\u0005R\t\r\u0005b\u0002BD\u0001\u0011\u0005#\u0011\u0012\u0005\b\u0005;\u0003A\u0011\u000bBP\u0011\u001d\u0011\u0019\u000b\u0001C)\u0005KCqAa+\u0001\t\u0003\u0012i\u000bC\u0004\u00038\u0002!\tE!/\b\u000f\tuf\f#\u0001\u0003@\u001a1QL\u0018E\u0001\u0005\u0003Dq!!\u001d0\t\u0003\u0011)\u000eC\u0004\u0003X>\"\tE!7\t\u000f\t\rx\u0006\"\u0011\u0003f\u001a9!Q^\u0018\u0001_\t=\b\"\u0003B\u007fg\t\u0005\t\u0015!\u0003u\u0011\u001d\t\th\rC\u0001\u0005\u007f4aaa\u00024\t\u000e%\u0001BCA(m\tU\r\u0011\"\u0001\u0002R!Q\u0011\u0011\r\u001c\u0003\u0012\u0003\u0006I!a\u0015\t\u0015\u0005\u001dhG!f\u0001\n\u0003\t\t\u0006\u0003\u0006\u0002pZ\u0012\t\u0012)A\u0005\u0003'B!\"!\u00127\u0005+\u0007I\u0011AA$\u0011%\tYE\u000eB\tB\u0003%a\u000e\u0003\u0006\u00022Y\u0012)\u001a!C\u0001\u0003gA!\"!\u00117\u0005#\u0005\u000b\u0011BA\u001b\u0011)\t)G\u000eBK\u0002\u0013\u0005\u0011q\r\u0005\u000b\u0003_2$\u0011#Q\u0001\n\u0005%\u0004bBA9m\u0011\u00051\u0011\u0003\u0005\n\u0005\u000f3\u0014\u0011!C\u0001\u0007CA\u0011b!\f7#\u0003%\taa\f\t\u0013\r\rc'%A\u0005\u0002\r=\u0002\"CB#mE\u0005I\u0011AB$\u0011%\u0019YENI\u0001\n\u0003\u0019i\u0005C\u0005\u0004RY\n\n\u0011\"\u0001\u0004T!I1q\u000b\u001c\u0002\u0002\u0013\u00053\u0011\f\u0005\n\u0007S2\u0014\u0011!C\u0001\u0003#B\u0011ba\u001b7\u0003\u0003%\ta!\u001c\t\u0013\rEd'!A\u0005B\rM\u0004\"CBAm\u0005\u0005I\u0011ABB\u0011%\u00199INA\u0001\n\u0003\u001aI\tC\u0005\u00038Z\n\t\u0011\"\u0011\u0004\f\"I1Q\u0012\u001c\u0002\u0002\u0013\u00053qR\u0004\n\u0007'\u001b\u0014\u0011!E\u0005\u0007+3\u0011ba\u00024\u0003\u0003EIaa&\t\u000f\u0005E\u0014\u000b\"\u0001\u0004&\"I!qW)\u0002\u0002\u0013\u001531\u0012\u0005\n\u0007O\u000b\u0016\u0011!CA\u0007SC\u0011b!.R\u0003\u0003%\tia.\t\u000f\r\u00157\u0007\"\u0015\u0004H\u001a111Z\u0018\u0005\u0007\u001bDq!!\u001dX\t\u0003\u0019y\rC\u0005\u0004T^\u0013\r\u0011\"\u0003\u0004Z!A1Q[,!\u0002\u0013\u0019Y\u0006C\u0004\u0003d^#\tea6\t\u0013\rmw&!A\u0005\n\ru'a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m\u0015\ty\u0006-\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0014\u0017AA7m\u0015\t\u0019G-A\u0003ta\u0006\u00148N\u0003\u0002fM\u00061\u0011\r]1dQ\u0016T\u0011aZ\u0001\u0004_J<7\u0001A\n\u0005\u0001),\b\u0010\u0005\u0003lY:$X\"\u00010\n\u00055t&\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u001c:\u000e\u0003AT!!\u001d1\u0002\r1Lg.\u00197h\u0013\t\u0019\bO\u0001\u0004WK\u000e$xN\u001d\t\u0003W\u0002\u0001\"a\u001b<\n\u0005]t&\u0001\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ngB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010Y\u0001\u0005kRLG.\u0003\u0002~u\nQQ\nT,sSR\f'\r\\3\u0002\u0007ULG-\u0006\u0002\u0002\u0002A!\u00111AA\u000b\u001d\u0011\t)!!\u0005\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003i\u0003\u0019a$o\\8u})\u0011\u0011qB\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003'\ti!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003'\ti\u0001K\u0003\u0002\u0003;\tI\u0003\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019CY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0014\u0003C\u0011QaU5oG\u0016\f#!a\u000b\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0006\u0005\u0005u\u0011\u0011F\u0001\u0012G>,gMZ5dS\u0016tG/T1ue&DXCAA\u001b!\ry\u0017qG\u0005\u0004\u0003s\u0001(AB'biJL\u0007\u0010K\u0003\u0004\u0003;\ti$\t\u0002\u0002@\u0005)!GL\u0019/a\u0005\u00112m\\3gM&\u001c\u0017.\u001a8u\u001b\u0006$(/\u001b=!Q\u0015!\u0011QDA\u001f\u0003=Ig\u000e^3sG\u0016\u0004HOV3di>\u0014X#\u00018)\u000b\u0015\ti\"!\u0010\u0002!%tG/\u001a:dKB$h+Z2u_J\u0004\u0003&\u0002\u0004\u0002\u001e\u0005u\u0012A\u00038v[\u000ec\u0017m]:fgV\u0011\u00111\u000b\t\u0005\u0003+\n9&\u0004\u0002\u0002\u000e%!\u0011\u0011LA\u0007\u0005\rIe\u000e\u001e\u0015\u0006\u000f\u0005u\u0011QL\u0011\u0003\u0003?\nQ!\r\u00184]A\n1B\\;n\u00072\f7o]3tA!*\u0001\"!\b\u0002^\u0005i\u0011n]'vYRLgn\\7jC2,\"!!\u001b\u0011\t\u0005U\u00131N\u0005\u0005\u0003[\niAA\u0004C_>dW-\u00198\u0002\u001d%\u001cX*\u001e7uS:|W.[1mA\u00051A(\u001b8jiz\"2\u0002^A;\u0003s\ni(!!\u0002\u0006\"1ap\u0003a\u0001\u0003\u0003Ac!!\u001e\u0002\u001e\u0005%\u0002bBA\u0019\u0017\u0001\u0007\u0011Q\u0007\u0015\u0007\u0003s\ni\"!\u0010\t\r\u0005\u00153\u00021\u0001oQ\u0019\ti(!\b\u0002>!9\u0011qJ\u0006A\u0002\u0005M\u0003FBAA\u0003;\ti\u0006C\u0004\u0002f-\u0001\r!!\u001b\u0015\u000fQ\fI)a#\u0002\u0010\"1a\u0010\u0004a\u0001\u0003\u0003Aa!!$\r\u0001\u0004q\u0017\u0001D2pK\u001a4\u0017nY5f]R\u001c\bbBAI\u0019\u0001\u0007\u00111S\u0001\nS:$XM]2faR\u0004B!!\u0016\u0002\u0016&!\u0011qSA\u0007\u0005\u0019!u.\u001e2mK\"*Q\"!\b\u0002\u001c\u0006\u0012\u0011QT\u0001\u0006e9\u0002d\u0006M\u0001\u000e?\u000e|WM\u001a4jG&,g\u000e^:\u0016\u0005\u0005M\u0005&B\b\u0002\u001e\u0005u\u0013AC0j]R,'oY3qi\u0006a1/\u001a;UQJ,7\u000f[8mIR!\u00111VAW\u001b\u0005\u0001\u0001bBAX#\u0001\u0007\u00111S\u0001\u0006m\u0006dW/\u001a\u0015\u0006#\u0005u\u00111W\u0011\u0003\u0003k\u000bQ!\r\u00186]A\nAbZ3u)\"\u0014Xm\u001d5pY\u0012DSAEA\u000f\u0003g\u000bQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cH\u0003BAV\u0003\u007fCq!a,\u0014\u0001\u0004\t\t\r\u0005\u0004\u0002V\u0005\r\u00171S\u0005\u0005\u0003\u000b\fiAA\u0003BeJ\f\u0017\u0010K\u0003\u0014\u0003;\t\u0019,A\u0007hKR$\u0006N]3tQ>dGm]\u000b\u0003\u0003\u0003DS\u0001FA\u000f\u0003g\u000ba!\\1sO&tWCAAj!\u001d\t)&!6o\u0003'KA!a6\u0002\u000e\tIa)\u001e8di&|g.M\u0001\b[\u0006\u0014x-\u001b8!\u0003\u001di\u0017M]4j]N,\"!a8\u0011\r\u0005U\u0013Q\u001b8o\u0003!i\u0017M]4j]N\u0004\u0013!B:d_J,\u0017AB:d_J,\u0007%A\u0006ok64U-\u0019;ve\u0016\u001c\b&B\u000e\u0002\u001e\u0005-\u0018EAAw\u0003\u0015\tdF\u000e\u00181\u00031qW/\u001c$fCR,(/Z:!Q\u0015a\u0012QDAv\u0003=!(/Y5oS:<7+^7nCJLXCAA|!\u0019\t)&!?\u0002~&!\u00111`A\u0007\u0005\u0019y\u0005\u000f^5p]B\u00191.a@\n\u0007\t\u0005aLA\u0011M_\u001eL7\u000f^5d%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\nue\u0006Lg.\u001b8h'VlW.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0003\b\t5\u0001\u0003BA+\u0005\u0013IAAa\u0003\u0002\u000e\t!QK\\5u\u0011%\u0011yAHA\u0001\u0002\u0004\t90A\u0002yIE\n\u0001\u0003\u001e:bS:LgnZ*v[6\f'/\u001f\u0011\u0002\u000fM,X.\\1ssV\u0011\u0011Q \u0015\u0006A\u0005u\u00111W\u0001\u000eE&t\u0017M]=Tk6l\u0017M]=\u0016\u0005\tu\u0001cA6\u0003 %\u0019!\u0011\u00050\u0003O\tKg.\u0019:z\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000e\u0016:bS:LgnZ*v[6\f'/\u001f\u0015\u0006C\u0005u!QE\u0011\u0003\u0005O\tQA\r\u00184]A\n\u0001CZ5oIN+X.\\1ss6{G-\u001a7\u0015\u0005\t5\u0002#CA+\u0005_!\u0018\u0011AA\u0001\u0013\u0011\u0011\t$!\u0004\u0003\rQ+\b\u000f\\34\u0003)\u0019X\r^*v[6\f'/\u001f\u000b\u0005\u0003W\u00139\u0004C\u0004\u0003\u0014\r\u0002\r!a>\u0002\u0015!\f7oU;n[\u0006\u0014\u0018\u0010K\u0003%\u0003;\t\u0019,\u0001\u0005fm\u0006dW/\u0019;f)\u0011\u0011\tEa\u0012\u0011\u0007-\u0014\u0019%C\u0002\u0003Fy\u0013\u0011\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]N+X.\\1ss\"9!\u0011J\u0013A\u0002\t-\u0013a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0005\u001b\u0012i\u0006\u0005\u0004\u0003P\tU#\u0011L\u0007\u0003\u0005#R1Aa\u0015c\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005/\u0012\tFA\u0004ECR\f7/\u001a;\u0011\t\tm#Q\f\u0007\u0001\t1\u0011yFa\u0012\u0002\u0002\u0003\u0005)\u0011\u0001B1\u0005\ryFeM\t\u0005\u0005G\u0012I\u0007\u0005\u0003\u0002V\t\u0015\u0014\u0002\u0002B4\u0003\u001b\u0011qAT8uQ&tw\r\u0005\u0003\u0002V\t-\u0014\u0002\u0002B7\u0003\u001b\u00111!\u00118zQ\u0015)\u0013QDAN\u0003\u001d\u0001(/\u001a3jGR$B!a%\u0003v!1!q\u000f\u0014A\u00029\f\u0001BZ3biV\u0014Xm]\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0019aN! \t\r\t}t\u00051\u0001o\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006Q\u0001O]3eS\u000e$(+Y<\u0015\u00079\u0014)\t\u0003\u0004\u0003x!\u0002\rA\\\u0001\u0005G>\u0004\u0018\u0010F\u0002u\u0005\u0017CqA!$*\u0001\u0004\u0011y)A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003\u0012\n]UB\u0001BJ\u0015\r\u0011)\nY\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u00053\u0013\u0019J\u0001\u0005QCJ\fW.T1qQ\u0015I\u0013QDA\u0015\u00039\u0011\u0018m\u001e\u001aqe\u0016$\u0017n\u0019;j_:$B!a%\u0003\"\"1!q\u0010\u0016A\u00029\fa\u0003\u001d:pE\u0006\u0014\u0017\u000e\\5usJ\u0002(/\u001a3jGRLwN\u001c\u000b\u0005\u0003'\u00139\u000b\u0003\u0004\u0003*.\u0002\rA\\\u0001\faJ|'-\u00192jY&$\u00180A\u0003xe&$X-\u0006\u0002\u00030B\u0019\u0011P!-\n\u0007\tM&P\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015a\u0013QDAv\u0003!!xn\u0015;sS:<GCAA\u0001Q\u0015\u0001\u0011QDA\u0015\u0003]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002l_M9qFa1\u0003J\n=\u0007\u0003BA+\u0005\u000bLAAa2\u0002\u000e\t1\u0011I\\=SK\u001a\u0004B!\u001fBfi&\u0019!Q\u001a>\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0002V\tE\u0017\u0002\u0002Bj\u0003\u001b\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa0\u0002\tI,\u0017\rZ\u000b\u0003\u00057\u0004B!\u001fBoi&\u0019!q\u001c>\u0003\u00115c%+Z1eKJDS!MA\u000f\u0003W\fA\u0001\\8bIR\u0019AOa:\t\u000f\t%(\u00071\u0001\u0002\u0002\u0005!\u0001/\u0019;iQ\u0015\u0011\u0014QDAv\u0005uaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148#B\u001a\u00030\nE\b\u0003\u0002Bz\u0005sl!A!>\u000b\u0007\t](-\u0001\u0005j]R,'O\\1m\u0013\u0011\u0011YP!>\u0003\u000f1{wmZ5oO\u0006A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0004\u0002\r\u0015\u0001cAB\u0002g5\tq\u0006\u0003\u0004\u0003~V\u0002\r\u0001\u001e\u0002\u0005\t\u0006$\u0018mE\u00047\u0005\u0007\u001cYAa4\u0011\t\u0005U3QB\u0005\u0005\u0007\u001f\tiAA\u0004Qe>$Wo\u0019;\u0015\u0019\rM1qCB\r\u00077\u0019iba\b\u0011\u0007\rUa'D\u00014\u0011\u001d\ty%\u0011a\u0001\u0003'Bq!a:B\u0001\u0004\t\u0019\u0006\u0003\u0004\u0002F\u0005\u0003\rA\u001c\u0005\b\u0003c\t\u0005\u0019AA\u001b\u0011\u001d\t)'\u0011a\u0001\u0003S\"Bba\u0005\u0004$\r\u00152qEB\u0015\u0007WA\u0011\"a\u0014C!\u0003\u0005\r!a\u0015\t\u0013\u0005\u001d(\t%AA\u0002\u0005M\u0003\u0002CA#\u0005B\u0005\t\u0019\u00018\t\u0013\u0005E\"\t%AA\u0002\u0005U\u0002\"CA3\u0005B\u0005\t\u0019AA5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\r+\t\u0005M31G\u0016\u0003\u0007k\u0001Baa\u000e\u0004@5\u00111\u0011\b\u0006\u0005\u0007w\u0019i$A\u0005v]\u000eDWmY6fI*!\u00111EA\u0007\u0013\u0011\u0019\te!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\n\u0016\u0004]\u000eM\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u001fRC!!\u000e\u00044\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAB+U\u0011\tIga\r\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019Y\u0006\u0005\u0003\u0004^\r\u001dTBAB0\u0015\u0011\u0019\tga\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0007K\nAA[1wC&!\u0011qCB0\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u001b\u0004p!I!q\u0002&\u0002\u0002\u0003\u0007\u00111K\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\u000f\t\u0007\u0007o\u001aiH!\u001b\u000e\u0005\re$\u0002BB>\u0003\u001b\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019yh!\u001f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\u001a)\tC\u0005\u0003\u00101\u000b\t\u00111\u0001\u0003j\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002TQ\u001111L\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%4\u0011\u0013\u0005\n\u0005\u001fy\u0015\u0011!a\u0001\u0005S\nA\u0001R1uCB\u00191QC)\u0014\u000bE\u001bIJa4\u0011\u001f\rm5\u0011UA*\u0003'r\u0017QGA5\u0007'i!a!(\u000b\t\r}\u0015QB\u0001\beVtG/[7f\u0013\u0011\u0019\u0019k!(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0004\u0016\u0006)\u0011\r\u001d9msRa11CBV\u0007[\u001byk!-\u00044\"9\u0011q\n+A\u0002\u0005M\u0003bBAt)\u0002\u0007\u00111\u000b\u0005\u0007\u0003\u000b\"\u0006\u0019\u00018\t\u000f\u0005EB\u000b1\u0001\u00026!9\u0011Q\r+A\u0002\u0005%\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007s\u001b\t\r\u0005\u0004\u0002V\u0005e81\u0018\t\u000e\u0003+\u001ai,a\u0015\u0002T9\f)$!\u001b\n\t\r}\u0016Q\u0002\u0002\u0007)V\u0004H.Z\u001b\t\u0013\r\rW+!AA\u0002\rM\u0011a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003\b\r%\u0007b\u0002Bu-\u0002\u0007\u0011\u0011\u0001\u0002\u001e\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019qKa7\u0015\u0005\rE\u0007cAB\u0002/\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004Cc\u0001;\u0004Z\"9!\u0011^.A\u0002\u0005\u0005\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa8\u0011\t\ru3\u0011]\u0005\u0005\u0007G\u001cyF\u0001\u0004PE*,7\r\u001e\u0015\u0006_\u0005u\u00111\u001e\u0015\u0006]\u0005u\u00111\u001e")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private Vector _coefficients;
    private double _intercept;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private double _intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._intercept = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.interceptVector().toArray())).head());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._intercept;
    }

    private double _intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._intercept$lzycompute() : this._intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this LogisticRegressionModel");
        });
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(88).append("Cannot create a binary summary for a non-binary model").append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public Tuple3<LogisticRegressionModel, String, String> findSummaryModel() {
        LogisticRegressionModel model = this.$(this.probabilityCol()).isEmpty() && this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)((PredictionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString())).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.probabilityCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : this));
        return new Tuple3((Object)model, (Object)model.getProbabilityCol(), (Object)model.getPredictionCol());
    }

    public LogisticRegressionModel setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple3<LogisticRegressionModel, String, String> tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol())) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector2 = (DenseVector)vector;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                int size = denseVector2.size();
                double[] values = denseVector2.values();
                int maxMarginIndex = rawPrediction.argmax();
                double maxMargin = rawPrediction.apply(maxMarginIndex);
                if (maxMargin == Double.POSITIVE_INFINITY) {
                    for (int k = 0; k < size; ++k) {
                        values[k] = k == maxMarginIndex ? 1.0 : 0.0;
                    }
                } else {
                    double temp = 0.0;
                    for (int k = 0; k < this.numClasses(); ++k) {
                        values[k] = maxMargin > 0.0 ? scala.math.package$.MODULE$.exp(values[k] - maxMargin) : scala.math.package$.MODULE$.exp(values[k]);
                        temp += values[k];
                    }
                    double sum = temp;
                    BLAS$.MODULE$.scal(1.0 / sum, (Vector)denseVector2);
                }
                denseVector = denseVector2;
            } else {
                int size = denseVector2.size();
                for (int i = 0; i < size; ++i) {
                    denseVector2.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector2.values()[i]));
                }
                denseVector = denseVector2;
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector3 = denseVector;
        return denseVector3;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double d;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            d = super.raw2prediction(rawPrediction);
        } else {
            double t = this.getThreshold();
            double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
            d = rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(62).append("LogisticRegressionModel: ").append("uid = ").append(Identifiable.toString$(this)).append(", numClasses = ").append(this.numClasses()).append(", numFeatures = ").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dimension mismatch! Expected ").append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").append(this.interceptVector().size()).toString());
        this.margin = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable & scala.Serializable)features -> {
            void var2_2;
            DenseVector m = this.interceptVector().toDense().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
        this.trainingSummary = None$.MODULE$;
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqLike)some.get()).apply(0);
                                    Object numFeatures = ((SeqLike)some.get()).apply(1);
                                    Object intercept = ((SeqLike)some.get()).apply(2);
                                    coefficients = ((SeqLike)some.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

