/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00054Qa\u0004\t\u0001)qA\u0001B\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\u0001\u0006A1A\u0005RECa!\u0016\u0001!\u0002\u0013\u0011\u0006b\u0002,\u0001\u0005\u0004%I!\u0015\u0005\u0007/\u0002\u0001\u000b\u0011\u0002*\t\u000fa\u0003!\u0019!C\u00053\"1!\f\u0001Q\u0001\nQBqa\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004]\u0001\u0001\u0006I\u0001\u000e\u0005\u0006;\u0002!\tA\u0018\u0002\u0010\u0011V\u0014WM]!hOJ,w-\u0019;pe*\u0011\u0011CE\u0001\u000bC\u001e<'/Z4bi>\u0014(BA\n\u0015\u0003\u0015y\u0007\u000f^5n\u0015\t)b#\u0001\u0002nY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xmE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007\u0003\u0002\u0013&O5j\u0011\u0001E\u0005\u0003MA\u0011A\u0004R5gM\u0016\u0014XM\u001c;jC\ndW\rT8tg\u0006;wM]3hCR|'\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+)\u00059a-Z1ukJ,\u0017B\u0001\u0017*\u0005!Ien\u001d;b]\u000e,\u0007C\u0001\u0013\u0001\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u\u0007\u0001\u0001\"AH\u0019\n\u0005Iz\"a\u0002\"p_2,\u0017M\\\u0001\bKB\u001c\u0018\u000e\\8o!\tqR'\u0003\u00027?\t1Ai\\;cY\u0016\fQBY2GK\u0006$XO]3t'R$\u0007cA\u001d=}5\t!H\u0003\u0002<-\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003{i\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007yyD'\u0003\u0002A?\t)\u0011I\u001d:bs\u0006a!m\u0019)be\u0006lW\r^3sgB\u0019\u0011\bP\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019#\u0012A\u00027j]\u0006dw-\u0003\u0002I\u000b\n1a+Z2u_J\fa\u0001P5oSRtD\u0003B&N\u001d>#\"!\f'\t\u000b\u0005+\u0001\u0019\u0001\"\t\u000b9*\u0001\u0019\u0001\u0019\t\u000bM*\u0001\u0019\u0001\u001b\t\u000b]*\u0001\u0019\u0001\u001d\u0002\u0007\u0011LW.F\u0001S!\tq2+\u0003\u0002U?\t\u0019\u0011J\u001c;\u0002\t\u0011LW\u000eI\u0001\f]Vlg)Z1ukJ,7/\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b%A\u0003tS\u001el\u0017-F\u00015\u0003\u0019\u0019\u0018nZ7bA\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f^\u0001\u000bS:$XM]2faR\u0004\u0013aA1eIR\u0011Qf\u0018\u0005\u0006A:\u0001\raJ\u0001\tS:\u001cH/\u00198dK\u0002")
public class HuberAggregator
implements DifferentiableLossAggregator<Instance, HuberAggregator> {
    private final boolean fitIntercept;
    private final double epsilon;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<Vector> bcParameters;
    private final int dim;
    private final int numFeatures;
    private final double sigma;
    private final double intercept;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        HuberAggregator huberAggregator = this;
        synchronized (huberAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    private double sigma() {
        return this.sigma;
    }

    private double intercept() {
        return this.intercept;
    }

    @Override
    public HuberAggregator add(Instance instance) {
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double margin;
            double linearLoss;
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(64).append("Dimensions mismatch when adding new sample.").append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
            double[] localCoefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((Vector)this.bcParameters.value()).toArray())).slice(0, this.numFeatures());
            double[] localGradientSumArray = this.gradientSumArray();
            DoubleRef sum = DoubleRef.create((double)0.0);
            features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                block0: {
                    if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                    sum$1.elem += localCoefficients[index] * (value / localFeaturesStd[index]);
                }
            });
            if (this.fitIntercept) {
                sum.elem += this.intercept();
            }
            if (package$.MODULE$.abs(linearLoss = label - (margin = sum.elem)) <= this.sigma() * this.epsilon) {
                this.lossSum_$eq(this.lossSum() + 0.5 * weight * (this.sigma() + package$.MODULE$.pow(linearLoss, 2.0) / this.sigma()));
                double linearLossDivSigma = linearLoss / this.sigma();
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + -1.0 * weight * linearLossDivSigma * (value / localFeaturesStd[index]);
                    }
                });
                if (this.fitIntercept) {
                    int n = this.dim() - 2;
                    localGradientSumArray[n] = localGradientSumArray[n] + -1.0 * weight * linearLossDivSigma;
                }
                int n = this.dim() - 1;
                localGradientSumArray[n] = localGradientSumArray[n] + 0.5 * weight * (1.0 - package$.MODULE$.pow(linearLossDivSigma, 2.0));
            } else {
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                this.lossSum_$eq(this.lossSum() + 0.5 * weight * (this.sigma() + 2.0 * this.epsilon * package$.MODULE$.abs(linearLoss) - this.sigma() * this.epsilon * this.epsilon));
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + weight * sign * $this.epsilon * (value / localFeaturesStd[index]);
                    }
                });
                if (this.fitIntercept) {
                    int n = this.dim() - 2;
                    localGradientSumArray[n] = localGradientSumArray[n] + weight * sign * this.epsilon;
                }
                int n = this.dim() - 1;
                localGradientSumArray[n] = localGradientSumArray[n] + 0.5 * weight * (1.0 - this.epsilon * this.epsilon);
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.weightSum_$eq(this.weightSum() + weight);
        HuberAggregator huberAggregator = this;
        return huberAggregator;
    }

    public HuberAggregator(boolean fitIntercept, double epsilon, Broadcast<double[]> bcFeaturesStd, Broadcast<Vector> bcParameters) {
        this.fitIntercept = fitIntercept;
        this.epsilon = epsilon;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcParameters = bcParameters;
        DifferentiableLossAggregator.$init$(this);
        this.dim = ((Vector)bcParameters.value()).size();
        this.numFeatures = fitIntercept ? this.dim() - 2 : this.dim() - 1;
        this.sigma = ((Vector)bcParameters.value()).apply(this.dim() - 1);
        this.intercept = fitIntercept ? ((Vector)bcParameters.value()).apply(this.dim() - 2) : 0.0;
    }
}

